﻿module y4d_timer.timer;

private import SDL;
private import ytl.singleton;


///	早い話が、独立タイマ。
/**
	reset()すると、タイマがリセットされ、それ以降、get()を呼び出すと、
	前回、reset()されたときからの経過時間（[ms]単位）が返ってくるようになる。
*/
class Timer {
	uint	get()
	///	現在の時刻の取得 [ms]単位。
	{
		if (bPaused>0) return dwPauseTime-dwOffsetTime;
		return cast(uint)(getTime() - dwOffsetTime);
	}

	void	reset()
	///	現在の時刻を 0 に。これを呼び出した直後はget()の戻り値が0になる。
	{
		dwOffsetTime = getTime();
		bPaused = 0;
	}

	void	set(uint t)
	///	現在の時刻の設定。[ms]単位。
	/** この呼び出し直後はgetの戻り値がここで設定した値になる。*/
	{
		if (bPaused>0) {
			//	いらんかな～？
			dwOffsetTime = dwPauseTime-t;
		} else {
			dwOffsetTime = cast(uint)(getTime() - t);
		}
	}

	void	pause()
	///	Pause機能。タイマーが一時停止する。
	{
		if (bPaused++ == 0) {
			//	Pauseさせる
			dwPauseTime = getTime();
		}
	}

	void	restart()
	///	Pauseしていたものを解除する。
	{
		if (--bPaused == 0) {
		//	Pause解除
			dwOffsetTime += getTime() - dwPauseTime;
		}
	}

protected:
	uint	dwOffsetTime;			//	オフセット値
	uint	dwPauseTime;			//	PauseかけたときのTime
	int		bPaused;				//	pause中か？

private:
	uint getTime() { return getTimer_().getTime(); }
	Timer_ getTimer_() { return singleton!(Timer_).get(); }
}

private:
class Timer_ {
	uint getTime() { return SDL_GetTicks(); }

	//	SDLでタイマー初期化に失敗するようなシステム構成のことは知らん(`Д´)
	this() { SDL_InitSubSystem(SDL_INIT_TIMER); }
	~this() { SDL_QuitSubSystem(SDL_INIT_TIMER); }
}

static this() {} /// for singleton template's static constructor
