﻿module y4d_draw.texturebase;

private import y4d_draw.drawcontext;
private import y4d_draw.drawbase;

///	Texture転送の基底クラス
/*
	Texture , TextureVector の基底クラス。<BR>

	描画の基本的な考えかた。

	ITextureBaseは、転送元の描画矩形を保持しています。
	これは転送元矩形という言葉で表されます。

	ただし、実際は矩形である必要はなく、 TextureVector のように、
	矩形の集合や、何らかの集合であっても構いません。概念的な矩形だと
	考えてください。

	この転送元矩形を Screen.blt メソッドによって、転送先に転送すると
	いう風に捉えます。転送先は、矩形、凸四角形、clipされた矩形etc..です。

	文字列集合は、それぞれの文字 Texture の集合だと考えることが
	出来るでしょう。これが TexturVector の実体です。

	よって、 TextureVector は、単なる矩形と考えて、 Screen.blt を用いて
	Texture 同様に描画することができます。
*/
interface ITextureBase {

	///	テクスチャの幅を得る
	float	getWidth();

	///	テスクチャの高さを得る
	float	getHeight();

	///	このテクスチャを指定のscreenにbltする。
	/**
		visitorパターンのために実装してある。
		Screen.bltからVisitorとして呼び出される。
	*/
	void	blt(DrawContext drawContext,float x,float y);

	///	このテクスチャを指定のscreenにbltする。
	/**
		visitorパターンのために実装してある。
		Screen.bltからVisitorとして呼び出される。
	*/
	void	blt(DrawContext drawContext,float x,float y,Rect* srcRect);

	///	このテクスチャを指定のscreenにbltする。
	/**
		visitorパターンのために実装してある。
		Screen.bltからVisitorとして呼び出される。
	*/
	void	blt(DrawContext drawContext,float x,float y,
		Rect* srcRect,Size* dstSize);

	///	このテクスチャを指定のscreenにbltする。
	/**
		visitorパターンのために実装してある。
		Screen.bltからVisitorとして呼び出される。
	*/
	void	blt(DrawContext src,Rect* srcRect,Point[4] dstPoint);

	///	このテクスチャを指定のscreenにbltする。
	/**
		visitorパターンのために実装してある。
		Screen.bltからVisitorとして呼び出される。

		これ、 TextureVector では未実装。(面倒だから)
	*/
	void	blt(DrawContext src,Point[4] srcPoint,Point[4] dstPoint);

}
