using System;
using System.Collections.Generic;
using System.Text;
using Yamalib.Draw;
using Yanesdk.Ytl;
using Yamalib.Util;
using Yamalib.Yanesdkext.Draw;
using Yanesdk.Draw;
using System.Diagnostics;
using Yamalib.Scenario;

namespace Yamalib.Model
{
    /// <summary>
    /// wi摜Ǘ
    /// </summary>
    public class BgImage : IBgImageResource
    {
        #region otB[h

        //private bool showing;
        private int effectNo;
        private readonly RootCounterS effectPhaseCounter;
        private int posX;
        private int posY;
        private float drawSize = 1.0f;
        private Color4ub color = new Color4ub(255, 255, 255, 255);
        private readonly ITexture texture;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="texture_"></param>
        public BgImage(ITexture texture_)
        {
            Debug.Assert(texture_ != null);
            texture = texture_;
            effectPhaseCounter = new RootCounterS();
            effectPhaseCounter.Set(TransBltter.PAHSE_MAX, TransBltter.PAHSE_MAX, 1);
        }

        /// <summary>
        /// ̃\[X͕\
        /// </summary>
        public  virtual bool IsShowing
        {
            get { return false; }
        }

        /// <summary>
        /// GtFNg
        /// </summary>
        public bool IsEffecting
        {
            get { return !effectPhaseCounter.IsEnd; }
        }

        public void SetEffect(int effectNo, int start, int end, int speed)
        {
            this.effectNo = effectNo;
            effectPhaseCounter.Set(start, end, speed);
        }

        /// <summary>
        /// GtFNgԍ̎擾
        /// </summary>
        public int EffectNo
        {
            get { return effectNo; }
        }

        /// <summary>
        /// GtFNgʑ̎擾
        /// GtFNgĂȂTransBltter.PAHSE_MAXԋp
        /// </summary>
        public int EffectPhase
        {
            get
            {
                if (IsEffecting)
                {
                    return effectPhaseCounter.Value();
                }
                // GtFNgĂȂƂƂ͊ĂƌȂ
                return TransBltter.PAHSE_MAX;
            }
        }

        /// <summary>
        /// `ʒu
        /// </summary>
        public int X
        {
            set { posX = value; }
            get { return posX; }
        }
        public int Y
        {
            set { posY = value; }
            get { return posY; }
        }

        /// <summary>
        /// `TCY
        /// </summary>
        public float Size
        {
            set { drawSize = value; }
            get { return drawSize; }
        }

        /// <summary>
        /// F
        /// </summary>
        public Color4ub Color
        {
            set { color = value; }
            get { return color; }
        }

        /// <summary>
        /// eNX`̎擾
        /// </summary>
        /// <returns></returns>
        public ITexture GetTexture()
        {
            return texture;
        }

        /// <summary>
        /// \[X̊ǗlɈڍs
        /// </summary>
        /// <param name="screen"></param>
        /// <returns></returns>
        public YanesdkResult OnMove(IScreen screen)
        {
            return YanesdkResult.NoError;
        }
    }
}
