using System;
using System.Collections.Generic;
using System.Text;
using Yamalib.Draw;
using Yanesdk.Draw;
using Yanesdk.GUIParts;
using Yanesdk.Input;
using Yamalib.Util;

namespace Yamalib.GUI
{
    /// <summary>
    /// _CAO{bNXŎgtHgA摜W߂GbZXIuWFNgB
    ///	 ꖇDIɎgpA[h̉񐔂炷ƂŏrqɂȂA
    /// ւ̕SyB
    /// </summary>
    public class DialogBoxResources
    {
        #region otB[h

        private TileTexture dialogTile;	//!< _CAO̊{^C
        public TileTexture DialogTile
        {
            get { return dialogTile; }
            set { dialogTile = value; }
        }

        private TileTexture titleTile;	//!< _CAO㕔́A^Cg̃^C
        public TileTexture TitleTile
        {
            get { return titleTile; }
            set { titleTile = value; }
        }

        private TileTexture cursorTile;	//!< _CAO{bNXĨJ[\^C
        public TileTexture CursorTile
        {
            get { return cursorTile; }
            set { cursorTile = value; }
        }

        private FontLoader buttonLabelFontLoader;
        public FontLoader ButtonLabelFontLoader
        {
            get { return buttonLabelFontLoader; }
            set { buttonLabelFontLoader = value; }
        }

        private int buttonLabelFontLoaderNo;
        public int ButtonLabelFontLoaderNo
        {
            get { return buttonLabelFontLoaderNo; }
            set { buttonLabelFontLoaderNo = value; }
        }

        private Font messageFont;
        public Font MessageFont
        {
            get { return messageFont; }
            set { messageFont = value; }
        }

        #endregion
    }

    /// <summary>
    /// OSɈˑȂTextureɂ_CAO{bNX
    /// </summary>
    public class TextureDialog : ITextureGUI
    {

        #region 萔l

        /// {^̃^Cv
        public enum TYPE
        {
            ONE_BUTTON,		//!< nj
            TWO_BUTTON,		//!< ͂A
            THREE_BUTTON,	//!< ͂AALZ
            SELECTION		//!< Ip
        };

        /// ^Cgo[̃^Cv
        public enum TITLE : int
        {
            WARNING,
            CAUTION,
            INFORMATION,
            SELECTION,
            ERROR,
        };

        /// `ʒuItZbg
        public enum POS_OFFSET
        {
            LEFT_TOP,
            CENTER,
        };

        private static readonly string[] TITLE_BAR_FILENAME = new string[]{
		    "img/dialog/sel_bar01.png",
		    "img/dialog/sel_bar02.png",
		    "img/dialog/sel_bar03.png",
		    "img/dialog/sel_bar04.png",
		    "img/dialog/sel_bar05.png",
	    };

        protected static readonly string C_PROP_KEY_MESSAGE = "MESSAGE";
        protected static readonly string C_PROP_KEY_MESSAGE_OX = "MESSAGE_OX";
        protected static readonly string C_PROP_KEY_MESSAGE_OY = "MESSAGE_OY";
        protected static readonly string C_PROP_KEY_SIZEX = "SIZEX";
        protected static readonly string C_PROP_KEY_SIZEY = "SIZEY";
        protected static readonly string C_PROP_KEY_TITLE_TYPE = "TITLE_TYPE";
        protected static readonly string C_PROP_KEY_BUTTON_NM = "BUTTON_NM";
        protected static readonly string C_PROP_KEY_BUTTON_ACTIVE = "BUTTON_ACTIVE";
        protected static readonly string C_PROP_KEY_BUTTON_NON_ACTIVE = "BUTTON_NON_ACTIVE";
        protected static readonly string C_PROP_KEY_BUTTON_OX = "BUTTON_OX";
        protected static readonly string C_PROP_KEY_BUTTON_OY = "BUTTON_OY";
        protected static readonly string C_PROP_KEY_POSX = "POSX";
        protected static readonly string C_PROP_KEY_POSY = "POSY";
        protected static readonly string C_PROP_KEY_POS_BASE = "POS_BASE";
        protected static readonly string C_PROP_KEY_DLG_ALPHA = "DLG_ALPHA";
        protected static readonly string C_PROP_KEY_TAB_NEXT = "TAB_NEXT";
        protected static readonly string C_PROP_KEY_TAB_PREV = "TAB_PREV";


        #endregion

        #region otB[h

        //private TYPE m_type = TYPE.TWO_BUTTON;
        private TITLE m_titleType = TITLE.INFORMATION;	//!< ^Cgo[̃^Cv

        private IKeyInput m_key;

        private bool m_modal;
        private bool m_show = true;		//!< \tO
        //private ITexture m_titleTex;
        private ITexture m_messageTex; //!< bZ[WeNX`
        private int m_msgox;	//!< bZ[W`ʒũItZbgl
        private int m_msgoy;	//!< bZ[W`ʒũItZbgl
        private POS_OFFSET m_offsetType = POS_OFFSET.LEFT_TOP;	//!< `ItZbg^Cv
        private int m_dlgAlpha = 255;

        private string m_text = string.Empty;

        private int m_x;
        private int m_y;
        private int m_sx = 120;
        private int m_sy = 80;

        private FocusableTextureGUIControl textureGuiCtrl = new FocusableTextureGUIControl();
        private List<TextureGUIControl.Control> m_button = new List<TextureGUIControl.Control>();
        private ControlContext ctrlContext;

        private DialogBoxResources m_dlgRes;

        #endregion


        /// <summary>
        /// _CAO{bNXĕԋp
        /// </summary>
        /// <param name="dlgRes"></param>
        /// <param name="defFilename"></param>
        /// <param name="mouse"></param>
        /// <param name="key"></param>
        /// <param name="prevKeyNo"></param>
        /// <param name="nextKeyNo"></param>
        /// <returns></returns>
        public static TextureDialog CreateDialogBox(DialogBoxResources dlgRes, string defFilename, ControlContext cc,
            IKeyInput key, int prevKeyNo, int nextKeyNo)
        {
            Properties prop = Properties.GetInstance(defFilename);

            int sx = (int)prop.GetPropertyNum(C_PROP_KEY_SIZEX, 320);
            int sy = (int)prop.GetPropertyNum(C_PROP_KEY_SIZEY, 240);
            string msg = prop.GetProperty(C_PROP_KEY_MESSAGE);
            int mox = (int)prop.GetPropertyNum(C_PROP_KEY_MESSAGE_OX, 0);
            int moy = (int)prop.GetPropertyNum(C_PROP_KEY_MESSAGE_OY, 0);
            string actCol = prop.GetProperty(C_PROP_KEY_BUTTON_ACTIVE); ;
            string nonActCol = prop.GetProperty(C_PROP_KEY_BUTTON_NON_ACTIVE);
            List<string> buttonNm = GetButtonText(prop);
            int titleType = (int)prop.GetPropertyNum(C_PROP_KEY_TITLE_TYPE, 0);
            int dlgAlpha = (int)prop.GetPropertyNum(C_PROP_KEY_DLG_ALPHA, 255);
            prevKeyNo = (int)prop.GetPropertyNum(C_PROP_KEY_TAB_PREV, prevKeyNo);
            nextKeyNo = (int)prop.GetPropertyNum(C_PROP_KEY_TAB_NEXT, nextKeyNo);

            // _CAO{bNX̕\ʒu
            int dx = (int)prop.GetPropertyNum(C_PROP_KEY_POSX, 0);
            int dy = (int)prop.GetPropertyNum(C_PROP_KEY_POSY, 0);
            // ̍W͉Ӗ邩(A)
            int pos_base = (int)prop.GetPropertyNum(C_PROP_KEY_POS_BASE, 0);

            // w肳ꂽ\ʒu͊_
            if (0 != pos_base)
            {
                switch (pos_base)
                {
                    case 1:
                        // 
                        dx -= sx / 2;
                        dy -= sy / 2;
                        break;
                    default:
                        // ȂĂȂ...
                        break;
                }
            }

            // ȂƂ񂩂
            dlgRes.TitleTile = new TileTexture(null, TileTexture.TILE_TYPE.H_LINE3);

            TextureDialog dialog = new TextureDialog();
            dialog.SetDialogBoxResources(dlgRes);

            // KeyGroupŎgpL[ƎgpL[ԍݒ
            dialog.SetKey(key, prevKeyNo, nextKeyNo);
            dialog.SetDialogSize(sx, sy);
            dialog.SetXY(dx, dy);
            dialog.SetXYOffsetType(TextureDialog.POS_OFFSET.LEFT_TOP);
            dialog.SetTitleType((TextureDialog.TITLE)titleType);
            dialog.SetDialogAlpha(dlgAlpha);

            if (0 != msg.Length)
            {
                ITexture t = SetMessageText(dlgRes.MessageFont, msg);
                dialog.SetMessageTexture(t, mox, moy, true);
            }

            int box, boy;

            int i = 0;
            foreach (string btLabel in buttonNm)
            {
                GetButtonXY(prop, i, out box, out boy);
                FontButton bt = CreateButton(cc,
                                    dlgRes.ButtonLabelFontLoader,
                                    dlgRes.ButtonLabelFontLoaderNo,
                                    btLabel, actCol, nonActCol, dlgRes.CursorTile);
                dialog.AddButton(bt, cc, dx + box, dy + boy);
                ++i;
            }

            return dialog;
        }

        #region ITextureGUI o

        /// <summary>
        /// 
        /// </summary>
        /// <param name="cc"></param>
        public void OnInit(ControlContext cc)
        {
            ctrlContext = cc;
            textureGuiCtrl.OnInit(cc);
        }

        /// <summary>
        /// /`揈
        /// </summary>
        /// <param name="scr"></param>
        /// <param name="cc"></param>
        /// <param name="X"></param>
        /// <param name="Y"></param>
        public void OnPaint(IScreen scr, ControlContext cc, int x, int y)
        {
            // ړ
            OnMove(scr, cc);
            // `揈
            OnDraw(scr, cc);
        }

        public bool Visible
        {
            get
            {
                throw new Exception("The method or operation is not implemented.");
            }
            set
            {
                throw new Exception("The method or operation is not implemented.");
            }
        }

        #endregion

        /// <summary>
        /// ړ
        /// </summary>
        /// <param name="screen"></param>
        private void OnMove(IScreen screen, ControlContext cc)
        {
            if (!this.m_show) return;
            if (!(m_key == null))
            {
                textureGuiCtrl.OnMoveFocus();
            }
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        private void OnDraw(IScreen screen, ControlContext cc)
        {
            if (!this.m_show) return;

            Color4ub colorOrg = YanesdkUtil.GetNowScreenColor(screen);
            screen.BlendSrcAlpha();
            screen.SetColor(255, 255, 255, m_dlgAlpha);

            int posx;
            int posy;
            posx = posy = 0;
            if (POS_OFFSET.LEFT_TOP == m_offsetType)
            {
                posx = this.m_x;
                posy = this.m_y;
            }
            else if (POS_OFFSET.CENTER == m_offsetType)
            {
                posx = this.m_x - (this.m_sx / 2);
                posy = this.m_y - (this.m_sy / 2);
            }
            // C_CAO`
            m_dlgRes.DialogTile.OnPaint(screen, m_x, m_y, m_sx, m_sy);

            // {^`
            textureGuiCtrl.OnPaint(screen);

            // ^Cgo[`
            screen.SetColor(255, 255, 255, 255);
            //m_dlgRes.TitleTile.OnPaint(screen, m_x, m_y, m_sx, 0);

            // bZ[W\
            if (this.m_messageTex != null)
            {
                screen.Blt(m_messageTex, posx + m_msgox, posy + m_msgoy);
            }
            else if (m_text != null)
            {
                // todo
            }

            // Fɖ߂
            screen.SetColor(colorOrg);
        }

        /// <summary>
        /// _CAO{bNXŎgp郊\[Xݒ肷
        /// </summary>
        /// <param name="res"></param>ed
        public void SetDialogBoxResources(DialogBoxResources res)
        {
            this.m_dlgRes = res;
        }

        public void SetXY(int x, int y)
        {
            this.m_x = x;
            this.m_y = y;
        }

        /// <summary>
        /// L[ݒ肷
        /// </summary>
        /// <param name="key"></param>
        /// <param name="prevKeyNo">^uO[vɎgpkeyno</param>
        /// <param name="nextKeyNo">^uO[vɎgpkeyno</param>
        public void SetKey(IKeyInput key, int prevKeyNo, int nextKeyNo)
        {
            m_key = key;
            textureGuiCtrl.PrevButtonNo = prevKeyNo;
            textureGuiCtrl.NextButtonNo = nextKeyNo;
        }

        /// [_ɐݒ肷
        /**
            ̕ϐ݂邩ǂ́Ã_CAOgpNXɈˑ
        */
        public void SetModal(bool b)
        {
            this.m_modal = b;
        }
        /// [_E[_XԂ擾
        public bool IsModal()
        {
            return this.m_modal;
        }

        /// _CAO\
        public void Show()
        {
            this.m_show = true;
        }

        /// _CAO
        public void Hide()
        {
            this.m_show = false;
        }

        /// _CAu{bNX̃TCY
        public void SetDialogSize(int sx_, int sy_)
        {
            this.m_sx = sx_;
            this.m_sy = sy_;
        }

        /// _CAO{bNX̃At@l̐ݒ
        public void SetDialogAlpha(int alpha_)
        {
            if (alpha_ < 0)
            {
                alpha_ = 0;
            }
            else if (alpha_ > 255)
            {
                alpha_ = 255;
            }
            this.m_dlgAlpha = alpha_;
        }

        /// `ItZbg^Cv̐ݒ
        /// O SetXY Ŏw肵lɗL
        public void SetXYOffsetType(POS_OFFSET type)
        {
            this.m_offsetType = type;
        }

        /// <summary>
        /// {^ǉ
        /// </summary>
        /// <param name="button"></param>
        /// <param name="X"></param>
        /// <param name="Y"></param>
        public void AddButton(ITextureGUI button, ControlContext cc,  int x, int y)
        {
            textureGuiCtrl.OnInit(cc);
            TextureGUIControl.Control control = new TextureGUIControl.Control(button, x, y);
            m_button.Add(control);
            textureGuiCtrl.AddControl(control);

            FocusableTextureGUI focusGui = button as FocusableTextureGUI;
            if (null != focusGui)
            {
                textureGuiCtrl.AddFocusGUI(focusGui);
            }

        }

        /// <summary>
        /// ݒ肳Ă邷ׂẴ{^擾
        /// </summary>
        /// <returns></returns>
        public List<TextureGUIControl.Control> GetButton()
        {
            return m_button;
        }

        /// \bZ[W𕶎ƂĐݒ
        public void SetShowMessage(string text_)
        {
            m_text = text_;
        }

        /// \bZ[WeNX`ƂĐݒ肷
        public void SetMessageTexture(ITexture tex_, int ox, int oy, bool resizeWidth)
        {
            this.m_messageTex = tex_;
            this.m_msgox = ox;
            this.m_msgoy = oy;
            if (resizeWidth)
            {
                this.m_sx = (int)tex_.Width + (ox * 2);
            }
        }

        /// ^Cgo[̃^Cvݒ肵܂
        public void SetTitleType(TITLE type)
        {
            m_titleType = type;
        }

        /// ^Cgo[̃^Cv擾
        public TITLE GetTitleType()
        {
            return m_titleType;
        }

        /// vpeB{^̖O擾	
        protected static List<string> GetButtonText(Properties prop)
        {
            int count = 0;
            List<string> result = new List<string>();
            while (true)
            {
                string key = C_PROP_KEY_BUTTON_NM + count.ToString();
                string str = prop.GetProperty(key);
                if (str == null || str.Length == 0)
                {
                    break;
                }
                ++count;
                result.Add(str);
            }
            return result;
        }

        /// Ỹ{^ItZbgƂ擾
        protected static void GetButtonXY(Properties prop, int no, out int x_, out int y_)
        {
            x_ = (int)prop.GetPropertyNum(C_PROP_KEY_BUTTON_OX + no.ToString(), 0);
            y_ = (int)prop.GetPropertyNum(C_PROP_KEY_BUTTON_OY + no.ToString(), 0);
        }

        /// <summary>
        /// bZ[W쐬ăZbg
        /// </summary>
        /// <param name="font"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        protected static ITexture SetMessageText(Font font, string msg)
        {
            ITexture texture = YamalibConst.CreateTexture();
            texture.SetSurface(font.DrawBlendedUnicode(msg));
            return texture;
        }

        /// {^𐶐
        private static FontButton CreateButton(ControlContext cc, FontLoader fl, int fontno,
                    string text, string colorOn, string colorOff, TileTexture bgTex)
        {
            FontButton bt = new FontButton(fl, fontno);
            bt.OnInit(cc);
            bt.SetText(text);
            bt.SetColor(YanesdkUtil.ToColor4ub(colorOn), YanesdkUtil.ToColor4ub(colorOff));
            bt.OnClick += null;
            return bt;
        }
    }
}
