using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.GUIParts;
using Yanesdk.Draw;
using Yanesdk.Input;
using Yamalib.Util;

namespace Yamalib.GUI
{
    public class Slider : FocusableTextureGUI
    {

        #region 萔l

        private const int KEY_MOVE_SIZE = 3;
        private const int LC_SCROLL_MAX = 65535;

        #endregion

        #region otB[h

        private ITexture m_barTex;	// XC_[{^̃eNX`
        private ITexture m_baseTex;	// nƂȂeNX`

        private IKeyInput m_key;

        private bool m_keyFocused;
        private bool m_keyFocusedMove;

        private int m_posOld;	//!< Öʒu	
        private int preMx;
        private int preMy;

        private int m_texSz;
        private int m_ox;
        private int m_oy;
        private int m_sx;		//!< XC_[{^̑傫
        private int m_sy;
        private int m_length;	//!< XC_[̉͈
        private int m_pos;		//!< ݂̃XN[o[̈ʒu
        private int m_catch;	//!< XN[o[ł邩
        private int m_catchOx;

        private int x;
        private int y;

        private ControlContext controlContex;

        #endregion


        #region ITextureGUI o

        public void OnInit(ControlContext cc)
        {
            controlContex = cc;
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="scr"></param>
        /// <param name="cc"></param>
        /// <param name="X"></param>
        /// <param name="Y"></param>
        public void OnPaint(Yanesdk.Draw.IScreen scr, ControlContext cc, int x, int y)
        {
            OnMove(scr, cc);
            OnDraw(scr);
        }

        public bool Visible
        {
            get
            {
                throw new Exception("The method or operation is not implemented.");
            }
            set
            {
                throw new Exception("The method or operation is not implemented.");
            }
        }

        #endregion


        /// XN[o[̃TCY
        public void SetSize(int x_, int y_)
        {
            this.m_sx = x_;
            this.m_sy = y_;
        }

        /// L[ݒ肷
        public void SetKey(IKeyInput key_)
        {
            this.m_key = key_;
        }

        /// XCho[ꂽ
        public bool IsModifiy()
        {
            return m_posOld != m_pos;
        }

        /// XC_[̉͈͂̐ݒ
        public void SetLength(int length_)
        {
            this.m_length = length_;
        }

        /// XC_[̉͈͂̎擾
        public int GetLength()
        {
            return this.m_length;
        }

        /// ʒu̐ݒ
        public void SetXY(int x_, int y_)
        {
            x = x_;
            y = y_;
        }

        /// XC_[{^̃ItZbgʒu
        public void SetSliderOffset(int ox_, int oy_)
        {
            this.m_ox = ox_;
            this.m_oy = (int)(oy_ - m_barTex.Height / 2);
        }

        /// XChʒu̐ݒ
        public void SetSlidePos(float f)
        {
            if (1.0f < f)
            {
                f = 1.0f;
            }
            else if (0.0f > f)
            {
                f = 0.0f;
            }
            this.m_pos = (int)(m_length * f) + x;
        }
        /// XN[|WV̎擾(0 - 1.0)
        public float GetSlidePos()
        {
            int width = m_pos - x;
            if (width == 0)
            {
                return 0.0f;
            }
            return width / (float)m_length;
        }


        /// neNX`̐ݒ
        public void SetBaseTexture(ITexture t_)
        {
            this.m_baseTex = t_;
        }

        /// o[eNX`̐ݒ
        public void SetBarTexture(ITexture t_)
        {
            this.m_barTex = t_;
            m_texSz = (int)t_.Width;
            this.m_sx = (int)t_.Width;
            this.m_sy = (int)t_.Height;
        }

        private void OnMove(IScreen screen, ControlContext cc)
        {
            int mx, my;
            cc.MouseInput.GetPos(out mx, out my);
            m_posOld = m_pos;

            // keyΉ
            if (m_key != null)
            {
                bool isIn = PointInRect(mx, my, m_pos + m_ox, y + m_oy, m_pos + m_sx + m_ox, y + m_sy + m_oy);

                // L[tH[JXĂƂɁA}EX삳ꂽAL[tH[JXOFFɂ
                if (m_keyFocused && m_keyFocusedMove)
                {
                    if (mx != preMx || my != preMy)
                    {
                        m_keyFocused = false;
                    }
                }

                if (!isIn || !m_keyFocused)
                {
                    this.m_keyFocused = false;
                    this.m_keyFocusedMove = false;
                    OnMoveSlider(cc.MouseInput.IsPress(MouseInput.Button.Left), mx, my);
                }
                else
                {
                    if (m_key.IsPress(3))
                    {
                        // 
                        if (!IsMin())
                        {
                            mx -= KEY_MOVE_SIZE;
                        }

                    }
                    else if (m_key.IsPress(4))
                    {
                        // E
                        if (!IsMax())
                        {
                            mx += KEY_MOVE_SIZE;
                        }
                    }
                    cc.MouseInput.SetPos(mx, my);
                    preMx = mx;
                    preMy = my;
                    m_keyFocusedMove = true;
                    OnMoveSlider(true, mx, my);
                }


            }
            else
            {
                // L[͐ݒ肳ĂȂ
                OnMoveSlider(cc.MouseInput.IsPress(MouseInput.Button.Left), mx, my);
            }
        }

        /// XC_[̈ړ
        private void OnMoveSlider(bool leftDown, int mouseX, int mouseY)
        {
            if (m_pos < this.x)
            {
                m_pos = this.x;
            }

            if (leftDown)
            {
                // Lb`ĂȂɁAXCho[̂Lb`
                if (0 == m_catch
                    && PointInRect(mouseX, mouseY, m_pos + m_ox, y + m_oy, m_pos + m_sx + m_ox, y + m_sy + m_oy))
                {
                    m_catch = 1;
                    m_catchOx = m_pos - mouseX;
                }

                // Lb`ĂȂƂɁAXCho[͈͂̂ǂI
                else if (0 == m_catch
                    && PointInRect(mouseX, mouseY, x, y + m_oy, x + m_sx + m_length, y + m_sy + m_oy))
                {
                    m_catch = 2;
                    m_catchOx = 0;
                }
            }
            else
            {
                m_catch = 0;
            }

            // Lb`Ă
            if (m_catch != 0)
            {
                m_pos = mouseX + m_catchOx;
                if (m_pos < this.x)
                {
                    m_pos = this.x;
                }
                else if (m_pos > this.x + m_length)
                {
                    m_pos = this.x + m_length;
                }
            }
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        public void OnDraw(IScreen screen)
        {
            Color4ub colorOrg = YanesdkUtil.GetNowScreenColor(screen);

            // n`
            screen.Blt(this.m_baseTex, x, y);

            // XC_[`
            if (m_barTex == null)
            {
                screen.SetColor(0, 255, 0);
                screen.DrawPolygon(
                    x + m_ox, m_pos,
                    x + m_oy, m_pos + m_texSz,
                    x + m_ox + m_sx, m_pos + m_texSz,
                    x + m_oy + m_sx, m_pos
                );
            }
            else
            {
                // eNX`Ƃĕ`
                screen.Blt(this.m_barTex, m_pos + m_ox, y + m_oy);
            }

            // F߂
            screen.SetColor(colorOrg);
        }


        /// L[tH[JXԂ̐ݒ	
        public void SetKeyFocus(bool b)
        {
            m_keyFocused = b;
        }

        /// tH[JX
        public void Focus()
        {
            int mx = m_pos + m_ox + (int)m_barTex.Width / 2;
            int my = y + m_oy + (int)m_barTex.Height / 2;
            controlContex.MouseInput.SetPos(mx, my);
            m_keyFocused = true;
        }

        /// XC_[o[̒ɂ邩H
        public bool IsIn()
        {
            int mx, my;
            controlContex.MouseInput.GetPos(out mx, out my);
            return IsCursorInButton(mx, my);
        }

        /// XC_[o[őɂȂĂ邩H
        public bool IsMax()
        {
            return GetSlidePos() == 1.0f;
        }

        /// XC_[ŒɂȂĂ邩H
        public bool IsMin()
        {
            return GetSlidePos() == 0.0f;
        }


        /// _`̓ɂ邩ǂ
        private static bool PointInRect(int px, int py, int left, int top, int right, int bottom)
        {
            return (bool)(px >= left && px < right && py >= top && py < bottom);
        }
        /// Ŏw肵W̓XC_[{^̒ɂ邩H
        private bool IsCursorInButton(int mouseX, int mouseY)
        {
            return PointInRect(mouseX, mouseY, x, y + m_oy, x + m_sx + m_length, y + m_sy + m_oy);
        }

        #region FocusableTextureGUI o

        public void Focus(ControlContext controlContext, int x, int y)
        {
            int mx = m_pos + m_ox + (int)m_barTex.Width / 2;
            int my = y + m_oy + (int)m_barTex.Height / 2;
            controlContex.MouseInput.SetPos(mx, my);
            m_keyFocused = true;
        }

        #endregion
    }
}
