using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.GUIParts;
using Yamalib.GUI;
using Yanesdk.Ytl;
using Yanesdk.Draw;

namespace Yamalib.GUI
{
    /// <summary>
    /// GUIp[ctH[JX邱ƂłRg[
    /// </summary>
    public class FocusableTextureGUIControl : TextureGUIControl
    {
        private List<FocusableTextureGUI> focusGUIs = new List<FocusableTextureGUI>();
        private int index;
        private int prevButtonNo = 1;
        private int nextButtonNo = 2;


        #region tH[JX֘A\bh
        
        /// <summary>
        /// OtH[JXƂɔɎg{^ԍ
        /// </summary>
        public int PrevButtonNo
        {
            get { return prevButtonNo; }
            set { prevButtonNo = value; }
        }

        /// <summary>
        /// tH[JXƂɔɎg{^ԍ
        /// </summary>
        public int NextButtonNo
        {
            get { return nextButtonNo; }
            set { nextButtonNo = value; }
        }

        public void OnMoveFocus()
        {
            FocusableGUIParam param = ControlContext.Param as FocusableGUIParam;
            if (null != param)
            {
                bool push = false;
                if (param.Key.IsPush(PrevButtonNo))
                {
                    FocusPrev();
                    push = true;
                }
                else if (param.Key.IsPush(NextButtonNo))
                {
                    FocusNext();
                    push = true;
                }

                if (!push)
                {
                    int i = 0;
                    foreach (FocusableTextureGUI gui in focusGUIs)
                    {
                        FocusableTextureButton bt = gui as FocusableTextureButton;
                        if (bt != null)
                        {
                            if (bt.IsHover)
                            {
                                Control control = GetControl(bt);
                                SetSelectNo(i);
                                break;
                            }
                        }
                        ++i;
                    }
                }

            }
        }

        public void AddFocusGUI(FocusableTextureGUI parts)
        {
            focusGUIs.Add(parts);
        }

        public void FocusNext()
        {
            if (0 != focusGUIs.Count)
            {
                ++index;
                if (focusGUIs.Count <= index)
                {
                    index = 0;
                }

                Control control = GetControl(index);
                FocusableTextureGUI parts = control.Parts as FocusableTextureGUI;
                if (parts != null)
                {
                    int mx, my;
                    GetCenterXY(control, out mx, out my);
                    parts.Focus(ControlContext, mx, my);
                }
            }
        }

        public void FocusPrev()
        {
            if (0 != focusGUIs.Count)
            {
                --index;
                if (0 > index)
                {
                    index = focusGUIs.Count - 1;
                }

                Control control = GetControl(index);
                FocusableTextureGUI parts = control.Parts as FocusableTextureGUI;
                if (parts != null)
                {
                    int mx, my;
                    GetCenterXY(control, out mx, out my);
                    parts.Focus(ControlContext, mx, my);
                }
            }
        }

        public void Focus(int no)
        {
            if (no < 0 || focusGUIs.Count <= no)
            {
                return;
            }
            index = no;

            Control control = GetControl(index);
            FocusableTextureGUI parts = control.Parts as FocusableTextureGUI;
            if (parts != null)
            {
                int mx, my;
                GetCenterXY(control, out mx, out my);
                parts.Focus(ControlContext, mx, my);
            }
        }

        public void Focus(FocusableTextureGUI parts)
        {
            foreach (FocusableTextureGUI bt in focusGUIs)
            {
                if (bt == parts)
                {
                    Control control = GetControl(bt);
                    bt.Focus(ControlContext, control.X, control.Y);
                    break;
                }
            }
        }

        /// focusł́A}EXړ邪ÁAIȈړŁA}EX͈ړȂ
        public void SetSelectNo(int no)
        {
            if (no < 0 || focusGUIs.Count <= no)
            {
                return;
            }
            index = no;
        }

        /// tH[JXĂCfbNXԍ擾
        public int GetFocusNo()
        {
            return this.index;
        }

        /// SẴL[O[v
        public void ClearFocusGUI()
        {
            this.focusGUIs.Clear();
            index = 0;
        }

        private Control GetControl(FocusableTextureGUI parts)
        {
            foreach (Control c in Controls)
            {
                if (c.Parts == parts)
                {
                    return c;
                }
            }
            return null;
        }

        private Control GetControl(int no)
        {
            return GetControl(focusGUIs[no]);
        }

        private static void GetCenterXY(Control control, out int x, out int y)
        {
            x = control.X;
            y = control.Y;
        }

        #endregion

    }
}
