using System;
using System.Collections.Generic;
using System.Text;
using Yamalib.Util;
using Yanesdk.Timer;
using Yanesdk.Draw;
using Yamalib.Scenario;
using Yanesdk.System;

namespace Yamalib.Draw.Effect
{
    /// <summary>
    /// pNX
    /// ptH[}bgɂĒ`ꂽVFʏɕ\܂
    /// </summary>
    public class ShellEmulatorDraw
    {
        /// VFʏ
        internal class ShellDrawInfo
        {
            public ScenarioParser scenarioParser;
            public RootCounterS textCount;
            public int ox; 	// `ʒuItZbg
            public int oy;
            public int analyzedTag;

            /// RXgN^
            public ShellDrawInfo()
            {
                scenarioParser = new ScenarioParser();
                textCount = new RootCounterS();
            }
        }

        #region 萔l

        private const int TYPE_SPEED = 1;	// ^CsOXs[h
        //	ǂ̃^OɊY邩𒲂ׂ
        private readonly static string[] tags = new string[]{
			"readstop",	 	// 0 .ǂݎ~܂
			"nowait",		// 1 .ǂݔ΂START
			"/nowait",		// 2 .ǂݔ΂END
			"push"			// 3 .̃vvgʂ
		};

        #endregion

        #region otB[h

        //private PromptCarsor carsor;
        private readonly List<ShellDrawInfo> infos = new List<ShellDrawInfo>();
        private int curInfoIndex;	// ݕ\ScenarioDrawCfbNX
        private GameTimer readWaitTimer;
        private int readwait;
        private bool drawEnd;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public ShellEmulatorDraw()
        {
            readWaitTimer = new GameTimer();
            ITexture carsortexture = YamalibConst.CreateTexture("img/ending/carsor.png");
            //carsor = new PromptCarsor();
            //carsor.SetTexture( carsortexture );
            readwait = -1;
        }

        /// ĂяoȂ[
        public void OnMove(IScreen screen)
        {
            if (drawEnd) return;

            AnalyzeTag();

            if (readwait == -1)
            {
                infos[curInfoIndex].textCount++;
            }
            else
            {
                if (readWaitTimer.Time >= readwait)
                {
                    readwait = -1;
                }
            }

        }

        /// ł邾тȂ[
        public void OnDraw(IScreen screen)
        {
            if (drawEnd) return;

            ShellDrawInfo shellDrawInfo = infos[curInfoIndex];

            int tx, ty = 0;
            // `悷`
            List<ILetterDeta> drawchar = shellDrawInfo.scenarioParser.DrawCharacterData;
            for (int i = 0; i < shellDrawInfo.textCount.Value() && i < drawchar.Count; ++i)
            {
                float size = drawchar[i].Size;

                // e̕`
                screen.SetColor(0, 0, 0);
                tx = shellDrawInfo.ox + (int)drawchar[i].Pos.X + 2;
                ty = shellDrawInfo.oy + (int)drawchar[i].Pos.Y + 1;

                // g傠ŕ`
                if (1.0f != size)
                {
                    screen.BltRotate(
                        drawchar[i].ImgObj as ITexture,	// eNX` 
                        tx, ty, 	// x,y ʒu
                        0, 			// ]p
                        size, 		// g嗦
                        0			// `x[Xʒuij
                        );
                }
                else
                {
                    screen.Blt(drawchar[i].ImgObj as ITexture, tx, ty);
                }

                // {̕`
                screen.SetColor(drawchar[i].Color);
                tx = shellDrawInfo.ox + (int)drawchar[i].Pos.X;
                ty = shellDrawInfo.oy + (int)drawchar[i].Pos.Y;

                // g傠ŕ`
                if (1.0f != size)
                {
                    screen.BltRotate(
                        drawchar[i].ImgObj as ITexture,	// eNX` 
                        tx, ty, 	// x,y ʒu
                        0, 			// ]p
                        size, 		// g嗦
                        0			// `x[Xʒuij
                        );
                }
                else
                {
                    screen.Blt(drawchar[i].ImgObj as ITexture, tx, ty);
                }
            }

            //carsor.SetXY(tx + 8, ty + 3);
            //carsor.OnDraw(screen);

            if (shellDrawInfo.oy + ty > 450)
            {
                shellDrawInfo.oy -= 15;
            }


            if (shellDrawInfo.textCount.IsEnd)
            {
                if (curInfoIndex > 0)
                {
                    curInfoIndex--;
                }
                else
                {
                    drawEnd = true;
                }
            }

            screen.ResetColor();

        }

        /// \ʏXNvgt@Cݒ肷
        public void SetCommands(string[] filenames_, FontLoader fl)
        {

            // ꉞȌ
            infos.Clear();

            foreach (string filename in filenames_)
            {

                ShellDrawInfo info = new ShellDrawInfo();
                FontRepository fr = new FontRepository(YamalibConst.FONT_REP_TEXTURE_FACTORY);
                fr.SetLoader(fl, 7);
                // قƂǉp炱񂭂炢...
                fr.Max = (64);
                info.scenarioParser.TextFontRepository = fr;

                ScenarioDrawContext textdrawcontext = new ScenarioDrawContext();
                string strText = YamalibUtility.ReadTextFile(filename);

                textdrawcontext.SetText(strText);
                info.scenarioParser.SetScenarioDrawContext(textdrawcontext);
                info.scenarioParser.UpdateText();
                List<ILetterDeta> drawchar = info.scenarioParser.DrawCharacterData;
                info.textCount.Set(0, drawchar.Count, TYPE_SPEED);
                info.ox = 40;

                infos.Add(info);
            }
        }

        /// S`悪I
        public bool IsEnd()
        {
            return drawEnd;
        }
        /// <summary>
        /// ^Ỏ͂s܂
        /// </summary>
        private void AnalyzeTag()
        {
            ShellDrawInfo shellDrawInfo = infos[curInfoIndex];
            List<ScenarioParser.UnknownTagInfo> tag = shellDrawInfo.scenarioParser.UnknownTags;
            while (shellDrawInfo.analyzedTag < tag.Count && tag[shellDrawInfo.analyzedTag].Pos <= shellDrawInfo.textCount.Value())
            {
                string[] tagStr = tag[shellDrawInfo.analyzedTag].Tag.Split(new char[] { ',' });
                string cc = tagStr[0];
                int found = -1; // not found marker
                for (int i = 0; i < tags.Length; ++i)
                {
                    if (cc == tags[i])
                    {
                        found = i;
                        //Log.print("SED tag %s", tags[found]);
                        break;
                    }
                }

                //	̃^Ȍ
                switch (found)
                {
                    case 0:		// readstop
                        if (tagStr.Length >= 2)
                        {
                            readwait = Convert.ToInt32(tagStr[1]);
                            readWaitTimer.Reset();
                        }
                        break;

                    case 1:		// nowait
                        shellDrawInfo.textCount.opAssign(tag[shellDrawInfo.analyzedTag + 1].Pos);
                        break;

                    case 2:		// nowaitend
                        break;

                    case 3:		// push
                        curInfoIndex++;
                        break;

                    default:
                        break;
                }

                shellDrawInfo.analyzedTag++;
            }	// while
        }
    }
}
