using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;

namespace Yamalib.Draw.Effect
{
    /// <summary>
    /// g`łeNX`NX
    /// AeNX`TCYzĔg`悷邱Ƃ͂ł܂B
    /// </summary>
    public class RipplingTexture
    {
        #region 萔l

        private const int WEIGHT = 8;
        private const int WEIGHTO = WEIGHT - 4;
        private const int HSIZE = 4;
        private const int ZM = 256;	//ZM͔g̐xłB2ׂ̂ŕ\鐔ɂƏȂ܂B

        // WԂ̋\܂
        private static readonly int[][] POW;

        #endregion

        #region otB[h

        private int m_w;
        private int m_h;
        private bool alpha;
        private Surface surfaceOrg;	//!< 摜̃IWi
        private Surface surface;
        private ITexture texture;	// ʂɕ\邽߂̃eNX`

        // g̏
        private int[] m_pixelsWaveInfo;
        // g̑Ȍ
        private int[] pbOldState;
        private int[] pmOldState;

        #endregion

        /// <summary>
        /// ÓIRXgN^
        /// </summary>
        static RipplingTexture()
        {
            POW = new int[HSIZE * 2][];
            for (int x = 0; x < POW.Length; x++)
            {
                POW[x] = new int[HSIZE * 2];
                for (int y = 0; y < POW.Length; y++)
                {
                    long tmp = (x - HSIZE) * (x - HSIZE) + (y - HSIZE) * (y - HSIZE);
                    POW[x][y] = (int)System.Math.Sqrt(tmp);
                }
            }
        }

        /// <summary>
        ///  RXgN^
        /// </summary>
        public RipplingTexture()
        {
            texture = YamalibConst.CreateTexture();
        }

        unsafe public void OnMove(IScreen screen)
        {

            if (surface == null) return;

            int py;
            int curIndex;

            MoveRipple();

            for (int y = 1; y < m_h - 1; y++)
            {
                // ̍s̐擪CfbNX
                py = m_w * y;
                for (int x = 1; x < m_w - 1; x++)
                {
                    // ݃sNZ̃CfbNXԍ
                    curIndex = py + x;
                    int r, g, b;
                    if (alpha)
                    {
                        Sdl.SDL.SDL_Color* srcPixels = (Sdl.SDL.SDL_Color*)surfaceOrg.Pixels;
                        Sdl.SDL.SDL_Color* dstPixels = (Sdl.SDL.SDL_Color*)surface.Pixels;

                        // ƂƂ̐FfƂ̔g                        
                        r = srcPixels[curIndex].r + (m_pixelsWaveInfo[curIndex] >> 8);
                        g = srcPixels[curIndex].g + (m_pixelsWaveInfo[curIndex] >> 8);
                        b = srcPixels[curIndex].b + (m_pixelsWaveInfo[curIndex] >> 8);

                        // ꂪۂɕ\z
                        dstPixels[curIndex].r = (byte)(r > 255 ? 255 : (r < 0 ? 0 : r));
                        dstPixels[curIndex].g = (byte)(g > 255 ? 255 : (g < 0 ? 0 : g));
                        dstPixels[curIndex].b = (byte)(b > 255 ? 255 : (b < 0 ? 0 : b));
                        dstPixels[curIndex].unused = srcPixels[curIndex].unused;
                    }
                    else
                    {
                        Sdl.SDL.SDL_Color* srcPixels = (Sdl.SDL.SDL_Color*)surfaceOrg.Pixels;
                        Sdl.SDL.SDL_Color* dstPixels = (Sdl.SDL.SDL_Color*)surface.Pixels;

                        // ƂƂ̐FfƂ̔g                        
                        r = srcPixels[curIndex].r + (m_pixelsWaveInfo[curIndex] >> 8);
                        g = srcPixels[curIndex].g + (m_pixelsWaveInfo[curIndex] >> 8);
                        b = srcPixels[curIndex].b + (m_pixelsWaveInfo[curIndex] >> 8);

                        // ꂪۂɕ\z
                        dstPixels[curIndex].r = (byte)(r > 255 ? 255 : (r < 0 ? 0 : r));
                        dstPixels[curIndex].g = (byte)(g > 255 ? 255 : (g < 0 ? 0 : g));
                        dstPixels[curIndex].b = (byte)(b > 255 ? 255 : (b < 0 ? 0 : b));
                    }
                }
            }
        }

        public ITexture GetTexture()
        {
            if (surface == null) return null;

            //// eNX`ɃZbg
            // ̃\bh̓T[tFCX̏LȂ
            texture.SetSurface(surface);

            return texture;
        }

        /// g𐶐
        public void CreateWave(int mx, int my, int sz)
        {
            if (surface == null)
            {
                return;
            }

            int r;
            for (int x = -HSIZE; x < HSIZE; x++)
            {
                for (int y = -HSIZE; y < HSIZE; y++)
                {

                    r = POW[x + HSIZE][y + HSIZE];
                    if (r <= HSIZE)
                    {
                        //ɉĔg̋
                        m_pixelsWaveInfo[GetOff(x + mx, y + my)] = sz >> r;
                    }	// if

                }	// for
            }	// for
        }

        /// T[tFCX̐ݒ
        public void SetSurface(Surface surface_)
        {
            if (surface_ == null)
            {
                //Log.printError("RipplingTexture#SetSurface : surface is null!!");
                return;
            }

            // IWiT[tFCX
            surfaceOrg = surface_;

            // T[tFCX̕ƍTĂ		
            m_w = surface_.Width;
            m_h = surface_.Height;
            alpha = surface_.Alpha;

            if (surface != null)
            {
                surface.Release();
            }
            else
            {
                surface = new Surface();
            }

            surface.CreateDIB(m_w, m_h, alpha);
            // T[tFCX̃Rs[
            surface.Blt(surfaceOrg, 0, 0);

            // ꔭT[tFCX𐶐Ă
            texture.SetSurface(surface);

            // gƗpXy[X̊m
            m_pixelsWaveInfo = new int[m_w * m_h];
            pbOldState = new int[m_w * m_h];
            pmOldState = new int[m_w * m_h];
        }

        #region J\bh

        /// X,YWnzCfbNX߂
        private int GetOff(int x, int y)
        {
            if (x < 0 || x >= m_w - 1)
                x = 0;
            if (y < 0 || y >= m_h - 1)
                y = 0;
            return y * m_w + x;
        }

        private void MoveRipple()
        {
            const int BORDER = 58 * ZM;
            int f;
            int py;
            int curIndex;
            for (int y = 1; y < m_h - 1; y++)
            {
                // ̍s̐擪CfbNX
                py = m_w * y;
                for (int x = 1; x < m_w - 1; x++)
                {
                    // ݃sNZ̃CfbNXԍ
                    curIndex = py + x;

                    if (m_pixelsWaveInfo[curIndex] == 0
                    && pbOldState[curIndex - m_w] == 0
                    && m_pixelsWaveInfo[curIndex + m_w] == 0
                    && m_pixelsWaveInfo[curIndex + 1] == 0
                    && pbOldState[curIndex - 1] == 0)
                        continue;

                    f = pmOldState[curIndex] +
                            ((m_pixelsWaveInfo[curIndex] * WEIGHTO   //
                              + pbOldState[curIndex - m_w]        //1dot
                              + m_pixelsWaveInfo[curIndex + m_w]  //1dot
                              + m_pixelsWaveInfo[curIndex + 1]    //1dotE
                              + pbOldState[curIndex - 1]          // 1dot
                                )
                             >> 3); // Ff̕

                    // Ŕǧ肳
                    f -= (f >> 7);

                    pmOldState[curIndex] = f - (pbOldState[curIndex] = m_pixelsWaveInfo[curIndex]);
                    //                m_pixelsWaveInfo[curIndex] = f;

                    if (f > BORDER)
                    {
                        m_pixelsWaveInfo[curIndex] = BORDER;
                    }
                    else
                    {
                        m_pixelsWaveInfo[curIndex] = f;
                    }

                }
            }
        }



        #endregion


    }
}
