using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.System;
using Kyojin.Model;
using Yamalib.Input;
using Yanesdk.Draw;
using Yanesdk.GUIParts;
using Yamalib.Util;
using Yamalib.GUI;
using Yanesdk.Input;
using Yamalib;
using System.Diagnostics;
using Kyojin.Component.Option;

namespace Kyojin.Scene.Option
{
    /// <summary>
    /// IvVݒ
    /// </summary>
    class OptionScene : TaskBase, IDisposable
    {
        #region 萔l

        private const int volChipWidth = 19;

        // \ʒu
        private static readonly Point[] GUI_POS = new Point[]{
			    new Point(214,106),new Point(366,106),	// Window / Full
			    new Point(214,145),new Point(290,145),new Point(366,145),new Point(442,145),	// ͑x
			    new Point(442,199),	// afl
			    new Point(442,239),	// VOICE
			    new Point(442,279),	// ʉ
			    new Point(214,335),	// L[RtBO
			    new Point(538,425),	// ߂
            };

        /// <summary>
        /// {^̖Ot
        /// </summary>
        private enum eButtonID : int
        {
            WINDOW, FULL,// EBhE[h
            T_NORMAL, T_FAST, T_LINE, T_PAGE,	// ͑x
            BGM_OFF,	// bgm on/off
            VOICE_OFF,	// voice on/off
            SE_OFF,		//  se on/off
            KEY_CONFIG,	// L[ݒ
            BACK,		// IA^CgA߂
        };

        /// <summary>
        /// XC_[̖Ot
        /// </summary>
        private enum eSliderID : int
        {
            BGM,
            VOICE,
            SE,
        };

        private static int[] VOL_ONOFF = {
		    (int)eButtonID.BGM_OFF,
		    (int)eButtonID.VOICE_OFF,
		    (int)eButtonID.SE_OFF,
	    };

        private static readonly string KEY_CONF_DLG_DEF_FILENAME = "img/dialog/dialog_keyconfig.txt";

        #endregion

        #region otB[h
        private GameSystem m_gSys;
        private bool m_init = false;

        private IMouseInput m_mouse;
        private OptionInfo m_optionInfo;
        private ITexture m_titleTex;
        private RootCounterS m_tox;	//!< ^CgeNX`̃XChCItZbg

        private ITexture m_imgBg;
        private ITexture m_baseTexOn;
        private ITexture m_baseTexOff;
        private ITexture m_barTexOn;
        private ITexture m_barTexOff;

        private TextureLoader textureLoader;

        private FocusableTextureGUIControl textureGuiCtrl = new FocusableTextureGUIControl();
        private ControlContext ctrlContext;
        private List<TextureGUIControl.Control> m_button = new List<TextureGUIControl.Control>();
        private List<TextureGUIControl.Control> m_optionCtrls = new List<TextureGUIControl.Control>();
        private List<Slider> m_volBar = new List<Slider>();
        private RootCounterS alpha = new RootCounterS(0, 255, 4);
        private bool m_showDlg;
        private KeyConfigDialog m_keyConfDlg;
        private bool returnSceneFlg = false;

        #endregion


        #region IDisposable o

        public void Dispose()
        {
            YamalibUtility.Dispose(m_imgBg);
            YamalibUtility.Dispose(m_baseTexOn);
            YamalibUtility.Dispose(m_baseTexOff);
            YamalibUtility.Dispose(m_barTexOn);
            YamalibUtility.Dispose(m_barTexOff);

            textureGuiCtrl = null;
            ctrlContext = null;
            m_button = null;
            m_optionCtrls = null;
            m_volBar = null;
            alpha = null;
        }

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="gameSystem"></param>
        public OptionScene(GameSystem gameSystem)
        {
            m_gSys = gameSystem;
            textureLoader = gameSystem.SmartTextureLoader.LoadDefFile("img/option/op_bt.lst", false);

            //Rg[̏
            ctrlContext = new ControlContext();
            ctrlContext.MouseInput = ((NullableMouseInput)m_gSys.Mouse).GetOriginal() as MouseInput;
            ctrlContext.SmartTextureLoader = m_gSys.SmartTextureLoader;
            ctrlContext.SmartSoundLoader = m_gSys.SmartSoundLoader;
            ctrlContext.Param = new FocusableGUIParam(m_gSys.KeyDecolateMouse, m_gSys.Key);
            textureGuiCtrl.OnInit(ctrlContext);
        }

        public override int Task(object o)
        {
            GameSystem gameSystem = (GameSystem)o;
            if (0 == OnMove(gameSystem))
            {
                return 0;
            }
            gameSystem.OnMoveCommon();
            if (!gameSystem.FpsTimer.ToBeSkip)
            {
                gameSystem.Screen.Select();
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
                gameSystem.Screen.Update();
            }
            else
            {
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
            }
            return 1;
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="gameSystem"></param>
        private void OnPaint(GameSystem gameSystem)
        {
            m_gSys.Screen.Clear();
            m_gSys.Screen.BlendSrcAlpha();

            if (!alpha.IsEnd)
            {
                m_gSys.Screen.SetColor(255, 255, 255, alpha.Value());
            }

            // wi`
            m_gSys.Screen.Blt(m_imgBg, 0, 0);
            // ^Cg`
            m_gSys.Screen.Blt(m_titleTex, m_tox.ValueSined(), 0);

            // At@MAX
            m_gSys.Screen.SetColor(255, 255, 255, 255);

            // {^̕`
            textureGuiCtrl.OnPaint(m_gSys.Screen);

            // XC_[`
            foreach (Slider sb in m_volBar)
            {
                sb.OnDraw(m_gSys.Screen);
            }

            if (m_showDlg)
            {
                EnableInputDevice();
                m_gSys.JoyStick.Update();
                m_keyConfDlg.OnPaint(m_gSys.Screen, ctrlContext, 0, 0);
                if (m_keyConfDlg.IsFinish())
                {
                    m_keyConfDlg.Hide();
                    // L[}bsOXV
                    UpdateJoystickMapping(m_keyConfDlg.GetKeyButtonIDs());
                    // ۑ
                    SetKeyConfigData(m_gSys.JoyStick.DeviceName, m_keyConfDlg.GetKeyButtonIDs());
                    m_showDlg = false;
                }
                else
                {
                    DisableInputDevice();
                }
            }

        }

        /// <summary>
        /// ړ
        /// </summary>
        /// <param name="gameSystem"></param>
        private int OnMove(GameSystem gameSystem)
        {
            if (!m_init)
            {
                m_init = true;
                OnInit();
            }

            if (returnSceneFlg)
            {
                // ꂪ΂ƁÃ^XNDispose
                m_gSys.SceneController.ReturnScene();
                // Z[u
                m_gSys.SaveUserInfo(KyojinConst.SAVE_HEADER_FILE);
                m_gSys.PlaySystemSE((int)GameSystem.SYS_SE.CLICK_TITLE_NEGATIVE);

                return 0;
            }

            gameSystem.Screen.BlendSrcAlpha();
            alpha.Inc();
            m_tox.Inc();

            textureGuiCtrl.OnMoveFocus();

            //XC_[
            int loopCount = 0;
            foreach (Slider slider in m_volBar)
            {
                if (slider.IsModifiy())
                {
                    int vol = (int)(100 * slider.GetSlidePos());
                    switch ((eSliderID)loopCount)
                    {
                        case eSliderID.BGM:
                            SetBGMVolume(vol);
                            if (!m_optionInfo.BGMOn)
                            {
                                OnClickVolumeOff(VOL_ONOFF[loopCount], m_optionInfo.BGMOn, loopCount);
                                m_optionInfo.BGMOn = !m_optionInfo.BGMOn;
                            }
                            break;
                        case eSliderID.SE:
                            m_optionInfo.SEVolume = vol;
                            if (!m_optionInfo.SEOn)
                            {
                                OnClickVolumeOff(VOL_ONOFF[loopCount], m_optionInfo.SEOn, loopCount);
                                m_optionInfo.SEOn = !m_optionInfo.SEOn;
                            }
                            break;
                        case eSliderID.VOICE:
                            m_optionInfo.VoiceVolume = vol;
                            if (!m_optionInfo.VoiceOn)
                            {
                                OnClickVolumeOff(VOL_ONOFF[loopCount], m_optionInfo.VoiceOn, loopCount);
                                m_optionInfo.VoiceOn = !m_optionInfo.VoiceOn;
                            }
                            break;
                        default:
                            break;
                    }
                }
                loopCount++;
            }

            m_mouse.Update();
            m_gSys.Key.Update();
            m_gSys.CommonSeLoader.UpdateSE();

            // GtFNgȂ炱ł
            if (!alpha.IsEnd)
            {
                return 1;
            }
            return 1;
        }

        /// <summary>
        /// BGM{[̐ݒ
        /// </summary>
        /// <param name="vol"></param>
        private void SetBGMVolume(int vol)
        {
            m_optionInfo.BGMVolume = vol;
            /*
            int bgmNo = m_gSys.CommonBgmLoader.IsP
                int bgmNo = info.bgmloader.getBGMNo();
                if (0 <= bgmNo && info.bgmloader.isPlay(bgmNo))
                {
                    info.bgmloader.Get(bgmNo).SetVolume(vol);
                }
             * */
        }


        /// <summary>
        ///  
        /// </summary>
        private void OnInit()
        {
            m_optionInfo = m_gSys.OptionInfo;
            m_mouse = m_gSys.KeyDecolateMouse;

            m_imgBg = YamalibConst.CreateTexture("img/option/bg.jpg");
            m_titleTex = YamalibConst.CreateTexture("img/option/op_title_last.png");
            m_tox = new RootCounterS(-50, 0, 1);

            //{^
            OnInitGUICtrol();

            // XC_[
            OnInitSlider();

            // L[tH[JX
            textureGuiCtrl.AddFocusGUI(m_optionCtrls[0].Parts as FocusableTextureGUI);
            textureGuiCtrl.AddFocusGUI(m_optionCtrls[1].Parts as FocusableTextureGUI);
            textureGuiCtrl.AddFocusGUI(m_optionCtrls[2].Parts as FocusableTextureGUI);
            textureGuiCtrl.AddFocusGUI(m_optionCtrls[3].Parts as FocusableTextureGUI);
            textureGuiCtrl.AddFocusGUI(m_optionCtrls[4].Parts as FocusableTextureGUI);
            textureGuiCtrl.AddFocusGUI(m_optionCtrls[5].Parts as FocusableTextureGUI);
            textureGuiCtrl.AddFocusGUI(m_volBar[0] as FocusableTextureGUI);
            textureGuiCtrl.AddFocusGUI(m_optionCtrls[6].Parts as FocusableTextureGUI);
            textureGuiCtrl.AddFocusGUI(m_volBar[1] as FocusableTextureGUI);
            textureGuiCtrl.AddFocusGUI(m_optionCtrls[7].Parts as FocusableTextureGUI);
            textureGuiCtrl.AddFocusGUI(m_volBar[2] as FocusableTextureGUI);
            textureGuiCtrl.AddFocusGUI(m_optionCtrls[8].Parts as FocusableTextureGUI);
            textureGuiCtrl.AddFocusGUI(m_optionCtrls[9].Parts as FocusableTextureGUI);
            textureGuiCtrl.AddFocusGUI(m_optionCtrls[10].Parts as FocusableTextureGUI);

            textureGuiCtrl.Focus(0);

            textureGuiCtrl.OnPaint(m_gSys.Screen);
        }

        /// <summary>
        /// XC_[̐
        /// </summary>
        private void OnInitSlider()
        {
            int[][] SLIDER_POS = new int[][]{
			        new int[]{214,199},
			        new int[]{214,239},
			        new int[]{214,279},
            };
            const int BAR_OFFSETX = 6;
            const int BAR_OFFSETY = 24;
            const int BAR_LENGTH = 194;

            m_baseTexOn = YamalibConst.CreateTexture("img/option/op_vol_bar_on.png");
            m_baseTexOff = YamalibConst.CreateTexture("img/option/op_vol_bar_off.png");
            m_barTexOn = YamalibConst.CreateTexture("img/option/op_bt_l_on.png");
            m_barTexOff = YamalibConst.CreateTexture("img/option/op_bt_l_off.png");

            bool[] volOn = new bool[] { m_optionInfo.BGMOn, m_optionInfo.VoiceOn, m_optionInfo.SEOn };
            int[] vol = new int[] { m_optionInfo.BGMVolume, m_optionInfo.VoiceVolume, m_optionInfo.SEVolume };

            for (int i = 0; i < 3; ++i)
            {
                Slider sb = new Slider();
                sb.SetKey(m_gSys.Key);

                if (volOn[i])
                {
                    sb.SetBaseTexture(m_baseTexOn);
                    sb.SetBarTexture(m_barTexOn);
                }
                else
                {
                    sb.SetBaseTexture(m_baseTexOff);
                    sb.SetBarTexture(m_barTexOff);
                }

                sb.SetXY(SLIDER_POS[i][0], SLIDER_POS[i][1]);
                sb.SetSliderOffset(BAR_OFFSETX, BAR_OFFSETY);
                sb.SetLength(BAR_LENGTH);
                sb.SetSlidePos(vol[i] / 100.0f);

                m_volBar.Add(sb);

                textureGuiCtrl.AddControl(sb, SLIDER_POS[i][0], SLIDER_POS[i][1]);
                //textureGuiCtrl.AddFocusGUI(sb as FocusableTextureGUI);
            }
        }

        /// <summary>
        /// GUI{^𐶐
        /// </summary>
        private void OnInitGUICtrol()
        {
            // {^̉摜ԍ
            int[] bt_no = 
			    {	0,4,		// window
				    8,12,16,20,	// ͑x
				    24,	// bgm
				    24,	// voice
				    24,	// se
				    28,
				    32
			    };

            int i = 0;
            string buttonDefFile = "img/option/op_bt.lst";
            foreach (Point point in GUI_POS)
            {
                FocusableTextureButton bt = new FocusableTextureButton(buttonDefFile, false);
                // C[W̃ItZbg
                bt.LoaderOffset = bt_no[i];
                bt.OnClick += GetButtonEvent(i);
                SetDefaultButtonState(bt, i);
                TextureGUIControl.Control ctrl = new TextureGUIControl.Control(bt, (int)point.X, (int)point.Y);
                textureGuiCtrl.AddControl(ctrl);
                m_optionCtrls.Add(ctrl);

                //textureGuiCtrl.AddFocusGUI(bt);
                ++i;
            }
        }

        private void SetDefaultButtonState(FocusableTextureButton button, int buttonId)
        {
            switch ((eButtonID)buttonId)
            {
                case eButtonID.WINDOW:
                    if (m_optionInfo.WindowMode)
                    {
                        button.Enable = false;
                    }
                    break;
                case eButtonID.FULL:
                    if (!m_optionInfo.WindowMode)
                    {
                        button.Enable = false;
                    }
                    break;
                case eButtonID.T_NORMAL:
                    if (m_optionInfo.TextSpeed == (int)OptionInfo.TEXT_SPEED.NORMAL)
                    {
                        button.Enable = false;
                    }
                    break;
                case eButtonID.T_FAST:
                    if (m_optionInfo.TextSpeed == (int)OptionInfo.TEXT_SPEED.FAST)
                    {
                        button.Enable = false;
                    }
                    break;
                case eButtonID.T_LINE:
                    if (m_optionInfo.TextSpeed == (int)OptionInfo.TEXT_SPEED.LINE)
                    {
                        button.Enable = false;
                    }
                    break;
                case eButtonID.T_PAGE:
                    if (m_optionInfo.TextSpeed == (int)OptionInfo.TEXT_SPEED.PAGE)
                    {
                        button.Enable = false;
                    }
                    break;
                case eButtonID.BGM_OFF:
                    if (!m_optionInfo.BGMOn)
                    {
                        button.LoaderOffset += 1;
                    }
                    break;
                case eButtonID.VOICE_OFF:
                    if (!m_optionInfo.VoiceOn)
                    {
                        button.LoaderOffset += 1;
                    }
                    break;
                case eButtonID.SE_OFF:
                    if (!m_optionInfo.SEOn)
                    {
                        button.LoaderOffset += 1;
                    }
                    break;
                case eButtonID.KEY_CONFIG:
                    if (!m_gSys.IsEnableJoystick)
                    {
                        button.Enable = false;
                    }
                    break;
                case eButtonID.BACK:
                    break;
                default:
                    break;
            }
        }

        /// <summary>
        /// e{^Rg[ɕt^fQ[hԋp
        /// </summary>
        /// <param name="buttonId"></param>
        /// <returns></returns>
        private TextureButton.MouseEvent GetButtonEvent(int buttonId)
        {
            switch ((eButtonID)buttonId)
            {
                case eButtonID.WINDOW:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        if (!m_optionInfo.WindowMode)
                        {
                            SwitchButton(m_optionCtrls[(int)eButtonID.WINDOW], m_optionCtrls[(int)eButtonID.FULL]);
                            m_optionInfo.WindowMode = true;
                        }
                        m_gSys.PlaySEActive();
                    };
                case eButtonID.FULL:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        if (m_optionInfo.WindowMode)
                        {
                            SwitchButton(m_optionCtrls[(int)eButtonID.FULL], m_optionCtrls[(int)eButtonID.WINDOW]);
                            m_optionInfo.WindowMode = false;
                        }
                        m_gSys.PlaySEActive();
                    };
                case eButtonID.T_NORMAL:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        if (m_optionInfo.TextSpeed != (int)OptionInfo.TEXT_SPEED.NORMAL)
                        {
                            SwitchTextSpeedButton((int)eButtonID.T_NORMAL, m_optionInfo.TextSpeed);
                            m_optionInfo.TextSpeed = (int)OptionInfo.TEXT_SPEED.NORMAL;
                        }
                        m_gSys.PlaySEActive();
                    };
                case eButtonID.T_FAST:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        if (m_optionInfo.TextSpeed != (int)OptionInfo.TEXT_SPEED.FAST)
                        {
                            SwitchTextSpeedButton((int)eButtonID.T_FAST, m_optionInfo.TextSpeed);
                            m_optionInfo.TextSpeed = (int)OptionInfo.TEXT_SPEED.FAST;
                        }
                        m_gSys.PlaySEActive();
                    };
                case eButtonID.T_LINE:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        if (m_optionInfo.TextSpeed != (int)OptionInfo.TEXT_SPEED.LINE)
                        {
                            SwitchTextSpeedButton((int)eButtonID.T_LINE, m_optionInfo.TextSpeed);
                            m_optionInfo.TextSpeed = (int)OptionInfo.TEXT_SPEED.LINE;
                        }
                        m_gSys.PlaySEActive();
                    };
                case eButtonID.T_PAGE:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        if (m_optionInfo.TextSpeed != (int)OptionInfo.TEXT_SPEED.PAGE)
                        {
                            SwitchTextSpeedButton((int)eButtonID.T_PAGE, m_optionInfo.TextSpeed);
                            m_optionInfo.TextSpeed = (int)OptionInfo.TEXT_SPEED.PAGE;
                        }
                        m_gSys.PlaySEActive();
                    };
                case eButtonID.BGM_OFF:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        OnClickVolumeOff((int)eButtonID.BGM_OFF, m_optionInfo.BGMOn, (int)eSliderID.BGM);
                        m_optionInfo.BGMOn = !m_optionInfo.BGMOn;
                        m_gSys.PlaySEActive();
                    };
                case eButtonID.VOICE_OFF:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        OnClickVolumeOff((int)eButtonID.VOICE_OFF, m_optionInfo.VoiceOn, (int)eSliderID.VOICE);
                        m_optionInfo.VoiceOn = !m_optionInfo.VoiceOn;
                        m_gSys.PlaySEActive();
                    };
                case eButtonID.SE_OFF:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        OnClickVolumeOff((int)eButtonID.SE_OFF, m_optionInfo.SEOn, (int)eSliderID.SE);
                        m_optionInfo.SEOn = !m_optionInfo.SEOn;
                        m_gSys.PlaySEActive();
                    };
                case eButtonID.KEY_CONFIG:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        m_keyConfDlg = KeyConfigDialog.CreateDialogBox(
                                        m_gSys.createDialogResources(),
                                        KEY_CONF_DLG_DEF_FILENAME,
                                        ctrlContext,
                                        m_gSys.JoyStick,
                                        4, 5);
                        m_showDlg = true;
                        DisableInputDevice();
                        m_gSys.PlaySEActive();
                    };
                case eButtonID.BACK:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        returnSceneFlg = true;
                        //// ꂪ΂ƁÃ^XNDispose
                        //m_gSys.SceneController.ReturnScene();
                        //// Z[u
                        //m_gSys.SaveUserInfo(KyojinConst.SAVE_HEADER_FILE);

                        //m_gSys.PlaySystemSE((int)GameSystem.SYS_SE.CLICK_TITLE_NEGATIVE);
                    };
                default:
                    Debug.Assert(false);
                    return null;
            }
        }

        private void DisableInputDevice()
        {
            // ׂẴ{^𖳌ɂĂ
            NullableMouseInput aMouse = (NullableMouseInput)m_gSys.Mouse;
            NullableKeyInput aKey = (NullableKeyInput)m_gSys.Key;
            NullableMouseInput aKeyMouse = (NullableMouseInput)m_gSys.KeyDecolateMouse;
            JoyStick aJoystick = m_gSys.JoyStick;
            aMouse.Disable();
            aKey.Disable();
            aKeyMouse.Disable();
        }

        private void EnableInputDevice()
        {
            // ׂẴ{^𖳌ɂĂ
            NullableMouseInput aMouse = (NullableMouseInput)m_gSys.Mouse;
            NullableKeyInput aKey = (NullableKeyInput)m_gSys.Key;
            NullableMouseInput aKeyMouse = (NullableMouseInput)m_gSys.KeyDecolateMouse;
            JoyStick aJoystick = m_gSys.JoyStick;
            aMouse.Enable();
            aKey.Enable();
            aKeyMouse.Enable();
        }
        /// ݒ肵KEY ID Abvf[g
        private void UpdateJoystickMapping(List<int> buttonIDs)
        {
            MousedKey aMouse = (MousedKey)((NullableKeyInput)m_gSys.Key).GetOriginal();
            aMouse.Init();
            aMouse.AddJoyKeyLeft(buttonIDs[0]);
            aMouse.AddJoyKeyRight(buttonIDs[1]);
            aMouse.AddJoyKeyWheelUp(buttonIDs[2]);
            aMouse.AddJoyKeyWheelDown(buttonIDs[3]);
            aMouse.AddJoyKeyExit(buttonIDs[4]);
        }

        /// <summary>
        /// ݒ肳ꂽL[RtBOۑ
        /// </summary>
        /// <param name="deviceName"></param>
        /// <param name="keyData"></param>
        private void SetKeyConfigData(string deviceName, List<int> keyData)
        {
            if (null == m_gSys.KeyConfigData)
            {
                m_gSys.KeyConfigData = new KeyConfigData();
            }
            m_gSys.KeyConfigData.DeviceName = deviceName;
            for (int i = 0; i < keyData.Count; i++)
            {
                m_gSys.KeyConfigData.SetKeyData(i, new int[] { keyData[i] });
            }
        }

        /// <summary>
        /// ON/OFFRg[̐ݒԂ؂ւ
        /// </summary>
        /// <param name="type"></param>
        /// <param name="flg"></param>
        /// <param name="sliderId"></param>
        private void OnClickVolumeOff(int type, bool flg, int sliderId)
        {
            if (flg)
            {
                SetButtonStateWithImgOffset(m_optionCtrls[type], true);

                // XC_[摜ւ
                ReplaceTexture(m_volBar[sliderId], m_baseTexOff, m_barTexOff);
            }
            else
            {
                SetButtonStateWithImgOffset(m_optionCtrls[type], false);

                // XC_[摜ւ
                ReplaceTexture(m_volBar[sliderId], m_baseTexOn, m_barTexOn);
            }
        }

        /// <summary>
        /// XC_[o[̃eNX`
        /// </summary>
        /// <param name="slider"></param>
        /// <param name="baseTex"></param>
        /// <param name="barTex"></param>
        private void ReplaceTexture(Slider slider, ITexture baseTex, ITexture barTex)
        {
            slider.SetBaseTexture(baseTex);
            slider.SetBarTexture(barTex);
        }

        /// <summary>
        /// eLXgXs[hݒ̃{^؂ւ
        /// </summary>
        /// <param name="activeButtonIndex"></param>
        /// <param name="oldActvieTextSpeed"></param>
        private void SwitchTextSpeedButton(int activeButtonIndex, int oldActvieTextSpeed)
        {
            switch ((OptionInfo.TEXT_SPEED)oldActvieTextSpeed)
            {
                case OptionInfo.TEXT_SPEED.NORMAL:
                    SwitchButton(m_optionCtrls[activeButtonIndex], m_optionCtrls[(int)eButtonID.T_NORMAL]);
                    break;
                case OptionInfo.TEXT_SPEED.FAST:
                    SwitchButton(m_optionCtrls[activeButtonIndex], m_optionCtrls[(int)eButtonID.T_FAST]);
                    break;
                case OptionInfo.TEXT_SPEED.LINE:
                    SwitchButton(m_optionCtrls[activeButtonIndex], m_optionCtrls[(int)eButtonID.T_LINE]);
                    break;
                case OptionInfo.TEXT_SPEED.PAGE:
                    SwitchButton(m_optionCtrls[activeButtonIndex], m_optionCtrls[(int)eButtonID.T_PAGE]);
                    break;
                default:
                    Debug.Assert(false);
                    break;
            }
        }

        /// <summary>
        /// {^ԂύX
        /// </summary>
        /// <param name="ctrl"></param>
        /// <param name="enable"></param>
        private void SetButtonState(TextureGUIControl.Control ctrl, bool enable)
        {
            FocusableTextureButton bt = ctrl.Parts as FocusableTextureButton;
            if (null != bt)
            {
                bt.Enable = enable;
            }
        }

        private void SetButtonStateWithImgOffset(TextureGUIControl.Control ctrl, bool enable)
        {
            FocusableTextureButton bt = ctrl.Parts as FocusableTextureButton;
            if (null != bt)
            {
                if (enable)
                {
                    bt.LoaderOffset += 1;
                }
                else
                {
                    bt.LoaderOffset -= 1;
                }
            }
        }

        /// <summary>
        /// ꂼ̃Rg[ANeBuƖɐ؂ւ
        /// </summary>
        /// <param name="activeCtrl"></param>
        /// <param name="disableCtrl"></param>
        private void SwitchButton(TextureGUIControl.Control activeCtrl, TextureGUIControl.Control disableCtrl)
        {
            SetButtonState(activeCtrl, false);
            SetButtonState(disableCtrl, true);
        }

        private void SwitchButtonWithImgOffset(TextureGUIControl.Control activeCtrl, TextureGUIControl.Control disableCtrl)
        {
            SetButtonStateWithImgOffset(activeCtrl, false);
            SetButtonStateWithImgOffset(disableCtrl, true);
        }
    }
}
