using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.System;
using Kyojin.Model;
using Yanesdk.Draw;
using Yamalib.Input;
using Yamalib.Util;
using Yamalib.GUI;
using Yanesdk.GUIParts;
using Yamalib;
using System.Diagnostics;
using Yanesdk.Input;

namespace Kyojin.Scene.EndingOption
{
    class EndingOptionScene : TaskBase, IDisposable
    {
        private delegate void EndSceneEvent();
        #region 萔l

        // {^̖Ot
        private enum eButtonID : int
        {
            AUTO_PLAY,
            SHOW_GUIDE,
            SHOW_MOVIE,
            SHOW_TIME,
            SHOW_SCORE,
            START,
            BACK,		// IA^CgA߂
        };

        // \ʒu
        private static readonly Point[] BT_POS = new Point[]{
			new Point(238,100),	// I[gvC
			new Point(238,146),	// KCh\
			new Point(238,192),	// [r[\
			new Point(238,238),	// ^C\
			new Point(238,284),	// XRA\
			new Point(300,338),	// vC
			new Point(538,425),	// ߂
        };

        // {^̉摜ԍ
        private static readonly int[] BT_NO = new int[] {
				0,	// I[gvC
				0,	// KCh\
				0,	// [r[\
				0,	// ^C\
				0,	// XRA\
				4,
				8
        };


        #endregion

        #region otB[h

        private GameSystem m_gSys;
        private IMouseInput m_mouse;

        private ITexture m_titleTex;
        private RootCounterS m_tox;	//!< ^CgeNX`̃XChCItZbg

        private ITexture bg;

        private FocusableTextureGUIControl textureGuiCtrl = new FocusableTextureGUIControl();
        private ControlContext ctrlContext;
        private List<FocusableTextureButton> m_button = new List<FocusableTextureButton>();
        private EndSceneEvent endSceneEvent = null;

        private readonly RootCounterS alpha;

        private bool init;

        #endregion

        public EndingOptionScene(GameSystem gameSystem)
        {
            m_gSys = gameSystem;
            alpha = new RootCounterS(0, 255, 4);
        }


        #region IDisposable o

        public void Dispose()
        {
            YamalibUtility.Dispose(m_titleTex);
            textureGuiCtrl = null;
            ctrlContext = null;
            m_button = null;
        }

        #endregion

        public override int Task(object o)
        {
            GameSystem gameSystem = (GameSystem)o;
            if (0 == OnMove(gameSystem))
            {
                return 0;
            }
            gameSystem.OnMoveCommon();
            if (!gameSystem.FpsTimer.ToBeSkip)
            {
                gameSystem.Screen.Select();
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
                gameSystem.Screen.Update();
            }
            else
            {
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
            }
            return 1;
        }

        /// <summary>
        /// 쏈
        /// </summary>
        /// <param name="gameSystem"></param>
        private int OnMove(GameSystem gameSystem)
        {
            // 
            if (!init)
            {
                init = true;
                OnInit();
            }


            m_gSys.CommonSeLoader.UpdateSE();
            m_gSys.Screen.BlendSrcAlpha();
            alpha++;
            m_tox++;

            m_mouse.Update();
            m_gSys.Key.Update();

            textureGuiCtrl.OnMoveFocus();

            if (alpha.IsEnd && endSceneEvent != null)
            {
                endSceneEvent();
                return 0;
            }

            return 1;
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="gameSystem"></param>
        private void OnPaint(GameSystem gameSystem)
        {

            // 
            if (!init)
            {
                init = true;
                OnInit();
            }

            m_gSys.Screen.Clear();
            m_gSys.Screen.BlendSrcAlpha();

            if (!alpha.IsEnd)
            {
                m_gSys.Screen.SetColor(255, 255, 255, alpha.Value());
            }

            // wi`
            m_gSys.Screen.Blt(bg, 0, 0);
            // ^Cg`
            m_gSys.Screen.Blt(m_titleTex, m_tox.ValueSined(), 0);

            textureGuiCtrl.OnPaint(m_gSys.Screen);
        }


        #region Jo

        private void OnInit()
        {
            m_mouse = m_gSys.KeyDecolateMouse;

            //Rg[̏
            ctrlContext = new ControlContext();
            ctrlContext.MouseInput = ((NullableMouseInput)m_gSys.Mouse).GetOriginal() as MouseInput;
            ctrlContext.SmartTextureLoader = m_gSys.SmartTextureLoader;
            ctrlContext.SmartSoundLoader = m_gSys.SmartSoundLoader;
            ctrlContext.Param = new FocusableGUIParam(m_gSys.KeyDecolateMouse, m_gSys.Key);
            textureGuiCtrl = new FocusableTextureGUIControl();
            textureGuiCtrl.OnInit(ctrlContext);


            // {^
            string defFilename = "img2/ending/option/op_bt.lst";
            for (int i = 0; i < BT_POS.Length; i++)
            {
                FocusableTextureButton bt = new FocusableTextureButton(defFilename, false);
                bt.LoaderOffset = BT_NO[i];
                bt.OnClick += GetButtonEvent(i);
                TextureGUIControl.Control ctrl = new TextureGUIControl.Control(bt, (int)BT_POS[i].X, (int)BT_POS[i].Y);
                textureGuiCtrl.AddControl(ctrl);
                m_button.Add(bt);

                textureGuiCtrl.AddFocusGUI(bt);
            }

            // wieNX`[h
            bg = YamalibConst.CreateTexture("img2/ending/option/bg.jpg");
            // ^CgeNX`
            m_titleTex = YamalibConst.CreateTexture("img2/ending/option/op_title_last.png");
            m_tox = new RootCounterS();
            m_tox.Set(-50, 0, 2);

            // {^̏
            for (int i = 0; i < m_button.Count; i++)
            {
                FocusableTextureButton bt = m_button[i];
                switch ((eButtonID)i)
                {
                    case eButtonID.AUTO_PLAY:
                    case eButtonID.SHOW_GUIDE:
                    case eButtonID.SHOW_MOVIE:
                    case eButtonID.SHOW_TIME:
                    case eButtonID.SHOW_SCORE:
                        {
                        }
                        break;
                    case eButtonID.START:
                        {
                        }
                        break;
                    case eButtonID.BACK:
                        {
                        }
                        break;
                    default:
                        Debug.Assert(false);
                        break;
                }
            }

            textureGuiCtrl.Focus(0);

        }

        //private bool autoPlayFlg = false;
        private bool showGuidFlg = false;
        private bool showMovieFlg = false;
        private bool showTimeFlg = false;
        private bool showScoreFlg = false;

        /// <summary>
        /// e{^Rg[ɕt^fQ[hԋp
        /// </summary>
        /// <param name="buttonId"></param>
        /// <returns></returns>
        private TextureButton.MouseEvent GetButtonEvent(int buttonId)
        {
            switch ((eButtonID)buttonId)
            {
                case eButtonID.AUTO_PLAY:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        //m_gSys.KyojinEndingSceneParam.IsAutoPlay = !m_gSys.KyojinEndingSceneParam.IsAutoPlay;
                        //OnClickOption(m_button[(int)eButtonID.AUTO_PLAY], ref autoPlayFlg);
                        // {^SEĐ
                        m_gSys.PlaySENegative();
                    };
                case eButtonID.SHOW_GUIDE:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        m_gSys.KyojinEndingSceneParam.IsShowGuide = !m_gSys.KyojinEndingSceneParam.IsShowGuide;
                        OnClickOption(m_button[(int)eButtonID.SHOW_GUIDE], ref showGuidFlg);
                        // {^SEĐ
                        m_gSys.PlaySEActive();
                    };
                case eButtonID.SHOW_MOVIE:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        m_gSys.KyojinEndingSceneParam.IsShowMovie = !m_gSys.KyojinEndingSceneParam.IsShowMovie;
                        OnClickOption(m_button[(int)eButtonID.SHOW_MOVIE], ref showMovieFlg);
                        // {^SEĐ
                        m_gSys.PlaySEActive();
                    };
                case eButtonID.SHOW_TIME:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        m_gSys.KyojinEndingSceneParam.IsShowTime = !m_gSys.KyojinEndingSceneParam.IsShowTime;
                        OnClickOption(m_button[(int)eButtonID.SHOW_TIME], ref showTimeFlg);
                        // {^SEĐ
                        m_gSys.PlaySEActive();
                    };
                case eButtonID.SHOW_SCORE:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        m_gSys.KyojinEndingSceneParam.IsShowScore = !m_gSys.KyojinEndingSceneParam.IsShowScore;
                        OnClickOption(m_button[(int)eButtonID.SHOW_SCORE], ref showScoreFlg);
                        // {^SEĐ
                        m_gSys.PlaySEActive();
                    };
                case eButtonID.START:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        m_gSys.DisableAllInputDevie();
                        endSceneEvent = delegate()
                        {
                            // ^Cgʂafl̏I
                            m_gSys.CommonBgmLoader.StopFade(0, 1000);

                            // ׂẴX^bNj		
                            m_gSys.SceneController.ExitScene();
                            m_gSys.SceneController.JumpScene(Scenes.Ending);
                            m_gSys.EnableAllInputDevie();
                        };
                        alpha.Set(255, 0, 3);
                    };
                case eButtonID.BACK:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        endSceneEvent = delegate()
                        {
                            m_gSys.SceneController.ReturnScene();
                        };
                        m_gSys.PlaySystemSE((int)GameSystem.SYS_SE.CLICK_TITLE_NEGATIVE);
                        alpha.Set(255, 0, 3);
                    };
                default:
                    Debug.Assert(false);
                    break;
            }
            return null;
        }

        /// BGM OFF NbNꂽƂ̏
        private void OnClickOption(FocusableTextureButton bt, ref bool flg)
        {
            if (null != bt)
            {
                if (!flg)
                {
                    bt.LoaderOffset += 1;
                    //bt.Enable = true;
                }
                else
                {
                    bt.LoaderOffset -= 1;
                    //bt.Enable = false;
                }
                flg = !flg;
            }
        }



        #endregion

    }
}
