using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Timer;
using Yanesdk.Draw;
using Yamalib.Util;
using Yamalib.Yanesdkext.Draw;
using Yanesdk.Math;
using Yanesdk.Movie;

namespace Kyojin.Component.Ending
{
    public class Scene03 : Scene01
    {

        #region 萔l

        private const long START_TIME = 88300 + MUSIC_OFFSET_TIME;
        private const long END_TIME = 153700 + MUSIC_OFFSET_TIME;

        #endregion

        #region otB[h


        private Rand rand;
        private bool useMovie;
        private MoviePlayer moviePlayer;
        private List<MovieFileInfo> movieFileInfos;

        private Phase2Base phase1_1;
        private Phase2Base phase1_3;
        private Phase2Base phase2_1;
        private Phase2Base phase2_3;
        private Phase2Base phase3_1;
        private Phase2Base phase3_3;
        private Phase2Base phase4_1;
        private Phase2Base phase4_3;
        private Phase2Base phase5_1;
        private Phase2Base phase5_3;
        private Phase2Base phase6_1;
        private Phase2Base phase6_3;
        private Phase7 phase7_1;
        private Phase7 phase7_2;
        private Phase7 phase7_3;
        private Phase7 phase7_4;
        private Phase7 phase7_5;
        private Phase7 phase7_6;
        private Phase7 phase7_7;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="timer"></param>
        public Scene03(FixTimer timer, bool useMovie)
            : base(timer)
        {
            rand = new Rand();
            rand.Randomize();

            this.useMovie = useMovie;
            if (useMovie)
            {
                movieFileInfos = MovieFileInfo.CreateFromDefFile("img2/ending/movie/movielist.txt");
                moviePlayer = new MoviePlayer();
                moviePlayer.SetPlayFile(movieFileInfos);
            }

            textureLoader = new TextureLoader();
            textureLoader.IsDefRelativePath = false;
            textureLoader.LoadDefFile("img2/ending/s03/list.txt");
            this.timer = timer;
            SetupTimingData();
        }

        /// ׂẲ摜LbV	
        public override void CacheTexture()
        {
            CacheTextureAll(textureLoader, "img2/ending/s03/list.txt");
        }

        // V[͊JnĂ邩
        public override bool IisStart
        {
            get { return START_TIME <= timer.Time; }
        }

        // V[I
        public override bool IsEnd
        {
            get { return sceneEndFlg || END_TIME <= timer.Time; }
        }

        //// \[X̉
        //public override void Release()
        //{
        //    textureLoader.Dispose();
        //}

        /// ^C~Of[^쐬
        protected override void SetupTimingData()
        {
            const long phase3Offset = 88000 + MUSIC_OFFSET_TIME;
            TimingData[] t3_1 = new TimingData[]{
			    new TimingData( 2170 + phase3Offset, new HitEvent[]{eventCallback1_1}), 
			    new TimingData( 2880 + phase3Offset, new HitEvent[]{eventCallback1_2}), 
			    new TimingData( 4840 + phase3Offset, new HitEvent[]{eventCallback1_3}), 
			    new TimingData( 5510 + phase3Offset, new HitEvent[]{eventCallback1_4}), 
			    new TimingData( 7500 + phase3Offset, new HitEvent[]{eventCallback1_5}), 
			    new TimingData( 8320 + phase3Offset, new HitEvent[]{eventCallback1_6}), 
			    new TimingData(10160 + phase3Offset, new HitEvent[]{eventCallback1_7}),
			    new TimingData(10810 + phase3Offset, new HitEvent[]{eventCallback1_8}),
		    };
            m_timingData.Add(t3_1);

            TimingData[] t3_2 = new TimingData[]{
			    new TimingData(12820 + phase3Offset, new HitEvent[]{eventCallback2_1}),
			    new TimingData(13480 + phase3Offset, new HitEvent[]{eventCallback2_2}),
			    new TimingData(15480 + phase3Offset, new HitEvent[]{eventCallback2_3}),
			    new TimingData(16150 + phase3Offset, new HitEvent[]{eventCallback2_4}),
			    new TimingData(18140 + phase3Offset, new HitEvent[]{eventCallback2_5}),
			    new TimingData(18970 + phase3Offset, new HitEvent[]{eventCallback2_6}),
			    new TimingData(20810 + phase3Offset, new HitEvent[]{eventCallback2_7}),
			    new TimingData(21640 + phase3Offset, new HitEvent[]{eventCallback2_8}),
		    };
            m_timingData.Add(t3_2);

            TimingData[] t3_3 = new TimingData[]{
			    new TimingData(23480 + phase3Offset, new HitEvent[]{eventCallback3_1}),
			    new TimingData(24160 + phase3Offset, new HitEvent[]{eventCallback3_2}),
			    new TimingData(26150 + phase3Offset, new HitEvent[]{eventCallback3_3}),
			    new TimingData(26850 + phase3Offset, new HitEvent[]{eventCallback3_4}),
			    new TimingData(28820 + phase3Offset, new HitEvent[]{eventCallback3_5}),
			    new TimingData(29660 + phase3Offset, new HitEvent[]{eventCallback3_6}),
			    new TimingData(31470 + phase3Offset, new HitEvent[]{eventCallback3_7}),
			    new TimingData(32260 + phase3Offset, new HitEvent[]{eventCallback3_8}),
		    };
            m_timingData.Add(t3_3);

            TimingData[] t3_4 = new TimingData[]{
			    new TimingData(34150 + phase3Offset, new HitEvent[]{eventCallback4_1}),
			    new TimingData(34810 + phase3Offset, new HitEvent[]{eventCallback4_2}),
			    new TimingData(36810 + phase3Offset, new HitEvent[]{eventCallback4_3}),
			    new TimingData(37490 + phase3Offset, new HitEvent[]{eventCallback4_4}),
			    new TimingData(39460 + phase3Offset, new HitEvent[]{eventCallback4_5}),
			    new TimingData(40270 + phase3Offset, new HitEvent[]{eventCallback4_6}),
			    new TimingData(42150 + phase3Offset, new HitEvent[]{eventCallback4_7}),
			    new TimingData(42960 + phase3Offset, new HitEvent[]{eventCallback4_8}),
		    };
            m_timingData.Add(t3_4);

            TimingData[] t3_5 = new TimingData[]{
			    new TimingData(MUSIC_OFFSET_TIME + 132820, new HitEvent[]{eventCallback5_1}),
			    new TimingData(MUSIC_OFFSET_TIME + 133490, new HitEvent[]{eventCallback5_2}),
			    new TimingData(MUSIC_OFFSET_TIME + 135480, new HitEvent[]{eventCallback5_3}),
			    new TimingData(MUSIC_OFFSET_TIME + 136160, new HitEvent[]{eventCallback5_4}),
			    new TimingData(MUSIC_OFFSET_TIME + 138140, new HitEvent[]{eventCallback5_5}),
			    new TimingData(MUSIC_OFFSET_TIME + 138980, new HitEvent[]{eventCallback5_6}),
			    new TimingData(MUSIC_OFFSET_TIME + 140810, new HitEvent[]{eventCallback5_7}),
			    new TimingData(MUSIC_OFFSET_TIME + 141650, new HitEvent[]{eventCallback5_8}),
		    };
            m_timingData.Add(t3_5);

            TimingData[] t3_6 = new TimingData[]{
			    new TimingData(MUSIC_OFFSET_TIME + 143490, new HitEvent[]{eventCallback6_1}),
			    new TimingData(MUSIC_OFFSET_TIME + 144140, new HitEvent[]{eventCallback6_2}),
			    new TimingData(MUSIC_OFFSET_TIME + 146130, new HitEvent[]{eventCallback6_3}),
			    new TimingData(MUSIC_OFFSET_TIME + 146820, new HitEvent[]{eventCallback6_4}),
			    new TimingData(MUSIC_OFFSET_TIME + 148820, new HitEvent[]{eventCallback6_5}),
			    new TimingData(MUSIC_OFFSET_TIME + 149640, new HitEvent[]{eventCallback6_6}),
		    };
            m_timingData.Add(t3_6);

            TimingData[] t3_7 = new TimingData[]{
			    new TimingData(62500 + phase3Offset, new HitEvent[]{eventCallback7_1}),
			    new TimingData(62840 + phase3Offset, new HitEvent[]{eventCallback7_2}),
			    new TimingData(63190 + phase3Offset, new HitEvent[]{eventCallback7_3}),
			    new TimingData(63500 + phase3Offset, new HitEvent[]{eventCallback7_4}),
			    new TimingData(63840 + phase3Offset, new HitEvent[]{eventCallback7_5}),
			    new TimingData(64120 + phase3Offset, new HitEvent[]{eventCallback7_6}),
			    new TimingData(64500 + phase3Offset, new HitEvent[]{eventCallback7_7}),
		    };
            m_timingData.Add(t3_7);
        }

        public override void OnMove(IScreen screen)
        {
            foreach (PhaseBase phase in activePhase)
            {
                phase.OnMove(screen);
            }
            foreach (HittingEffect hitEffect in hitEffects)
            {
                if (hitEffect != null)
                {
                    hitEffect.OnMove(screen);
                }
            }

            if (useMovie)
            {
                moviePlayer.OnMove(screen);
            }
        }

        public override void OnDraw(IScreen screen)
        {
            foreach (PhaseBase phase in activePhase)
            {
                phase.OnDraw(screen);
            }
            foreach (HittingEffect hitEffect in hitEffects)
            {
                if (hitEffect != null)
                {
                    hitEffect.OnPaint(screen);
                }
            }

            if (useMovie)
            {
                moviePlayer.OnDraw(screen);
            }
        }

        /// <summary>
        /// 
        /// </summary>
        public override void Release()
        {
            base.Release();
            if (movieFileInfos != null)
            {
                foreach (MovieFileInfo movieFileInfo in movieFileInfos)
                {
                    if (null != movieFileInfo)
                    {
                        movieFileInfo.Dispose();
                    }
                }
            }
        }

        #region IDisposable o

        public override void Dispose()
        {
            Release();
        }

        #endregion


        #region qbgCxg

        // ========================================================================================== //
        // =================================     PHASE 1 - 1     ==================================== //
        // ========================================================================================== //

        /// 1-1 
        bool eventCallback1_1(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // Xe[^XJEg
            CountHitStatus(status);
            try
            {
                // poor  error Ȃ΃[r[
                if (moviePlayer != null && GamePointcalculator().PoorCount == 0 && GamePointcalculator().ErrorCount == 0)
                {
                    moviePlayer.Play();
                }
                else
                {
                    useMovie = false;
                }
            }
            catch (Exception)
            {
                ////Log.print("PLAY MOVIE ERROR:%s", e.toString());
                useMovie = false;
            }
            if (IsHitedStatus(status))
            {
                phase1_1 = new Phase2Base(textObj, textureLoader, status);
                phase1_1.SetImgNo(0);
                phase1_1.SetXY(189, 180);
                phase1_1.GetTransCounter().Set(0, 255, 4);
                phase1_1.SetEffectNo(20);

                activePhase.Add(phase1_1);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 1-2 
        bool eventCallback1_2(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase1_1 != null)
                {
                    phase1_1.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-3 k
        bool eventCallback1_3(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase1_3 = new Phase2Base(textObj, textureLoader, status);
                phase1_3.SetImgNo(1);
                phase1_3.SetXY(262, 233);
                phase1_3.GetTransCounter().Set(0, 255, 4);
                phase1_3.SetEffectNo(20);

                activePhase.Add(phase1_3);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 1-4@u[
        bool eventCallback1_4(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase1_3 != null)
                {
                    phase1_3.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 1-5@hbv
        bool eventCallback1_5(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase1_1 != null)
                {
                    phase1_1.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 1-6@hbv
        bool eventCallback1_6(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase1_3 != null)
                {
                    phase1_3.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-7@tF[h
        bool eventCallback1_7(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase1_1 != null)
                {
                    if (IsHitedStatus(status))
                    {
                        phase1_1.FadeOut();
                    }
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 1-8@u[
        bool eventCallback1_8(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase1_3 != null)
                {
                    phase1_3.FadeOut();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        // ========================================================================================== //
        // =================================     PHASE 1 - 2     ==================================== //
        // ========================================================================================== //
        /// 2-1 
        bool eventCallback2_1(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[Y͏I
            activePhase.Clear();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase2_1 = new Phase2Base(textObj, textureLoader, status);
                phase2_1.SetImgNo(2);
                phase2_1.SetXY(216, 189);
                phase2_1.GetTransCounter().Set(0, 255, 4);
                phase2_1.SetEffectNo(20);

                activePhase.Add(phase2_1);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 2-2 
        bool eventCallback2_2(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase2_1 != null)
                {
                    phase2_1.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 2-3 @lice
        bool eventCallback2_3(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase2_3 = new Phase2Base(textObj, textureLoader, status);
                phase2_3.SetImgNo(3);
                phase2_3.SetXY(274, 233);
                phase2_3.GetTransCounter().Set(0, 255, 4);
                phase2_3.SetEffectNo(20);

                activePhase.Add(phase2_3);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 2-4@u[
        bool eventCallback2_4(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase2_3 != null)
                {
                    phase2_3.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 2-5@hbv
        bool eventCallback2_5(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase2_1 != null)
                {
                    phase2_1.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 2-6@hbv
        bool eventCallback2_6(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase2_3 != null)
                {
                    phase2_3.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 2-7@tF[h
        bool eventCallback2_7(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase2_1 != null)
                {
                    phase2_1.FadeOut();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 2-8@u[
        bool eventCallback2_8(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase2_3 != null)
                {
                    phase2_3.FadeOut();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        // ========================================================================================== //
        // =================================     PHASE 1 - 3     ==================================== //
        // ========================================================================================== //
        /// 3-1 
        bool eventCallback3_1(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[Y͏I
            activePhase.Clear();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_1 = new Phase2Base(textObj, textureLoader, status);
                phase3_1.SetImgNo(4);
                phase3_1.SetXY(191, 180);
                phase3_1.GetTransCounter().Set(0, 255, 4);
                phase3_1.SetEffectNo(20);

                activePhase.Add(phase3_1);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 3-2 
        bool eventCallback3_2(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase3_1 != null)
                {
                    phase3_1.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 3-3 @lice
        bool eventCallback3_3(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_3 = new Phase2Base(textObj, textureLoader, status);
                phase3_3.SetImgNo(1);
                phase3_3.SetXY(262, 233);
                phase3_3.GetTransCounter().Set(0, 255, 4);
                phase3_3.SetEffectNo(20);

                activePhase.Add(phase3_3);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 3-4@u[
        bool eventCallback3_4(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase3_3 != null)
                {
                    phase3_3.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 3-5@hbv
        bool eventCallback3_5(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase3_1 != null)
                {
                    phase3_1.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 3-6@hbv
        bool eventCallback3_6(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase3_3 != null)
                {
                    phase3_3.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 3-6@tF[h
        bool eventCallback3_7(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase3_1 != null)
                {
                    if (HitStatus.POOR != status)
                    {
                        phase3_1.FadeOut();
                    }
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 3-4@u[
        bool eventCallback3_8(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase3_3 != null)
                {
                    phase3_3.FadeOut();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        // ========================================================================================== //
        // =================================     PHASE 1 - 4     ==================================== //
        // ========================================================================================== //
        /// 4-1 
        bool eventCallback4_1(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[Y͏I
            activePhase.Clear();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_1 = new Phase2Base(textObj, textureLoader, status);
                phase4_1.SetImgNo(5);
                phase4_1.SetXY(191, 180);
                phase4_1.GetTransCounter().Set(0, 255, 4);
                phase4_1.SetEffectNo(20);

                activePhase.Add(phase4_1);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 4-2 
        bool eventCallback4_2(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase4_1 != null)
                {
                    phase4_1.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 4-3 
        bool eventCallback4_3(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_3 = new Phase2Base(textObj, textureLoader, status);
                phase4_3.SetImgNo(6);
                phase4_3.SetXY(241, 233);
                phase4_3.GetTransCounter().Set(0, 255, 4);
                phase4_3.SetEffectNo(20);

                activePhase.Add(phase4_3);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 4-4@u[
        bool eventCallback4_4(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase4_3 != null)
                {
                    phase4_3.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 4-5@hbv
        bool eventCallback4_5(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase4_1 != null)
                {
                    phase4_1.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 4-6@hbv
        bool eventCallback4_6(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase4_3 != null)
                {
                    phase4_3.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 4-6@tF[h
        bool eventCallback4_7(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase4_1 != null)
                {
                    if (HitStatus.POOR != status)
                    {
                        phase4_1.FadeOut();
                    }
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 4-4@u[
        bool eventCallback4_8(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase4_3 != null)
                {
                    phase4_3.FadeOut();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        // ========================================================================================== //
        // =================================     PHASE 1 - 5     ==================================== //
        // ========================================================================================== //
        /// 5-1 
        bool eventCallback5_1(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[Y͏I
            activePhase.Clear();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase5_1 = new Phase2Base(textObj, textureLoader, status);
                phase5_1.SetImgNo(7);
                phase5_1.SetXY(190, 185);
                phase5_1.GetTransCounter().Set(0, 255, 4);
                phase5_1.SetEffectNo(20);

                activePhase.Add(phase5_1);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 5-2 
        bool eventCallback5_2(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase5_1 != null)
                {
                    phase5_1.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 5-3 @lice
        bool eventCallback5_3(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase5_3 = new Phase2Base(textObj, textureLoader, status);
                phase5_3.SetImgNo(8);
                phase5_3.SetXY(270, 234);
                phase5_3.GetTransCounter().Set(0, 255, 4);
                phase5_3.SetEffectNo(20);

                activePhase.Add(phase5_3);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 5-4@u[
        bool eventCallback5_4(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase5_3 != null)
                {
                    phase5_3.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 5-5@hbv
        bool eventCallback5_5(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase5_1 != null)
                {
                    phase5_1.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 5-6@hbv
        bool eventCallback5_6(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase5_3 != null)
                {
                    phase5_3.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 5-6@tF[h
        bool eventCallback5_7(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase5_1 != null)
                {
                    if (HitStatus.POOR != status)
                    {
                        phase5_1.FadeOut();
                    }
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 5-4@u[
        bool eventCallback5_8(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase5_3 != null)
                {
                    phase5_3.FadeOut();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        // ========================================================================================== //
        // =================================     PHASE 1 - 6     ==================================== //
        // ========================================================================================== //
        /// 6-1 
        bool eventCallback6_1(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[Y͏I
            activePhase.Clear();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase6_1 = new Phase2Base(textObj, textureLoader, status);
                phase6_1.SetImgNo(9);
                phase6_1.SetXY(192, 181);
                phase6_1.GetTransCounter().Set(0, 255, 4);
                phase6_1.SetEffectNo(20);

                activePhase.Add(phase6_1);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 6-2 
        bool eventCallback6_2(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase6_1 != null)
                {
                    phase6_1.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 6-3 @lice
        bool eventCallback6_3(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase6_3 = new Phase2Base(textObj, textureLoader, status);
                phase6_3.SetImgNo(10);
                phase6_3.SetXY(235, 231);
                phase6_3.GetTransCounter().Set(0, 255, 4);
                phase6_3.SetEffectNo(20);

                activePhase.Add(phase6_3);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 6-4@u[
        bool eventCallback6_4(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase6_3 != null)
                {
                    phase6_3.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 6-5@hbv
        bool eventCallback6_5(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase6_1 != null)
                {
                    phase6_1.Drop();
                    phase6_1.FadeOut();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 6-6@hbv
        bool eventCallback6_6(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase6_3 != null)
                {
                    phase6_3.Drop();
                    phase6_3.FadeOut();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        // ========================================================================================== //
        // =================================     PHASE 1 - 7     ==================================== //
        // ========================================================================================== //
        /// 7-1 
        bool eventCallback7_1(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[Y͏I
            activePhase.Clear();
            hitEffects.Clear();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase7_1 = new Phase7(textObj, textureLoader, status);
                phase7_1.SetImgNo(12);
                activePhase.Add(phase7_1);
            }

            hitEffects.Add(CreateHitEffect(textObj));
            // ͎Oł̂łł[
            return true;
        }
        /// 7-2 
        bool eventCallback7_2(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase7_2 = new Phase7(textObj, textureLoader, status);
                phase7_2.SetImgNo(13);
                activePhase.Add(phase7_2);
            }
            hitEffects.Add(CreateHitEffect(textObj));
            // ͎Oł̂łł[
            return true;
        }

        /// 7-3 @lice
        bool eventCallback7_3(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                phase7_3 = new Phase7(textObj, textureLoader, status);
                phase7_3.SetImgNo(14);
                activePhase.Add(phase7_3);
            }

            hitEffects.Add(CreateHitEffect(textObj));
            // ͎Oł̂łł[
            return true;
        }
        /// 7-4@TEXT
        bool eventCallback7_4(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase7_4 = new Phase7(textObj, textureLoader, status);
                phase7_4.SetImgNo(15);
                activePhase.Add(phase7_4);
            }
            hitEffects.Add(CreateHitEffect(textObj));
            // ͎Oł̂łł[
            return true;
        }
        /// 7-5@LN^[
        bool eventCallback7_5(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                phase7_5 = new Phase7(textObj, textureLoader, status);
                phase7_5.SetImgNo(16);
                activePhase.Add(phase7_5);
            }

            hitEffects.Add(CreateHitEffect(textObj));
            // ͎Oł̂łł[
            return true;
        }

        /// 7-6@TEXT
        bool eventCallback7_6(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase7_6 = new Phase7(textObj, textureLoader, status);
                phase7_6.SetImgNo(17);
                activePhase.Add(phase7_6);
            }
            hitEffects.Add(CreateHitEffect(textObj));
            // ͎Oł̂łł[
            return true;
        }

        /// 7-7@TEXT
        bool eventCallback7_7(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase7_7 = new Phase7(textObj, textureLoader, status);
                phase7_7.SetImgNo(18);
                activePhase.Add(phase7_7);
            }

            hitEffects.Add(CreateHitEffect(textObj));
            // ͎Oł̂łł[
            return true;
        }

        #endregion

    }
}
