using System;
using System.Collections.Generic;
using System.Text;
using Yamalib.Util;
using Yanesdk.Draw;
using Yanesdk.System;
using Yanesdk.Math;
using Yamalib.Yanesdkext.Draw;
using Yamalib.Draw;
using Yanesdk.Ytl;
using System.Diagnostics;
using Yamalib.Scenario;

namespace Yamalib.Model
{
    public class Character : ICharacterImageResource
    {
        public const String PRESET_LEFT = "left";
        public const String PRESET_CENTER = "center";
        public const String PRESET_RIGHT = "right";

        public enum PresetPosID : int
        {
            LEFT = 1,
            CENTER = 2,
            RIGHT = 3,
            UNSET = -1
        };

        #region ÓItB[h
        static int C_CHARA_BLT_Y = 0;
        #endregion


        #region tB[ho
        /// <summary>
        /// vZbgėʒu̔ԍ
        /// </summary>
        private PresetPosID preset_pos = PresetPosID.UNSET;
        /// <summary>
        /// Lړϐ
        /// </summary>
        private readonly RootCounterS charaMove;
        /// <summary>
        /// ʒuwW
        /// </summary>
        private int posx;
        private int posy;
        /// <summary>
        /// XChCAAEgAtO
        /// </summary>
        private int slide = 0;
        /// <summary>
        /// LGtFNgҋ@tO
        /// </summary>
        private bool wait = false;
        /// <summary>
        /// GtFNgALN^ŃNA邩@
        /// LN^\ɂȂƂALN^gꍇOffɂ
        /// </summary>
        private bool autoClear = true;

        //	    private static int[String] charMap;		//!< 
        /// <summary>
        /// LN^[ԍƃLN^[hcƂ̘AzL
        /// </summary>
        private static Dictionary<String, int> charMap = new Dictionary<string, int>();
        private static CSVReader lineParser = new CSVReader();	//!< Cp[T
        private readonly static SinTable st = SinTable.Instance;

        /// <summary>
        /// LN^[摜̃[_
        /// </summary>
        private TextureLoader textureLoader;
        private int charNo;		//!< LN^[ԍ
        private int charNoOld;	//!< Oɕ\ĂLN^[ԍ
        private String strCharId;	//!< LN^[̂hc
        private String strCharIdOld;	//!< Oɕ\ĂLN^̂hc

        private int preX;		//!< ÕLN^[\Ăʒu
        private int preY;
        /// <summary>
        /// `J[
        /// </summary>
        private Color4ub m_color = new Color4ub(255, 255, 255, 255);

        private int slideOffsetX;

        /// <summary>
        /// \ItZbgʒu
        /// </summary>
        private int m_offsetx;
        private int m_offsety;

        /// <summary>
        /// ʂ̕
        /// </summary>
        private int m_viewWidth;

        /// <summary>
        /// gWbgGtFNgԍ
        /// </summary>
        private int effectNo;
        /// <summary>
        /// gWbgԍuOp
        /// </summary>
        private int effectNoBack;
        /// <summary>
        ///  LGtFNgϐ
        /// </summary>
        private RootCounterS effectPhaseCounter;
        /// <summary>
        /// LGtFNgϐ
        /// </summary>
        //private InteriorCounter charaEffectPre;
        private RootCounterS charaEffectPre;
        /// <summary>
        /// tF[hLp̃JE^
        /// </summary>
        //        private BackCharaAlaphaCounter backCharaAlphaCounter;
        /// <summary>
        /// LutO
        /// </summary>
        private bool replace;

        #endregion

        #region vpeB

        /// <summary>
        /// LN^[ړw肵ꍇ̈ړ
        /// </summary>
        public RootCounterS SlideCounter
        {
            get { return charaMove; }
        }

        /// <summary>
        /// LN^[GtFNgɕׂăXChғ
        /// wł
        /// </summary>
        public bool IsSlide
        {
            get { return slide != 0; }
        }

        /// <summary>
        /// XChw肵Ƃ̈ړTCY
        /// </summary>
        public int SlideOffsetX
        {
            get { return slideOffsetX; }
        }

        /// <summary>
        /// wWw肵ĕ\ꍇ̈ʒu
        /// </summary>
        public int X
        {
            get { return posx; }
            set { posx = value; }
        }

        public int Y
        {
            get { return posy; }
            set { posy = value; }
        }

        /// <summary>
        /// 
        /// </summary>
        public float Size
        {
            get { return 1.0f; }
            set { throw new Exception("Not Imprimented"); }
        }

        /// <summary>
        /// vZbgĂʒuhc
        /// </summary>
        public PresetPosID PresetPos
        {
            get { return preset_pos; }
            set { preset_pos = value; }
        }

        /// <summary>
        /// GtFNgĂƂɁAҋ@邩ǂ̃tO
        /// ̃tO݂邩ǂ́AgpĂ郆[U̎R
        /// </summary>
        public bool WaitFlg
        {
            get { return wait; }
            set { wait = value; }
        }

        /// <summary>
        /// gp̏ԂɂȂƂɁAIɖgpԂɂAɂB
        /// \ԂɂƂɁA܂AĎgpƂOFFɂ
        /// ftHgtrue
        /// </summary>
        public bool AutoClearFlg
        {
            get { return autoClear; }
            set { autoClear = value; }
        }

        /// <summary>
        /// LN^[̃ItZbgʒu
        /// </summary>
        public int CharacterOffsetX
        {
            get { return m_offsetx; }
            set { m_offsetx = value; }
        }

        /// <summary>
        /// LN^[̃ItZbgʒu
        /// YŎw肵ʒu{Ŏw肵ʒu
        /// `ʒuɂȂ
        /// </summary>
        public int CharacterOffsetY
        {
            get { return m_offsety; }
            set { m_offsety = value; }
        }

        /// <summary>
        /// \ʂ̃TCYw肷B
        /// ̒lɁAvZbgʒuoB
        /// ftHg640
        /// </summary>
        public int ViewWidth
        {
            get { return m_viewWidth; }
            set { m_viewWidth = value; }
        }

        /// <summary>
        /// LN^[̕\J[
        /// </summary>
        public Color4ub Color
        {
            get { return m_color; }
            set { m_color = value; }
        }

        /// <summary>
        /// \̃LN^[G
        /// ̃tOONɂ΁AOɕ\ĂLN^[
        /// w肳ꂽGtFNgŃtF[hAEgÃ݂LN^[
        /// \
        /// </summary>
        public bool ReplaceFlg
        {
            get { return replace; }
            set { replace = value; }
        }

        public bool IsEffecting
        {
            get
            {
                return (!charaMove.IsEnd || !effectPhaseCounter.IsEnd);
            }
        }

        /// <summary>
        /// GtFNgԍ
        /// </summary>
        public int EffectNo
        {
            set { effectNo = value; }
            get { return effectNo; }
        }

        /// <summary>
        /// GtFNg̈ʑ
        /// </summary>
        public int EffectPhase
        {
            get { return effectPhaseCounter.Value(); }
            //            Set { effectPhaseCounter = value as RootCounterS; }
        }

        /// <summary>
        /// gpĂ邩
        /// </summary>
        public bool IsShowing
        {
            get
            {
                return ((charNo == -1 || strCharId == null) ? false : true);
            }
        }

        #endregion

        /// Ɣԍ̃}bv
        public static void SetCharMap(String filename)
        {
            if (null == filename)
            {
                throw new Exception("param is null");
            }
            lineParser.Read(filename);
            int count = 0;
            foreach (List<String> lineData in lineParser.CsvData)
            {
                if (2 > lineData.Count || lineData[0].ToCharArray()[0] == '#')
                {
                    continue;
                }
                charMap[lineData[1]] = count++;
                Console.WriteLine("charMap added: " + lineData[1] + " - " + (count - 1));
            }
        }

        /// <summary>
        /// 񂩂|WVIDɕϊ
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public static PresetPosID ToPresetPos(String value)
        {
            switch (value.ToLower())
            {
                case PRESET_LEFT:
                    return PresetPosID.LEFT;
                case PRESET_CENTER:
                    return PresetPosID.CENTER;
                case PRESET_RIGHT:
                    return PresetPosID.RIGHT;
                default:
                    return PresetPosID.CENTER;
            }
        }

        /// <summary>
        /// LN^}bv̎擾
        /// </summary>
        /// <returns></returns>
        public static Dictionary<String, int> GetCharacterMap()
        {
            return charMap;
        }

        /// RXgN^
        public Character()
        {
            charaMove = new RootCounterS();
            charaMove.Set(0, 0, 1);	// 
            effectPhaseCounter = new RootCounterS(0, TransBltter.PAHSE_MAX, 2);
            charaEffectPre = new RootCounterS();
            Reset();
            m_viewWidth = YamalibConst.DEFAULT_SCRENN_WIDTH; // ftHg
        }

        /// <summary>
        /// \eNX`ԋp
        /// </summary>
        /// <returns></returns>
        public ITexture GetTexture()
        {
            if (null != textureLoader)
            {
                return textureLoader.GetTexture(GetTextureNo());
            }
            return null;
        }

        /// LN^[eNX`[_̐ݒ
        public void SetTextureLoader(TextureLoader tl)
        {
            Debug.Assert(tl != null);
            textureLoader = tl;
        }

        /// \GtFNgH
        public bool IsEffectOut()
        {
            if (effectPhaseCounter == null)
            {
                return false;
            }
            return effectPhaseCounter.StartValue > effectPhaseCounter.EndValue;
        }

        /// \GtFNgH
        public bool IsEffectIn()
        {
            if (effectPhaseCounter == null)
            {
                return false;
            }
            return effectPhaseCounter.StartValue < effectPhaseCounter.EndValue;
        }

        /// <summary>
        /// GtFNgݒ肷
        /// start < end
        /// ł΁AtF[hCƌȂB
        /// Ȃ΃tF[hAEg
        /// </summary>
        /// <param name="effectNo"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="speed"></param>
        public void SetEffect(int effectNo, int start, int end, int speed)
        {
            this.effectNo = effectNo;
            if (start < end)
            {
                FadeIn(speed, speed);
            }
            else
            {
                FadeOut(effectNo, speed);
            }
        }

        /**
         * LN^[\̃GtFNgݒ
         * LN^[ւ̂Ƃ̃GtFNgwsetEffectReplace
         */
        public void SetEffect(int effectType, int effectSpeed)
        {
            ReplaceFlg = false;
            this.effectNo = effectType;
            this.effectPhaseCounter.Set(0, TransBltter.PAHSE_MAX, effectSpeed);
        }

        public void SetEffectReplace(string newCharaId, int fontEffectType, int frontEfectSpeed, int backEffectType, int backEffectSpeed)
        {
            SetEffect(fontEffectType, frontEfectSpeed);
            this.charaEffectPre.Set(0, TransBltter.PAHSE_MAX, backEffectSpeed);
            this.effectNoBack = backEffectType;
            ReplaceFlg = true;

            // VLN^[IDZbg
            SetCharId(newCharaId);
        }

        /// tF[hCJn
        public void FadeIn(int speed, int speedPre)
        {
            effectPhaseCounter.Set(0, TransBltter.PAHSE_MAX, speed);
            charaEffectPre.Set(0, TransBltter.PAHSE_MAX, CalcAlphaStep(speed) * speedPre);
        }

        /// tF[hAEgJn
        public void FadeOut(int effectType, int speed)
        {
            this.effectNo = effectType;
            effectPhaseCounter.Set(TransBltter.PAHSE_MAX, 0, speed);
            ReplaceFlg = false;
        }

        /// gpԂɖ߂
        public void Reset()
        {
            effectPhaseCounter.Set(TransBltter.PAHSE_MAX, TransBltter.PAHSE_MAX, 1);
            effectNo = -1;
            charNo = -1;
            preset_pos = PresetPosID.CENTER;
            strCharId = null;
            strCharIdOld = null;
            wait = false;
            replace = false;
            slide = 0;
            posx = 0;
            this.m_color.SetColor(255, 255, 255);
            charaMove.Set(0, 0, 1);
            slideOffsetX = 0;
        }

        /// LN^hcݒ肷
        public void SetCharId(String str)
        {
            if (null == str) return;
            strCharIdOld = strCharId;
            charNoOld = charNo;
            strCharId = str;

            if (!charMap.ContainsKey(str))
            {
                Console.WriteLine(str + " not find in CharaMap!");
                foreach (KeyValuePair<String, int> keyValue in charMap)
                {
                    Console.WriteLine("chara {0}:{1} )", keyValue.Key, keyValue.Value);
                }
                return;
            }

            charNo = charMap[str];
        }

        /**
         * ܃GtFNgsĂ̂ł΁AI
         * ܂AꂪLN^[AEgȂ΁AAgpԂɂ
         */
        public void EffectFinish()
        {
            int end = charaMove.EndValue;
            charaMove.opAssign(end);
            end = effectPhaseCounter.EndValue;
            effectPhaseCounter.opAssign(end);
            effectNo = -1;

            // char_out Ȃ
            if (0 == end)
            {
                Reset();
            }
        }

        /// ̃LN^[̂hcԋp
        public String GetCharId()
        {
            return strCharId;
        }

        /// LN^hc񂩂犄oeNX`ԍԂ
        public int GetTextureNo()
        {
            return charNo;
        }

        /// LN^hc񂩂犄oÕeNX`ԍԂ
        public int GetTextureNoOld()
        {
            return charNoOld;
        }

        /// <summary>
        /// XChw肷
        /// </summary>
        /// <param name="slideOffset"></param>
        /// <param name="slideSpeed"></param>
        public void SetSlide(int slideOffset, int slideSpeed)
        {
            slide = 1;
            slideOffsetX = slideOffset;
            charaMove.Set(0, slideOffset, slideSpeed);
        }


        /// <summary>
        /// `摮vZ
        /// </summary>
        /// <param name="screen">`悷ReNXg</param>
        /// <returns></returns>
        public YanesdkResult OnMove(IScreen screen)
        {
            Debug.Assert(screen != null);
            if (IsShowing)
            {
                Y = C_CHARA_BLT_Y;
                int phase = TransBltter.PAHSE_MAX;

                ITexture t1 = textureLoader.GetTexture(GetTextureNo());
                if (null == t1)
                {
                    //				    Log.printError("Texture load fault!!:%s\n", getCharId());
                    return YanesdkResult.PreconditionError;
                }

                int tx = (int)t1.Width;
                int ty = (int)t1.Height;

                if (EffectNo != -1)
                {
                    effectPhaseCounter.Inc();
                    if (charaEffectPre != null && ReplaceFlg)
                    {
                        ++charaEffectPre;
                    }
                    if (effectPhaseCounter.IsEnd)
                    {
                        wait = false;
                        replace = false;
                        if (0 == (int)effectPhaseCounter && autoClear)
                        {
                            Reset();
                        }
                        /// GtFNgȂ炱ŏI
                        if (0 == (int)effectPhaseCounter)
                        {
                            return YanesdkResult.NoError;
                        }
                    }

                    phase = (int)effectPhaseCounter;
                }

                // XCh
                if (slide != 0)
                {
                    if (preset_pos != PresetPosID.UNSET)
                    {
                        X = GetCharaPresetPos(screen, preset_pos, (int)tx);
                    }
                    else
                    {
                        // ʒuڎw
                        Y = posx - tx / 2;
                    }

                    if (!ReplaceFlg)
                    {
                        // ŏI`ʒu\z
                        preX = X + slideOffsetX;
                        preY = Y;
                    }
                    charaMove.Inc();
                    X += st.Sin((int)charaMove, slideOffsetX);
                }
                else
                {
                    // vZbg|WV
                    if (preset_pos != PresetPosID.UNSET)
                    {
                        X = GetCharaPresetPos(screen, preset_pos, tx);
                    }
                    else
                    {
                        // ʒuڎw
                        X = posx - tx / 2;
                    }
                    if (!ReplaceFlg)
                    {
                        // ŏI`ʒu\z
                        preX = X + slideOffsetX;
                        preY = Y;
                    }
                }

                if (phase == TransBltter.PAHSE_MAX)
                {
                    preX = X;
                    preY = Y;
                }
                else if (phase == 0)
                {
                    // Ă
                    Reset();
                }
            }

            return YanesdkResult.NoError;
        }

        /// LN^[̕`
        public YanesdkResult OnPaint(IScreen screen, bool draw)
        {
            Debug.Assert(screen != null);
            if (null == textureLoader)
            {
                // eNX`[_ݒ肳ĂȂ
                return YanesdkResult.PreconditionError;
            }

            if (IsShowing)
            {
                if (0 == (int)effectPhaseCounter)
                {
                    return YanesdkResult.NoError;
                }

                ITexture t1 = textureLoader.GetTexture(GetTextureNo());
                if (null == t1)
                {
                    //				    Log.printError("Texture load fault!!:%s\n", getCharId());
                    return YanesdkResult.FileNotFound;
                }

                // Color obNAbv
                Color4ub colorOrg = YanesdkUtil.GetNowScreenColor(screen);
                int phase = (int)effectPhaseCounter;

                if (TransBltter.PAHSE_MAX == (int)effectPhaseCounter)
                {
                    // `
                    screen.SetColor(m_color.R, m_color.G, m_color.B, m_color.A);
                    screen.Blt(t1, X, Y);
                }
                else if (0 != (int)effectPhaseCounter)
                {
                    if (replace)
                    {
                        // ẪeNX`\
                        ITexture oldCharaTexture = textureLoader.GetTexture(GetTextureNoOld());
                        if (null != oldCharaTexture)
                        {
                            screen.SetColor(m_color.R, m_color.G, m_color.B);
                            //TransBltter.Blt(effectNoBack, screen,
                            //    oldCharaTexture, preX + m_offsetx, preY + m_offsety, TransBltter.PAHSE_MAX - charaEffectPre.ValueSined());
                            TransBltter.Blt(effectNoBack, screen,
                                oldCharaTexture, preX + m_offsetx, preY + m_offsety, TransBltter.PAHSE_MAX - phase);
                        }
                    }
                    if (draw)
                    {
                        screen.SetColor(m_color.R, m_color.G, m_color.B, m_color.A);
                        TransBltter.Blt(effectNo, screen, t1, X + m_offsetx, Y + m_offsety, phase);
                    }
                }

                // Color ߂
                screen.SetColor(colorOrg);
            }

            return YanesdkResult.NoError;
        }


        #region J\bh


        /// LN^[̃vZbgʒu擾	
        protected int GetCharaPresetPos(IScreen screen, PresetPosID presetNumber, int textureWidth)
        {
            int halfScreenWidth = screen.Width / 2;
            switch (presetNumber)
            {
                case PresetPosID.LEFT:
                    return (halfScreenWidth - (m_viewWidth / 4)) - (textureWidth / 2);
                case PresetPosID.CENTER:
                    return halfScreenWidth - (textureWidth / 2);
                case PresetPosID.RIGHT:
                    return (halfScreenWidth + (m_viewWidth / 4)) - (textureWidth / 2);
                default:
                    //                    Log.printError("%s#GetCharaPresetPos : undefined Pos :%s", this.toString(), presetNumber);
                    //                    assert(false);
                    return 0;
            }
        }

        /// w肵XebvŁARootCounter𓮍삳ƂɁAŏI[ɒB邩ԋp
        protected static int CalcAlphaStep(int step)
        {
            if (0 == step)
            {
                step = 1;
            }
            int result;
            if (0 > step)
            {
                result = (255 * (step + 1)) + step;
                return result;
            }
            else
            {
                result = 255 / step;
                return (255 % step) == 0 ? result : result + 1;
            }
        }


        #endregion

    }
}
