using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.System;
using Kyojin.Model;
using Yanesdk.GUIParts;
using Kyojin.Component;
using Yanesdk.Draw;
using Yamalib.Draw;
using System.Diagnostics;
using Yanesdk.Ytl;
using Kyojin.Component.Scenario;
using Yamalib;
using Yanesdk.Input;
using Yamalib.Util;
using Yamalib.GUI;
using Yamalib.Model;
using System.Text.RegularExpressions;
using Yanesdk.Sound;
using Yanesdk.Timer;
using Yamalib.Yanesdkext.Draw;
using Yamalib.Input;
using Kyojin.Scene.EyeCatche;
using Yamalib.Scenario;
using Yamalib.Scenario.YaneScript;
using Yamalib.Logger;
using Kyojintachi.src.yamalib.draw;

namespace Kyojin.Scene.Scenario
{
    class ScenarioScene : TaskBase, IDisposable
    {
        #region 萔l

        private const int MAIN_TEXT_MAX = 500;
        private const int RUBI_TEXT_MAX = 50;

        private const int VIEW_TEXT_OFFSETX = 45;
        private const int VIEW_TEXT_OFFSETY = 28;

        private const int TEXT_MAX_WIDTH = 530;

        // {^ʒu
        private const int EXIT_BT_X = 550;
        private const int EXIT_BT_Y = 400;
        private const int SKIP_BT_X = 550;
        private const int SKIP_BT_Y = 440;

        private const int MUNU_POS_X = 440;
        private const int MUNU_POS_Y = 454;
        private const int MUNU_SEVE_BT_OX = 4;
        private const int MUNU_OPT_BT_OX = 74;
        private const int MUNU_SIMP_OX = 125;
        private const int MUNU_IND_OX = 168;

        /// I[gZ[uԊu
        private const int AUTO_SAVE_SPAN = 3 * 60 * 1000;	// R

        /// <summary>
        /// lp[gł̓LN^[ʒuEɑ傫ӂ̂ŁAʂ傫
        /// </summary>
        private const int KYOJIN_VIRTUAL_VIEW_WIDTH = 860;


        #endregion

        private delegate void ReturnSceneDelegate();

        #region otB[h

        private GameSystem m_gSys;
        private ScenarioDrawContext scenarioDrawContext;
        private KyojinScenarioModel model;
        private KyojinScenarioView view;
        private KyojinConst.ScenarioID nowScenarioId = KyojinConst.ScenarioID.KYOJIN01;

        private ITexture screenFilter;

        private KyojinScenarioParser scenarioParser;

        // {^֘A
        private FocusableTextureGUIControl focusGuiCtrl = new FocusableTextureGUIControl();
        private ControlContext ctrlContext = new ControlContext();
        private bool initFlg = false;

        private ReturnSceneDelegate backOptionDg;
        private ReturnSceneDelegate backBookmarkDg;
        private ReturnSceneDelegate nextSceneDg;
        private ReturnSceneDelegate selectDialogDg;

        // j[o[
        private PartialMenuBar menuBar;
        private ITexture skipLayer;
        private bool skipping = false;

        // vvgJ[\
        private PromptCarsor promptCarsor;

        private readonly FixTimer autoSaveTimer = new FixTimer();
        private Dictionary<string, int> scenarioVoiceMap;

        /// I
        private TextureDialog selectDialog;
        private bool showSelectDialog = false;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="gameSystem"></param>
        public ScenarioScene(GameSystem gameSystem)
        {
            m_gSys = gameSystem;
        }

        #region IDisposable o

        public void Dispose()
        {
            // NXꂽCxgj
            m_gSys.FinishDialogEvent -= DoAutoSave;
        }

        #endregion

        public override int Task(object o)
        {
            GameSystem gameSystem = (GameSystem)o;
            OnMove(gameSystem);
            gameSystem.OnMoveCommon();
            if (!gameSystem.FpsTimer.ToBeSkip)
            {
                gameSystem.Screen.Select();
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
                gameSystem.Screen.Update();
            }
            else
            {
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
            }
            return 1;
        }

        /// <summary>
        /// 쏈
        /// </summary>
        /// <param name="gameSystem"></param>
        private void OnMove(GameSystem gameSystem)
        {
            if (!initFlg)
            {
                OnInit();
                initFlg = true;
            }

            m_gSys.Key.Update();
            m_gSys.KeyDecolateMouse.Update();
            m_gSys.CommonSeLoader.UpdateSE();

            // obNÕnĥ܂ǂ
            if (!model.IsBackLogMode && m_gSys.KeyDecolateMouse.IsWheelUp)
            {
                model.IsBackLogMode = true;
            }
            if (model.IsBackLogMode)
            {
                if (m_gSys.KeyDecolateMouse.IsWheelUp)
                {
                    model.PrevBackLog();
                }
                else if (m_gSys.KeyDecolateMouse.IsWheelDown)
                {
                    model.NextBackLog();
                }
                else if (m_gSys.KeyDecolateMouse.IsPush(MouseInput.Button.Right))
                {
                    model.IsBackLogMode = false;
                }
            }

            // I[gZ[u
            autoSaveTimer.Update();
            if (autoSaveTimer.Time > AUTO_SAVE_SPAN)
            {
                DoAutoSave();
                autoSaveTimer.Reset();
            }

            if (null != backOptionDg)
            {
                backOptionDg();
                backOptionDg = null;
            }
            if (null != backBookmarkDg)
            {
                backBookmarkDg();
                backBookmarkDg = null;
            }

            if (null != nextSceneDg)
            {
                nextSceneDg();
                nextSceneDg = null;
            }

            if (null != selectDialogDg)
            {
                selectDialogDg();
                selectDialogDg = null;
            }

            // tH[JX
            focusGuiCtrl.OnMoveFocus();

            // Cvbgnhł̂܂ǂ
            if (skipping)
            {
                IMouseInput mouse = m_gSys.KeyDecolateMouse;
                if (mouse.IsPush(MouseInput.Button.Left) || mouse.IsPush(MouseInput.Button.Middle) ||
                    mouse.IsPush(MouseInput.Button.Right) || mouse.IsPush(MouseInput.Button.XButton1) ||
                    mouse.IsPush(MouseInput.Button.XButton2))
                {
                    skipping = false;
                    SetTextSpeed(model, m_gSys.OptionInfo);
                    if (m_gSys.OptionInfo.VoiceOn)
                    {
                        model.VoiceMgr.SoundDisable = false;
                    }
                    view.PostPaintText = null;
                }
                else
                {
                    long scenarioReadPos = m_gSys.UserInfo.GetReadPos(nowScenarioId);
                    if (scenarioReadPos > scenarioDrawContext.PageHeadTextOffset)
                    {
                        model.ContinueRead();
                    }
                    else
                    {
                        // ǈʒuɗ
                        skipping = false;
                        SetTextSpeed(model, m_gSys.OptionInfo);
                        if (m_gSys.OptionInfo.VoiceOn)
                        {
                            model.VoiceMgr.SoundDisable = false;
                        }
                        view.PostPaintText = null;
                    }
                }
            }

            this.model.OnMove(gameSystem.Screen);
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="gameSystem"></param>
        private void OnPaint(GameSystem gameSystem)
        {
            m_gSys.Screen.Clear();
            m_gSys.Screen.BlendSrcAlpha();

            // ViI`
            this.view.OnPaint(gameSystem.Screen);

            // {^͎ŕ`悷[
            //focusGuiCtrl.OnPaint(gameSystem.Screen);

            // I
            if (showSelectDialog)
            {
                m_gSys.EnableAllInputDevie();
                m_gSys.Key.Update();
                m_gSys.KeyDecolateMouse.Update();
                selectDialog.OnPaint(m_gSys.Screen, ctrlContext, 0, 0);
                // ̏Ń_CAO{bNX\I肪sĂ
                if (showSelectDialog)
                {
                    m_gSys.DisableAllInputDevie();
                }
            }

            // j[o[
            menuBar.OnPaint(m_gSys.Screen, ctrlContext, 0, 0);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="gameSystem"></param>
        private void OnInit()
        {
            Debug.Assert(m_gSys.ScenarioSceneParam.ScenarioInfo != null, "ScenarioInfoݒ肳ĂȂ");

            // Ô߃TEhׂĒ~
            Sound.StopAll();

            //// test
            //if (m_gSys.ScenarioSceneParam.ScenarioInfo.ScenarioID == 0)
            //{
            //    m_gSys.ScenarioSceneParam.ScenarioInfo.ScenarioID = KyojinConst.ScenarioID.KYOJIN01;
            //}

            promptCarsor = new PromptCarsor();
            ITexture promptImg = YamalibConst.CreateTexture("img/scenario/carsor.png");
            promptCarsor.SetTexture(promptImg);


            // p[T̃ZbgAbv
            SetupScenarioParser(m_gSys.ScenarioSceneParam.ScenarioInfo.ScenarioID);

            // f̃ZbgAbv
            SetupModel();

            // r[̃ZbgAbv
            SetupView();

            // Tl[
            SetupThumbnailDraw(scenarioDrawContext, m_gSys.ScenarioSceneParam.ScenarioInfo.ScenarioID);

            // {^
            SetupControl();
            CreateMenuButton();

            // {CXe[uXVĂ
            scenarioVoiceMap = GetVoiceListMap(nowScenarioId);
            model.CommandFactory.GetFactories()[TagDefinition.TAG_VOICE] = delegate()
            {
                return new KyojinVoicePlayCommandHandler(scenarioVoiceMap);
            };

            // XLbvC[
            skipLayer = YamalibConst.CreateTexture("img/common/skip_layer.png");

            //// fobO
            //KyojinScenarioModel theModel = this.model as KyojinScenarioModel;
            //theModel.IsAutoRead = true;

            autoSaveTimer.Reset();

            // I_CAÕNbNꂽƂ̃fQ[gɓo^
            m_gSys.FinishDialogEvent += DoAutoSave;

            if (m_gSys.ScenarioSceneParam.IsReadTop)
            {
                // ǂݎn߂
                this.model.ContinueRead();
            }
        }

        /// <summary>
        /// GUIRg[
        /// </summary>
        /// <param name="gameSystem"></param>
        private void SetupControl()
        {
            ctrlContext.MouseInput = m_gSys.MouseOriginal;
            ctrlContext.SmartTextureLoader = m_gSys.SmartTextureLoader;
            ctrlContext.SmartSoundLoader = m_gSys.SmartSoundLoader;
            ctrlContext.Param = new FocusableGUIParam(m_gSys.KeyDecolateMouse, m_gSys.Key);
            focusGuiCtrl.OnInit(ctrlContext);
        }

        /// <summary>
        /// ViIʂ̃{^쐬
        /// </summary>
        private void CreateMenuButton()
        {
            menuBar = new PartialMenuBar();
            menuBar.OnInit(ctrlContext);
            menuBar.SetHideStep(30);

            const string defFilename = "img/menu/menu_bt.txt";

            // tH[JXɃ_~[H킹
            {
                NullButton nullBt = new NullButton();
                TextureGUIControl.Control ctrl = new TextureGUIControl.Control(nullBt, 630, 450);
                focusGuiCtrl.AddControl(ctrl);
                focusGuiCtrl.AddFocusGUI(nullBt);
            }

            // CWP[^
            {
                FocusableTextureButton btInd = new FocusableTextureButton(defFilename, false);
                btInd.LoaderOffset = 12;
                btInd.OnInit(ctrlContext);
                menuBar.SetIndicator(new TextureGUIControl.Control(btInd, MUNU_POS_X + MUNU_IND_OX, MUNU_POS_Y),
                    640 - MUNU_POS_X, 0);
            }
            // XLbv
            {
                FocusableTextureButton btSd = new FocusableTextureButton(defFilename, false);
                btSd.LoaderOffset = 8;
                btSd.OnInit(ctrlContext);
                btSd.OnClick += delegate(IScreen scr, ControlContext cc)
                {
                    // ݂̃ViI̊ǈʒuł邱
                    long scenarioReadPos = m_gSys.UserInfo.GetReadPos(nowScenarioId);
                    if (scenarioReadPos <= scenarioDrawContext.PageHeadTextOffset || model.IsBackLogMode)
                    {
                        m_gSys.PlaySENegative();
                        return;
                    }

                    if (!skipping)
                    {
                        skipping = true;
                        model.IsEnableReadStop = true;
                        model.ReadSpeed = int.MaxValue;
                        model.VoiceMgr.SoundDisable = true;
                        // r[ɃXLbvC[`悳
                        view.PostPaintText += delegate(IScreen screen, YaneScenarioView ownView)
                        {
                            screen.Blt(skipLayer, 0, 0);
                            return YanesdkResult.NoError;
                        };

                    }
                };

                TextureGUIControl.Control ctrl = new TextureGUIControl.Control(btSd,
                    MUNU_POS_X + MUNU_SIMP_OX, MUNU_POS_Y);
                PartialMenuItem item = new PartialMenuItem();
                item.GUIControl = ctrl;
                item.Hide();

                menuBar.AddItem(item);

                focusGuiCtrl.AddControl(ctrl);
                focusGuiCtrl.AddFocusGUI(btSd);
            }
            // IvV
            {
                FocusableTextureButton btOp = new FocusableTextureButton(defFilename, false);
                btOp.LoaderOffset = 4;
                btOp.OnInit(ctrlContext);
                btOp.OnClick += delegate(IScreen scr, ControlContext cc)
                {
                    DoAutoSave();
                    m_gSys.FromTitleScene = false;
                    m_gSys.SceneController.CallScene(Scenes.OptionSetting);
                    m_gSys.PlaySystemSE((int)GameSystem.SYS_SE.CLICK_TITLE_ACTIVE);

                    // ߂ĂƂ̏fQ[hŋLq
                    backOptionDg = delegate()
                    {
                        SetOptionInfo(model, m_gSys.OptionInfo);
                    };

                };

                TextureGUIControl.Control ctrl = new TextureGUIControl.Control(btOp,
                    MUNU_POS_X + MUNU_OPT_BT_OX, MUNU_POS_Y);
                PartialMenuItem item = new PartialMenuItem();
                item.GUIControl = ctrl;
                item.Hide();

                menuBar.AddItem(item);
                focusGuiCtrl.AddControl(ctrl);
                focusGuiCtrl.AddFocusGUI(btOp);
            }
            // Z[u[h
            {
                FocusableTextureButton btSaveLoad = new FocusableTextureButton(defFilename, false);
                btSaveLoad.LoaderOffset = 0;
                btSaveLoad.OnInit(ctrlContext);
                btSaveLoad.OnClick += delegate(IScreen scr, ControlContext cc)
                {
                    if (model.IsBackLogMode)
                    {
                        m_gSys.PlaySENegative();
                        return;
                    }

                    // ۑ
                    DoAutoSave();

                    m_gSys.SceneController.CallScene(Scenes.SeveLoad);
                    m_gSys.PlaySystemSE((int)GameSystem.SYS_SE.CLICK_TITLE_ACTIVE);
                    m_gSys.FromTitleScene = false;

                    // ubN}[NV[ŕKvȃf[^n
                    if (null == m_gSys.BookmarkSceneParam.CurrentScenarioInfo)
                    {
                        m_gSys.BookmarkSceneParam.CurrentScenarioInfo = new CurrentInfo();
                    }
                    m_gSys.BookmarkSceneParam.CurrentScenarioInfo.Text = RemoveHtmlTag(scenarioParser.GetText());
                    m_gSys.BookmarkSceneParam.CurrentScenarioInfo.ScenarioInfo = CreateScenarioInfo();

                    // ubN}[NAĂƂ̏
                    backBookmarkDg = delegate()
                    {
                        // ViIIꂽ
                        if (m_gSys.ScenarioSceneParam.ScenarioInfo != null)
                        {
                            LoadFromScenarioInfo(m_gSys.ScenarioSceneParam.ScenarioInfo, !m_gSys.ScenarioSceneParam.IsReadTop);
                        }
                    };

                };

                TextureGUIControl.Control ctrl = new TextureGUIControl.Control(btSaveLoad,
                    MUNU_POS_X + MUNU_SEVE_BT_OX, MUNU_POS_Y);
                PartialMenuItem item = new PartialMenuItem();
                item.GUIControl = ctrl;
                item.Hide();

                menuBar.AddItem(item);

                focusGuiCtrl.AddControl(ctrl);
                focusGuiCtrl.AddFocusGUI(btSaveLoad);
            }
        }

        /// <summary>
        /// w肵fɁAIvV𔽉f
        /// </summary>
        /// <param name="theModel"></param>
        /// <param name="theOptionInfo"></param>
        private static void SetOptionInfo(KyojinScenarioModel theModel, OptionInfo theOptionInfo)
        {
            theModel.BgmMgr.SoundDisable = !theOptionInfo.BGMOn;
            theModel.SeMgr.SoundDisable = !theOptionInfo.SEOn;
            theModel.VoiceMgr.SoundDisable = !theOptionInfo.VoiceOn;

            // BGM{[
            theModel.BgmMgr.MasterVolume = theOptionInfo.BGMVolume / 100.0f;

            // SE{[
            theModel.SeMgr.MasterVolume = theOptionInfo.SEVolume / 100.0f;

            // {CX{[
            theModel.VoiceMgr.MasterVolume = theOptionInfo.VoiceVolume / 100.0f;

            SetTextSpeed(theModel, theOptionInfo);
        }

        /// <summary>
        /// IvV̐ݒlAeLXgXs[hfɐݒ肵܂B
        /// </summary>
        /// <param name="theModel"></param>
        /// <param name="theOptionInfo"></param>
        private static void SetTextSpeed(KyojinScenarioModel theModel, OptionInfo theOptionInfo)
        {
            // eLXgXs[h
            switch ((OptionInfo.TEXT_SPEED)theOptionInfo.TextSpeed)
            {
                case OptionInfo.TEXT_SPEED.NORMAL:
                    theModel.ReadSpeed = theOptionInfo.TextSpeed;
                    theModel.IsEnableReadStop = true;
                    break;
                case OptionInfo.TEXT_SPEED.FAST:
                    theModel.ReadSpeed = theOptionInfo.TextSpeed;
                    theModel.IsEnableReadStop = true;
                    break;
                case OptionInfo.TEXT_SPEED.LINE:
                    theModel.ReadSpeed = int.MaxValue;
                    theModel.IsEnableReadStop = true;
                    break;
                case OptionInfo.TEXT_SPEED.PAGE:
                    theModel.ReadSpeed = int.MaxValue;
                    theModel.IsEnableReadStop = false;
                    break;
                default:
                    Debug.Assert(false, "`̃eLXgXs[hIꂽ:" + new Exception().StackTrace);
                    break;
            }
        }

        /// <summary>
        /// Z[u
        /// </summary>
        private void DoAutoSave()
        {
            if (model != null && scenarioParser != null)
            {
                BookmarkData bkData = null;
                foreach (BookmarkData data in m_gSys.UserInfo.BookmarkData)
                {
                    if (data.IsAutoBookmark)
                    {
                        bkData = data;
                        break;
                    }
                }
                Debug.Assert(bkData != null, "I[gZ[uf[^Ȃ");
                bkData.ScenarioInfo = CreateScenarioInfo();
                bkData.Text = RemoveHtmlTag(scenarioParser.GetText());
                bkData.SaveDate = DateTime.Now;
                bkData.IsUse = true;

                // [Uǈʒu̐ݒ
                m_gSys.UserInfo.SetReadPos(this.nowScenarioId, scenarioDrawContext.PageHeadTextOffset);

                m_gSys.SaveUserInfo(KyojinConst.SAVE_HEADER_FILE);
            }
        }

        /// <summary>
        /// w肵񂩂HTML^O菜ԋp
        /// </summary>
        /// <param name="str"></param>
        private static string RemoveHtmlTag(string str)
        {
            // ^OƉsASp󔒂
            Regex regex = new System.Text.RegularExpressions.Regex("<.*?>|[\n\r]|@");
            return regex.Replace(str, string.Empty);
        }

        /// <summary>
        /// ݂̏񂩂ScenarioInfo\zĕԋp
        /// </summary>
        /// <returns></returns>
        private ScenarioInfo CreateScenarioInfo()
        {
            ScenarioInfo scenarioInfo = new ScenarioInfo();
            KyojinScenarioModel aModel = model as KyojinScenarioModel;
            scenarioInfo.ScenarioID = nowScenarioId;
            scenarioInfo.ScenarioPos = scenarioParser.GetHeadTextOffset();
            scenarioInfo.TextPos = aModel.ShowTextCount;
            //scenarioInfo.AnalyzedTagNum=model.
            scenarioInfo.BgNo = aModel.BgImgMgr.BgImgNo;
            scenarioInfo.PageNo = aModel.PageNo;
            scenarioInfo.BgmNo = aModel.BgmMgr.PlayBgmNo;
            scenarioInfo.BgmVol = aModel.BgmMgr.PlayBgmVolume;
            scenarioInfo.BgmLoop = true;
            scenarioInfo.SeNo = aModel.SeMgr.GetPlayingSeNo();

            YaneCharacterManager charaMgr = aModel.CharacterImgMgr as YaneCharacterManager;

            // LN^[
            scenarioInfo.CharaPos.Clear();
            scenarioInfo.PresetPos.Clear();
            scenarioInfo.CharaIds.Clear();
            scenarioInfo.CharaColors.Clear();

            foreach (Character chara in charaMgr.CharacterContainer)
            {
                if (chara.IsShowing && !chara.IsEffectOut())
                {
                    scenarioInfo.CharaPos.Add(chara.CharacterOffsetX);
                    scenarioInfo.PresetPos.Add((int)chara.PresetPos);
                    scenarioInfo.CharaColors.Add(YanesdkUtil.Color4ubToString(chara.Color));
                    scenarioInfo.CharaIds.Add(chara.GetCharId());
                }
                else
                {
                    scenarioInfo.CharaPos.Add(chara.CharacterOffsetX);
                    scenarioInfo.PresetPos.Add((int)Character.PresetPosID.UNSET);
                    scenarioInfo.CharaColors.Add(YanesdkUtil.Color4ubToString(chara.Color));
                    scenarioInfo.CharaIds.Add(null);
                }
            }

            return scenarioInfo;

        }

        /// <summary>
        /// SenarioInfo ViI[h܂
        /// </summary>
        /// <param name="scenarioInfo"></param>
        /// <param name="scenarioLoad"></param>
        void LoadFromScenarioInfo(ScenarioInfo scenarioInfo, bool scenarioLoad)
        {
            if (!m_gSys.ScenarioSceneParam.IsUseExtraMusic)
            {
                scenarioDrawContext =
                    CreateScenarioDrawContext(KyojinConst.GetScenarioFilename(scenarioInfo.ScenarioID));
            }
            else
            {
                // TODO TEheXgp
                scenarioDrawContext =
                    CreateScenarioDrawContext(KyojinConst.GetScenarioFilename(scenarioInfo.ScenarioID + 3));
            }
            // ݂̃ViIIDۑ
            nowScenarioId = scenarioInfo.ScenarioID;

            scenarioParser.SetScenarioDrawContext(scenarioDrawContext);

            KyojinScenarioModel theModel = model as KyojinScenarioModel;
            // ΏۃViĨ{CX}bvɍXVĂ
            scenarioVoiceMap = GetVoiceListMap(scenarioInfo.ScenarioID);
            // ΏۃViĨ{CX`ǂݍł
            YaneVoiceManager voiceMgr = theModel.VoiceMgr as YaneVoiceManager;
            Debug.Assert(voiceMgr != null);
            voiceMgr.SoundLoader = m_gSys.SmartSoundLoader.LoadDefFile(KyojinConst.GetVoiceListName(scenarioInfo.ScenarioID));
            CommonLogWriter.Write("update voice SoundLoader def file : " + KyojinConst.GetVoiceListName(scenarioInfo.ScenarioID));

            if (!scenarioLoad)
            {
                // ͂߂
                theModel.PageNo = 0;

                YaneCharacterManager characterMgr = theModel.CharacterImgMgr as YaneCharacterManager;
                Debug.Assert(characterMgr != null);
                foreach (Character chara in characterMgr.CharacterContainer)
                {
                    chara.Reset();
                }
                // se ׂĎ~߂
                theModel.SeMgr.StopAll();
            }
            else
            {
                SetupFromScenarioInfoForLoad(theModel, scenarioInfo);
            }

        }

        /// <summary>
        /// gpViIp[T
        /// </summary>
        private void SetupScenarioParser(KyojinConst.ScenarioID scenarioID)
        {
            FontRepository mainTextFontRep = new FontRepository(YamalibConst.FONT_REP_TEXTURE_FACTORY);
            mainTextFontRep.SetLoader(m_gSys.CommonFontLoader, KyojinConst.SCENARIO_KYOJIN_TEXT_FONT_NO);
            mainTextFontRep.Max = MAIN_TEXT_MAX;

            FontRepository rubiTextFontRep = new FontRepository(YamalibConst.FONT_REP_TEXTURE_FACTORY);
            rubiTextFontRep.SetLoader(m_gSys.CommonFontLoader, KyojinConst.SCENARIO_RUBI_FONT_NO);
            rubiTextFontRep.Max = RUBI_TEXT_MAX;

            FontRepository backMainTextFontRep = new FontRepository(YamalibConst.FONT_REP_TEXTURE_FACTORY);
            backMainTextFontRep.SetLoader(m_gSys.CommonFontLoader, KyojinConst.SCENARIO_KYOJIN_TEXT_FONT_NO);
            backMainTextFontRep.Max = MAIN_TEXT_MAX;

            scenarioParser = new KyojinScenarioParser();
            scenarioParser.TextFontRepository = mainTextFontRep;
            scenarioParser.RubiFontRepository = rubiTextFontRep;
            scenarioParser.BacklogFontRepository = backMainTextFontRep;

            // Ώۂ̃ViIǂݍ
            if (!m_gSys.ScenarioSceneParam.IsUseExtraMusic)
            {
                scenarioDrawContext =
                    CreateScenarioDrawContext(KyojinConst.GetScenarioFilename(scenarioID));
            }
            else
            {
                scenarioDrawContext =
                    CreateScenarioDrawContext(KyojinConst.GetScenarioFilename(scenarioID + 3));
            }
            scenarioParser.SetScenarioDrawContext(scenarioDrawContext);

            // ݂̃ViIIDۑ
            nowScenarioId = scenarioID;
        }

        /// <summary>
        /// ViIXNvgǍAʐݒsÃIuWFNgԋp
        /// </summary>
        /// <param name="scenarioFilename"></param>
        /// <returns></returns>
        private static ScenarioDrawContext CreateScenarioDrawContext(String scenarioFilename)
        {
            ScenarioDrawContext scenarioDrawContext = new ScenarioDrawContext();
            scenarioDrawContext.LoadTextFile(scenarioFilename);

            scenarioDrawContext.DrawWidth = TEXT_MAX_WIDTH;
            // s
            scenarioDrawContext.BlankHeight = 2;
            // s
            scenarioDrawContext.BlankLineHeight = 20;
            // 
            scenarioDrawContext.CharacterInterval = -1;

            return scenarioDrawContext;
        }

        /// <summary>
        /// Tl[\NXZbgAbv܂
        /// </summary>
        /// <param name="scenarioDrawContext"></param>
        private void SetupThumbnailDraw(ScenarioDrawContext scenarioDrawContext_, KyojinConst.ScenarioID scenarioID)
        {
            ScenarioDrawContext theScenarioDrawContext = scenarioDrawContext_.Colne();
            theScenarioDrawContext.TextOffsetPos = 0;
            theScenarioDrawContext.PageHeadTextOffset = 0;
            ThumbnailInfo.SetCharactorImgMap(GetCharacterMapName(scenarioID));
            List<ThumbnailInfo> thumbnailInfos = new List<ThumbnailInfo>();
            long readPos = m_gSys.UserInfo.GetReadPos(scenarioID);
            int readPageNo = -1;
            int loopCount = 0;
            // TlC^Ôݔo
            Regex regex = new System.Text.RegularExpressions.Regex("<thuminfo.*?>");
            while (true)
            {
                string pageText = theScenarioDrawContext.GetNextText();
                if (pageText == null)
                {
                    break;
                }
                Match match = regex.Match(pageText);
                if (match.Success)
                {
                    ThumbnailInfo thumbnailInfo = CreateThumbnailInfo(match.Value);
                    thumbnailInfo.Text = pageText;
                    thumbnailInfo.PageNo = loopCount;
                    thumbnailInfo.TextOffset = theScenarioDrawContext.TextOffsetPos;
                    thumbnailInfos.Add(thumbnailInfo);
                    if (-1 == readPageNo && thumbnailInfo.TextOffset > readPos)
                    {
                        // ̃y[W̑O܂Ŋ
                        readPageNo = loopCount;
                    }

                    ++loopCount;
                    match = match.NextMatch();
                }
            }

            if (readPageNo == -1)
            {
                readPageNo = thumbnailInfos.Count;
            }

            // ɖ߂
            theScenarioDrawContext.TextOffsetPos = 0;

            KyojinScenarioModel theModel = model as KyojinScenarioModel;
            theModel.ThumbnailCreator = new ThumbnailCreator(m_gSys.SmartSurfaceLoader.LoadDefFile("img2/back/list.lst", false),
                m_gSys.SmartSurfaceLoader.LoadDefFile("img2/sil/list.lst", false), CreateThumbnailTextDraw(theScenarioDrawContext));
            theModel.ThumbnailCreator.ViewWidth = KYOJIN_VIRTUAL_VIEW_WIDTH;

            theModel.ThumbnailDraw = new ThumbnailDraw(m_gSys.Screen.Width, m_gSys.Screen.Height);
            theModel.ThumbnailDraw.ThumbnailCreator = theModel.ThumbnailCreator;
            theModel.ThumbnailDraw.ThumbnailInfos = thumbnailInfos;
            theModel.ThumbnailDraw.SetThumbnailLimitNo(readPageNo);


            //test
            //theModel.IsShowThumbnailDraw = true;
            //theModel.ThumbnailDraw.SetThumbnailLimitNo(loopCount - 1);
            //theModel.ThumbnailDraw.FadeIn(5, 10);
            //theModel.ThumbnailDraw.SetThumbnailNo(10);
        }

        /// T[tFCXł ScenarioDraw \z
        private ScenarioParserSurface CreateThumbnailTextDraw(ScenarioDrawContext context)
        {
            ScenarioParserSurface parser = new ScenarioParserSurface();
            parser.SetScenarioDrawContext(context);

            // tHg
            SurfaceFontRepository mainFontRep = parser.GetSurfaceFontRepository();
            mainFontRep.SetLoader(m_gSys.CommonFontLoader, KyojinConst.SCENARIO_KYOJIN_TEXT_FONT_NO);
            mainFontRep.Max = 300;

            SurfaceFontRepository rubiFontRep = parser.GetRubiSurfaceFontRepository();
            rubiFontRep.SetLoader(m_gSys.CommonFontLoader, KyojinConst.SCENARIO_RUBI_FONT_NO);
            rubiFontRep.Max = 300;

            return parser;
        }

        /// XNvg^O񂩂Af[^NX\zԋp
        private static ThumbnailInfo CreateThumbnailInfo(string thumbTagStr)
        {
            char[] keyValueSplitChar = new char[] { '=' };
            char[] tagElemntSplitChar = new char[] { ' ' };

            ThumbnailInfo thumbInfo = new ThumbnailInfo();
            //<>
            string[] splitStr = thumbTagStr.Substring(1, thumbTagStr.Length - 2).Split(tagElemntSplitChar);
            foreach (string str in splitStr)
            {
                if (-1 != str.IndexOf('='))
                {
                    string[] keyValue = str.Split(keyValueSplitChar);
                    string key = keyValue[0].ToUpper();
                    string value = keyValue[1];
                    switch (key)
                    {
                        case "BG":
                            thumbInfo.BgNo = Convert.ToInt32(value);
                            break;
                        case "CHARA0":
                            thumbInfo.CharaLeft = value;
                            break;
                        case "CHARA1":
                            thumbInfo.CharaCenter = value;
                            break;
                        case "CHARA2":
                            thumbInfo.CharaRight = value;
                            break;
                        case "BGM":
                            thumbInfo.BgmNo = Convert.ToInt32(value);
                            break;
                        case "BGM_LOOP":
                            thumbInfo.BgmLoop = Convert.ToInt32(value);
                            break;
                        case "SE":
                            thumbInfo.SeNo = Convert.ToInt32(value);
                            break;
                        case "SE_LOOP":
                            thumbInfo.SeLoop = Convert.ToInt32(value);
                            break;
                        default:
                            //#Log.print("undefined thumbnail tag key:%s", key);
                            break;
                    }
                }
            }

            return thumbInfo;
        }

        /// <summary>
        /// eNX`[_[ɐݒ肷wi摜̐ݒt@C擾
        /// </summary>
        /// <returns></returns>
        private static string GetBGListName(KyojinConst.ScenarioID scenarioID)
        {
            switch (scenarioID)
            {
                case KyojinConst.ScenarioID.NOT_DATA:
                case KyojinConst.ScenarioID.STORY01:
                case KyojinConst.ScenarioID.STORY02_0:
                case KyojinConst.ScenarioID.STORY02_1:
                case KyojinConst.ScenarioID.STORY02_2:
                case KyojinConst.ScenarioID.STORY03:
                case KyojinConst.ScenarioID.STORY04:
                case KyojinConst.ScenarioID.STORY05:
                case KyojinConst.ScenarioID.STORY06:
                case KyojinConst.ScenarioID.STORY07:
                case KyojinConst.ScenarioID.STORY08_0:
                case KyojinConst.ScenarioID.STORY08_1:
                case KyojinConst.ScenarioID.STORY08_2:
                case KyojinConst.ScenarioID.STORY08_3:
                case KyojinConst.ScenarioID.STORY09:
                case KyojinConst.ScenarioID.STORY2ch01:
                    return "img/back/list.lst";
                case KyojinConst.ScenarioID.KYOJIN01:
                case KyojinConst.ScenarioID.KYOJIN02:
                case KyojinConst.ScenarioID.KYOJIN03:
                    return "img2/back/list.lst";
                default:
                    return "img2/back/list.lst";
            }
        }

        /// <summary>
        /// eNX`[_[ɐݒ肷郊Xgݒt@C擾
        /// </summary>
        /// <returns></returns>
        private static string GetCharacterListName(KyojinConst.ScenarioID scenarioID)
        {
            switch (scenarioID)
            {
                case KyojinConst.ScenarioID.NOT_DATA:
                case KyojinConst.ScenarioID.STORY01:
                case KyojinConst.ScenarioID.STORY02_0:
                case KyojinConst.ScenarioID.STORY02_1:
                case KyojinConst.ScenarioID.STORY02_2:
                case KyojinConst.ScenarioID.STORY03:
                case KyojinConst.ScenarioID.STORY04:
                case KyojinConst.ScenarioID.STORY05:
                case KyojinConst.ScenarioID.STORY06:
                case KyojinConst.ScenarioID.STORY07:
                case KyojinConst.ScenarioID.STORY08_0:
                case KyojinConst.ScenarioID.STORY08_1:
                case KyojinConst.ScenarioID.STORY08_2:
                case KyojinConst.ScenarioID.STORY08_3:
                case KyojinConst.ScenarioID.STORY09:
                case KyojinConst.ScenarioID.STORY2ch01:
                    return "img/sil/list.lst";
                case KyojinConst.ScenarioID.KYOJIN01:
                case KyojinConst.ScenarioID.KYOJIN02:
                case KyojinConst.ScenarioID.KYOJIN03:
                    return "img2/sil/list.lst";
                default:
                    return "img2/sil/list.lst";
            }
        }

        /// <summary>
        /// LN^[}bṽt@C擾
        /// </summary>
        /// <returns></returns>
        private static string GetCharacterMapName(KyojinConst.ScenarioID scenarioID)
        {
            switch (scenarioID)
            {
                case KyojinConst.ScenarioID.NOT_DATA:
                case KyojinConst.ScenarioID.STORY01:
                case KyojinConst.ScenarioID.STORY02_0:
                case KyojinConst.ScenarioID.STORY02_1:
                case KyojinConst.ScenarioID.STORY02_2:
                case KyojinConst.ScenarioID.STORY03:
                case KyojinConst.ScenarioID.STORY04:
                case KyojinConst.ScenarioID.STORY05:
                case KyojinConst.ScenarioID.STORY06:
                case KyojinConst.ScenarioID.STORY07:
                case KyojinConst.ScenarioID.STORY08_0:
                case KyojinConst.ScenarioID.STORY08_1:
                case KyojinConst.ScenarioID.STORY08_2:
                case KyojinConst.ScenarioID.STORY08_3:
                case KyojinConst.ScenarioID.STORY09:
                case KyojinConst.ScenarioID.STORY2ch01:
                    return "img/sil/chara_map.lst";
                case KyojinConst.ScenarioID.KYOJIN01:
                case KyojinConst.ScenarioID.KYOJIN02:
                case KyojinConst.ScenarioID.KYOJIN03:
                    return "img2/sil/chara_map.lst";
                default:
                    return "img2/sil/chara_map.lst";
            }
        }

        /// <summary>
        /// f
        /// </summary>
        /// <returns></returns>
        private YanesdkResult SetupModel()
        {
            KyojinScenarioModel theModel = new KyojinScenarioModel();
            // [U
            theModel.UserInfo = m_gSys.UserInfo;

            // [U\IuWFNg
            theModel.UserStateView = new UserStateView(m_gSys.UserInfo);

            theModel.BgImgMgr = new YaneBgImageManager(
                m_gSys.SmartTextureLoader.LoadDefFile(GetBGListName(m_gSys.ScenarioSceneParam.ScenarioInfo.ScenarioID), false));
            TextureLoader charaTl = m_gSys.SmartTextureLoader.LoadDefFile(GetCharacterListName(m_gSys.ScenarioSceneParam.ScenarioInfo.ScenarioID), false);
            YaneCharacterManager theCharaMgr = new YaneCharacterManager(charaTl, GetCharacterMapName(
                m_gSys.ScenarioSceneParam.ScenarioInfo.ScenarioID), KyojinConst.CHARA_CONTAINER_SIZE);
            // LN^[̃ItZbgʒuOɂ炷߂ɁAzʃTCYɂ
            foreach (Character chara in theCharaMgr.CharacterContainer)
            {
                chara.ViewWidth = KYOJIN_VIRTUAL_VIEW_WIDTH;
            }
            theModel.CharacterImgMgr = theCharaMgr;

            if (!m_gSys.ScenarioSceneParam.IsUseExtraMusic)
            {
                theModel.BgmMgr = new YaneBgmManager(m_gSys.SmartSoundLoader.LoadDefFile("snd/bgm/list.lst", false));
            }
            else
            {
                // TODO TEheXgp
                theModel.BgmMgr = new YaneBgmManager(m_gSys.SmartSoundLoader.LoadDefFile("snd/bgm_ex/list.lst", false));
            }
            theModel.SeMgr = new YaneSeManager(m_gSys.SmartSoundLoader.LoadDefFile("snd/se/list.lst", false));
            theModel.VoiceMgr = new YaneVoiceManager(m_gSys.SmartSoundLoader.LoadDefFile(
                KyojinConst.GetVoiceListName(m_gSys.ScenarioSceneParam.ScenarioInfo.ScenarioID)));
            m_gSys.LogWriter.Write("load voice id def file : " + KyojinConst.GetVoiceListName(m_gSys.ScenarioSceneParam.ScenarioInfo.ScenarioID));

            // IvV̐ݒ𔽉f
            SetOptionInfo(theModel, m_gSys.OptionInfo);

            // R}ht@Ng̐Eݒ
            YaneCommandHandlerFactory commandFactory = new YaneCommandHandlerFactory();
            commandFactory.SetFactories(CreateCommandFactories());
            theModel.CommandFactory = commandFactory;

            theModel.ScenarioParser = scenarioParser;

            theModel.MouseInputHandler = CreateMouseInputHandler();
            theModel.KeyInputHandler = CreateKeyInputHandler();

            if (m_gSys.ScenarioSceneParam.IsReadTop)
            {
                // ͂߂
                theModel.PageNo = 0;
            }
            else
            {
                ScenarioInfo scenarioInfo = m_gSys.ScenarioSceneParam.ScenarioInfo;
                SetupFromScenarioInfoForLoad(theModel, scenarioInfo);
            }

            this.model = theModel;

            // eLXg̔wiC[
            SetupScenarioLayer();

            return YanesdkResult.NoError;
        }

        /// <summary>
        /// ScenarioInfoViI\z
        /// [hp
        /// </summary>
        /// <param name="theModel"></param>
        /// <param name="scenarioInfo"></param>
        private void SetupFromScenarioInfoForLoad(KyojinScenarioModel theModel, ScenarioInfo scenarioInfo)
        {
            // 
            scenarioDrawContext.TextOffsetPos = scenarioInfo.ScenarioPos;
            scenarioDrawContext.PageHeadTextOffset = scenarioInfo.ScenarioPos;
            theModel.PageNo = scenarioInfo.PageNo;

            // wi
            YaneBgImageManager bgMgr = theModel.BgImgMgr as YaneBgImageManager;
            bgMgr.BgImgNo = scenarioInfo.BgNo;

            // LN^[
            YaneCharacterManager characterMgr = theModel.CharacterImgMgr as YaneCharacterManager;
            Debug.Assert(characterMgr != null);
            for (int i = 0; i < characterMgr.CharacterContainer.Length; i++)
            {
                // vZbg|WV
                characterMgr.CharacterContainer[i].PresetPos = (Character.PresetPosID)scenarioInfo.PresetPos[i];
                // LN^[ID
                characterMgr.CharacterContainer[i].SetCharId(scenarioInfo.CharaIds[i]);
                // F
                characterMgr.CharacterContainer[i].Color = YanesdkUtil.ToColor4ub(scenarioInfo.CharaColors[i]);

                if (characterMgr.CharacterContainer[i].PresetPos == Character.PresetPosID.UNSET)
                {
                    characterMgr.CharacterContainer[i].Reset();
                }

            }

            // BGM
            theModel.BgmMgr.PlayBgmFade(scenarioInfo.BgmNo, scenarioInfo.BgmVol, 1500);

            // se
            if (null != scenarioInfo.SeNo)
            {
                for (int i = 0; i < scenarioInfo.SeNo.Length; i++)
                {
                    theModel.SeMgr.PlaySe(scenarioInfo.SeNo[i], scenarioInfo.SeVol / 100.0f, -1);
                }
            }

            theModel.Reset();

            // updateKv
            theModel.ContinueRead();
            theModel.SetShowTextCountForRestore(scenarioInfo.TextPos);
        }

        /// <summary>
        /// ViIɏ]{CX}bv擾
        /// </summary>
        /// <param name="scenarioID"></param>
        /// <returns></returns>
        private static Dictionary<string, int> GetVoiceListMap(KyojinConst.ScenarioID scenarioID)
        {
            string voiceListFilename = KyojinConst.GetVoiceListName(scenarioID);
            CommonLogWriter.Write("load voice def file : " + voiceListFilename);
            Dictionary<string, int> voiceMap = new Dictionary<string, int>();
            if (null == voiceListFilename)
            {
                return voiceMap;
            }

            CSVReader reader = new CSVReader();
            YanesdkResult result = reader.Read(voiceListFilename);
            if (result != YanesdkResult.NoError)
            {
                return voiceMap;
            }

            // ǂݍCSVAt@CƔԍƂΉA
            // LinkedListɊi[ĂB

            List<List<string>> list = reader.CsvData;
            foreach (List<string> line in list)
            {
                // filename, channel, no, id
                if (line.Count < 4)
                {
                    continue;
                }
                voiceMap.Add(line[3], Convert.ToInt32(line[2]));
            }
            return voiceMap;
        }

        /// <summary>
        /// lViIp̃R}hnht@Ng𐶐ԋp
        /// </summary>
        /// <returns></returns>
        private Dictionary<String, CommandHandlerCreator> CreateCommandFactories()
        {
            Dictionary<String, CommandHandlerCreator> factories = TagDefinition.GetFactories();

            // lp̃R}hnhɏ㏑
            factories[TagDefinition.TAG_BG] = delegate()
            {
                return new KyojinBgCommandHandler();
            };
            factories[TagDefinition.TAG_CHARA_IN] = delegate()
            {
                return new KyojinCharaInCommandHandler();
            };
            factories[TagDefinition.TAG_CHARA_OUT] = delegate()
            {
                return new KyojinCharaOutCommandHandler();
            };
            factories[TagDefinition.TAG_VOICE] = delegate()
            {
                return new KyojinVoicePlayCommandHandler(GetVoiceListMap(KyojinConst.ScenarioID.KYOJIN01));
            };

            factories["nextscene"] = delegate()
            {
                KyojinNextSceneCommandHandler nextSceneCmd = new KyojinNextSceneCommandHandler();
                nextSceneCmd.CommandProsser = delegate(ICommandHandler own, IScenarioModel model)
                {
                    // ̃^OsꂽƂ̃fQ[g
                    KyojinNextSceneCommandHandler cmd = own as KyojinNextSceneCommandHandler;
                    return NextScene(cmd.SceneId);
                };
                return nextSceneCmd;
            };

            /// I}
            factories["select"] = delegate()
            {
                SelectCommandHandler selectCmd = new SelectCommandHandler();
                selectCmd.CommandProsser = delegate(ICommandHandler own, IScenarioModel model)
                {
                    if (!showSelectDialog)
                    {
                        // I_CAO쐬
                        selectDialog = TextureDialog.CreateDialogBox(m_gSys.createDialogResources(), "img/dialog/dialog_select.txt",
                            ctrlContext, m_gSys.Key, 0, 1);
                        List<TextureGUIControl.Control> bts = selectDialog.GetButton();
                        // Lǂ
                        FontButton readButton = bts[0].Parts as FontButton;
                        readButton.OnClick += delegate(IScreen scr, ControlContext cc)
                        {
                            // Ɏ́uړvɏs邽߂ɁAfQ[go^Ă
                            selectDialogDg = delegate()
                            {
                                m_gSys.UserInfo.SetReadFlg((int)KyojinConst.ScenarioID.STORY02_0, true);
                                // ebv
                                m_gSys.SceneController.ExitScene();
                                m_gSys.SceneController.CallScene(Scenes.ScenarioEndEyecatche);
                                m_gSys.CommonBgmLoader.StopBGMFade(1000);
                                OnPaint(m_gSys);
                                m_gSys.EyeCatcheSceneParam.ScreenImg = YanesdkUtil.CopyGlFlameBufferNormalize(m_gSys.Screen as Screen2DGl);
                                m_gSys.EyeCatcheSceneParam.CallScenarioNo = KyojinConst.ScenarioID.STORY02_2;
                                m_gSys.EyeCatcheSceneParam.Pattern = (int)SenarioEndEyeCatcheScene.SHI_TYPE.ANZAI01;
                                // _CAOII
                                showSelectDialog = false;
                                m_gSys.EnableAllInputDevie();
                                CommonLogWriter.Write("READ");
                            };
                        };
                        // Lǂ܂Ȃ
                        FontButton noReadButton = bts[1].Parts as FontButton;
                        noReadButton.OnClick += delegate(IScreen scr, ControlContext cc)
                        {
                            // Ɏ́uړvɏs邽߂ɁAfQ[go^Ă
                            selectDialogDg = delegate()
                            {
                                m_gSys.UserInfo.SetReadFlg((int)KyojinConst.ScenarioID.STORY02_0, true);
                                // ebv
                                m_gSys.SceneController.ExitScene();
                                m_gSys.SceneController.CallScene(Scenes.ScenarioEndEyecatche);
                                m_gSys.CommonBgmLoader.StopBGMFade(1000);
                                OnPaint(m_gSys);
                                m_gSys.EyeCatcheSceneParam.ScreenImg = YanesdkUtil.CopyGlFlameBufferNormalize(m_gSys.Screen as Screen2DGl);
                                m_gSys.EyeCatcheSceneParam.CallScenarioNo = KyojinConst.ScenarioID.STORY02_1;
                                m_gSys.EyeCatcheSceneParam.Pattern = (int)SenarioEndEyeCatcheScene.SHI_TYPE.ANZAI01;
                                // _CAOII
                                showSelectDialog = false;
                                m_gSys.EnableAllInputDevie();
                                CommonLogWriter.Write("NO READ");
                            };
                        };

                        // I\͂ȂɂȂ
                        m_gSys.DisableAllInputDevie();
                        showSelectDialog = true;
                    }
                    return YanesdkResult.NoError;
                };
                return selectCmd;
            };


            return factories;
        }

        /// <summary>
        /// ʃV[ւ̑Jڏ
        /// </summary>
        /// <param name="sceneId"></param>
        /// <returns></returns>
        private YanesdkResult NextScene(string sceneId)
        {
            nextSceneDg = delegate()
            {
                ScenarioInfo scenarioInfo = new ScenarioInfo();
                // TODO ViIGh̑Jڏǉ邱
                switch (sceneId.ToLower())
                {
                    case "title":
                        // Cp[gv[Oi^Cgʂɖ߂邯ǁAׂătOȂGfBOցj
                        m_gSys.UserInfo.SetReadFlg((int)nowScenarioId, true);
                        m_gSys.UserInfo.SetReadPos(nowScenarioId, scenarioParser.GetScenarioDrawContext().PageHeadTextOffset + 1);

                        if (nowScenarioId == KyojinConst.ScenarioID.STORY07 || nowScenarioId == KyojinConst.ScenarioID.STORY05)
                        {
                            // ̃ViI̓Gs[O
                            if (m_gSys.UserInfo.IsRead((int)KyojinConst.ScenarioID.STORY05) && m_gSys.UserInfo.IsRead((int)KyojinConst.ScenarioID.STORY07))
                            {
                                // Cp[gׂēǂ񂾂ƂƂȂ̂ŁAGfBOɃWvďI
                                m_gSys.SceneController.ExitScene();
                                m_gSys.SceneController.JumpScene(Scenes.MainPartEnding);
                                m_gSys.CommonBgmLoader.StopBGMFade(1000);
                                break;
                            }
                        }
                        // ^CgփWv
                        m_gSys.SceneController.ExitScene();
                        m_gSys.SceneController.JumpScene(Scenes.Startmenu);
                        m_gSys.CommonBgmLoader.StopBGMFade(1000);
                        break;

                    case "telop":
                        m_gSys.TelopParam.CallScenarioNo = nowScenarioId;
                        m_gSys.SceneController.CallScene(Scenes.MainPartTelop);
                        break;

                    case "story02":
                        // cH҉
                        m_gSys.UserInfo.SetReadFlg((int)KyojinConst.ScenarioID.STORY01, true);
                        m_gSys.UserInfo.SetReadPos(nowScenarioId, scenarioParser.GetScenarioDrawContext().PageHeadTextOffset + 1);
                        // ebv
                        m_gSys.SceneController.ExitScene();
                        m_gSys.SceneController.CallScene(Scenes.ScenarioEndEyecatche);
                        m_gSys.CommonBgmLoader.StopBGMFade(1000);
                        OnPaint(m_gSys);
                        m_gSys.EyeCatcheSceneParam.ScreenImg = YanesdkUtil.CopyGlFlameBufferNormalize(m_gSys.Screen as Screen2DGl);
                        m_gSys.EyeCatcheSceneParam.CallScenarioNo = KyojinConst.ScenarioID.STORY02_0;
                        m_gSys.EyeCatcheSceneParam.Pattern = (int)SenarioEndEyeCatcheScene.SHI_TYPE.TOMIE01;
                        break;
                    case "story05":
                        m_gSys.UserInfo.SetReadFlg((int)KyojinConst.ScenarioID.STORY02_1, true);
                        m_gSys.UserInfo.SetReadPos(nowScenarioId, scenarioParser.GetScenarioDrawContext().PageHeadTextOffset + 1);
                        // ebv
                        m_gSys.SceneController.ExitScene();
                        m_gSys.SceneController.CallScene(Scenes.ScenarioEndEyecatche);
                        m_gSys.CommonBgmLoader.StopBGMFade(1000);
                        OnPaint(m_gSys);
                        m_gSys.EyeCatcheSceneParam.ScreenImg = YanesdkUtil.CopyGlFlameBufferNormalize(m_gSys.Screen as Screen2DGl);
                        m_gSys.EyeCatcheSceneParam.CallScenarioNo = KyojinConst.ScenarioID.STORY03;
                        m_gSys.EyeCatcheSceneParam.Pattern = (int)SenarioEndEyeCatcheScene.SHI_TYPE.ALICE01;
                        break;
                    case "story06":
                        m_gSys.UserInfo.SetReadFlg((int)KyojinConst.ScenarioID.STORY03, true);
                        m_gSys.UserInfo.SetReadPos(nowScenarioId, scenarioParser.GetScenarioDrawContext().PageHeadTextOffset + 1);
                        // ebv
                        m_gSys.SceneController.ExitScene();
                        m_gSys.SceneController.CallScene(Scenes.ScenarioEndEyecatche);
                        m_gSys.CommonBgmLoader.StopBGMFade(1000);
                        OnPaint(m_gSys);
                        m_gSys.EyeCatcheSceneParam.ScreenImg = YanesdkUtil.CopyGlFlameBufferNormalize(m_gSys.Screen as Screen2DGl);
                        m_gSys.EyeCatcheSceneParam.CallScenarioNo = KyojinConst.ScenarioID.STORY04;
                        m_gSys.EyeCatcheSceneParam.Pattern = (int)SenarioEndEyeCatcheScene.SHI_TYPE.MIDO01;
                        break;
                    case "story07":
                        m_gSys.UserInfo.SetReadFlg((int)KyojinConst.ScenarioID.STORY01, true);
                        m_gSys.UserInfo.SetReadPos(nowScenarioId, scenarioParser.GetScenarioDrawContext().PageHeadTextOffset + 1);
                        // ebv
                        m_gSys.SceneController.ExitScene();
                        m_gSys.SceneController.CallScene(Scenes.ScenarioEndEyecatche);
                        m_gSys.CommonBgmLoader.StopBGMFade(1000);
                        OnPaint(m_gSys);
                        m_gSys.EyeCatcheSceneParam.ScreenImg = YanesdkUtil.CopyGlFlameBufferNormalize(m_gSys.Screen as Screen2DGl);
                        m_gSys.EyeCatcheSceneParam.CallScenarioNo = KyojinConst.ScenarioID.STORY05;
                        m_gSys.EyeCatcheSceneParam.Pattern = (int)SenarioEndEyeCatcheScene.SHI_TYPE.AYA01;
                        break;
                    case "story08":
                        m_gSys.UserInfo.SetReadFlg((int)KyojinConst.ScenarioID.STORY02_2, true);
                        m_gSys.UserInfo.SetReadPos(nowScenarioId, scenarioParser.GetScenarioDrawContext().PageHeadTextOffset + 1);
                        // ebv
                        m_gSys.SceneController.ExitScene();
                        m_gSys.SceneController.CallScene(Scenes.ScenarioEndEyecatche);
                        m_gSys.CommonBgmLoader.StopBGMFade(1000);
                        OnPaint(m_gSys);
                        m_gSys.EyeCatcheSceneParam.ScreenImg = YanesdkUtil.CopyGlFlameBufferNormalize(m_gSys.Screen as Screen2DGl);
                        m_gSys.EyeCatcheSceneParam.CallScenarioNo = KyojinConst.ScenarioID.STORY06;
                        m_gSys.EyeCatcheSceneParam.Pattern = (int)SenarioEndEyeCatcheScene.SHI_TYPE.MIDO01;
                        break;
                    case "kyojin02":
                        // ǃtO
                        m_gSys.UserInfo.SetReadFlg((int)KyojinConst.ScenarioID.KYOJIN01, true);
                        m_gSys.UserInfo.SetReadPos(nowScenarioId, scenarioParser.GetScenarioDrawContext().PageHeadTextOffset + 1);
                        DoAutoSave();

                        // ebv
                        m_gSys.SceneController.ExitScene();
                        m_gSys.SceneController.CallScene(Scenes.Telop);
                        m_gSys.CommonBgmLoader.StopBGMFade(1000);
                        OnPaint(m_gSys);
                        //m_gSys.EyeCatcheSceneParam.ScreenImg = YanesdkUtil.CopyGlFlameBuffer(m_gSys.Screen as Screen2DGl);
                        //m_gSys.EyeCatcheSceneParam.CallScenarioNo = KyojinConst.ScenarioID.KYOJIN02;
                        m_gSys.TelopParam.ScreenImg = YanesdkUtil.CopyGlFlameBuffer(m_gSys.Screen as Screen2DGl);
                        m_gSys.TelopParam.CallScenarioNo = KyojinConst.ScenarioID.KYOJIN02;
                        break;
                    case "kyojin03":
                        // ǃtO
                        m_gSys.UserInfo.SetReadFlg((int)KyojinConst.ScenarioID.KYOJIN02, true);
                        m_gSys.UserInfo.SetReadPos(nowScenarioId, scenarioParser.GetScenarioDrawContext().PageHeadTextOffset + 1);
                        DoAutoSave();

                        // ebv
                        m_gSys.SceneController.ExitScene();
                        m_gSys.SceneController.CallScene(Scenes.Telop);
                        m_gSys.CommonBgmLoader.StopBGMFade(1000);
                        OnPaint(m_gSys);
                        m_gSys.TelopParam.ScreenImg = YanesdkUtil.CopyGlFlameBuffer(m_gSys.Screen as Screen2DGl);
                        m_gSys.TelopParam.CallScenarioNo = KyojinConst.ScenarioID.KYOJIN03;
                        break;

                    case "kyojinending":
                        // ǃtO
                        m_gSys.UserInfo.SetReadFlg((int)KyojinConst.ScenarioID.KYOJIN03, true);
                        m_gSys.UserInfo.SetReadPos(nowScenarioId, scenarioParser.GetScenarioDrawContext().PageHeadTextOffset + 1);
                        DoAutoSave();

                        // GfBO
                        m_gSys.SceneController.ExitScene();
                        m_gSys.SceneController.CallScene(Scenes.Ending);
                        m_gSys.CommonBgmLoader.StopBGMFade(1000);
                        break;

                    default:
                        break;
                }
            };
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// r[ݒ肷
        /// </summary>
        /// <returns></returns>
        private YanesdkResult SetupView()
        {
            screenFilter = YamalibConst.CreateTexture("img/scenario/black_filter.png");
            KyojinScenarioView theView = new KyojinScenarioView();
            theView.Model = model;
            // }EX
            theView.Mouse = m_gSys.KeyDecolateMouse;

            theView.SetTextOffsetXY(VIEW_TEXT_OFFSETX, VIEW_TEXT_OFFSETY);
            this.view = theView;

            // vvgJ[\\ƗȂȂ...
            //theView.PostPaintText = delegate(IScreen screen, YaneScenarioView view)
            //{
            //    // vvgJ[\`悷
            //    KyojinScenarioView myView = view as KyojinScenarioView;
            //    YaneScenarioModel myModel = myView.Model as YaneScenarioModel;
            //    int ox, oy;
            //    myView.GetTextOffsetXY(out ox, out oy);
            //    int lastLetterIndex = myModel.ShowTextCount;
            //    if (myModel.LetterData.Count <= lastLetterIndex)
            //    {
            //        lastLetterIndex = myModel.LetterData.Count - 1;
            //        ox += 20;
            //    }
            //    promptCarsor.SetXY(ox + (int)myModel.LetterData[lastLetterIndex].Pos.X, oy + (int)myModel.LetterData[lastLetterIndex].Pos.Y);
            //    promptCarsor.OnPaint(screen);
            //    return YanesdkResult.NoError;
            //};

            theView.PostPaintCharacter = delegate(IScreen screen, YaneScenarioView view)
            {
                KyojinScenarioView myView = view as KyojinScenarioView;
                myView.IsShowText = false;
                if (!m_gSys.Key.IsPress(11) && !m_gSys.Key.IsPress(12))
                {
                    Color4ub colorOrg = YanesdkUtil.GetNowScreenColor(screen);
                    screen.SetColor(255, 255, 255, 128);
                    screen.Blt(screenFilter, 0, 0);
                    screen.SetColor(colorOrg);
                    myView.IsShowText = true;
                }
                return YanesdkResult.NoError;
            };

            return YanesdkResult.NoError;
        }

        /// <summary>
        /// Xg[[ʂ̃C[ݒ
        /// </summary>
        /// <returns></returns>
        private YanesdkResult SetupScenarioLayer()
        {
            // TODO: C[KvȂǋL邱
            return YanesdkResult.NoError;
        }

        private void ReturnScene()
        {
            m_gSys.SceneController.ReturnScene();
        }

        /// <summary>
        /// }EX̃nh𐶐ĕԋp
        /// </summary>
        /// <returns></returns>
        private MouseInputHandler CreateMouseInputHandler()
        {
            MouseInputHandler handler = new MouseInputHandler(m_gSys.KeyDecolateMouse);

            // ENbN
            handler.SetHandler(new MouseState(MouseInput.Button.Left, true),
                delegate(IScenarioModel model)
                {
                    KyojinScenarioModel theModel = model as KyojinScenarioModel;
                    if (theModel == null)
                    {
                        return YanesdkResult.InvalidParameter;
                    }
                    //CommonLogWriter.Write("HANDLE LCLICK UP");
                    if ((theModel.IsReadStop || theModel.IsPageEnd) && !theModel.IsEffectWait && !theModel.ScenarioState.InputLockFlg && !theModel.IsShowThumbnailDraw &&
                        !menuBar.IsInBar())
                    {
                        // {CXĐĂ~߂
                        model.VoiceMgr.StopVoiceFade(250);

                        // ǂݐi߂
                        return model.ContinueRead();
                    }
                    return YanesdkResult.NoError;
                }
            );

            return handler;
        }

        /// <summary>
        /// }EX̃nh𐶐ĕԋp
        /// </summary>
        /// <returns></returns>
        private KeyInputHandler CreateKeyInputHandler()
        {
            KeyInputHandler handler = new KeyInputHandler(m_gSys.Key);

            // Tl[N
            InputHandler thumbnailStartEvent = delegate(IScenarioModel model)
                {
                    KyojinScenarioModel theModel = model as KyojinScenarioModel;
                    if (theModel == null)
                    {
                        return YanesdkResult.InvalidParameter;
                    }

                    if (nowScenarioId < KyojinConst.ScenarioID.KYOJIN01)
                    {
                        return YanesdkResult.NoError;
                    }

                    CommonLogWriter.Write("HANDLE Thumbail Start Event");
                    if (!theModel.IsShowThumbnailDraw)
                    {

                        if (theModel.PageNo > theModel.ThumbnailDraw.GetThumbnailLimitNo())
                        {
                            theModel.ThumbnailDraw.SetThumbnailLimitNo(theModel.PageNo);
                        }

                        theModel.ThumbnailDraw.SetThumbnailNo(theModel.PageNo - 1);
                        theModel.ThumbnailDraw.FadeIn(5, 10);
                        theModel.IsShowThumbnailDraw = true;
                    }
                    return YanesdkResult.NoError;
                };

            // Ctrl + TAB Tl[N
            handler.SetHandler(new KeyState(new KeyCode[] { (KeyCode)11, (KeyCode)14 }, false), thumbnailStartEvent);
            handler.SetHandler(new KeyState(new KeyCode[] { (KeyCode)13, (KeyCode)14 }, false), thumbnailStartEvent);

            // Tl[ enter
            handler.SetHandler(new KeyState(new KeyCode[] { (KeyCode)6 }, false),
                 delegate(IScenarioModel model)
                 {
                     KyojinScenarioModel theModel = model as KyojinScenarioModel;
                     if (theModel == null)
                     {
                         return YanesdkResult.InvalidParameter;
                     }
                     if (theModel.IsShowThumbnailDraw)
                     {
                         CommonLogWriter.Write("HANDLE Thumbail End Event");
                         if (theModel.ThumbnailDraw.IsFinishSelect())
                         {
                             // Tl[
                             theModel.ThumbnailDraw.ResetSelect();
                         }
                     }
                     return YanesdkResult.NoError;
                 }
                );

            // Tl[LZ Esc
            handler.SetHandler(new KeyState(new KeyCode[] { (KeyCode)0 }, false),
                 delegate(IScenarioModel model)
                 {
                     KyojinScenarioModel theModel = model as KyojinScenarioModel;
                     if (theModel == null)
                     {
                         return YanesdkResult.InvalidParameter;
                     }
                     if (theModel.IsShowThumbnailDraw)
                     {
                         // Tl[LZ
                         if (YanesdkResult.NoError == theModel.ThumbnailDraw.FadeOut(5, 10))
                         {
                             theModel.ThumbnailDraw.FadeOutFinishEvent = delegate()
                             {
                                 theModel.ThumbnailDraw.ResetSelect();
                                 theModel.IsShowThumbnailDraw = false;
                             };
                         }
                     }
                     return YanesdkResult.NoError;
                 }
                );

            // Tl[LZ 
            handler.SetHandler(new KeyState(new KeyCode[] { (KeyCode)14 }, false),
                 delegate(IScenarioModel model)
                 {
                     KyojinScenarioModel theModel = model as KyojinScenarioModel;
                     if (theModel == null)
                     {
                         return YanesdkResult.InvalidParameter;
                     }
                     if (theModel.IsShowThumbnailDraw)
                     {
                         // Tl[LZ
                         theModel.ThumbnailDraw.Next();
                     }
                     return YanesdkResult.NoError;
                 }
                );

            // 
            handler.SetHandler(new KeyState(new KeyCode[] { (KeyCode)6 }, false),
                 delegate(IScenarioModel model)
                 {
                     KyojinScenarioModel theModel = model as KyojinScenarioModel;
                     if (theModel == null)
                     {
                         return YanesdkResult.InvalidParameter;
                     }
                     if (theModel.IsShowThumbnailDraw && !theModel.ThumbnailDraw.IsFinishSelect())
                     {
                         theModel.ThumbnailDraw.SelectPane(0, 20);

                         theModel.ThumbnailDraw.SelectFinishEvent = delegate
                         {
                             theModel.ThumbnailDraw.ResetSelect();
                             theModel.IsShowThumbnailDraw = false;
                             JumpByThumbnail(theModel.ThumbnailDraw.GetActiveInfo()[0]);
                             theModel.ThumbnailDraw.SelectFinishEvent = null;
                         };
                     }
                     return YanesdkResult.NoError;
                 }
                );

            return handler;
        }

        /// <summary>
        /// ēǍ
        /// </summary>
        /// <param name="thumbInfo"></param>
        private void JumpByThumbnail(ThumbnailInfo thumbInfo)
        {
            model.ScenarioState.PageEndFlg = true;
            LoadFromScenarioInfo(CreateScenarioInfoFromThumbnailInfo(thumbInfo), true);
        }

        /// <summary>
        /// Tl[񂩂ScenarioInfoč쐬
        /// </summary>
        /// <param name="thumbInfo"></param>
        /// <returns></returns>
        private ScenarioInfo CreateScenarioInfoFromThumbnailInfo(ThumbnailInfo thumbInfo)
        {
            ScenarioInfo scenarioInfo = new ScenarioInfo();

            scenarioInfo.ScenarioID = nowScenarioId;	// ViIԍ
            scenarioInfo.BgNo = thumbInfo.BgNo;
            scenarioInfo.BgmNo = thumbInfo.BgmNo;
            scenarioInfo.BgmVol = m_gSys.OptionInfo.BGMVolume / 100.0f;
            scenarioInfo.BgmLoop = true;
            if (thumbInfo.SeNo != -1)
            {
                scenarioInfo.SeNo = new int[4];
                scenarioInfo.SeNo[0] = thumbInfo.SeNo;
                scenarioInfo.SeLoop = 0;
                scenarioInfo.SeVol = m_gSys.OptionInfo.SEVolume / 100.0f; ;
            }
            scenarioInfo.PageNo = thumbInfo.PageNo;	// Py[W͂܂
            scenarioInfo.TextPos = 0;
            scenarioInfo.ScenarioPos = thumbInfo.TextOffset;
            scenarioInfo.TextPos = int.MaxValue;
            scenarioInfo.AnalyzedTagNum = int.MaxValue;

            if (thumbInfo.CharaLeft != null)
            {
                scenarioInfo.CharaPos.Add(0);
                scenarioInfo.PresetPos.Add((int)Character.PresetPosID.LEFT);
                scenarioInfo.CharaIds.Add(thumbInfo.CharaLeft);
                scenarioInfo.CharaColors.Add(null);
            }
            else
            {
                scenarioInfo.CharaPos.Add(0);
                scenarioInfo.PresetPos.Add((int)Character.PresetPosID.UNSET);
                scenarioInfo.CharaIds.Add(null);
                scenarioInfo.CharaColors.Add(null);
            }

            if (thumbInfo.CharaCenter != null)
            {
                scenarioInfo.CharaPos.Add(0);
                scenarioInfo.PresetPos.Add((int)Character.PresetPosID.CENTER);
                scenarioInfo.CharaIds.Add(thumbInfo.CharaCenter);
                scenarioInfo.CharaColors.Add(null);
            }
            else
            {
                scenarioInfo.CharaPos.Add(0);
                scenarioInfo.PresetPos.Add((int)Character.PresetPosID.UNSET);
                scenarioInfo.CharaIds.Add(null);
                scenarioInfo.CharaColors.Add(null);
            }

            if (thumbInfo.CharaRight != null)
            {
                scenarioInfo.CharaPos.Add(0);
                scenarioInfo.PresetPos.Add((int)Character.PresetPosID.RIGHT);
                scenarioInfo.CharaIds.Add(thumbInfo.CharaRight);
                scenarioInfo.CharaColors.Add(null);
            }
            else
            {
                scenarioInfo.CharaPos.Add(0);
                scenarioInfo.PresetPos.Add((int)Character.PresetPosID.UNSET);
                scenarioInfo.CharaIds.Add(null);
                scenarioInfo.CharaColors.Add(null);
            }

            scenarioInfo.CharaPos.Add(0);
            scenarioInfo.PresetPos.Add((int)Character.PresetPosID.UNSET);
            scenarioInfo.CharaIds.Add(null);
            scenarioInfo.CharaColors.Add(null);

            return scenarioInfo;
        }

    }


}
