﻿using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Input;

namespace Kyojin.Input
{
    /// <summary>
    /// 1Pの入力
    /// </summary>
    public class Input1 : VirtualKey
    {
        private KeyBoardInput keyboard = new KeyBoardInput();
        private JoyStick joystick = new JoyStick(0);
        public Input1()
        {
            AddDevice(keyboard);
            AddDevice(joystick);

            //	0	:	Escape
            AddKey(0, 0, (int)KeyCode.ESCAPE);

            //	1	:	Up
            AddKey(1, 0, (int)KeyCode.UP);
            AddKey(1, 1, 0);

            //	2	:	Down
            AddKey(2, 0, (int)KeyCode.DOWN);
            AddKey(2, 1, 1);

            //	3	:	Left
            AddKey(3, 0, (int)KeyCode.LEFT);
            AddKey(3, 1, 2);

            //	4	:	Right
            AddKey(4, 0, (int)KeyCode.RIGHT);
            AddKey(4, 1, 3);

            //	5	:	Space
            AddKey(5, 0, (int)KeyCode.z);
            AddKey(5, 0, (int)KeyCode.SPACE);
            AddKey(5, 1, 4);

            //	6	:	Return
            AddKey(6, 0, (int)KeyCode.x);
            AddKey(6, 1, 5);
        }
    }

    /// <summary>
    /// 2Pの入力
    /// </summary>
    public class Input2 : VirtualKey
    {
        private KeyBoardInput keyboard = new KeyBoardInput();
        private JoyStick joystick = new JoyStick(1);
        public Input2()
        {
            AddDevice(keyboard);
            AddDevice(joystick);

            //	0	:	Escape
            AddKey(0, 0, (int)KeyCode.ESCAPE);

            //	1	:	Up
            AddKey(1, 0, (int)KeyCode.KP8);
            AddKey(1, 1, 0);

            //	2	:	Down
            AddKey(2, 0, (int)KeyCode.KP2);
            AddKey(2, 1, 1);

            //	3	:	Left
            AddKey(3, 0, (int)KeyCode.KP4);
            AddKey(3, 1, 2);

            //	4	:	Right
            AddKey(4, 0, (int)KeyCode.KP6);
            AddKey(4, 1, 3);

            //	5	:	Space
            AddKey(5, 0, (int)KeyCode.KP_MULTIPLY);
            AddKey(5, 1, 4);

            //	6	:	Return
            AddKey(6, 0, (int)KeyCode.KP_DIVIDE);
            AddKey(6, 1, 5);
        }
    }

}
