using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Timer;
using Yanesdk.Draw;
using Yamalib.Util;
using Yamalib.Yanesdkext.Draw;

namespace Kyojin.Component.Ending
{
    public class Scene01 : EndingSceneBase, IDisposable
    {

        protected class Phase2Base : PhaseBase
        {

            /// 
            public Phase2Base(TextObj obj, TextureLoader loader, HitStatus status)
                : base(obj, loader, status)
            {
                phase = new RootCounterS(0, 255, 2);
                offsetX = new PowIncCounter(0, 100, 100);
                offsetY = new PowIncCounter(0, 500, 128);
                offsetY.SetIncCount(256);
                alpha = new RootCounterS(200, 0, 2);
            }

            /// [_̉摜ԍ
            public void SetImgNo(int no)
            {
                imgNo = no;
            }

            /// `ʒu
            public void SetXY(int x, int y)
            {
                posx = x;
                posy = y;
            }
            public void GetXY(out int x, out int y)
            {
                x = posx;
                y = posy;
            }

            /// gXub^p̃JE^
            public RootCounterS GetTransCounter()
            {
                return phase;
            }

            /// gXub^̌ʔԍ
            public void SetEffectNo(int no)
            {
                effectNo = no;
            }
            public int GetEffectNo()
            {
                return effectNo;
            }

            /// XChJn
            public void Slide()
            {
                startSlide = true;
            }

            public void Drop()
            {
                startDrop = true;
                alpha.Set(255, 255, 1);
                offsetY.Dec();
                posy = posy - (offsetY.EndValue - (int)offsetY.Value());
            }

            /// tF[hAEg
            public void FadeOut()
            {
                fadeOutFlg = true;
                alpha.Set(255, 0, 10);
            }

            /// ړ
            public override void OnMove(IScreen screen)
            {
                if (IsStart)
                {
                    phase.Inc();
                    if (startSlide)
                    {
                        alpha.Inc();
                        offsetX.Inc();
                    }
                    if (startDrop)
                    {
                        offsetY.Dec();
                        if (fadeOutFlg)
                        {
                            alpha.Inc();
                        }
                    }
                }
            }
            /// `揈
            public override void OnDraw(IScreen screen)
            {
                if (IsStart && !IsEnd)
                {
                    if (startSlide)
                    {
                        if (alpha.Value() > 0)
                        {
                            screen.SetColor(255, 255, 255, alpha.Value());
                            screen.Blt(m_textureLoader.GetTexture(imgNo), posx + (int)offsetX.Value(), posy);
                        }
                        else
                        {
                            startSlide = false;
                        }
                    }
                    if (startDrop)
                    {
                        screen.SetColor(255, 255, 255, alpha.Value());
                        screen.Blt(m_textureLoader.GetTexture(imgNo), posx, posy + (offsetY.EndValue - (int)offsetY.Value()));
                    }
                    else
                    {
                        SetScreenColorMax(screen);
                        TransBltter.Blt(effectNo, screen, m_textureLoader.GetTexture(imgNo), posx, posy, phase.Value());
                    }
                }
            }

            private bool startSlide;
            private bool startDrop;
            private bool fadeOutFlg = false;
            private int effectNo;
            private int posx;
            private int posy;
            private int imgNo;
            private RootCounterS phase;
            private RootCounterS alpha;
            private IDecimalCounter offsetX;
            private PowIncCounter offsetY;
        }

        protected class Phase7 : PhaseBase
        {
            /// 
            public Phase7(TextObj obj, TextureLoader loader, HitStatus status)
                : base(obj, loader, status)
            {
                alpha = new RootCounterS(200, 0, 7);
            }

            /// [_̉摜ԍ
            public void SetImgNo(int no)
            {
                imgNo = no;
            }

            /// ړ
            public override void OnMove(IScreen IScreen)
            {
                if (IsStart)
                {
                    alpha.Inc();
                }
            }

            /// `揈
            public override void OnDraw(IScreen IScreen)
            {
                if (IsStart && !IsEnd)
                {
                    if (alpha.Value() > 0)
                    {
                        ITexture img = m_textureLoader.GetTexture(imgNo);
                        IScreen.SetColor(255, 255, 255, alpha.Value());
                        IScreen.Blt(img, 0, 0);
                    }
                }
            }


            private RootCounterS alpha;
            private int imgNo;
        }

        protected class Phase7Base : PhaseBase
        {

            /// 
            public Phase7Base(TextObj obj, TextureLoader loader, HitStatus status)
                : base(obj, loader, status)
            {
                phase = new RootCounterS(255, 0, 16);
                rateCounter = new PowIncCounter(1, 2, 64);
                alpha = new RootCounterS(0, 196, 7);
            }

            /// [_̉摜ԍ
            public void SetImgNo(int no)
            {
                imgNo = no;
            }

            /// `ʒu
            public void SetXY(int x, int y)
            {
                posx = x;
                posy = y;
            }
            public void GetXY(out int x, out int y)
            {
                x = posx;
                y = posy;
            }

            /// gXub^p̃JE^
            public RootCounterS GetTransCounter()
            {
                return phase;
            }

            /// gXub^̌ʔԍ
            public void SetEffectNo(int no)
            {
                effectNo = no;
            }
            public int GetEffectNo()
            {
                return effectNo;
            }

            /// tF[hAEg
            public void Next()
            {
                fadeOutFlg = true;
                imgNo += 1;
                phase.Set(alpha.Value(), 0, 6);
                alpha.Set(alpha.Value(), 0, 6);
            }

            public void FadeOut()
            {
                alpha.Set(alpha.Value(), 0, 5);
                alpha.Set(128, 0, 5);
            }

            /// ړ
            public override void OnMove(IScreen IScreen)
            {
                if (IsStart)
                {
                    phase.Inc();
                    alpha.Inc();
                }
                if (fadeOutFlg)
                {
                    rateCounter.Inc();
                }
            }
            /// `揈
            public override void OnDraw(IScreen IScreen)
            {
                if (IsStart && !IsEnd)
                {
                    if (alpha.Value() > 0)
                    {
                        if (fadeOutFlg)
                        {
                            if (phase.Value() > 0)
                            {
                                IScreen.SetColor(255, 255, 255, phase.Value());
                                IScreen.Blt(m_textureLoader.GetTexture(imgNo - 1), posx, posy);
                            }
                            IScreen.SetColor(255, 255, 255, alpha.Value());
                            ITexture img = m_textureLoader.GetTexture(imgNo);
                            IScreen.BltRotate(img, posx + (int)img.Width / 2,
                                posy + (int)img.Height / 2, 0, (float)rateCounter.GetDecimal(), 4);
                        }
                        else
                        {
                            IScreen.SetColor(255, 255, 255, alpha.Value());
                            IScreen.Blt(m_textureLoader.GetTexture(imgNo), posx, posy);
                        }
                    }
                }
            }


            private bool fadeOutFlg = false;
            private int effectNo = 19;
            private int posx;
            private int posy;
            private int imgNo;
            private RootCounterS phase;
            private RootCounterS alpha;
            private PowIncCounter rateCounter;
        }

        #region 萔l

        protected const int P1_1_FADEOUT_SPEED = 5;
        protected const int LOGO_X = 320;
        protected const int LOGO_Y = 120;
        // ÔߎԂłIԂ`FbN
        private const long END_TIME = 66000 + MUSIC_OFFSET_TIME;

        #endregion

        #region otB[h

        protected readonly List<PhaseBase> activePhase = new List<PhaseBase>();
        protected TextureLoader textureLoader;
        protected FixTimer timer;
        protected bool fadeTitile = false;
        protected bool sceneEndFlg = false;
        protected readonly List<HittingEffect> hitEffects = new List<HittingEffect>();

        private Phase2Base phase2_1;
        private Phase2Base phase2_3;
        private Phase2Base phase3_1;
        private Phase2Base phase3_3;
        private Phase2Base phase4_1;
        private Phase2Base phase4_3;
        private Phase2Base phase5_1;
        private Phase2Base phase5_3;
        private Phase2Base phase6_1;
        private Phase2Base phase6_3;

        private Phase1Base phase1_1;
        private Phase1Base phase1_2;
        private Phase1Base phase1_3;
        private Phase1Base phase1_4;
        private Phase1Base phase1_5;
        private Phase1Base phase1_6;

        private Phase7 phase7_1;
        private Phase7 phase7_2;
        private Phase7 phase7_3;
        private Phase7 phase7_4;
        private Phase7 phase7_5;
        private Phase7 phase7_6;
        private Phase7 phase7_7;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="timer"></param>
        public Scene01(FixTimer timer)
        {
            textureLoader = new TextureLoader();
            textureLoader.IsDefRelativePath = false;
            textureLoader.LoadDefFile("img2/ending/s01/list.txt");
            this.timer = timer;
            SetupTimingData();
        }

        /// ׂẲ摜LbV	
        public override void CacheTexture()
        {
            CacheTextureAll(textureLoader, "img2/ending/s01/list.txt");
        }

        // V[I
        public override bool IsEnd
        {
            get { return sceneEndFlg || END_TIME <= timer.Time; }
        }

        // \[X̉
        public override void Release()
        {
            textureLoader.Dispose();
        }

        /// ^C~Of[^쐬
        protected virtual void SetupTimingData()
        {
            TimingData[] t1_1 = new TimingData[] {
			    new TimingData(MUSIC_OFFSET_TIME + 2170,  new HitEvent[]{eventCallback1_1}), 
                new TimingData(MUSIC_OFFSET_TIME + 2880,  new HitEvent[]{eventCallback1_2}), 
                new TimingData(MUSIC_OFFSET_TIME + 4840,  new HitEvent[]{eventCallback1_3}), 
                new TimingData(MUSIC_OFFSET_TIME + 5510,  new HitEvent[]{eventCallback1_4}), 
                new TimingData(MUSIC_OFFSET_TIME + 7500,  new HitEvent[]{eventCallback1_5}), 
                new TimingData(MUSIC_OFFSET_TIME + 8320,  new HitEvent[]{eventCallback1_6}), 
                new TimingData(MUSIC_OFFSET_TIME + 10160, new HitEvent[]{eventCallback1_7}),
                new TimingData(MUSIC_OFFSET_TIME + 10810, new HitEvent[]{eventCallback1_8}),
		    };
            m_timingData.Add(t1_1);

            TimingData[] t1_2 = new TimingData[] {
                new TimingData(MUSIC_OFFSET_TIME + 12820, new HitEvent[]{eventCallback2_1}),
                new TimingData(MUSIC_OFFSET_TIME + 13480, new HitEvent[]{eventCallback2_2}),
                new TimingData(MUSIC_OFFSET_TIME + 15480, new HitEvent[]{eventCallback2_3}),
                new TimingData(MUSIC_OFFSET_TIME + 16150, new HitEvent[]{eventCallback2_4}),
                new TimingData(MUSIC_OFFSET_TIME + 18140, new HitEvent[]{eventCallback2_5}),
                new TimingData(MUSIC_OFFSET_TIME + 18970, new HitEvent[]{eventCallback2_6}),
                new TimingData(MUSIC_OFFSET_TIME + 20810, new HitEvent[]{eventCallback2_7}),
                new TimingData(MUSIC_OFFSET_TIME + 21640, new HitEvent[]{eventCallback2_8}),
            };
            m_timingData.Add(t1_2);


            TimingData[] t1_3 = new TimingData[] {
                new TimingData(MUSIC_OFFSET_TIME + 23480, new HitEvent[]{eventCallback3_1}),
                new TimingData(MUSIC_OFFSET_TIME + 24160, new HitEvent[]{eventCallback3_2}),
                new TimingData(MUSIC_OFFSET_TIME + 26150, new HitEvent[]{eventCallback3_3}),
                new TimingData(MUSIC_OFFSET_TIME + 26850, new HitEvent[]{eventCallback3_4}),
                new TimingData(MUSIC_OFFSET_TIME + 28820, new HitEvent[]{eventCallback3_5}),
                new TimingData(MUSIC_OFFSET_TIME + 29660, new HitEvent[]{eventCallback3_6}),
                new TimingData(MUSIC_OFFSET_TIME + 31470, new HitEvent[]{eventCallback3_7}),
                new TimingData(MUSIC_OFFSET_TIME + 32260, new HitEvent[]{eventCallback3_8}),
            };
            m_timingData.Add(t1_3);


            TimingData[] t1_4 = new TimingData[] {
                new TimingData(MUSIC_OFFSET_TIME + 34150, new HitEvent[]{eventCallback4_1}),
                new TimingData(MUSIC_OFFSET_TIME + 34810, new HitEvent[]{eventCallback4_2}),
                new TimingData(MUSIC_OFFSET_TIME + 36810, new HitEvent[]{eventCallback4_3}),
                new TimingData(MUSIC_OFFSET_TIME + 37490, new HitEvent[]{eventCallback4_4}),
                new TimingData(MUSIC_OFFSET_TIME + 39460, new HitEvent[]{eventCallback4_5}),
                new TimingData(MUSIC_OFFSET_TIME + 40270, new HitEvent[]{eventCallback4_6}),
                new TimingData(MUSIC_OFFSET_TIME + 42150, new HitEvent[]{eventCallback4_7}),
                new TimingData(MUSIC_OFFSET_TIME + 42960, new HitEvent[]{eventCallback4_8}),
            };
            m_timingData.Add(t1_4);

            // 1-5 original is 3-5
            const long offset1_5 = 88000 - MUSIC_OFFSET_TIME;
            TimingData[] t1_5 = new TimingData[] {
                new TimingData(132820 - offset1_5, new HitEvent[]{eventCallback5_1}, true),
                new TimingData(133490 - offset1_5, new HitEvent[]{eventCallback5_2}, true),
                new TimingData(135480 - offset1_5, new HitEvent[]{eventCallback5_3}, true),
                new TimingData(136160 - offset1_5, new HitEvent[]{eventCallback5_4}, true),
                new TimingData(138140 - offset1_5, new HitEvent[]{eventCallback5_5}, true),
                new TimingData(138980 - offset1_5, new HitEvent[]{eventCallback5_6}, true),
                new TimingData(140810 - offset1_5, new HitEvent[]{eventCallback5_7}, true),
                new TimingData(141650 - offset1_5, new HitEvent[]{eventCallback5_8}, true),
            };
            m_timingData.Add(t1_5);

            // 1-6 original is 3-6
            const long offset1_6 = 88000 - MUSIC_OFFSET_TIME;
            TimingData[] t1_6 = new TimingData[] {
                new TimingData(143490 - offset1_6, new HitEvent[]{eventCallback6_1}, true),
                new TimingData(144140 - offset1_6, new HitEvent[]{eventCallback6_2}, true),
                new TimingData(146130 - offset1_6, new HitEvent[]{eventCallback6_3}, true),
                new TimingData(146820 - offset1_6, new HitEvent[]{eventCallback6_4}, true),
                new TimingData(148820 - offset1_6, new HitEvent[]{eventCallback6_5}, true),
                new TimingData(149640 - offset1_6, new HitEvent[]{eventCallback6_6}, true),
            };
            m_timingData.Add(t1_6);

            TimingData[] t1_7 = new TimingData[] {
                new TimingData(MUSIC_OFFSET_TIME + 62500, new HitEvent[]{eventCallback7_1}),
                new TimingData(MUSIC_OFFSET_TIME + 62840, new HitEvent[]{eventCallback7_2}),
                new TimingData(MUSIC_OFFSET_TIME + 63190, new HitEvent[]{eventCallback7_3}),
                new TimingData(MUSIC_OFFSET_TIME + 63500, new HitEvent[]{eventCallback7_4}),
                new TimingData(MUSIC_OFFSET_TIME + 63840, new HitEvent[]{eventCallback7_5}),
                new TimingData(MUSIC_OFFSET_TIME + 64120, new HitEvent[]{eventCallback7_6}),
                new TimingData(MUSIC_OFFSET_TIME + 64500, new HitEvent[]{eventCallback7_7}),
            };
            m_timingData.Add(t1_7);
        }

        public override void OnMove(IScreen screen)
        {
            foreach (PhaseBase phase in activePhase)
            {
                phase.OnMove(screen);
            }
            foreach (HittingEffect hitEffect in hitEffects)
            {
                if (hitEffect != null)
                {
                    hitEffect.OnMove(screen);
                }
            }
        }

        public override void OnDraw(IScreen screen)
        {
            foreach (PhaseBase phase in activePhase)
            {
                phase.OnDraw(screen);
            }
            foreach (HittingEffect hitEffect in hitEffects)
            {
                if (hitEffect != null)
                {
                    hitEffect.OnPaint(screen);
                }
            }

            if (fadeTitile)
            {
                if (phase1_5 != null)
                {
                    screen.SetColor(255, 255, 255, phase1_5.GetTransCounter().Value());
                    //				screen.bltRotate(textureLoader.Get(0), LOGO_X, LOGO_Y, 0, 1.0f, 4);
                }
            }
            else
            {
                //			screen.bltRotate(textureLoader.Get(0), LOGO_X, LOGO_Y, 0, 1.0f, 4);
            }
        }


        #region IDisposable o

        public virtual void Dispose()
        {
            Release();
        }

        #endregion


        #region qbgCxg

        // ========================================================================================== //
        // =================================     PHASE 1 - 1     ==================================== //
        // ========================================================================================== //

        /// 1-1
        private bool eventCallback1_1(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                phase1_1 = new Phase1Base(textObj, textureLoader, status);
                phase1_1.SetImgNo(1);
                phase1_1.SetXY(154, 215);
                phase1_1.GetTransCounter().Set(0, 255, 2);
                phase1_1.SetEffectNo(20);

                activePhase.Add(phase1_1);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-2
        private bool eventCallback1_2(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                phase1_2 = new Phase1Base(textObj, textureLoader, status);
                phase1_2.SetImgNo(2);
                phase1_2.SetXY(157, 243);
                phase1_2.GetTransCounter().Set(0, 255, 1);
                phase1_2.SetEffectNo(20);
                activePhase.Add(phase1_2);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 1-3
        private bool eventCallback1_3(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                phase1_3 = new Phase1Base(textObj, textureLoader, status);
                phase1_3.SetImgNo(3);
                phase1_3.SetXY(338, 215);
                phase1_3.GetTransCounter().Set(0, 255, 2);
                phase1_3.SetEffectNo(20);
                activePhase.Add(phase1_3);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-4
        private bool eventCallback1_4(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase1_4 = new Phase1Base(textObj, textureLoader, status);
                phase1_4.SetImgNo(4);
                phase1_4.SetXY(320, 243);
                phase1_4.GetTransCounter().Set(0, 255, 1);
                phase1_4.SetEffectNo(20);
                activePhase.Add(phase1_4);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-5
        private bool eventCallback1_5(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                phase1_5 = new Phase1Base(textObj, textureLoader, status);
                phase1_5.SetImgNo(5);
                phase1_5.SetXY(87, 274);
                phase1_5.GetTransCounter().Set(0, 255, 2);
                phase1_5.SetEffectNo(22);
                activePhase.Add(phase1_5);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-6
        private bool eventCallback1_6(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                phase1_6 = new Phase1Base(textObj, textureLoader, status);
                phase1_6.SetImgNo(6);
                phase1_6.SetXY(258, 274);
                phase1_6.GetTransCounter().Set(0, 255, 2);
                phase1_6.SetEffectNo(22);
                activePhase.Add(phase1_6);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-7
        private bool eventCallback1_7(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                // tF[hAEg[
                if (phase1_1 != null)
                {
                    phase1_1.GetTransCounter().Set(255, 0, P1_1_FADEOUT_SPEED);
                }
                if (phase1_2 != null)
                {
                    phase1_2.GetTransCounter().Set(255, 0, P1_1_FADEOUT_SPEED);
                }
                if (phase1_3 != null)
                {
                    phase1_3.GetTransCounter().Set(255, 0, P1_1_FADEOUT_SPEED);
                    phase1_3.SetEffectNo(21);
                }
                if (phase1_4 != null)
                {
                    phase1_4.GetTransCounter().Set(255, 0, P1_1_FADEOUT_SPEED);
                    phase1_4.SetEffectNo(21);
                }

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-8
        private bool eventCallback1_8(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                fadeTitile = true;
                // tF[hAEg[
                if (phase1_5 != null)
                {
                    phase1_5.GetTransCounter().Set(255, 0, P1_1_FADEOUT_SPEED + 2);
                    phase1_5.SetEffectNo(23);
                }
                if (phase1_6 != null)
                {
                    phase1_6.GetTransCounter().Set(255, 0, P1_1_FADEOUT_SPEED + 2);
                    phase1_6.SetEffectNo(23);
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        // ========================================================================================== //
        // =================================     PHASE 1 - 2     ==================================== //
        // ========================================================================================== //
        /// 2-1 
        private bool eventCallback2_1(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[Y͏I
            activePhase.Clear();
            //		hitEffects.Clear();

            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                phase2_1 = new Phase2Base(textObj, textureLoader, status);
                phase2_1.SetImgNo(7);
                phase2_1.SetXY(237, 185);
                phase2_1.GetTransCounter().Set(0, 255, 4);
                phase2_1.SetEffectNo(20);

                activePhase.Add(phase2_1);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 2-2 
        private bool eventCallback2_2(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase2_1 != null)
                {
                    phase2_1.Slide();
                }
                // ͎Oł̂łł[
                hitEffects.Add(CreateHitEffect(textObj));
            }
            return true;
        }

        /// 2-3 @lice
        private bool eventCallback2_3(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                phase2_3 = new Phase2Base(textObj, textureLoader, status);
                phase2_3.SetImgNo(8);
                phase2_3.SetXY(280, 228);
                phase2_3.GetTransCounter().Set(0, 255, 4);
                phase2_3.SetEffectNo(20);

                activePhase.Add(phase2_3);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 2-4@u[
        private bool eventCallback2_4(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                if (phase2_3 != null)
                {
                    phase2_3.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 2-5@hbv
        private bool eventCallback2_5(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                if (phase2_1 != null)
                {
                    phase2_1.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 2-6@hbv
        private bool eventCallback2_6(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                if (phase2_3 != null)
                {
                    phase2_3.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 2-6@tF[h
        private bool eventCallback2_7(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase2_1 != null)
                {
                    if (IsHitedStatus(status))
                    {
                        phase2_1.FadeOut();
                    }
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 2-4@u[
        private bool eventCallback2_8(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase2_3 != null)
                {
                    phase2_3.FadeOut();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        // ========================================================================================== //
        // =================================     PHASE 1 - 3     ==================================== //
        // ========================================================================================== //
        /// 3-1 
        private bool eventCallback3_1(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[Y͏I
            activePhase.Clear();
            hitEffects.Clear();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_1 = new Phase2Base(textObj, textureLoader, status);
                phase3_1.SetImgNo(9);
                phase3_1.SetXY(222, 192);
                phase3_1.GetTransCounter().Set(0, 255, 4);
                phase3_1.SetEffectNo(20);

                activePhase.Add(phase3_1);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 3-2 
        private bool eventCallback3_2(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase3_1 != null)
                {
                    phase3_1.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 3-3 @lice
        private bool eventCallback3_3(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_3 = new Phase2Base(textObj, textureLoader, status);
                phase3_3.SetImgNo(10);
                phase3_3.SetXY(263, 231);
                phase3_3.GetTransCounter().Set(0, 255, 4);
                phase3_3.SetEffectNo(20);

                activePhase.Add(phase3_3);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 3-4@u[
        private bool eventCallback3_4(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase3_3 != null)
                {
                    phase3_3.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 3-5@hbv
        private bool eventCallback3_5(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase3_1 != null)
                {
                    phase3_1.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 3-6@hbv
        private bool eventCallback3_6(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase3_3 != null)
                {
                    phase3_3.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 3-6@tF[h
        private bool eventCallback3_7(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase3_1 != null)
                {
                    if (HitStatus.POOR != status)
                    {
                        phase3_1.FadeOut();
                    }
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 3-4@u[
        private bool eventCallback3_8(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase3_3 != null)
                {
                    phase3_3.FadeOut();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        // ========================================================================================== //
        // =================================     PHASE 1 - 4     ==================================== //
        // ========================================================================================== //
        /// 4-1 
        private bool eventCallback4_1(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[Y͏I
            activePhase.Clear();
            hitEffects.Clear();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_1 = new Phase2Base(textObj, textureLoader, status);
                phase4_1.SetImgNo(11);
                phase4_1.SetXY(239, 186);
                phase4_1.GetTransCounter().Set(0, 255, 4);
                phase4_1.SetEffectNo(20);

                activePhase.Add(phase4_1);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 4-2 
        private bool eventCallback4_2(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase4_1 != null)
                {
                    phase4_1.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 4-3 @lice
        private bool eventCallback4_3(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_3 = new Phase2Base(textObj, textureLoader, status);
                phase4_3.SetImgNo(12);
                phase4_3.SetXY(264, 230);
                phase4_3.GetTransCounter().Set(0, 255, 4);
                phase4_3.SetEffectNo(20);

                activePhase.Add(phase4_3);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 4-4@u[
        private bool eventCallback4_4(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase4_3 != null)
                {
                    phase4_3.Slide();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 4-5@hbv
        private bool eventCallback4_5(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase4_1 != null)
                {
                    phase4_1.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 4-6@hbv
        private bool eventCallback4_6(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase4_3 != null)
                {
                    phase4_3.Drop();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 4-6@tF[h
        private bool eventCallback4_7(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase4_1 != null)
                {
                    if (HitStatus.POOR != status)
                    {
                        phase4_1.FadeOut();
                    }
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 4-4@u[
        private bool eventCallback4_8(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase4_3 != null)
                {
                    phase4_3.FadeOut();
                }
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        // ========================================================================================== //
        // =================================     PHASE 1 - 5     ==================================== //
        // ========================================================================================== //
        /// 5-1 
        private bool eventCallback5_1(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[Y͏I
            activePhase.Clear();
            hitEffects.Clear();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase5_1 = new Phase2Base(textObj, textureLoader, status);
                phase5_1.SetImgNo(13);
                phase5_1.SetXY(238, 185);
                phase5_1.GetTransCounter().Set(0, 255, 4);
                phase5_1.SetEffectNo(20);

                activePhase.Add(phase5_1);
                //		hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 5-2 
        private bool eventCallback5_2(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase5_1 != null)
                {
                    phase5_1.Slide();
                }
                //		hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 5-3 @lice
        private bool eventCallback5_3(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase5_3 = new Phase2Base(textObj, textureLoader, status);
                phase5_3.SetImgNo(14);
                phase5_3.SetXY(271, 236);
                phase5_3.GetTransCounter().Set(0, 255, 4);
                phase5_3.SetEffectNo(20);

                activePhase.Add(phase5_3);
                //		hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 5-4@u[
        private bool eventCallback5_4(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase5_3 != null)
                {
                    phase5_3.Slide();
                }
                //		hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 5-5@hbv
        private bool eventCallback5_5(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase5_1 != null)
                {
                    phase5_1.Drop();
                }
                //		hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 5-6@hbv
        private bool eventCallback5_6(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase5_3 != null)
                {
                    phase5_3.Drop();
                }
                //		hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 5-6@tF[h
        private bool eventCallback5_7(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase5_1 != null)
                {
                    if (HitStatus.POOR != status)
                    {
                        phase5_1.FadeOut();
                    }
                }
                //		hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 5-4@u[
        private bool eventCallback5_8(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase5_3 != null)
                {
                    phase5_3.FadeOut();
                }
                //		hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        // ========================================================================================== //
        // =================================     PHASE 1 - 6     ==================================== //
        // ========================================================================================== //
        /// 6-1 
        private bool eventCallback6_1(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[Y͏I
            activePhase.Clear();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase6_1 = new Phase2Base(textObj, textureLoader, status);
                phase6_1.SetImgNo(15);
                phase6_1.SetXY(200, 194);
                phase6_1.GetTransCounter().Set(0, 255, 4);
                phase6_1.SetEffectNo(20);

                activePhase.Add(phase6_1);
                //		hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 6-2 
        private bool eventCallback6_2(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase6_1 != null)
                {
                    phase6_1.Slide();
                }
                //		hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 6-3 @lice
        private bool eventCallback6_3(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase6_3 = new Phase2Base(textObj, textureLoader, status);
                phase6_3.SetImgNo(16);
                phase6_3.SetXY(288, 231);
                phase6_3.GetTransCounter().Set(0, 255, 4);
                phase6_3.SetEffectNo(20);

                activePhase.Add(phase6_3);
                //		hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 6-4@u[
        private bool eventCallback6_4(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase6_3 != null)
                {
                    phase6_3.Slide();
                }
                //		hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 6-5@hbv
        private bool eventCallback6_5(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase6_1 != null)
                {
                    phase6_1.Drop();
                    phase6_1.FadeOut();
                }
                //		hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 6-6@hbv
        private bool eventCallback6_6(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                if (phase6_3 != null)
                {
                    phase6_3.Drop();
                    phase6_3.FadeOut();
                }
                //		hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        // ========================================================================================== //
        // =================================     PHASE 1 - 7     ==================================== //
        // ========================================================================================== //
        /// 7-1 
        private bool eventCallback7_1(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[Y͏I
            activePhase.Clear();
            hitEffects.Clear();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase7_1 = new Phase7(textObj, textureLoader, status);
                phase7_1.SetImgNo(17);
                activePhase.Add(phase7_1);
            }

            hitEffects.Add(CreateHitEffect(textObj));
            // ͎Oł̂łł[
            return true;
        }
        /// 7-2 
        private bool eventCallback7_2(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase7_2 = new Phase7(textObj, textureLoader, status);
                phase7_2.SetImgNo(18);
                activePhase.Add(phase7_2);
            }
            hitEffects.Add(CreateHitEffect(textObj));
            // ͎Oł̂łł[
            return true;
        }

        /// 7-3 @lice
        private bool eventCallback7_3(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                phase7_3 = new Phase7(textObj, textureLoader, status);
                phase7_3.SetImgNo(19);
                activePhase.Add(phase7_3);
            }

            hitEffects.Add(CreateHitEffect(textObj));
            // ͎Oł̂łł[
            return true;
        }
        /// 7-4@TEXT
        private bool eventCallback7_4(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase7_4 = new Phase7(textObj, textureLoader, status);
                phase7_4.SetImgNo(20);
                activePhase.Add(phase7_4);
            }
            hitEffects.Add(CreateHitEffect(textObj));
            // ͎Oł̂łł[
            return true;
        }
        /// 7-5@LN^[
        private bool eventCallback7_5(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);

            if (IsHitedStatus(status))
            {
                phase7_5 = new Phase7(textObj, textureLoader, status);
                phase7_5.SetImgNo(21);
                activePhase.Add(phase7_5);
            }

            hitEffects.Add(CreateHitEffect(textObj));
            // ͎Oł̂łł[
            return true;
        }

        /// 7-6@TEXT
        private bool eventCallback7_6(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase7_6 = new Phase7(textObj, textureLoader, status);
                phase7_6.SetImgNo(22);
                activePhase.Add(phase7_6);
            }
            hitEffects.Add(CreateHitEffect(textObj));
            // ͎Oł̂łł[
            return true;
        }

        /// 7-7@TEXT
        private bool eventCallback7_7(IScreen IScreen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase7_7 = new Phase7(textObj, textureLoader, status);
                phase7_7.SetImgNo(23);
                activePhase.Add(phase7_7);
            }

            hitEffects.Add(CreateHitEffect(textObj));
            // ͎Oł̂łł[
            return true;
        }

        #endregion

    }
}
