using System;
using System.Collections.Generic;
using System.Text;
using Kyojin.Model;
using Yanesdk.Draw;
using Yamalib;

namespace Kyojin.Scene.SaveLoad
{
    class BookmarkView
    {
        #region  萔l

        /// ViI`ʒu`
        private const int SCENARIO_NAME_X = 254;
        private const int SCENARIO_NAME_Y = 10;

        private const int PAGE_FULL_LEN = 3;

        /// ڍדt`ʒu
        private const int DATE_X = 410;
        private const int DATE_Y = 73;

        /// ڍ׃y[W`ʒu
        private const int PAGE_X = 560;
        private const int PAGE_Y = DATE_Y;

        private enum TEXT_OFFSET { X = 272, Y = 95 };
        private const int MAX_TEXT_LINE = 3;
        private const int FONTSIZE = 20;
        private const int TEXTWIDTH = 340;

        private const float TEXT_RATE = 0.7f;

        #endregion

        #region otB[h

        private readonly static FontRepository fontRep = new FontRepository(YamalibConst.FONT_REP_TEXTURE_FACTORY);

        private BookmarkData bookmarkData;
        private TextureLoader scenarioName;

        #endregion

        public static FontRepository FontRep
        {
            get { return BookmarkView.fontRep; }
        }

        public BookmarkData BookmarkData
        {
            get { return bookmarkData; }
            set { bookmarkData = value; }
        }

        public TextureLoader ScenarioName
        {
            get { return scenarioName; }
            set { scenarioName = value; }
        }

        /// <summary>
        /// 쏈
        /// </summary>
        /// <param name="screen"></param>
        public void OnMove(IScreen screen)
        {
            if (bookmarkData == null || !bookmarkData.IsUse)
            {
                return;
            }
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        public void OnPaint(IScreen screen)
        {
            if (bookmarkData == null || !bookmarkData.IsUse)
            {
                return;
            }
            screen.Blt(GetScenarioNameTexture(bookmarkData.ScenarioInfo.ScenarioID), SCENARIO_NAME_X, SCENARIO_NAME_Y);
            // y[W`
            DrawDetailPageNo(screen);

            // t`
            DrawDetailDateText(screen);

            // eLXg`
            DrawDetailText(screen);
        }

        /// <summary>
        /// y[Wԍ`
        /// </summary>
        /// <param name="screen"></param>
        private void DrawDetailPageNo(IScreen screen)
        {
            int pageNum = bookmarkData.ScenarioInfo.PageNo;
            string pageStr = pageNum.ToString();

            // [߂
            if (PAGE_FULL_LEN > pageStr.Length)
            {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < PAGE_FULL_LEN - pageStr.Length; ++i)
                {
                    sb.Append('0');
                }
                sb.Append(pageStr);
                pageStr = sb.ToString();
            }

            ITexture pageText = fontRep.GetTexture(pageStr, 0);
            int x = PAGE_X;
            int y = PAGE_Y;
            screen.BltRotate(pageText, x, y, 0, TEXT_RATE, 0);
            // uŁv̕\
            screen.BltRotate(fontRep.GetTexture('', 0), x + (int) pageText.Width, y, 0, TEXT_RATE, 0);
        }

        private void DrawDetailDateText(IScreen screen)
        {
            string dateStr = bookmarkData.SaveDate.ToString("yy/MM/dd hh:mm:ss");
            ITexture dateStrImg = fontRep.GetTexture(dateStr, 0);
            int x = DATE_X;
            int y = DATE_Y;
            screen.BltRotate(dateStrImg, x, y, 0, TEXT_RATE, 0);
        }

        private void DrawDetailText(IScreen screen)
        {
            int x = (int)TEXT_OFFSET.X;
            int y = (int)TEXT_OFFSET.Y;
            int lineCount = 0;
            foreach (char ch in bookmarkData.Text)
            {
                ITexture texture = fontRep.GetTexture(ch, 0);
                int addOx = (int)(texture.Width * TEXT_RATE);
                if (MAX_TEXT_LINE - 1 == lineCount && (TEXTWIDTH + (int)TEXT_OFFSET.X) <= x + (addOx * 2))
                {
                    texture = fontRep.GetTexture('c', 0);
                    x += (int)(texture.Width * TEXT_RATE);
                    ++lineCount;
                }
                else if ((TEXTWIDTH + (int)TEXT_OFFSET.X) <= x + addOx)
                {
                    x = (int)TEXT_OFFSET.X;
                    y += (int)texture.Height;
                    ++lineCount;
                }
                else
                {
                    x += (int)(texture.Width * TEXT_RATE);
                }

                screen.BltRotate(texture,
                                 x,
                                 y,
                                 0, TEXT_RATE, 0);

                if (lineCount >= MAX_TEXT_LINE)
                {
                    break;
                }

            }
        }

        private ITexture GetScenarioNameTexture(KyojinConst.ScenarioID id)
        {
            switch (id)
            {
                case KyojinConst.ScenarioID.STORY01:
                    return scenarioName.GetTexture(0);
                case KyojinConst.ScenarioID.STORY02_0:
                case KyojinConst.ScenarioID.STORY02_1:
                case KyojinConst.ScenarioID.STORY02_2:
                    return scenarioName.GetTexture(1);
                case KyojinConst.ScenarioID.STORY03:
                    return scenarioName.GetTexture(2);
                case KyojinConst.ScenarioID.STORY04:
                    return scenarioName.GetTexture(3);
                case KyojinConst.ScenarioID.STORY05:
                    return scenarioName.GetTexture(4);
                case KyojinConst.ScenarioID.STORY06:
                    return scenarioName.GetTexture(5);
                case KyojinConst.ScenarioID.STORY07:
                    return scenarioName.GetTexture(6);
                case KyojinConst.ScenarioID.KYOJIN01:
                    return scenarioName.GetTexture(7);
                case KyojinConst.ScenarioID.KYOJIN02:
                    return scenarioName.GetTexture(8);
                case KyojinConst.ScenarioID.KYOJIN03:
                    return scenarioName.GetTexture(9);
                default:
                    return null;
            }
        }

    }
}
