using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Ytl;
using Yanesdk.System;

namespace Yamalib.Yanesdkext.System
{
    /// <summary>
    /// s̐擪ɁAݓo͂LogWriter
    /// </summary>
    public class TimestampLogWriter : IDisposable
    {
        private static readonly String DEFAULT_FORMAT = "HH:mm:ss";
        private String formatStr = DEFAULT_FORMAT;
        private readonly LogWriter logWriter;

        private static bool PRINT_CONSORL = true;

        /// <summary>
        /// OR\[ɂo͂邩
        /// </summary>
        /// <param name="b">^ł΁AR\[ɂóBȂ΃R\[ɏo͂Ȃ</param>
        public static void PrintConsorl(bool b)
        {
            PRINT_CONSORL = b;
        }

		#region public\bh
		/// <summary>
		///		RXgN^
		/// </summary>
        public TimestampLogWriter()
		{
            logWriter = new LogWriter();
		}

		/// <summary>otH_ʒuw肷</summary>
		/// <example>
		///		SetPath("log");Ƃ΁Alog/20060401_1.log ɏo
		///		(default : "")
		/// </example>
		/// <param name="path">otH_ʒu</param>
		public YanesdkResult SetPath(string path) 
		{
            return logWriter.SetPath(path);
		}

		/// <summary>
		///	[async]	1seLXgo͂
		/// </summary>
		/// <remarks>
		///		ۂɂ͑ɏ݂͍sȂB
		///		textbufɂ߂AʃXbht@Cɏ܂B
		/// </remarks>
		/// <param name="logtext">o͂eLXg</param>
		public YanesdkResult Write(string logtext)
		{
            StringBuilder sb = new StringBuilder(GetTimeString());
            sb.Append(" ").Append(logtext);
            String msgStr = sb.ToString();
            if (PRINT_CONSORL)
            {
                Console.WriteLine(msgStr);
            }
            return logWriter.Write(msgStr);
        }

		/// <summary>
		///		IB
		/// </summary>
		public void Dispose()
		{
            logWriter.Dispose();
		}

		#endregion

		#region vpeB
		/// <summary>
		/// 1t@C̍őTCYBdefault = 1MB = 1024*1024
		/// </summary>
		public long FileMaxSize
		{
			get { return logWriter.FileMaxSize; }
            set { logWriter.FileMaxSize = value; }
		}

		/// <summary>
		///		t@C̃GR[hw肵܂B
		/// </summary>
		/// <remarks>
		///		ۂ̃t@C̏(Write)sOɎw肵ĂB
		/// </remarks>
		public global::System.Text.Encoding CodePage
		{
			get { return logWriter.CodePage; }
            set { logWriter.CodePage = value; }
		}

        /// <summary>
        /// tH[}bgij̎w
        /// ftHg"hh:mm:ss"
        /// </summary>
        public String format
        {
            get { return formatStr; }
            set { formatStr = value; }
        }

        #endregion

        /// <summary>
        /// w肳ꂽꂽݓ̕擾
        /// </summary>
        /// <returns></returns>
        private String GetTimeString()
        {
            return DateTime.Now.ToString(formatStr);
        }

    }
}
