using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;
using Yanesdk.Ytl;
using Yanesdk.Sound;
using Yamalib.Util;
using Yanesdk.System;
using Yamalib.Yanesdkext.Draw;
using Yamalib.Model;
using System.Diagnostics;
using Yamalib.Scenario;

namespace Yamalib.Scenario.YaneScript
{

    /// <summary>
    /// ViIr[
    /// ITexturenł̎ł邱Ƃ𒍈ӂ邱
    /// </summary>
    public class YaneScenarioView : IScnarioView
    {
        #region 萔l
        private static readonly int SHADOW_TEXT_OFFSET_X = 2;
        private static readonly int SHADOW_TEXT_OFFSET_Y = 1;
        #endregion


        /// <summary>
        /// `̂ƂɎRɐݒł悤ɂ
        /// </summary>
        /// <param name="screen"></param>
        /// <returns></returns>
        public delegate YanesdkResult PostPaintExcec(IScreen screen, YaneScenarioView view);

        #region otB[h

        private IScenarioModel scenarioModel;
        private int offsetx = 0;
        private int offsety = 0;
        private int textOffsetx = 0;
        private int textOffsety = 0;

        private PostPaintExcec postPaintBG;
        private PostPaintExcec postPaintCharacter;
        private PostPaintExcec postPaintText;

        #endregion


        public IScenarioModel Model
        {
            get { return scenarioModel; }
            set { scenarioModel = value; }
        }

        public PostPaintExcec PostPaintBG
        {
            get { return postPaintBG; }
            set { postPaintBG = value; }
        }

        public PostPaintExcec PostPaintCharacter
        {
            get { return postPaintCharacter; }
            set { postPaintCharacter = value; }
        }

        public PostPaintExcec PostPaintText
        {
            get { return postPaintText; }
            set { postPaintText = value; }
        }

        public virtual YanesdkResult OnPaint(IScreen screen)
        {
            OnPaintBG(screen);
            if (null != PostPaintBG)
            {
                PostPaintBG(screen, this);
            }
            OnPaintCharacter(screen);
            if (null != PostPaintCharacter)
            {
                PostPaintCharacter(screen, this);
            }
            OnPaintText(screen);
            if (null != PostPaintText)
            {
                PostPaintText(screen, this);
            }

            //: TODO:
            return YanesdkResult.NoError;
        }

        public void SetViewOffsetXY(int ox, int oy)
        {
            offsetx = ox;
            offsety = oy;
        }

        public void GetViewOffsetXY(out int ox, out int oy)
        {
            ox = offsetx;
            oy = offsety;
        }

        public void SetTextOffsetXY(int ox, int oy)
        {
            textOffsetx = ox;
            textOffsety = oy;
        }

        public void GetTextOffsetXY(out int ox, out int oy)
        {
            ox = textOffsetx;
            oy = textOffsety;
        }


        #region J\bh

        /// <summary>
        /// eLXg摜̕`
        /// </summary>
        /// <param name="screen"></param>
        /// <returns></returns>
        protected YanesdkResult OnPaintText(IScreen screen)
        {
            YaneScenarioModel theModel = Model as YaneScenarioModel;
            if (theModel.IsBackLogMode)
            {
                return PaintDrawLetterBackLog(screen, theModel.BakLogletterData);
            }
            return PaintDrawLetter(screen, Model.LetterData);
        }

        /// <summary>
        /// ̕`
        /// </summary>
        /// <param name="screen"></param>
        /// <param name="drawCharaData"></param>
        /// <returns></returns>
        protected YanesdkResult PaintDrawLetter(IScreen screen, List<ILetterDeta> drawCharaData)
        {
            for (int i = 0; i < Model.ShowTextCount && i < drawCharaData.Count; ++i)
            {
                // e̕`
                screen.SetColor(YanesdkUtil.BLOCK_COLOR);
                // {e
                PaintShadowDrawLetter(screen, drawCharaData[i]);
                // {̕`
                PaintDrawLetter(screen, drawCharaData[i]);

                // re̕`
                screen.SetColor(YanesdkUtil.BLOCK_COLOR);
                List<ILetterDeta> rubi = drawCharaData[i].RubiChara;
                foreach (ScenarioParser.DrawLetter dc in rubi)
                {
                    PaintShadowDrawLetter(screen, dc);
                }

                // r̕`
                screen.SetColor(YanesdkUtil.WHITE_COLOR);
                foreach (ScenarioParser.DrawLetter dc in rubi)
                {
                    PaintDrawLetter(screen, dc);
                }
            }

            return YanesdkResult.NoError;
        }

        /// <summary>
        /// ̕`
        /// </summary>
        /// <param name="screen"></param>
        /// <param name="drawCharaData"></param>
        /// <returns></returns>
        protected YanesdkResult PaintDrawLetterBackLog(IScreen screen, List<ILetterDeta> drawCharaData)
        {
            for (int i = 0; i < drawCharaData.Count; ++i)
            {
                // e̕`
                screen.SetColor(YanesdkUtil.BLOCK_COLOR);
                // {e
                PaintShadowDrawLetter(screen, drawCharaData[i]);
                // {̕`
                PaintDrawLetter(screen, drawCharaData[i]);

                // re̕`
                screen.SetColor(YanesdkUtil.BLOCK_COLOR);
                List<ILetterDeta> rubi = drawCharaData[i].RubiChara;
                foreach (ScenarioParser.DrawLetter dc in rubi)
                {
                    PaintShadowDrawLetter(screen, dc);
                }

                // r̕`
                screen.SetColor(YanesdkUtil.WHITE_COLOR);
                foreach (ScenarioParser.DrawLetter dc in rubi)
                {
                    PaintDrawLetter(screen, dc);
                }
            }

            return YanesdkResult.NoError;
        }

        /// <summary>
        /// Ŏw肵DrawCharf[^`悵܂
        /// </summary>
        /// <param name="screen">`Screen</param>
        /// <param name="drawChar">`f[^NX</param>
        /// <returns></returns>
        private YanesdkResult PaintDrawLetter(IScreen screen, ILetterDeta drawChar)
        {
            screen.SetColor(drawChar.Color);
            return PaintDrawLetter(screen, drawChar,
                    (int)drawChar.Pos.X,
                    (int)drawChar.Pos.Y);
        }

        /// <summary>
        /// Ŏw肵DrawCharf[^eƂĕ`悷B
        /// `ʒu̓ItZbgʒu炵̂ɂȂB
        /// </summary>
        /// <param name="screen"></param>
        /// <param name="drawChar"></param>
        /// <returns></returns>
        private YanesdkResult PaintShadowDrawLetter(IScreen screen, ILetterDeta drawChar)
        {
            screen.SetColor(YanesdkUtil.BLOCK_COLOR);
            return PaintDrawLetter(screen, drawChar,
                    (int)drawChar.Pos.X + SHADOW_TEXT_OFFSET_X,
                    (int)drawChar.Pos.Y + SHADOW_TEXT_OFFSET_Y);
        }

        /// <summary>
        /// Ŏw肵DrawChar Ɏw肳ꂽsize
        /// Ŏw肳ꂽx,yɕ`悷
        /// </summary>
        /// <param name="screen">`Screen</param>
        /// <param name="drawChar">`f[^NX</param>
        /// <param name="X">`ʒu</param>
        /// <param name="Y">`ʒu</param>
        /// <returns></returns>
        private YanesdkResult PaintDrawLetter(IScreen screen, ILetterDeta drawChar, int x, int y)
        {
            if (0.0f >= drawChar.Size)
            {
                return YanesdkResult.InvalidParameter;
            }
            if (1.0f != drawChar.Size || 0 != drawChar.Angle)
            {
                int basePos = 0 != drawChar.Angle ? 6 : 0;
                screen.BltRotate(
                    drawChar.ImgObj as ITexture,	// eNX` 
                    textOffsetx + offsetx + x,
                    textOffsety + offsety + y, 	// X,Y ʒu
                    drawChar.Angle, 	// ]p
                    drawChar.Size, 		// g嗦
                    basePos			// `x[Xʒuij
                    );
            }
            else
            {
                screen.Blt(drawChar.ImgObj as ITexture, textOffsetx + offsetx + x, textOffsety + offsety + y);
            }

            return YanesdkResult.NoError;
        }

        /// <summary>
        /// wi`悷
        /// </summary>
        /// <param name="screen"></param>
        /// <returns></returns>
        protected YanesdkResult OnPaintBG(IScreen screen)
        {
            if (null == Model.BgImgMgr)
            {
                // wigpȂOK
                return YanesdkResult.NoError;
            }
            ITexture surfaceTexture = Model.BgImgMgr.GetTexture();
            ITexture backTexture = Model.BgImgMgr.GetEffectOutTexture();
            int effectNo = Model.BgImgMgr.EffectNo;
            int effectPhase = Model.BgImgMgr.EffectPhase;

            if (null != backTexture)
            {
                screen.Blt(backTexture, 0, 0);
            }

            if (null != surfaceTexture)
            {
                if (effectNo >= 0 && TransBltter.PAHSE_MAX != effectPhase)
                {
                    TransBltter.Blt(effectNo, screen, surfaceTexture, offsetx, offsety, effectPhase);
                }
                else
                {
                    screen.Blt(surfaceTexture, 0, 0);
                }
            }

            return YanesdkResult.NoError;
        }


        /// <summary>
        /// LN^[`悷
        /// </summary>
        /// <param name="screen"></param>
        /// <returns></returns>
        protected YanesdkResult OnPaintCharacter(IScreen screen)
        {
            if (null == Model.CharacterImgMgr)
            {
                // LN^[gpȂ̂OK
                return YanesdkResult.NoError;
            }
            YaneCharacterManager characterMgr = Model.CharacterImgMgr as YaneCharacterManager;
            if (null == characterMgr)
            {
                return YanesdkResult.PreconditionError;
            }

            Character[] characters = characterMgr.CharacterContainer;
            foreach (Character chara in characters)
            {
                chara.OnPaint(screen, true);
            }

            //`FbN
            for (int i = 0; i < characters.Length; i++)
            {
                for (int j = 0; j < characters.Length; j++)
                {
                    if (i == j || characters[i].GetCharId() == null)
                    {
                        continue;
                    }
                    Debug.Assert(characters[i].GetCharId() != characters[j].GetCharId(), "LN^[IDd:" + characters[i].GetCharId());
                }
            }


            return YanesdkResult.NoError;
        }

        #endregion

    }

    /// <summary>
    /// ViIf񋟂
    /// </summary>
    public class YaneScenarioModel : IScenarioModel, IDisposable
    {

        #region 萔ltB[h

        private static readonly List<ILetterDeta> NULL_LETTER_DATA = new List<ILetterDeta>();

        #endregion

        #region otB[h

        private IScenarioState scenarioState;
        /// <summary>
        /// ViIp[T
        /// ŗL̃NXȂ̂ŁAC^[tF[X邱
        /// </summary>
        private ScenarioParser scenarioParser;
        private ICommandHandlerFactory commandFactory;
        private ICharacterImageManager characterImgMgr;
        private IBgImageManager bgImgMgr;
        private IBgmResourceManager bgmManager;
        private ISeResourceManager seManager;
        private IVoiceResourceManager voiceManager;
        private List<ILetterDeta> letterData;
        private List<ILetterDeta> bakLogletterData;
        private MouseInputHandler mouseInputHandler;
        private KeyInputHandler keyInputHandler;
        protected readonly List<ICommandHandler> currentPageTags = new List<ICommandHandler>();
        private readonly List<IViewLayler> viewLayers = new List<IViewLayler>();
        private int readSpeed = 1;
        private int backLogDepth = 0;
        private bool backLogMode = false;

        private readonly RootCounterS textPhaseCounter = new RootCounterS(0, int.MaxValue, 1);
        private bool autoRead = false;
        private bool enableReadStop = true;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public YaneScenarioModel()
        {
            scenarioState = new YaneScenarioState();
        }

        /// <summary>
        /// \[X̔js
        /// </summary>
        public void Dispose()
        {
            YamalibUtility.Dispose(characterImgMgr);
            YamalibUtility.Dispose(bgImgMgr);
            YamalibUtility.Dispose(seManager);
            YamalibUtility.Dispose(voiceManager);
        }

        /// <summary>
        /// ViIXNvgł̃R}hnht@Ng̐ݒE擾
        /// </summary>
        public ICommandHandlerFactory CommandFactory
        {
            get { return commandFactory; }
            set { commandFactory = value; }
        }

        /// <summary>
        /// ViIɂ}EX̓nhݒ
        /// </summary>
        public MouseInputHandler MouseInputHandler
        {
            get { return mouseInputHandler; }
            set { mouseInputHandler = value; }
        }

        /// <summary>
        /// ViIɂL[̓nhݒ
        /// </summary>
        public KeyInputHandler KeyInputHandler
        {
            get { return keyInputHandler; }
            set { keyInputHandler = value; }
        }

        /// <summary>
        /// ViȈ
        /// </summary>
        public IScenarioState ScenarioState
        {
            get { return scenarioState; }
            set { scenarioState = value; }
        }

        /// <summary>
        /// ǂݎpBǂݎ~܂蒆ǂ
        /// </summary>
        public bool IsReadStop
        {
            get { return scenarioState.ReadStopFlg; }
        }

        /// <summary>
        /// GtFNgɂҋ@
        /// </summary>
        public bool IsEffectWait
        {
            get { return false; }
        }

        /// <summary>
        /// ݂̃ViIׂĊ
        /// </summary>
        public bool IsScenarioFinish
        {
            get { return scenarioState.ScenarioEndFlg; }
        }

        /// <summary>
        /// y[W\ׂĊ
        /// </summary>
        public bool IsPageEnd
        {
            get { return scenarioState.PageEndFlg; }
        }

        /// <summary>
        /// ǂ݂ɂ邩
        /// </summary>
        public bool IsAutoRead
        {
            get { return autoRead; }
            set { autoRead = value; }
        }

        /// <summary>
        /// obNO\ɂ邩ǂ
        /// </summary>
        public bool IsBackLogMode
        {
            get { return backLogMode; }
            set
            {
                backLogMode = value;
                if (backLogMode)
                {
                    scenarioParser.SetBackLogMode(true);
                    scenarioState.InputLockFlg = true;
                    backLogDepth = 0;

                    // scenarioParser 擾 LetterData ̎QƂĂƃf[^
                    List<ILetterDeta> tmpLetterData = new List<ILetterDeta>();
                    for (int i = 0; i < letterData.Count; i++)
                    {
                        tmpLetterData.Add(letterData[i].Clone());
                    }
                    letterData = tmpLetterData;

                    PrevBackLog();
                }
                else
                {
                    scenarioParser.SetBackLogMode(false);
                    scenarioState.InputLockFlg = false;
                }
            }
        }

        /// <summary>
        /// ÕobNO
        /// </summary>
        public void PrevBackLog()
        {
            if (IsBackLogMode)
            {
                UpdateTextBackPrev();
            }
        }

        /// <summary>
        /// ̃obNO
        /// </summary>
        public void NextBackLog()
        {
            if (IsBackLogMode)
            {
                UpdateTextBackNext();
            }
        }


        /// <summary>
        /// y[WReadStopR}hLǂ
        /// </summary>
        public bool IsEnableReadStop
        {
            get { return enableReadStop; }
            set { enableReadStop = value; }
        }

        /// <summary>
        /// \̐̕
        /// </summary>
        public int ShowTextCount
        {

            get { return textPhaseCounter.Value(); }
        }

        /// <summary>
        /// XgAp
        /// </summary>
        /// <param name="count"></param>
        /// <returns></returns>
        public void SetShowTextCountForRestore(int count)
        {
            if (count > textPhaseCounter.EndValue)
            {
                textPhaseCounter.Set(textPhaseCounter.EndValue, textPhaseCounter.EndValue, textPhaseCounter.StepValue);
            }
            else
            {
                textPhaseCounter.Set(count, textPhaseCounter.EndValue, textPhaseCounter.StepValue);
            }

            for (int i = 0; i < currentPageTags.Count; i++)
            {
                if (currentPageTags[i].ExecPosition <= textPhaseCounter.StartValue)
                {
                    // ÎƂāAR}h
                    currentPageTags[i] = NullCommandHandler.Instance;
                }
            }

        }

        /// <summary>
        /// ̃y[WɊ܂܂Ă镶̐
        /// </summary>
        public int PageTextCount
        {
            get { return textPhaseCounter.EndValue; }
        }

        /// <summary>
        /// LN^[C[W}l[W擾
        /// </summary>
        public ICharacterImageManager CharacterImgMgr
        {
            set { characterImgMgr = value; }
            get { return characterImgMgr; }
        }

        /// <summary>
        /// wiC[W}l[W擾
        /// </summary>
        public IBgImageManager BgImgMgr
        {
            set { bgImgMgr = value; }
            get { return bgImgMgr; }
        }

        /// <summary>
        /// BGM}l[W擾
        /// </summary>
        public IBgmResourceManager BgmMgr
        {
            set { bgmManager = value; }
            get { return bgmManager; }
        }

        /// <summary>
        /// SE}l[W擾
        /// </summary>
        public ISeResourceManager SeMgr
        {
            set { seManager = value; }
            get { return seManager; }
        }

        /// <summary>
        /// {CX}l[W擾
        /// </summary>
        public IVoiceResourceManager VoiceMgr
        {
            set { voiceManager = value; }
            get { return voiceManager; }
        }

        /// <summary>
        /// \x擾Eݒ肷
        /// </summary>
        public int ReadSpeed
        {
            get { return readSpeed; }
            set { readSpeed = value; }
        }

        /// <summary>
        /// ViIXNvgp[T[̎擾
        /// </summary>
        public ScenarioParser ScenarioParser
        {
            get { return scenarioParser; }
            set { scenarioParser = value; }
        }

        /// <summary>
        /// eLXgf[^̎擾
        /// </summary>
        public List<ILetterDeta> LetterData
        {
            get
            {
                if (null == letterData)
                {
                    // null`FbNƂ߂ǂ
                    return NULL_LETTER_DATA;
                }
                return letterData;
            }
        }

        /// <summary>
        /// obNOp̃eLXgf[^̎擾
        /// </summary>
        public List<ILetterDeta> BakLogletterData
        {
            get
            {
                if (null == bakLogletterData)
                {
                    // null`FbNƂ߂ǂ
                    return NULL_LETTER_DATA;
                }
                return bakLogletterData;
            }
        }

        /// <summary>
        /// C[
        /// </summary>
        public List<IViewLayler> ViewLayler
        {
            get { return viewLayers; }
            set { throw new Exception(YanesdkResult.NotImplemented.ToString()); }
        }

        /// <summary>
        /// ړ
        /// </summary>
        /// <param name="screen"></param>
        /// <returns></returns>
        public virtual YanesdkResult OnMove(IScreen screen)
        {
            // eLXgE߂
            OnMoveTextPhaseCouner();

            if (mouseInputHandler != null)
            {
                mouseInputHandler.OnHandle(this);
            }

            if (KeyInputHandler != null)
            {
                keyInputHandler.OnHandle(this);
            }

            if (null != characterImgMgr)
            {
                // LN^[
                Character[] characters = ((YaneCharacterManager)characterImgMgr).CharacterContainer;
                foreach (Character chara in characters)
                {
                    chara.OnMove(screen);
                }
            }

            // C[
            foreach (IViewLayler layer in viewLayers)
            {
                layer.OnMove(screen);
            }

            if (null != bgImgMgr)
            {
                // wi
                bgImgMgr.OnMove(screen);
            }

            if (null != seManager)
            {
                seManager.Update();
            }

            return YanesdkResult.NoError;
        }


        /// <summary>
        /// ǂݑ
        /// </summary>
        /// <returns></returns>
        public YanesdkResult ContinueRead()
        {
            if (null == letterData)
            {
                UpdateText();
            }

            if (IsPageEnd)
            {
                UpdateText();
            }
            else if (IsNextReadable())
            {
                scenarioState.ReadStopFlg = false;
            }

            return YanesdkResult.NoError;
        }

        /// <summary>
        /// ǂ݂𒆒f
        /// </summary>
        /// <returns></returns>
        public YanesdkResult StopRead()
        {
            return YanesdkResult.NoError;
        }

        #region J\bh

        /// <summary>
        /// ǂݑ邱ƂłԂ
        /// </summary>
        /// <returns></returns>
        private bool IsNextReadable()
        {
            if (scenarioState.ReadSkipFlg)
            {
                return true;
            }
            return !IsEffectWait && IsReadStop;
        }

        /// <summary>
        /// ^OID擾
        /// </summary>
        /// <param name="rawCommand"></param>
        /// <returns></returns>
        private static String GetTagId(String rawCommand)
        {
            CSVReader reader = new CSVReader();
            reader.Read(YanesdkUtil.FILE_READ_ON_MEMORY_FLG + rawCommand);
            if (null != reader.CsvData && reader.CsvData.Count != 0 && reader.CsvData[0].Count != 0)
            {
                //Console.WriteLine("FOUND TAG:{0}", reader.CsvData[0][0]);
                return reader.CsvData[0][0];
            }
            Console.Write("UNKOWN TAG:{0}", rawCommand);
            return null;
        }

        /// <summary>
        /// ̃y[WɈڍs
        /// </summary>
        protected virtual void UpdateText()
        {
            scenarioParser.UpdateText();
            letterData = scenarioParser.DrawCharacterData;
            textPhaseCounter.Set(0, letterData.Count, 1);
            UnknownTagToCommand(scenarioParser.UnknownTags);
            if (scenarioParser.IsParseFinish)
            {
                scenarioState.ScenarioEndFlg = true;
            }
            else
            {
                ScenarioState.ReadStopFlg = false;
                ScenarioState.PageEndFlg = false;
            }
        }

        protected virtual void UpdateTextBackPrev()
        {
            if (scenarioParser.UpdateTextBack())
            {
                ++backLogDepth;
                bakLogletterData = scenarioParser.BackLogDrawCharacter;
            }
        }

        protected virtual void UpdateTextBackNext()
        {
            if (backLogDepth > 1 && scenarioParser.UpdateText())
            {
                --backLogDepth;
                bakLogletterData = scenarioParser.BackLogDrawCharacter;
            }
        }

        /// <summary>
        /// eLXgi߂
        /// </summary>
        private void OnMoveTextPhaseCouner()
        {
            if (!scenarioState.ReadStopFlg)
            {
                int roopCounter = textPhaseCounter.EndValue < ReadSpeed ? textPhaseCounter.EndValue : ReadSpeed;
                for (int i = 0; i < roopCounter; i++)
                {
                    textPhaseCounter.Inc();
                    // i߂đ݂^Os
                    DoCommandHanlder();
                    if (IsAutoRead)
                    {
                        scenarioState.ReadStopFlg = false;
                    }
                    else if (!IsEnableReadStop && !IsPageEnd)
                    {
                        scenarioState.ReadStopFlg = false;
                    }
                    if (scenarioState.ReadStopFlg)
                    {
                        break;
                    }
                }
            }
            else
            {
                // eLXg͐i߂ȂƂĂAnh͓ĂȂ
                DoCommandHanlder();
            }

            if (textPhaseCounter.IsEnd)
            {
                scenarioState.PageEndFlg = true;
                if (scenarioState.ReadSkipFlg || IsAutoRead)
                {
                    // XLbvȂ玩Iɐi
                    ContinueRead();
                }
            }
        }

        /// <summary>
        /// o^ĂR}hnhׂċN
        /// </summary>
        private void DoCommandHanlder()
        {
            foreach (ICommandHandler handler in currentPageTags)
            {
                YanesdkResult result = handler.DoCommand(this);
                if (result != YanesdkResult.NoError)
                {
                    PrintDebug(result, "TagHandler");
                }
            }
        }

        /// <summary>
        /// ^Onh𐶐ێ
        /// </summary>
        /// <param name="tagInfos"></param>
        private void UnknownTagToCommand(List<ScenarioParser.UnknownTagInfo> tagInfos)
        {
            currentPageTags.Clear();
            foreach (ScenarioParser.UnknownTagInfo tag in tagInfos)
            {
                String tagId = GetTagId(tag.Tag);
                if (null != tagId)
                {
                    ICommandHandler handler = commandFactory.Create(tagId.ToLower());
                    handler.SetCommand(tag.Tag);
                    handler.ExecPosition = tag.Pos;
                    currentPageTags.Add(handler);
                }
            }
        }

        private static void PrintDebug(YanesdkResult result, String addMsg)
        {
            Console.WriteLine("Error {0} : result code = {1}", addMsg, result);
        }

        #endregion

    }


    /// <summary>
    /// ViȈԂ\f[^NX
    /// </summary>
    public class YaneScenarioState : IScenarioState
    {
        #region otB[h
        private bool readstopFlg;
        private bool pageEndFlg;
        private bool scenarioEndFlg;
        private bool jumpAnotherSceneFlg;
        private bool characterEffectWait;
        private bool bgEffectWait;
        private bool inputLock;
        private bool readSkipFlg;

        #endregion

        public bool ReadStopFlg
        {
            get { return readstopFlg; }
            set { readstopFlg = value; }
        }

        public bool PageEndFlg
        {
            get { return pageEndFlg; }
            set { pageEndFlg = value; }
        }

        public bool ScenarioEndFlg
        {
            get { return scenarioEndFlg; }
            set { scenarioEndFlg = value; }

        }

        public bool JumpAnotherSceneFlg
        {
            get { return jumpAnotherSceneFlg; }
            set { jumpAnotherSceneFlg = value; }
        }

        public bool CharacterEffectWaitFlg
        {
            get
            {
                return characterEffectWait;
            }
            set
            {
                characterEffectWait = value;
            }
        }

        public bool BgEffectWaitFlg
        {
            get
            {
                return bgEffectWait;
            }
            set { bgEffectWait = value; }
        }

        #region IScenarioState o

        /// <summary>
        /// CvbgbNtO
        /// </summary>
        public bool InputLockFlg
        {
            get
            {
                return inputLock;
            }
            set
            {
                inputLock = value;
            }
        }

        #endregion

        #region IScenarioState o


        public bool ReadSkipFlg
        {
            get
            {
                return readSkipFlg;
            }
            set
            {
                readSkipFlg = value;
            }
        }

        #endregion
    }

    /// <summary>
    /// wi̊Ǘ
    /// </summary>
    public class YaneBgImageManager : IBgImageManager
    {
        #region 萔l
        public static readonly int INVALID_BG_NO = -1;

        #endregion

        #region otB[h

        private bool disableDraw = true;
        private readonly TextureLoader textureLoader;
        private int oldBgImgNo = INVALID_BG_NO;
        private int bgImgNo = INVALID_BG_NO;
        private readonly RootCounterS effectPhaseCounter = new RootCounterS();
        private int effectType;
        private int posx;
        private int posy;
        private float drawSize = 1.0f;
        private Color4ub color = YanesdkUtil.WHITE_COLOR;
        #endregion


        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="loader"></param>
        public YaneBgImageManager(TextureLoader loader)
        {
            this.textureLoader = loader;
            effectPhaseCounter.Set(TransBltter.PAHSE_MAX, TransBltter.PAHSE_MAX, 0);
        }


        /// <summary>
        /// `悷邩ǂ
        /// `Ԃ͓ŕێ
        /// </summary>
        public bool DrawDisable
        {
            get { return disableDraw; }
            set { disableDraw = value; }
        }

        /// <summary>
        /// ̃\[X͕\
        /// </summary>
        public bool IsShowing
        {
            get { return bgImgNo != INVALID_BG_NO; }
        }

        /// <summary>
        /// GtFNg
        /// </summary>
        public bool IsEffecting
        {
            get
            {
                if (IsShowing)
                {
                    return !effectPhaseCounter.IsEnd;
                }
                return false;
            }
        }

        public void SetEffect(int effectNo, int start, int end, int speed)
        {
            this.effectType = effectNo;
            effectPhaseCounter.Set(start, end, speed);
        }

        public int EffectNo
        {
            get { return this.effectType; }
        }

        public int EffectPhase
        {
            get { return effectPhaseCounter.Value(); }
        }

        public int X
        {
            set { posx = value; }
            get { return posx; }
        }
        public int Y
        {
            set { posy = value; }
            get { return posy; }
        }

        public float Size
        {
            set { drawSize = value; }
            get { return drawSize; }
        }

        public Color4ub Color
        {
            set { color = value; }
            get { return color; }
        }

        /// <summary>
        /// GtFNgAEgĂC[Wԍ
        /// </summary>
        public int EffectOutBgImgNo
        {
            get { return oldBgImgNo; }
        }

        public int BgImgNo
        {
            set
            {
                oldBgImgNo = bgImgNo;
                bgImgNo = value;
            }
            get
            {
                return bgImgNo;
            }
        }

        /// <summary>
        /// eNX`̎擾
        /// </summary>
        /// <returns></returns>
        public ITexture GetTexture()
        {
            if (!IsShowing)
            {
                return null;
            }
            return textureLoader.GetTexture(bgImgNo);
        }

        /// <summary>
        /// GtFNgAEgĂeNX`̎擾
        /// </summary>
        /// <returns></returns>
        public ITexture GetEffectOutTexture()
        {
            if (EffectOutBgImgNo == INVALID_BG_NO)
            {
                return null;
            }
            return textureLoader.GetTexture(EffectOutBgImgNo);
        }

        /// <summary>
        /// \[X̊ǗlɈڍs
        /// </summary>
        /// <param name="screen"></param>
        /// <returns></returns>
        public YanesdkResult OnMove(IScreen screen)
        {
            if (IsShowing)
            {
                effectPhaseCounter.Inc();
            }
            return YanesdkResult.NoError;
        }

    }

    /// <summary>
    /// \LN^[̊Ǘ
    /// </summary>
    public class YaneCharacterManager : ICharacterImageManager, IDisposable
    {
        #region otB[h

        private bool drawDisable = false;
        private List<ICharacterImageResource> charaImgs = new List<ICharacterImageResource>();
        private Character[] character;
        private TextureLoader characterImgTextureLoader;

        #endregion

        public bool DrawDisable
        {
            get { return drawDisable; }
            set { drawDisable = value; }
        }

        /// <summary>
        /// RXgN^
        /// </summary>
        public YaneCharacterManager(TextureLoader charaTl, String charaMapDefFile, int maxCharacterContainer)
        {
            character = new Character[maxCharacterContainer];
            Character.SetCharMap(charaMapDefFile);
            for (int i = 0; i < character.Length; ++i)
            {
                character[i] = new Character();
                character[i].SetTextureLoader(charaTl);
            }

            CharacterImgTextureLoader = charaTl;
        }

        public TextureLoader CharacterImgTextureLoader
        {
            get { return characterImgTextureLoader; }
            set
            {
                for (int i = 0; i < character.Length; ++i)
                {
                    character[i].SetTextureLoader(value);
                }
                characterImgTextureLoader = value;
            }
        }


        /// <summary>
        /// \[X̔js
        /// </summary>
        public void Dispose()
        {
            foreach (Character chara in character)
            {
                YamalibUtility.Dispose(chara);
            }
        }

        /// <summary>
        /// LN^[Rei̎擾
        /// </summary>
        public Character[] CharacterContainer
        {
            get { return character; }
        }

        /// <summary>
        /// LN^[C[W̎擾
        /// </summary>
        /// <param name="no"></param>
        /// <returns></returns>
        public ICharacterImageResource GetCharacterImage(int no)
        {
            if (charaImgs.Count <= no)
            {
                return null;
            }
            return charaImgs[no];
        }

        public ICharacterImageResource GetNewCharacterImage(string id)
        {
            Character targetCharacter = GetUnuseCharacter() as Character;
            if (null == targetCharacter)
            {
                return null;
            }
            targetCharacter.Reset();
            targetCharacter.SetCharId(id);
            return targetCharacter;
        }

        /// <summary>
        /// LN^[̃L[IDLN^[NX擾
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public ICharacterImageResource GetCharacterImage(String id)
        {
            return GetCharacterCurrent(id);
        }

        /// <summary>
        /// LN^[̃C[W̎擾
        /// </summary>
        /// <param name="no"></param>
        /// <returns></returns>
        public IImageResource GetImage(int no)
        {
            return GetCharacterImage(no);
        }

        #region J\bh

        /// <summary>
        /// Reiid΂ԋp
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        private ICharacterImageResource GetCharacterCurrent(String id)
        {
            if (null == id)
            {
                return null;
            }
            foreach (Character chara in character)
            {
                if (id == chara.GetCharId())
                {
                    return chara;
                }
            }
            return null;
        }

        /// <summary>
        /// ReiŎgpĂȂLN^[擾
        /// </summary>
        /// <returns></returns>
        private ICharacterImageResource GetUnuseCharacter()
        {
            foreach (Character chara in character)
            {
                if (!chara.IsShowing)
                {
                    return chara;
                }
            }
            /// SgĂBtF[hAEgĂLN^[Ԃ...
            foreach (Character chara in character)
            {
                if (chara.IsEffectOut() && !chara.ReplaceFlg)
                {
                    chara.Reset();
                    return chara;
                }
            }

            Debug.Assert(false, "CharacterContainerɋ󂫂Ȃ");
            return null;
        }

        #endregion

    }

    /// <summary>
    /// TEh̊Ǘ
    /// </summary>
    public class YaneSoundResourceManager : ISoundResourceManager, IDisposable
    {
        #region otB[h
        private SoundLoader soundLoader;
        private bool disableSound = false;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="SoundLoader"></param>
        public YaneSoundResourceManager(SoundLoader soundLoader)
        {
            Debug.Assert(soundLoader != null);
            this.soundLoader = soundLoader;
        }

        /// <summary>
        /// \[X̔js
        /// </summary>
        public void Dispose()
        {
            YamalibUtility.Dispose(SoundLoader);
        }

        /// <summary>
        /// TEh[_[̐ݒ
        /// </summary>
        public SoundLoader SoundLoader
        {
            get { return soundLoader; }
            set { soundLoader = value; }
        }

        /// <summary>
        /// TEhĐ邩ǂ
        /// ĐԂɂĂ͓ŕێ
        /// </summary>
        public virtual bool SoundDisable
        {
            get { return disableSound; }
            set
            {
                disableSound = value;
            }
        }

        /// <summary>
        /// ̃f[^擾
        /// </summary>
        /// <param name="no"></param>
        /// <returns></returns>
        public Sound GetSound(int no)
        {
            return SoundLoader.GetSound(no);
        }

    }

    /// <summary>
    /// BGMǗ
    /// </summary>
    public class YaneBgmManager : YaneSoundResourceManager, IBgmResourceManager
    {
        #region 萔l

        public static readonly int INVALIDE_BGM_NO = -1;

        #endregion

        #region otB[h

        private int oldPlayBgmNo = INVALIDE_BGM_NO;
        private int playBgmNo = INVALIDE_BGM_NO;
        private float playBgmVolume = 0;
        private float masterVolume = 1.0f;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="SoundLoader"></param>
        public YaneBgmManager(SoundLoader soundLoader)
            : base(soundLoader)
        {
        }

        /// <summary>
        /// }X^[{[̐ݒ
        /// </summary>
        public float MasterVolume
        {
            get { return masterVolume; }
            set
            {
                masterVolume = value;
                PlayBgmVolume = PlayBgmVolume;
            }
        }

        public override bool SoundDisable
        {
            get
            {
                return base.SoundDisable;
            }
            set
            {
                if (SoundDisable != value)
                {
                    if (value)
                    {
                        // Vɖɂ
                        if (INVALIDE_BGM_NO != playBgmNo)
                        {
                            SoundLoader.StopBGM();
                        }
                    }
                    else
                    {
                        // VɗLɂ
                        if (INVALIDE_BGM_NO != playBgmNo)
                        {
                            SoundLoader.PlayBGM(playBgmNo);
                        }
                    }
                    base.SoundDisable = value;
                }
            }
        }

        /// <summary>
        /// ĐĂBGMԍ
        /// </summary>
        public int PlayBgmNo
        {
            get { return playBgmNo; }
            set { playBgmNo = value; }
        }

        /// <summary>
        ///  {[
        /// </summary>
        public float PlayBgmVolume
        {
            get { return playBgmVolume; }
            set
            {
                if (IsPalying)
                {
                    SetVolume(playBgmNo, GetAdjustVolume(value));
                }
            }
        }

        /// <summary>
        /// BGMĐĂ邩
        /// AtF[h~ĂƌȂ
        /// </summary>
        public bool IsPalying
        {
            get { return playBgmNo != INVALIDE_BGM_NO; }
        }

        /// <summary>
        /// Đ
        /// </summary>
        /// <param name="playNo"></param>
        /// <param name="volume"></param>
        /// <returns></returns>
        public YanesdkResult PlayBgm(int playNo, float volume)
        {
            YanesdkResult result = SetVolume(playNo, GetAdjustVolume(volume));
            if (YanesdkResult.NoError != result)
            {
                playBgmVolume = 0;
                return YanesdkResult.InvalidParameter;
            }
            playBgmVolume = volume;
            result = SetLoopInfinity(playNo);
            if (YanesdkResult.NoError != result)
            {
                return YanesdkResult.InvalidParameter;
            }
            if (SoundDisable)
            {
                result = YanesdkResult.NoError;
            }
            else
            {
                result = SoundLoader.PlayBGM(playNo);
            }

            CheckPlayResult(result, playNo);
            return result;
        }

        /// <summary>
        /// Đ
        /// </summary>
        /// <param name="playNo"></param>
        /// <param name="volume"></param>
        /// <param name="fadeTime"></param>
        /// <returns></returns>
        public YanesdkResult PlayBgmFade(int playNo, float volume, int fadeTime)
        {
            YanesdkResult result = SetVolume(playNo, GetAdjustVolume(volume));
            if (YanesdkResult.NoError != result)
            {
                return YanesdkResult.InvalidParameter;
            }
            playBgmVolume = volume;
            result = SetLoopInfinity(playNo);
            if (YanesdkResult.NoError != result)
            {
                return YanesdkResult.InvalidParameter;
            }

            if (SoundDisable)
            {
                result = YanesdkResult.NoError;
            }
            else
            {
                if (PlayBgmNo != INVALIDE_BGM_NO)
                {
                    // NXtF[h
                    result = SoundLoader.PlayBGMCrossFade(playNo, fadeTime);
                }
                else
                {
                    result = SoundLoader.PlayBGMFade(playNo, fadeTime);
                }
            }

            CheckPlayResult(result, playNo);
            return result;
        }

        /// <summary>
        /// ~
        /// </summary>
        /// <returns></returns>
        public YanesdkResult StopBgm()
        {
            if (PlayBgmNo == INVALIDE_BGM_NO)
            {
                return YanesdkResult.NoError;
            }
            playBgmNo = INVALIDE_BGM_NO;
            return SoundLoader.StopBGM();
        }

        /// <summary>
        /// tF[h~
        /// </summary>
        /// <param name="fadeTime"></param>
        /// <returns></returns>
        public YanesdkResult StopBgmFade(int fadeTime)
        {
            if (PlayBgmNo == INVALIDE_BGM_NO)
            {
                return YanesdkResult.NoError;
            }
            playBgmNo = INVALIDE_BGM_NO;
            return SoundLoader.StopBGMFade(fadeTime);
        }

        /// <summary>
        /// Đpv̌ʂ`FbNAĂ΍ĐBGMԍXgA
        /// </summary>
        /// <param name="result"></param>
        private void CheckPlayResult(YanesdkResult result, int playNo)
        {
            // TODO: CuŐIłG[AĂ(Lt`)
            if (YanesdkResult.NoError == result || true)
            {
                OldBgmNo = PlayBgmNo;
                PlayBgmNo = playNo;
            }
        }

        /// <summary>
        ///@~v̌ʂ`FbNA~ꂽȔԍXgA
        /// </summary>
        /// <param name="result"></param>
        private void CheckStopResult(YanesdkResult result)
        {
            // TODO: CuŐIłG[AĂ(Lt`)
            if (YanesdkResult.NoError == result)
            {
                OldBgmNo = PlayBgmNo;
                PlayBgmNo = INVALIDE_BGM_NO;
            }
            else
            {
                // sƂƂ...Ƃ肠~܂ĂƂ݂Ȃق
                OldBgmNo = PlayBgmNo;
                PlayBgmNo = INVALIDE_BGM_NO;
            }
        }

        /// <summary>
        /// }X^[{[Œʂ擾
        /// </summary>
        /// <param name="volume"></param>
        /// <returns></returns>
        private float GetAdjustVolume(float volume)
        {
            return volume * masterVolume;
        }

        /// <summary>
        /// [vɐݒ肷
        /// </summary>
        /// <param name="playNo"></param>
        /// <returns></returns>
        private YanesdkResult SetLoopInfinity(int playNo)
        {
            Sound sound = SoundLoader.GetSound(playNo);
            if (null == sound)
            {
                return YanesdkResult.InvalidParameter;
            }
            sound.Loop = -1;
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// {[ݒ肷
        /// </summary>
        /// <param name="playNo"></param>
        /// <param name="volume"></param>
        /// <returns></returns>
        private YanesdkResult SetVolume(int playNo, float volume)
        {
            Sound sound = SoundLoader.GetSound(playNo);
            if (null == sound)
            {
                return YanesdkResult.InvalidParameter;
            }
            sound.Volume = volume;
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// 
        /// </summary>
        private int OldBgmNo
        {
            get { return oldPlayBgmNo; }
            set { oldPlayBgmNo = value; }
        }
    }

    /// <summary>
    /// SEǗ
    /// </summary>
    public class YaneSeManager : YaneSoundResourceManager, ISeResourceManager
    {
        #region 萔l
        public static readonly int INVALID_SE_NO = -1;

        #endregion

        #region otB[h
        private List<int> playSeNo = new List<int>();
        private readonly List<int> playSeList = new List<int>();
        private float masterVolume = 1.0f;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="SoundLoader"></param>
        public YaneSeManager(SoundLoader soundLoader)
            : base(soundLoader)
        {
        }

        public float MasterVolume
        {
            get { return masterVolume; }
            set { masterVolume = value; }
        }

        public YanesdkResult StopAll()
        {
            foreach (int seNo in playSeNo)
            {
                StopSe(seNo);
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// {CXtO
        /// </summary>
        public override bool SoundDisable
        {
            get
            {
                return base.SoundDisable;
            }
            set
            {
                if (SoundDisable != value)
                {
                    if (value)
                    {
                        foreach (int no in playSeNo)
                        {
                            // Vɖɂ
                            if (INVALID_SE_NO != no)
                            {

                                SoundLoader.Stop(no);
                            }
                        }
                    }
                    else
                    {
                        foreach (int no in playSeNo)
                        {
                            // VɗLɂ
                            if (INVALID_SE_NO != no)
                            {
                                SoundLoader.Play(no);
                            }
                        }
                    }
                    base.SoundDisable = value;
                }
            }
        }

        /// <summary>
        /// SE̍Đ󋵂XV
        /// </summary>
        public void Update()
        {
            SoundLoader.UpdateSE();

            playSeList.Clear();
            // ĐĂSẼ`FbN
            // TODO ́Ase_stop ߂lȂƂȂ
            foreach (int no in playSeNo)
            {
                if (SoundLoader.GetSound(no).IsPlaying())
                {
                    playSeList.Add(no);
                }
            }
            playSeNo = playSeList;
        }

        /// <summary>
        /// ĐĂSE擾
        /// UpdateɍXV
        /// </summary>
        /// <returns>ĐĂSE̔ԍ̔z</returns>
        public int[] GetPlayingSeNo()
        {
            return playSeList.ToArray();
        }

        /// <summary>
        /// ʉĐ
        /// </summary>
        /// <param name="playNo"></param>
        /// <param name="volume"></param>
        /// <param name="loopTime"></param>
        /// <returns></returns>
        public YanesdkResult PlaySe(int playNo, float volume, int loopTime)
        {
            YanesdkResult result = SetLoopTime(playNo, loopTime);
            if (YanesdkResult.NoError != result)
            {
                return result;
            }
            result = SetVolume(playNo, GetAdjustVolume(volume));
            if (YanesdkResult.NoError != result)
            {
                return result;
            }

            // ĐɃ_učĐƂĂA
            // Ǘ͋ȔԍȂ̂ŁAǂ̃`NŖĂ邩͔coȂ
            if (!playSeNo.Contains(playNo))
            {
                playSeNo.Add(playNo);
            }

            if (SoundDisable)
            {
                return YanesdkResult.NoError;
            }
            else
            {
                return SoundLoader.PlaySE(playNo);
            }

        }

        /// <summary>
        /// ʉ̍Đ
        /// </summary>
        /// <param name="playNo"></param>
        /// <param name="volume"></param>
        /// <param name="fadeTime"></param>
        /// <returns></returns>
        public YanesdkResult PlaySeFade(int playNo, float volume, int fadeTime, int loopTime)
        {
            if (playSeNo.Contains(playNo))
            {
                //̃t[ňx
                return YanesdkResult.NoError;
            }
            YanesdkResult result = SetLoopTime(playNo, loopTime);
            if (YanesdkResult.NoError != result)
            {
                return result;
            }
            result = SetVolume(playNo, GetAdjustVolume(volume));
            if (YanesdkResult.NoError != result)
            {
                return result;
            }

            // ĐɃ_učĐƂĂA
            // Ǘ͋ȔԍȂ̂ŁAǂ̃`NŖĂ邩͔coȂ
            if (!playSeNo.Contains(playNo))
            {
                playSeNo.Add(playNo);
            }

            if (SoundDisable)
            {
                return YanesdkResult.NoError;
            }
            else
            {
                return SoundLoader.PlaySE(playNo);
            }

        }

        /// <summary>
        /// ʉ̒~
        /// </summary>
        /// <param name="playNo"></param>
        /// <returns></returns>
        public YanesdkResult StopSe(int playNo)
        {
            return SoundLoader.Stop(playNo);
        }

        /// <summary>
        /// ʉ̃tF[h~
        /// </summary>
        /// <param name="playNo"></param>
        /// <param name="fadeTime"></param>
        /// <returns></returns>
        public YanesdkResult StopSeFade(int playNo, int fadeTime)
        {
            return SoundLoader.StopFade(playNo, fadeTime);
        }

        /// <summary>
        /// }X^[{[Œʂ擾
        /// </summary>
        /// <param name="volume"></param>
        /// <returns></returns>
        private float GetAdjustVolume(float volume)
        {
            return volume * masterVolume;
        }

        /// <summary>
        /// {[̐ݒij
        /// </summary>
        /// <param name="playNo"></param>
        /// <param name="voluem"></param>
        /// <returns></returns>
        private YanesdkResult SetVolume(int playNo, float volume)
        {
            Sound sound = SoundLoader.GetSound(playNo);
            if (null == sound)
            {
                return YanesdkResult.InvalidParameter;
            }

            sound.Volume = volume;

            return YanesdkResult.NoError;
        }

        /// <summary>
        /// JԂ
        /// </summary>
        /// <param name="playNo"></param>
        /// <param name="loopTime"></param>
        /// <returns></returns>
        private YanesdkResult SetLoopTime(int playNo, int loopTime)
        {
            Sound sound = SoundLoader.GetSound(playNo);
            if (null == sound)
            {
                return YanesdkResult.InvalidParameter;
            }
            sound.Loop = loopTime;
            return YanesdkResult.NoError;
        }
    }

    /// <summary>
    /// {CXǗ
    /// </summary>
    public class YaneVoiceManager : YaneSoundResourceManager, IVoiceResourceManager
    {
        #region 萔l
        public static readonly int INVALIDE_VOICE_NO = -1;

        #endregion
        #region otB[h
        private int oldPlayVoiceNo = INVALIDE_VOICE_NO;
        private int playVoiceNo = INVALIDE_VOICE_NO;
        private float volume;
        private int[] sequenceVoiceNo;
        private int sequenceVoiceIndex;
        private float masterVolume = 1.0f;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="SoundLoader"></param>
        public YaneVoiceManager(SoundLoader soundLoader)
            : base(soundLoader)
        {
        }

        /// <summary>
        /// As
        /// </summary>
        public void Update()
        {
            if (sequenceVoiceNo != null && sequenceVoiceNo.Length > sequenceVoiceIndex)
            {
                // ĐI
                if (!SoundLoader.GetSound(sequenceVoiceNo[sequenceVoiceIndex]).IsPlaying())
                {
                    // 
                    if (sequenceVoiceIndex + 1 < sequenceVoiceNo.Length)
                    {
                        ++sequenceVoiceIndex;
                        PlayVoice(sequenceVoiceNo[sequenceVoiceIndex], volume);
                    }
                    else
                    {
                        // A
                        sequenceVoiceNo = null;
                        sequenceVoiceIndex = 0;
                    }
                }
            }
        }

        /// <summary>
        /// }X^[{[̐ݒ
        /// ݒ̎̍ĐKp
        /// </summary>
        public float MasterVolume
        {
            get { return masterVolume; }
            set
            {
                masterVolume = value;
            }
        }

        /// <summary>
        /// ĐĂBGMԍ
        /// </summary>
        public int PlayVoiceNo
        {
            get { return playVoiceNo; }
            set { playVoiceNo = value; }
        }

        /// <summary>
        /// {CXtO
        /// </summary>
        public override bool SoundDisable
        {
            get
            {
                return base.SoundDisable;
            }
            set
            {
                if (SoundDisable != value)
                {
                    if (value)
                    {
                        // Vɖɂ
                        if (INVALIDE_VOICE_NO != playVoiceNo)
                        {
                            SoundLoader.Stop(playVoiceNo);
                        }
                    }
                    else
                    {
                        // VɗLɂ
                        if (INVALIDE_VOICE_NO != playVoiceNo)
                        {
                            SoundLoader.Play(playVoiceNo);
                        }
                    }
                    base.SoundDisable = value;
                }
            }
        }

        /// <summary>
        /// BGMĐĂ邩
        /// AtF[h~ĂƌȂ
        /// </summary>
        public bool IsPalying
        {
            get { return playVoiceNo != INVALIDE_VOICE_NO && SoundLoader.IsPlaying(playVoiceNo); }
        }

        /// <summary>
        /// A{CXĐ
        /// </summary>
        /// <param name="playNo"></param>
        /// <param name="volume"></param>
        /// <returns></returns>
        public YanesdkResult PlayVoice(int[] playNo, float volume)
        {
            SetSequencePlay(playNo, volume);
            if (playNo.Length == 0)
            {
                return YanesdkResult.NoError;
            }

            return PlayVoice(playNo[sequenceVoiceIndex], volume);
        }

        /// <summary>
        /// A{CXĐAŏ̃{CXtF[hCōĐ
        /// </summary>
        /// <param name="playNo"></param>
        /// <param name="volume"></param>
        /// <param name="fadeTime"></param>
        /// <returns></returns>
        public YanesdkResult PlayVoiceFade(int[] playNo, float volume, int fadeTime)
        {
            SetSequencePlay(playNo, volume);
            if (playNo.Length == 0)
            {
                return YanesdkResult.NoError;
            }
            return PlayVoiceFade(playNo[sequenceVoiceIndex], volume, fadeTime);
        }

        /// <summary>
        /// Đ
        /// </summary>
        /// <param name="playNo"></param>
        /// <param name="volume"></param>
        /// <returns></returns>
        public YanesdkResult PlayVoice(int playNo, float volume)
        {
            YanesdkResult result;
            if (SoundDisable)
            {
                result = YanesdkResult.NoError;
            }
            else
            {
                result = SoundLoader.Play(playNo);
            }

            SetVolume(playNo, volume);
            CheckPlayResult(result, playNo);
            return result;
        }

        /// <summary>
        /// Đ
        /// </summary>
        /// <param name="playNo"></param>
        /// <param name="volume"></param>
        /// <param name="fadeTime"></param>
        /// <returns></returns>
        public YanesdkResult PlayVoiceFade(int playNo, float volume, int fadeTime)
        {
            YanesdkResult result;

            if (SoundDisable)
            {
                result = YanesdkResult.NoError;
            }
            else
            {
                if (PlayVoiceNo != INVALIDE_VOICE_NO)
                {
                    // NXtF[h
                    result = SoundLoader.PlayFade(playNo, fadeTime);
                }
                else
                {
                    result = SoundLoader.PlayFade(playNo, fadeTime);
                }
            }

            SetVolume(playNo, volume);
            CheckPlayResult(result, playNo);
            return result;
        }

        /// <summary>
        /// ~
        /// </summary>
        /// <returns></returns>
        public YanesdkResult StopVoice()
        {
            if (PlayVoiceNo == INVALIDE_VOICE_NO)
            {
                return YanesdkResult.NoError;
            }

            YanesdkResult result = SoundLoader.Stop(PlayVoiceNo);
            PlayVoiceNo = INVALIDE_VOICE_NO;
            return result;
        }

        /// <summary>
        /// tF[h~
        /// </summary>
        /// <param name="fadeTime"></param>
        /// <returns></returns>
        public YanesdkResult StopVoiceFade(int fadeTime)
        {
            if (PlayVoiceNo == INVALIDE_VOICE_NO)
            {
                return YanesdkResult.NoError;
            }

            YanesdkResult result = SoundLoader.StopFade(PlayVoiceNo, fadeTime);
            PlayVoiceNo = INVALIDE_VOICE_NO;
            return result;
        }

        /// <summary>
        /// Đpv̌ʂ`FbNAĂ΍ĐBGMԍXgA
        /// </summary>
        /// <param name="result"></param>
        private void CheckPlayResult(YanesdkResult result, int playNo)
        {
            if (YanesdkResult.NoError == result || true)
            {
                OldVoiceNo = PlayVoiceNo;
                PlayVoiceNo = playNo;
            }
        }

        /// <summary>
        ///@~v̌ʂ`FbNA~ꂽȔԍXgA
        /// </summary>
        /// <param name="result"></param>
        private void CheckStopResult(YanesdkResult result)
        {
            if (YanesdkResult.NoError == result)
            {
                OldVoiceNo = PlayVoiceNo;
                PlayVoiceNo = INVALIDE_VOICE_NO;
            }
            else
            {
                // sƂƂ...Ƃ肠~܂ĂƂ݂Ȃق
                OldVoiceNo = PlayVoiceNo;
                PlayVoiceNo = INVALIDE_VOICE_NO;
            }
        }

        /// <summary>
        /// AĐݒ
        /// </summary>
        /// <param name="playNo"></param>
        /// <param name="volume"></param>
        /// <returns></returns>
        private YanesdkResult SetSequencePlay(int[] playNo, float volume)
        {
            if (volume < 0 || playNo == null)
            {
                return YanesdkResult.InvalidParameter;
            }
            sequenceVoiceNo = playNo;
            this.volume = volume;
            sequenceVoiceIndex = 0;
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// }X^[{[Œʂ擾
        /// </summary>
        /// <param name="volume"></param>
        /// <returns></returns>
        private float GetAdjustVolume(float volume)
        {
            return volume * masterVolume;
        }

        /// <summary>
        /// {[ݒ肷
        /// </summary>
        /// <param name="playNo"></param>
        /// <param name="volume"></param>
        /// <returns></returns>
        private YanesdkResult SetVolume(int playNo, float volume)
        {
            Sound sound = SoundLoader.GetSound(playNo);
            if (null == sound)
            {
                return YanesdkResult.InvalidParameter;
            }
            sound.Volume = GetAdjustVolume(volume);
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// 
        /// </summary>
        private int OldVoiceNo
        {
            get { return oldPlayVoiceNo; }
            set { oldPlayVoiceNo = value; }
        }


    }



}
