using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Ytl;
using Yanesdk.Draw;
using Yamalib.Util;
using Yanesdk.Sound;
using Yanesdk.Input;
using System.Collections;
using Yamalib.Input;

namespace Yamalib.Scenario
{

    /// <summary>
    /// ViIp[T
    /// </summary>
    public interface IScenarioParser
    {
    }


    /// <summary>
    /// r[񋟂
    /// </summary>
    public interface IScnarioView
    {
        IScenarioModel Model
        {
            get;
            set;
        }

        /// <summary>
        /// ItZbgʒu̐ݒ
        /// </summary>
        /// <param name="ox"></param>
        /// <param name="oy"></param>
        void SetViewOffsetXY(int ox, int oy);

        /// <summary>
        /// ItZbgʒu̎擾
        /// </summary>
        /// <param name="ox"></param>
        /// <param name="oy"></param>
        void GetViewOffsetXY(out int ox, out int oy);

        void SetTextOffsetXY(int ox, int oy);
        void GetTextOffsetXY(out int ox, out int oy);

        YanesdkResult OnPaint(IScreen screen);

    }

    /// <summary>
    /// C[
    /// </summary>
    public interface IViewLayler
    {
        int Priority
        {
            get;
            set;
        }

        /// <summary>
        /// C[^Cv̐ݒ
        /// ꂼꂾAwĩC[ƂgbṽC[Ƃ
        /// wɎgƂ
        /// </summary>
        int LaylerType
        {
            get;
            set;
        }

        /// <summary>
        /// 쏈
        /// </summary>
        /// <param name="screen"></param>
        /// <returns></returns>
        YanesdkResult OnMove(IScreen screen);

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        /// <returns></returns>
        YanesdkResult OnPaint(IScreen screen);
    }

    /// <summary>
    /// ViIf񋟂
    /// </summary>
    public interface IScenarioModel
    {
        YanesdkResult OnMove(IScreen screen);

        IScenarioState ScenarioState
        {
            get;
            set;
        }

        bool IsReadStop
        {
            get;
        }
        bool IsEffectWait
        {
            get;
        }
        bool IsScenarioFinish
        {
            get;
        }

        bool IsPageEnd
        {
            get;
        }

        int ShowTextCount
        {
            get;
        }

        int PageTextCount
        {
            get;
        }

        ICharacterImageManager CharacterImgMgr
        {
            set;
            get;
        }

        IBgImageManager BgImgMgr
        {
            set;
            get;
        }

        IBgmResourceManager BgmMgr
        {
            set;
            get;
        }

        ISeResourceManager SeMgr
        {
            set;
            get;
        }

        IVoiceResourceManager VoiceMgr
        {
            set;
            get;
        }


        ICommandHandlerFactory CommandFactory
        {
            get;
            set;
        }

        MouseInputHandler MouseInputHandler
        {
            get;
            set;
        }


        int ReadSpeed
        {
            get;
            set;
        }

        List<ILetterDeta> LetterData
        {
            get;
        }

        /// <summary>
        /// ͏ۏႳĂ邱ƁII
        /// </summary>
        List<IViewLayler> ViewLayler
        {
            get;
            set;
        }

        /// <summary>
        /// ǂݑ
        /// </summary>
        /// <returns></returns>
        YanesdkResult ContinueRead();

        /// <summary>
        /// ǂ݂𒆒f
        /// </summary>
        /// <returns></returns>
        YanesdkResult StopRead();


    }

    /// <summary>
    /// ViIfŁAԂ񋟂
    /// </summary>
    public interface IScenarioState
    {
        bool ReadStopFlg
        {
            get;
            set;
        }

        bool PageEndFlg
        {
            get;
            set;
        }

        bool ScenarioEndFlg
        {
            get;
            set;
        }

        bool JumpAnotherSceneFlg
        {
            get;
            set;
        }

        bool CharacterEffectWaitFlg
        {
            get;
            set;
        }

        bool BgEffectWaitFlg
        {
            get;
            set;
        }

        bool InputLockFlg
        {
            get;
            set;
        }

        bool ReadSkipFlg
        {
            get;
            set;
        }

    }

    /// <summary>
    /// C[W摜ǗNX
    /// </summary>
    public interface IImageResourceManager
    {
        /// <summary>
        /// `悷邩ǂ
        /// `Ԃ͓ŕێ
        /// </summary>
        bool DrawDisable
        {
            get;
            set;
        }
    }

    public interface ICharacterImageManager : IImageResourceManager
    {
        /// <summary>
        /// w肵nõLN^[Rei擾
        /// </summary>
        /// <param name="no"></param>
        /// <returns></returns>
        ICharacterImageResource GetCharacterImage(int no);
        /// <summary>
        /// w肵LN^ID̃\[X݂΂ԋpB
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        ICharacterImageResource GetCharacterImage(String id);

        /// <summary>
        /// VLN^[\[X擾
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        ICharacterImageResource GetNewCharacterImage(String id);
    }

    public interface IBgImageManager : IImageResourceManager
    {


        /// <summary>
        /// ̃\[X͕\
        /// </summary>
        bool IsShowing
        {
            get;
        }

        /// <summary>
        /// GtFNg
        /// </summary>
        bool IsEffecting
        {
            get;
        }

        void SetEffect(int effectNo, int start, int end, int speed);

        int EffectNo
        {
            get;
        }

        int EffectPhase
        {
            get;
        }

        int X
        {
            set;
            get;
        }
        int Y
        {
            set;
            get;
        }

        float Size
        {
            set;
            get;
        }

        Color4ub Color
        {
            set;
            get;
        }

        /// <summary>
        /// GtFNgAEgĂC[Wԍ
        /// </summary>
        int EffectOutBgImgNo
        {
            get;
        }

        int BgImgNo
        {
            set;
            get;
        }

        ITexture GetTexture();

        ITexture GetEffectOutTexture();

        /// <summary>
        /// \[X̊ǗlɈڍs
        /// </summary>
        /// <param name="screen"></param>
        /// <returns></returns>
        YanesdkResult OnMove(IScreen screen);

    }

    /// <summary>
    /// C[W\[X\NX
    /// </summary>
    public interface IImageResource
    {
        /// <summary>
        /// ̃\[X͕\
        /// </summary>
        bool IsShowing
        {
            get;
        }

        /// <summary>
        /// GtFNg
        /// </summary>
        bool IsEffecting
        {
            get;
        }

        void SetEffect(int effectNo, int start, int end, int speed);

        int EffectNo
        {
            get;
        }

        int EffectPhase
        {
            get;
        }

        int X
        {
            set;
            get;
        }
        int Y
        {
            set;
            get;
        }

        float Size
        {
            set;
            get;
        }

        Color4ub Color
        {
            set;
            get;
        }

        ITexture GetTexture();

        /// <summary>
        /// \[X̊ǗlɈڍs
        /// </summary>
        /// <param name="screen"></param>
        /// <returns></returns>
        YanesdkResult OnMove(IScreen screen);
    }

    /// <summary>
    /// LN^[ɓ
    /// </summary>
    public interface ICharacterImageResource : IImageResource
    {
    }

    /// <summary>
    /// Bgɓ
    /// </summary>
    public interface IBgImageResource : IImageResource
    {
    }

    /// <summary>
    /// ̕`敶\f[^NX
    /// </summary>
    public interface ILetterDeta
    {
        //ITexture Texture
        //{
        //    Get;
        //    set;
        //}

        /// <summary>
        /// 摜f[^ׂ͂ɉŎ悤ƎR
        /// </summary>
        Object ImgObj
        {
            get;
            set;
        }

        float ImgObjWidth
        {
            get;
        }

        float ImgObjHeight
        {
            get;
        }

        float Size
        {
            get;
            set;
        }

        /// <summary>
        /// ]p
        /// 0 - 512
        /// </summary>
        int Angle
        {
            get;
            set;
        }

        Color4ub Color
        {
            get;
            set;
        }

        List<ILetterDeta> RubiChara
        {
            get;
            set;
        }

        char Letter
        {
            get;
            set;
        }

        Position Pos
        {
            get;
            set;
        }

        ILetterDeta Clone();

    }



    /// <summary>
    /// \[XǗNX
    /// </summary>
    public interface ISoundResourceManager
    {
        /// <summary>
        /// TEhĐ邩ǂ
        /// ĐԂɂĂ͓ŕێ
        /// </summary>
        bool SoundDisable
        {
            get;
            set;
        }

        Sound GetSound(int no);
    }

    /// <summary>
    /// BGMǗ
    /// BGM͂PȂĐȂ
    /// </summary>
    public interface IBgmResourceManager : ISoundResourceManager
    {
        float MasterVolume
        {
            get;
            set;
        }

        bool IsPalying
        {
            get;
        }
        int PlayBgmNo
        {
            get;
        }
        float PlayBgmVolume
        {
            get;
        }
        YanesdkResult PlayBgm(int playNo, float volume);
        YanesdkResult PlayBgmFade(int playNo, float volume, int fadeTime);
        YanesdkResult StopBgm();
        YanesdkResult StopBgmFade(int fadeTime);
    }

    /// <summary>
    /// ʉǗ
    /// ɕĐ
    /// </summary>
    public interface ISeResourceManager : ISoundResourceManager
    {
        /// <summary>
        /// }X^[{[̐ݒ擾
        /// </summary>
        float MasterVolume
        {
            get;
            set;
        }

        /// <summary>
        /// ĐĂSE擾
        /// </summary>
        /// <returns>ĐĂSE̔ԍ̔z</returns>
        int[] GetPlayingSeNo();

        YanesdkResult StopAll();

        YanesdkResult PlaySe(int playNo, float volume, int loopTime);
        YanesdkResult PlaySeFade(int playNo, float volume, int fadeTime, int loopTime);
        YanesdkResult StopSe(int playNo);
        YanesdkResult StopSeFade(int playNo, int fadeTime);

        /// <summary>
        /// ĐĂʉ̍Đ񐔂𒲍A
        /// ׂSEɊւĂ͂܂тB
        /// t[ɂPOOvꂽƂĂ100SE炷̂͂
        /// ̋@\邱
        /// </summary>
        void Update();
    }

    /// <summary>
    /// {CXĐǗ
    /// ́AA\
    /// Ƃ΁A{CXPA{CXQA{CXRAčĐꍇA
    /// AŎw肵Ă΁AI㐏̃{CXĐĂ
    /// AĐ̓T|[gȂ
    /// </summary>
    public interface IVoiceResourceManager : ISoundResourceManager
    {
        /// <summary>
        /// }X^[{[̐ݒ擾
        /// </summary>
        float MasterVolume
        {
            get;
            set;
        }

        bool IsPalying
        {
            get;
        }
        int PlayVoiceNo
        {
            get;
        }
        YanesdkResult PlayVoice(int[] playNo, float volume);
        YanesdkResult PlayVoiceFade(int[] playNo, float volume, int fadeTime);

        YanesdkResult PlayVoiceFade(int playNo, float volume, int fadeTime);
        YanesdkResult PlayVoice(int playNo, float volume);

        YanesdkResult StopVoice();
        YanesdkResult StopVoiceFade(int fadeTime);

        void Update();
    }

    /*
        /// <summary>
        /// \[X\NX
        /// </summary>
        public interface ISoundResource
        {
            bool IsPalying
            {
                Get;
            }

        }

        /// <summary>
        /// SEɓ
        /// </summary>
        public interface ISeResource : ISoundResource
        {
            YanesdkResult PlaySe(int volume);
            YanesdkResult PalySeFade(int volume, int fadeTime);
            YanesdkResult StopSe(int volume);
            YanesdkResult StopSeFade(int fadeTime);
        }

        /// <summary>
        /// {CXɓ
        /// </summary>
        public interface IVoiceResource : ISoundResource
        {
            YanesdkResult PlayVoice(int volume);
            YanesdkResult PalyVoiceFade(int volume, int fadeTime);
            YanesdkResult StopVoice();
            YanesdkResult StopVoiceFade(int fadeTime);
        }
    */

    public delegate YanesdkResult CommandProcessor(ICommandHandler own, IScenarioModel model);

    public enum CommandState
    {
        UN_EXECUTION,
        EXECUTING,
        DONE
    };

    /// <summary>
    /// XNvgŉ炩́AR}hAߕێf[^NX
    /// </summary>
    public interface ICommandHandler
    {

        YanesdkResult SetCommand(String command);

        CommandState State
        {
            get;
        }

        /// <summary>
        /// s|Cg̎w
        /// </summary>
        int ExecPosition
        {
            set;
            get;
        }

        CommandProcessor CommandProsser
        {
            get;
            set;
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        YanesdkResult DoCommand(IScenarioModel model);
    }

    public delegate ICommandHandler CommandHandlerCreator();
    /// <summary>
    /// R}hAKnh[𐶐ԋp
    /// </summary>
    public interface ICommandHandlerFactory
    {
        void SetFactories(Dictionary<String, CommandHandlerCreator> factories);
        Dictionary<String, CommandHandlerCreator> GetFactories();
        ICommandHandler Create(String commandId);
    }

    /// <summary>
    /// ȂR}hnh
    /// </summary>
    public class NullCommandHandler : ICommandHandler
    {
        private static NullCommandHandler instance;

        private static YanesdkResult NullCommand(ICommandHandler commandHanler, IScenarioModel model)
        {
            return YanesdkResult.NoError;
        }

        private NullCommandHandler()
        {
        }

        public CommandState State
        {
            get { return CommandState.DONE; }
        }

        public int ExecPosition
        {
            set { }
            get { return 0; }
        }

        public static NullCommandHandler Instance
        {
            get
            {
                if (null == instance)
                {
                    instance = new NullCommandHandler();
                }
                return instance;
            }
        }

        public YanesdkResult SetCommand(String command)
        {
            return YanesdkResult.NoError;
        }

        public CommandProcessor CommandProsser
        {
            get { return NullCommand; }
            set { }
        }

        public YanesdkResult DoCommand(IScenarioModel model)
        {
            return YanesdkResult.NoError;
        }
    }


    public delegate YanesdkResult InputHandler(IScenarioModel model);

    /// <summary>
    /// }EX̏Ԃ\
    /// </summary>
    public struct MouseState
    {
        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="bt">{^̎</param>
        /// <param name="upFlg">
        /// グǂBꂪ false Ȃ牟Ă
        /// </param>
        public MouseState(MouseInput.Button bt, bool upFlg)
        {
            this.button = bt;
            this.up = upFlg;
        }
        public MouseInput.Button button;
        public bool up;
    }

    /// <summary>
    /// }EX͂nhO
    /// </summary>
    public class MouseInputHandler
    {
        #region otB[h
        private readonly Dictionary<MouseState, InputHandler> handlers = new Dictionary<MouseState, InputHandler>();
        private IMouseInput mouse;
        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="mouse"></param>
        public MouseInputHandler(IMouseInput mouse)
        {
            this.mouse = mouse;
        }

        /// <summary>
        /// nhǉ
        /// </summary>
        /// <param name="mouseState"></param>
        /// <param name="handler"></param>
        public void SetHandler(MouseState mouseState, InputHandler handler)
        {
            handlers[mouseState] = handler;
        }

        /// <summary>
        /// o^Ănh擾
        /// o^ĂȂnullԋp
        /// </summary>
        /// <param name="mouseState"></param>
        /// <returns></returns>
        public InputHandler GetHandler(MouseState mouseState)
        {
            if (handlers.ContainsKey(mouseState))
            {
                return handlers[mouseState];
            }
            return null;
        }

        /// <summary>
        /// }EX̏ԂnhN
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public YanesdkResult OnHandle(IScenarioModel model)
        {
            foreach (KeyValuePair<MouseState, InputHandler> keyVal in handlers)
            {
                MouseState mouseState = keyVal.Key;
                if (mouseState.up)
                {
                    if (mouse.IsPush(mouseState.button))
                    {
                        keyVal.Value(model);
                    }
                }
                else
                {
                    if (mouse.IsPress(mouseState.button))
                    {
                        keyVal.Value(model);
                    }
                }
            }

            return YanesdkResult.NoError;
        }
    }

    /// <summary>
    /// }EX̏Ԃ\
    /// </summary>
    public struct KeyState
    {
        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="bt">{^̎</param>
        /// <param name="upFlg">
        /// グǂBꂪ false Ȃ牟Ă
        /// </param>
        public KeyState(KeyCode[] keyCodes, bool pushFlg)
        {
            pressKeyCodes = new SortedList<KeyCode, Object>();
            foreach (KeyCode keyCode in keyCodes)
            {
                pressKeyCodes.Add(keyCode, null);
            }
            this.push = pushFlg;
        }

        public readonly SortedList<KeyCode, Object> pressKeyCodes;
        public bool push;
    }

    public class KeyInputHandler
    {
        #region otB[h

        private IKeyInput key;
        private readonly Dictionary<KeyState, InputHandler> handlers = new Dictionary<KeyState, InputHandler>();

        #endregion

        public KeyInputHandler(IKeyInput key)
        {
            this.key = key;
        }

        /// <summary>
        /// nhǉ
        /// </summary>
        /// <param name="mouseState"></param>
        /// <param name="handler"></param>
        public void SetHandler(KeyState keyState, InputHandler handler)
        {
            handlers[keyState] = handler;
        }

        /// <summary>
        /// o^Ănh擾
        /// o^ĂȂnullԋp
        /// </summary>
        /// <param name="mouseState"></param>
        /// <returns></returns>
        public InputHandler GetHandler(KeyState keyState)
        {
            if (handlers.ContainsKey(keyState))
            {
                return handlers[keyState];
            }
            return null;
        }

        /// <summary>
        /// }EX̏ԂnhN
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public YanesdkResult OnHandle(IScenarioModel model)
        {
            foreach (KeyValuePair<KeyState, InputHandler> keyVal in handlers)
            {
                KeyState keyState = keyVal.Key;
                if (keyState.push)
                {
                    bool success = true;
                    foreach (KeyCode keyCode in keyState.pressKeyCodes.Keys)
                    {
                        if (!key.IsPush((int)keyCode))
                        {
                            success = false;
                            break;
                        }
                    }
                    if (success)
                    {
                        // ̃L[ĂƈႤH
                        for (int i = 0; i < key.ButtonNum; i++)
                        {
                            if (key.IsPush(i) && !keyState.pressKeyCodes.ContainsKey((KeyCode)i))
                            {
                                success = false;
                                break;
                            }
                        }
                    }
                    if (success)
                    {
                        keyVal.Value(model);
                    }
                }
                else
                {
                    bool success = true;
                    foreach (KeyCode keyCode in keyState.pressKeyCodes.Keys)
                    {
                        if (!key.IsPress((int)keyCode))
                        {
                            success = false;
                            break;
                        }
                    }
                    if (success)
                    {
                        // ̃L[ĂƈႤH
                        for (int i = 0; i < key.ButtonNum; i++)
                        {
                            if (key.IsPush(i) && !keyState.pressKeyCodes.ContainsKey((KeyCode)i))
                            {
                                success = false;
                                break;
                            }
                        }
                    }
                    if (success)
                    {
                        keyVal.Value(model);
                    }
                }
            }

            return YanesdkResult.NoError;
        }
    }


}
