using System;
using System.Collections.Generic;
using System.Text;
using Yamalib.Input;
using Yanesdk.Input;

namespace Yamalib.Input
{
    class MouseInputAdapter : IMouseInput
    {
        /** }EX{^ƃL[̃}bsO\NX  */
        public class MouseKeyInputMap
        {
            /// }EX|L[}bvZbgi㏑j
            public void Set(MouseInput.Button e, int keyCode)
            {
                keyMap[e] = (int)keyCode;
            }
            /// ݒ肳ꂽL[}bsO擾
            public int GetKeyCode(MouseInput.Button e)
            {
                return (int)keyMap[e];
            }
            /// RXgN^
            public MouseKeyInputMap()
            {
                keyMap[MouseInput.Button.Left] = (int)KeyCode.RETURN;
                keyMap[MouseInput.Button.Middle] = (int)KeyCode.UNKNOWN;
                keyMap[MouseInput.Button.Right] = (int)KeyCode.UNKNOWN;
                keyMap[MouseInput.Button.XButton1] = (int)KeyCode.UP;
                keyMap[MouseInput.Button.XButton2] = (int)KeyCode.DOWN;
            }

            private Dictionary<MouseInput.Button, int> keyMap = new Dictionary<MouseInput.Button, int>();
        }

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="key"></param>
        /// <param name="mapping"></param>
        public MouseInputAdapter(IMouseInput mouse, IKeyInput key, MouseKeyInputMap mapping)
        {
            m_mouse = mouse;
            m_key = key;
            m_mkMapping = mapping;
        }

        private readonly IMouseInput m_mouse;
        private readonly IKeyInput m_key;
        private MouseKeyInputMap m_mkMapping;

        #region IMouseInput o

        public void Show()
        {
            // Ȃ
        }

        public void Hide()
        {
            // Ȃ
        }

        public void GetPos(out int x, out int y)
        {
            m_mouse.GetPos(out x, out y);
        }

        public void SetPos(int x, int y)
        {
            m_mouse.SetPos(x, y);
        }

        public bool IsPress(MouseInput.Button e)
        {
            return m_key.IsPress((int)m_mkMapping.GetKeyCode(e));
        }

        public bool IsPush(MouseInput.Button e)
        {
            return m_key.IsPush((int)m_mkMapping.GetKeyCode(e));
        }

        public bool IsWheelUp
        {
            get
            {
                return m_key.IsPress((int)m_mkMapping.GetKeyCode(MouseInput.Button.XButton1));
            }
        }

        public bool IsWheelDown
        {
            get
            {
                return m_key.IsPress((int)m_mkMapping.GetKeyCode(MouseInput.Button.XButton2));
            }
        }

        public void Update()
        {
            m_mouse.Update();
        }

        public void Reset()
        {
            m_mouse.Reset();
        }

        public void SetLogicalPos(int x, int y)
        {
            m_mouse.SetPos(x, y);
        }

        public void Dispose()
        {
            m_mouse.Dispose();
        }

        #endregion


    }
}
