using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Input;
using Yamalib.Yanesdkext.System;

namespace Yamalib.Input
{
    public interface IMouseInput : IDisposable
    {
        ///	}EXJ[\\
        void Show();

        ///	}EXJ[\\ɂ
        void Hide();

        ///	}EẌʒu擾
        /**
            }EXʊOɂƂ͍ŌɎ擾lԂ܂B
            Ȃ킿AʃTCY640~480Ȃ΁Ax0`639,y0`479܂ł
            lԂȂƂۏ؂܂B
        */
        void GetPos(out int x, out int y);

        ///	}EẌʒuݒ
        /**
            SDL̃}EẌʒuݒCxgB
        */
        void SetPos(int x, int y);

        ///	{^Ă邩𔻒肷֐
        bool IsPress(MouseInput.Button e);
        bool IsPush(MouseInput.Button e);
        bool IsWheelUp { get;}
        bool IsWheelDown { get;}

        /// ԂXV
        void Update();

        /// <summary>
        ///  
        /// </summary>
        void Reset();

        void SetLogicalPos(int x, int y);
    }

    public class MouseInputImpl : MouseInput, IMouseInput
    {
        #region IMouseInput o


        public bool IsWheelUp
        {
            get
            {
                return SDLFrameEx.IsWheelUp;
            }
        }

        public bool IsWheelDown
        {
            get
            {
                return SDLFrameEx.IsWheelDown;
            }
        }

        #endregion
    }

    public class MouseInputNullDevice : IMouseInput
    {
        public void Show() { }
        public void Hide() { }
        public bool IsHide() { return false; }
        public void GetPos(out int x, out int y) { x = 0; y = 0; }
        public void SetPos(int x, int y) { }
        public bool IsPress(MouseInput.Button e) { return false; }
        public bool IsPush(MouseInput.Button e) { return false; }
        public void Reset() { }
        public void SetLogicalPos(int x, int y) { }
        public void Update() { }
        public void Dispose() { }
        public bool IsWheelUp { get { return false; } }
        public bool IsWheelDown { get { return false; } }


        /// NullDevice擾
        public static MouseInputNullDevice GetInstance()
        {
            if (m_instance == null)
            {
                m_instance = new MouseInputNullDevice();
            }
            return m_instance;
        }

        /// ꖇD
        private MouseInputNullDevice()
        {
        }
        private static MouseInputNullDevice m_instance;


    }

    /**
        Cӂ̃^C~OŃfoCXNULLfoCXɐ؂ւdg݂
        ĂMouseInput
    */
    public class NullableMouseInput : IMouseInput
    {
        public void Show() { Get().Show(); }
        public void Hide() { Get().Hide(); }
        public bool IsHide() { return false; }
        public void GetPos(out int x, out int y) { Get().GetPos(out x, out y); }
        public void SetPos(int x, int y) { Get().SetPos(x, y); }
        public void SetLogicalPos(int x, int y) { }
        public void Reset() { }
        public bool IsPress(MouseInput.Button e) { return Get().IsPress(e); }
        public bool IsPush(MouseInput.Button e) { return Get().IsPush(e); }
        public void Update() { Get().Update(); }
        public void Dispose() { GetOriginal().Dispose(); }
        public bool IsWheelUp { get { return Get().IsWheelUp; } }
        public bool IsWheelDown { get { return Get().IsWheelDown; } }

        /// kfoCXɐ؂ւ
        public void Disable()
        {
            m_enable = false;
        }
        /// m[}foCXɐ؂ւ
        public void Enable()
        {
            m_enable = true;
        }
        /// foCXLɂȂĂ邩H
        public bool IsEnable()
        {
            return m_enable;
        }
        /// IWĩfoCX擾
        public IMouseInput GetOriginal()
        {
            return this.m_mouse;
        }
        /// RXgN^
        public NullableMouseInput(IMouseInput mouse)
        {
            m_mouse = mouse;
            m_enable = true;
        }


        private IMouseInput Get()
        {
            return m_enable ? m_mouse : m_nullMouse;
        }

        private static IMouseInput m_nullMouse = MouseInputNullDevice.GetInstance();
        private IMouseInput m_mouse;
        private bool m_enable;
    }


}
