using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;
using Yanesdk.Math;
using Yamalib.Util;

namespace Yamalib.Draw.Effect
{

    /// <summary>
    /// _eLXg\NX
    /// w͈͂𕶎ŖߐsςĂ܂
    /// </summary>
    public class DizzyTextDraw
    {
        #region 萔l

        /// <summary>
        /// pJ^Ji
        /// </summary>
        public readonly string hankana_str = "";

        /// <summary>
        /// L
        /// </summary>
        public readonly string mark_str = ":;<=>?@[]^_!\"#$%&'()*+,-./`{|}";

        /// <summary>
        /// 
        /// </summary>
        public readonly string number_str = "0123456789";

        /// <summary>
        /// At@xbg
        /// </summary>
        public readonly string alphabet_str = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

        #endregion

        #region tB[ho

        private string enable_str;	//!< gp镶ׂĂA

        private readonly List<string> rand_str = new List<string>();	//!< `撆̕z

        private FontRepository fr;	// 
        private Rand rand;
        private Textures tv;	// 󂯎
        private Rect drawrect;		//!< \`

        private RootCounterS alpha;

        private int posx, posy;		//!< `Jnʒu
        private bool blend;
        private bool hankana;
        private bool mark;
        private bool number;	//!< gp镶
        private byte r, g, b;		//!< `F
        private int fwidth, fheight;	//!< tHg̕ƍ
        private int speed;		//!< ύX̃^C~O
        private int flamecounter;	//!< t[JE^

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public DizzyTextDraw()
        {
            // ɂ̐
            fr = new FontRepository(YamalibConst.FONT_REP_TEXTURE_FACTORY);
            fr.Max = 300;		// Ƃ肠 300 炢H

            rand = new Rand();
            rand.Randomize();

            alpha = new RootCounterS();
            alpha.Set(255, 255, 0);	// 

            enable_str += alphabet_str;
            enable_str += number_str;
            enable_str += mark_str;
            enable_str += hankana_str;

            blend = true;

            // gp镶
            hankana = true;
            mark = true;
            number = true;
        }

        public FontRepository FontRepository
        {
            get { return fr; }
            set { fr = value; }
        }

        public bool EnableHankana
        {
            get { return hankana; }
            set { hankana = value; }
        }

        public bool EnableMarkLetter
        {
            get { return mark; }
            set { mark = value; }
        }

        public bool EnableNumberLetter
        {
            get { return number; }
            set { number = value; }
        }

        public bool EnableBlend
        {
            get { return blend; }
            set { blend = value; }
        }

        public void setFadeIn(int step)
        {
            int start = 0;
            if (!alpha.IsEnd)
            {
                start = alpha.Value();
            }
            alpha.Set(start, 255, step);
        }

        public void SetFadeOut(int step)
        {
            int start = 255;
            if (!alpha.IsEnd)
            {
                start = alpha.Value();
            }
            alpha.Set(start, 0, step);
        }

        public bool IsFade()
        {
            return !alpha.IsEnd;
        }

        /// ێt[@傫قǍXV͒x
        public void SetSpeed(int i)
        {
            if (i == 0) i = 1;
            speed = i;
        }

        /// \` nullŉʑS
        public void SetDrawRect(Rect rc)
        {
            if (rc == null)
            {
                drawrect = null;
            }
            else
            {
                drawrect = rc;
            }
        }

        public void SetColor(byte r, byte g, byte b)
        {
            this.r = r; this.g = g; this.b = b;
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        public void OnPaint(IScreen screen)
        {
            int sx, sy;
            alpha++;
            // ȂႻ...
            if (alpha.Value() <= 0) return;

            if (fwidth == 0 || fheight == 0)
            {
                // ϕƍ
                Textures tv = FontRepository.GetTexture(enable_str, 0);
                fwidth = (int)(tv.Width / enable_str.Length);
                fheight = (int)tv.Height;
            }

            if (drawrect != null)
            {
                sx = (int)(drawrect.Width / fwidth);
                sy = (int)(drawrect.Height / fheight);
            }
            else
            {
                sx = screen.Width / fwidth;
                sy = screen.Height / fheight;
                posx = posy = 0;
            }

            int i, j;
            rand_str.Clear();
            // `悷郉_ĕ`悷
            screen.SetColor(73, 79, 179, alpha.Value());
            screen.BlendSrcAlpha();
            if (flamecounter == speed)
            {
                rand_str.Clear();
                for (i = 0; i < sy; ++i)
                {
                    StringBuilder ww = new StringBuilder();
                    for (j = 0; j < sx; ++j)
                    {
                        ww.Append(GetRandChara());
                    }
                    // `
                    tv = fr.GetTexture(ww.ToString(), 0);
                    screen.Blt(tv, posx, posy + i * fheight);

                    rand_str.Add(ww.ToString());
                }
                flamecounter = 0;
            }
            else
            {
                for (i = 0; i < rand_str.Count; ++i)
                {
                    tv = fr.GetTexture(rand_str[i], 0);
                    screen.Blt(tv, posx, posy + i * fheight);
                }

            }
            screen.ResetColor();
            flamecounter++;
        }

        #region Jo

        /// <summary>
        /// ݒꕶԂ
        /// </summary>
        /// <returns></returns>
        private char GetRandChara()
        {
            // ABC:26,123:10,mark:30,ݶ:55
            // 0          36      66
            int charnum = 0, index, last;

            // `ł镶̐
            charnum += alphabet_str.Length;
            if (EnableNumberLetter) charnum += number_str.Length;
            if (EnableMarkLetter) charnum += mark_str.Length;
            if (EnableHankana) charnum += hankana_str.Length;

            index = rand.GetRand(charnum);

            last = alphabet_str.Length;
            if (index > last)
            {
                last += number_str.Length;
                if (EnableNumberLetter)
                {
                    if (index > last)
                    {
                        last += mark_str.Length;
                        if (EnableMarkLetter)
                        {
                            if (index > last)
                            {
                                if (!EnableHankana)
                                {
                                    // error
                                    return ' ';
                                }
                            }
                        }
                        else
                        {
                            index += mark_str.Length;
                        }
                    }
                }
                else
                {
                    index += number_str.Length;
                    last += mark_str.Length;
                    if (EnableMarkLetter)
                    {
                        if (last > index)
                        {
                            if (!EnableHankana)
                            {
                                // error
                                return ' ';
                            }
                        }
                    }
                    else
                    {
                        index += mark_str.Length;
                    }
                }
            }

            return enable_str[index];
        }

        #endregion

    }
}
