using System;
using System.Collections.Generic;
using System.Text;
using Kyojin.Model;
using Yamalib.Util;
using Yanesdk.Draw;
using Yanesdk.System;
using Yamalib;
using System.Diagnostics;
using Yamalib.Yanesdkext.Draw;
using Yamalib.Draw.Effect;

namespace Kyojin.Scene.EyeCatche
{

    /// <summary>
    /// lCp[gŃViIĨACLb`^XN
    /// TeopScenePramɑJڐViIԍw肷邱
    /// </summary>
    class SenarioEndEyeCatcheScene : TaskBase, IDisposable
    {
        #region 萔l

        ///  DEF_FILES Ƃ킹î̂߂̌݊j
        public enum SHI_TYPE : int
        {
            STD = 0,
            TOMIE01,
            ALICE01,
            ANZAI01,
            RUBI01,
            MIDO01,
            YUIRI01,
            AYA01,
        };

        /// `t@CŒ胊Xg
        private static readonly string[] DEF_FILES = new string[]
        {
    	    "img/eye/std/std.lst",
		    "img/eye/tomie/tomie01.lst",
		    "img/eye/alice/alice01.lst",
		    "img/eye/anzai/anzai01.lst",
		    "img/eye/rubi/rubi01.lst",
		    "img/eye/mido/mido01.lst",
		    "img/eye/yuiri/yuiri01.lst",
		    "img/eye/aya/aya01.lst",
	    };

        #endregion

        #region otB[h

        private readonly GameSystem m_gSys;
        private SequenceDrawManager sdm;
        private bool init;
        private ITexture backup;
        private readonly RootCounterS phase = new RootCounterS();

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="gameSystem"></param>
        public SenarioEndEyeCatcheScene(GameSystem gameSystem)
        {
            m_gSys = gameSystem;
        }

        #region IDisposable o

        public void Dispose()
        {
            YamalibUtility.Dispose(sdm);
            YamalibUtility.Dispose(backup);
        }

        #endregion

        public override int Task(object o)
        {
            GameSystem gameSystem = (GameSystem)o;
            if (0 == OnMove(gameSystem))
            {
                return 0;
            }
            gameSystem.OnMoveCommon();
            if (!gameSystem.FpsTimer.ToBeSkip)
            {
                gameSystem.Screen.Select();
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
                gameSystem.Screen.Update();
            }
            else
            {
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
            }
            return 1;
        }

        /// <summary>
        /// 쏈
        /// </summary>
        /// <param name="gameSystem"></param>
        private int OnMove(GameSystem gameSystem)
        {
            if (!init)
            {
                onInit();
                m_gSys.Screen.BlendSrcAlpha();
                backup = m_gSys.EyeCatcheSceneParam.ScreenImg;
                init = true;
            }

            phase++;

            if (phase.IsEnd)
            {
                sdm.OnMove(m_gSys.Screen);

                if (sdm.IsFinish())
                {
                    if (!m_gSys.EyeCatcheSceneParam.JumpTitle)
                    {
                        // ViIʂ
                        JumpScenario();
                        return 0;
                    }
                    else
                    {
                        // ^Cgʂ
                        JumpTitle();
                        return 0;
                    }
                }
            }
            return 1;
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="gameSystem"></param>
        private void OnPaint(GameSystem gameSystem)
        {
            m_gSys.Screen.Clear();

            m_gSys.Screen.SetColor(255, 255, 255, 255);
            TransBltter.Blt(
                22,
                m_gSys.Screen,
                backup,
                0, 0,
                phase.Value()
            );

            if (phase.IsEnd)
            {
                sdm.OnDraw(m_gSys.Screen);
            }
        }

        /// 
        private void onInit()
        {
            sdm = new SequenceDrawManager();

            // RԖڂɂĂ[
            int selNo = 0;

            if (m_gSys.EyeCatcheSceneParam.Pattern < DEF_FILES.Length)
            {
                selNo = m_gSys.EyeCatcheSceneParam.Pattern;
            }

            sdm.LoadDefFile(DEF_FILES[selNo]);
            phase.Set(255, 130, 2);
        }

        /// ViI^XNɑJڂ
        private void JumpScenario()
        {
            //m_gSys.selectedStory = sId;
            //// obNAbvs
            //m_gSys.gameSceneTransiter.setTransitType(GameSceneTransiter.C_NO_EFFECT, 1, true);
            //m_gSys.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Scenario);

            m_gSys.ScenarioSceneParam.IsReadTop = true;
            if (m_gSys.ScenarioSceneParam.ScenarioInfo == null)
            {
                m_gSys.ScenarioSceneParam.ScenarioInfo = new ScenarioInfo();
            }
            m_gSys.ScenarioSceneParam.ScenarioInfo.ScenarioID = m_gSys.EyeCatcheSceneParam.CallScenarioNo;


            // ׂẴX^bNj		
            m_gSys.SceneController.ExitScene();
            m_gSys.SceneController.CallScene(Scenes.Scenario);
        }

        /// ViI^XNɑJڂ
        private void JumpTitle()
        {
            // ׂẴX^bNj		
            m_gSys.SceneController.ExitScene();

            // obNAbvs
            m_gSys.SceneController.CallScene(Scenes.Startmenu);
        }

    }
}
