﻿using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Ytl;
using Yanesdk.GUIParts;
using Yanesdk.Draw;
using Yanesdk.System;
using Kyojin.Model;
using Yanesdk.Sound;
using System.Diagnostics;
using Yamalib.Util;
using Yamalib;
using Kyojin;

namespace Kyojin.Scene.Demo
{
    /// <summary>
    /// スタートメニューのシーン
    /// </summary>
    class LogoScene : TaskBase, IDisposable
    {

        #region 定数値
        private static readonly int START_POS_CX = 211;
        private static readonly int CONTINUE_POS_CX = START_POS_CX;
        private static readonly int OPTION_POS_CX = START_POS_CX;
        private static readonly int EXIT_POS_CX = START_POS_CX;
        #endregion

        private enum PROCESS : int { K2C_LOGO, CAUTION, FADE_OUT };
        private const uint WAIT_TIME = 60;
        private const uint WAIT_TIME_CAUTION = 120;

        private GameSystem m_gSys;
        private bool m_init;
        private ITexture m_imgK2c;
        private ITexture m_imgCaution;
        private RootCounterS m_alpha;
        private uint m_waitCount;
        private PROCESS m_process;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="system">このアプリ共有で使用するGameSystemインスタンス</param>
        public LogoScene(GameSystem gameSystem)
        {
            m_process = PROCESS.K2C_LOGO;
        }

        /// <summary>
        /// リソースの破棄を行う
        /// </summary>
        public void Dispose()
        {
            m_imgCaution.Release();
            m_imgK2c.Release();
            m_alpha = null;
        }

        /// <summary>
        /// タスクの動作
        /// </summary>
        /// <param name="o">ここではGameSystemのインスタンスが渡されることが想定される</param>
        /// <returns>常に１が返却される</returns>
        public override int Task(object o)
        {
            GameSystem gameSystem = (GameSystem)o;
            if (0 == OnMove(gameSystem))
            {
                return 0;
            }
            gameSystem.OnMoveCommon();
            if (!gameSystem.FpsTimer.ToBeSkip)
            {
                gameSystem.Screen.Select();
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
                gameSystem.Screen.Update();
            }
            else
            {
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
            }
            return 1;
        }

        /// <summary>
        /// 移動処理
        /// </summary>
        /// <param name="gameSystem">共通で使用するGameSystemのインスタンス</param>
        private int OnMove(GameSystem gameSystem)
        {
            m_gSys = gameSystem;

            if (!m_init)
            {
                OnInit();
                m_init = true;
            }

            switch (m_process)
            {
                case PROCESS.K2C_LOGO:
                    m_alpha.Inc();

                    if (m_alpha.IsEnd)
                    {
                        m_waitCount++;
                        if (WAIT_TIME <= m_waitCount)
                        {
                            m_waitCount = 0;
                            m_process = PROCESS.CAUTION;
                            m_alpha.Reset();
                            m_gSys.Screen.SetClearColor(0, 0, 0);
                        }
                    }

                    break;
                case PROCESS.CAUTION:
                    m_alpha.Inc();

                    if (m_alpha.IsEnd)
                    {
                        ++m_waitCount;
                        if (WAIT_TIME_CAUTION <= m_waitCount)
                        {
                            m_waitCount = 0;
                            m_process = PROCESS.FADE_OUT;
                            m_alpha.Set(255, 0, 2);
                        }
                    }

                    break;
                case PROCESS.FADE_OUT:
                    m_alpha.Inc();
                    if (m_alpha.IsEnd)
                    {
                        m_gSys.SceneController.JumpScene(Scenes.Startmenu);
                        // マウスカーソルを戻す
                        m_gSys.Mouse.Show();
                        // タスク終了
                        return 0;
                    }
                    break;
                default:
                    Debug.Assert(false);
                    break;
            }

            return 1;
        }

        /// <summary>
        /// 描画処理
        /// </summary>
        /// <param name="gameSystem">共通で使用するGameSystemのインスタンス</param>
        private void OnPaint(GameSystem gameSystem)
        {
            m_gSys = gameSystem;
            // 非0を返せば、このタスクは消される。
            m_gSys.Screen.Clear();

            switch (m_process)
            {
                case PROCESS.K2C_LOGO:
                    m_gSys.Screen.SetColor(255, 255, 255, m_alpha.Value());
                    m_gSys.Screen.Blt(m_imgK2c, 0, 0);
                    break;
                case PROCESS.CAUTION:
                    m_gSys.Screen.SetColor(255, 255, 255, 255 - m_alpha.Value());
                    m_gSys.Screen.Blt(m_imgK2c, 0, 0);
                    m_gSys.Screen.SetColor(255, 255, 255, m_alpha.Value());
                    m_gSys.Screen.Blt(m_imgCaution, 0, 0);
                    break;
                case PROCESS.FADE_OUT:
                    m_gSys.Screen.SetColor(255, 255, 255, m_alpha.Value());
                    m_gSys.Screen.Blt(m_imgCaution, 0, 0);
                    break;
                default:
                    Debug.Assert(false);
                    break;
            }
        }

        /// 初期化処理
        private void OnInit()
        {
            m_imgK2c = YamalibConst.CreateTexture("img/logo/logo01.png");
            m_imgCaution = YamalibConst.CreateTexture("img/logo/logo02.png");
            m_alpha = new RootCounterS();
            m_alpha.Set(0, 255, 1);

            m_gSys.Screen.SetClearColor(255, 255, 255);
            m_gSys.Screen.BlendSrcAlpha();
        }

    }
}
