﻿module y4d_aux.stringconv;

private import std.string;

///	文字列の変換補助用関数群
class StringConv {

	///	m桁の16進数文字列に変換する
	/**
		文字列の前方に桁が余った場合は、0で埋める。
	*/
	static char[] toHex(uint u,int m) { return toConvHelpperU(u,16,m,'0'); }

	///	16進数文字列に変換する
	static char[] toHex(uint u) { return toConvHelpperU(u,16,-1,'0'); }

	///	m桁の10進数文字列に変換する
	/**
		文字列の前方に桁が余った場合は、0で埋める。
	*/
	static char[] toDec(int u,int m) { return toConvHelpperS(u,10,m,'0'); }

	///	m桁の10進数文字列に変換する
	static char[] toDec(int u) { return toConvHelpperS(u,10,-1,'0'); }

	///	m桁の8進数文字列に変換する
	/**
		文字列の前方に桁が余った場合は、0で埋める。
	*/
	static char[] toOct(int u,int m) { return toConvHelpperS(u,8,m,'0'); }

	///	m桁の8進数文字列に変換する
	static char[] toOct(int u) { return toConvHelpperS(u,8,-1,'0'); }

	///	m桁の2進数文字列に変換する
	/**
		文字列の前方に桁が余った場合は、0で埋める。
	*/
	static char[] toBin(int u,int m) { return toConvHelpperS(u,2,m,'0'); }

	///	m桁の2進数文字列に変換する
	static char[] toBin(int u) { return toConvHelpperS(u,2,-1,'0'); }

	/// 無符号の数字をm桁n進数文字列に変換する
	/**
		m == -1の場合は、前方のゼロサプレス(0で埋める)をしない。
		n の最大は36まで。
		桁が余った場合は前方を char cで埋める。
	<PRE>
	例)
		char[] s = toConvHelpper(123,5); // "00123"が戻る
		char[] s = toConvHelpper(12345,3); // "345"が戻る
	</PRE>
	*/
	static char[] toConvHelpperU(uint u,int n,int m,char c){
		if (n > 36 || n <= 1) return null; // だめぽ
		char[] s;
		static const char[] d = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
		while (m>0 || m==-1) {
			int v = u % n;
			s = d[v..v+1] ~ s;
			if (m>0) --m;
			u /= n;
			if (!u) break; // 桁がなくなった
		}
		if (m>0)
			{ char[] c_; for(int i=0;i<m;++i) c_~= c ; s = c_ ~ s; }
		if (!s.length) s = cast(char[]) "0";
		return s;
	}

	/// 符号つきの数字をm桁n進数文字列に変換する
	/**
		m == -1の場合は、前方のゼロサプレス(0で埋める)をしない。
		マイナス符号は桁数に含めない。
	*/
	static char[] toConvHelpperS(int u,int n,int m,char c) {
		if (u<0) {
			char[] s = cast(char[]) "-"; 
			s ~= toConvHelpperU(-u,n,m,c); return s;
		}
		return toConvHelpperU(u,n,m,c);
	}

	///	printメソッド
	/**
		char[]をprintする。改行込み。(デバッグに便利)
	*/
	static void print(char[] data){
		printf("%.*s\n",data);
	}
}
