module yamalib.input.adaptedkey;

private import y4d_input.mouse;
private import y4d_input.virtualkey;
private import y4d_input.joystick;
private import y4d_input.keyboardinput;

private import yamalib.input.adapter;


interface MouseAdaptable {
	/// マウスに適合させるための、マウスボタンに対応するキーのマッピングデータを返却する
	MouseInputAdapter.MouseKeyInputMap getAdaptKeyMapping();
}

/**
	マウスにマッピングを想定したKEY
	y4d_intput.key1のスーパーセットになっている
*/
public class MousedKey : VirtualKey, MouseAdaptable {

	///	コンストラクタで仮想キーの登録を行なう
	this() {
		init();
		addDefaultJoystickMapping();
	}
	
	/// 現在の設定を破棄し、デフォルトの Key マッピングを適用する
	void init() {
		clearDevice();
		clearKeyList();
		
		keyboard = new KeyBoardInput;
		joystick = new JoyStick(0);

		// ０番デバイス
		addDevice(keyboard);
		// １番デバイス
		addDevice(joystick);

		//	0	:	Escape
		addKey(0,0,KeyCode.ESCAPE);

		//	1	:	Up
		addKey(1,0,KeyCode.KP8);
		addKey(1,0,KeyCode.UP);
		// １番デバイスへも追加
		addKey(1,1,0);

		//	2	:	Down
		addKey(2,0,KeyCode.KP2);
		addKey(2,0,KeyCode.DOWN);
		addKey(2,1,1);

		//	3	:	Left
		addKey(3,0,KeyCode.KP4);
		addKey(3,0,KeyCode.LEFT);
		addKey(3,1,2);
		//	4	:	Right
		addKey(4,0,KeyCode.KP6);
		addKey(4,0,KeyCode.RIGHT);
		addKey(4,1,3);

		//	5	:	Space
		addKey(5,0,KeyCode.SPACE);
		//	6	:	Return
		addKey(6,0,KeyCode.RETURN);
		//	7	:	Backspace
		addKey(7,0,KeyCode.BACKSPACE);
		//	8	:	Space
		addKey(8,0,KeyCode.SPACE);
		//	9	:	PageUp
		addKey(9,0,KeyCode.PAGEUP);
		//	10	:	PageDown
		addKey(10,0,KeyCode.PAGEDOWN);
		//	11	:	左Ctrl
		addKey(11,0,KeyCode.LCTRL);
		//	12	:	右Ctrl
		addKey(12,0,KeyCode.RCTRL);
		//	13	:	C
		addKey(13,0,KeyCode.c);
		//	14	:	TAB
		addKey(14,0,KeyCode.TAB);
		
	}
	
	void addJoyKeyLeft(int buttonID) {
		addKey(6,1,buttonID);
	}
	void addJoyKeyRight(int buttonID) {
		addKey(7,1,buttonID);
	}
	void addJoyKeyWheelUp(int buttonID) {
		addKey(9,1,buttonID);
	}
	void addJoyKeyWheelDown(int buttonID) {
		addKey(10,1,buttonID);
	}
	void addJoyKeyExit(int buttonID) {
		addKey(11,1,buttonID);
	}
	
	/// マウスに適合させるための、マウスボタンに対応するキーのマッピングデータを返却する
	/**
		ここでのマッピングは
		LEFT -> RETURN
		RIGHT -> BACKSPACE
		MIDDLE -> SPACE
		WHEEL_UP -> PAGEUP
		WHEEL_DOWN -> PAGEDOWN
	*/
	MouseInputAdapter.MouseKeyInputMap getAdaptKeyMapping() {
		MouseInputAdapter.MouseKeyInputMap map = 
			new MouseInputAdapter.MouseKeyInputMap();
		map.set(MouseInput.button.left, 6);
		map.set(MouseInput.button.right, 7);
		map.set(MouseInput.button.middle, 8);
		map.set(MouseInput.button.wheel_up, 9);
		map.set(MouseInput.button.wheel_down, 10);
		return map;
	}
	
private:
	/// joystick のデフォルトマッピングを追加する
	void addDefaultJoystickMapping() {
		//	3	:	Left
		addKey(3,1,1);
		//	4	:	Right
		addKey(4,1,2);
		//	5	:	Space
		addKey(5,1,3);
		//	6	:	Return
		addKey(6,1,4);
		//	7	:	Backspace
		addKey(7,1,5);
		//	8	:	Space
		addKey(8,1,6);
		//	9	:	PageUp
		addKey(9,1,7);
		//	10	:	PageDown
		addKey(10,1,8);
	}


	KeyBoardInput keyboard;
	JoyStick joystick;
}