﻿module yamablib.dict.dictcontroller;

private import y4d_aux.filesys;
private import y4d_aux.widestring;
private import y4d_draw.drawbase;
private import y4d_draw.screen;
private import y4d_draw.texture;
private import y4d_draw.textureloader;
private import y4d_draw.fontloader;
private import y4d_input.mouse;

private import yamalib.draw.textdraw;

private import yamalib.dict.dictdata;
private import yamalib.dict.dictview;
private import yamalib.gui.guibutton;
private import yamalib.gui.guilistbox;
private import yamalib.gui.guiscrollbar;
private import yamalib.log.log;


/**
	task memo
	・インデックスビュー、メインビューにおけるフォントの指定
*/

/**
	事典コントローラ
*/
class DictController {
	
	/// マウスの設定
	void setMouse(MouseInput mouse_) {
		m_mouse = mouse_;
	}
	
	/// フォントローダの設定
	void setFontLoader(inout FontLoader fl_) {
		m_fontLoader = fl_;
	}
	
	/// 事典が閉じられたか？
	bool isClose() {
		return m_close;
	}
	
	/// クローズ状態を設定する
	void setClose(bool b) {
		m_close = b;
	}

	/// 毎回呼び出すなり
	int onMove(Screen screen) {
		
		if (!init) {
			onInit();
			init = true;
		}
		
		m_indexView.onMove(screen);

		m_mainView.onMove(screen);

/+		m_btHisNext.onMove(screen);
		m_btHisBack.onMove(screen);
+/				
		if ( m_indexView.isNewSelected() ) {
			// 選択した状態をＰＵＳＨ
			m_fileStack ~= m_indexView.getSelectedDataPath();
			// メインビューに登録
			setupDictData( m_fileStack[length-1] );

			m_mainView.setTitleText( (cast(SimpleListBoxItem) m_indexView.getSelectedItem()).getText()  );
			m_mainView.setData( m_data );			

			Log.print("Dict.Cont IndexView new SELECT!");

		} else if ( !(null is m_mainView.getLinkData()) ) {
			
			/* リンクが実行された */
			
			// 選択した状態をＰＵＳＨ
			m_fileStack ~= m_mainView.getLinkData();
			// メインビューに登録
			setupDictData(m_fileStack[length-1]);

			m_mainView.setData( m_data );			

			Log.print("Dict.Cont mainView Link CLICKED!");
		}
		
		// 閉じるボタン
		m_btClose.onMove(screen);
		if ( m_btClose.isLClick() ) {
			m_close = true;
		}
/+		
		if ( m_btHisNext.isLClick() ) {
			//　次へ
			Log.print("Dict.Cont History Next!");
			
		} else if ( m_btHisBack.isLClick() ) {
			// 前へ
			Log.print("Dict.Cont History Back!");
		}
+/		
	
		return 0;
	}
	
	/// 毎回呼び出すなり
	int onDraw(Screen screen) {
		
		// 背景描画
		screen.blt(m_bg,0,0);
		
		// ビュー描画
		m_indexView.onDraw(screen);
		m_mainView.onDraw(screen);
		
		// 閉じるボタン
		m_btClose.onDraw(screen);
		
		
		// ボタン描画
//		m_btHisNext.onDraw(screen);
//		m_btHisBack.onDraw(screen);
		
		return 0;
	}
	
	/// コンストラクタ
	this() {
	}

	
private:
	/// インデックス情報データファイル名
	static const char[] LC_INDEX_DATA_NAME = "data/dict/index.csv";
	
	enum LIST_BOX_POS : int {X=30, Y=140};
	enum MAIN_VIEW_POS : int {X=208, Y=105 }; 
	
	/// メインビューのテキストカラー	
	static const Color4ub TEXT_COLOR = {r:255, g:255, b:255};
	static const int MAIN_VIEW_WIDTH = 365;
	
	static const int CLOSE_BT_X = 566;
	static const int CLOSE_BT_Y = 454;
	
	/// 初期化処理
	void onInit() {
		Log.print("DictControlle#onInit start!");
		m_close = false;
		m_bg = new Texture();
		m_indexView = new IndexView();
		m_mainView = new MainView();
		m_data = new DictData();
		m_indexData = new IndexData();
		auto barTex = new Texture();
		barTex.load(cast(char[]) "img/dict/snd_cur.png");
		auto scrollBar = new TexturalScrollbar();
		scrollBar.setBarTexture(barTex);
		
		// リストボックスを使用する前に初期化
		SimpleListBoxItem.getFontRepository().setLoader(m_fontLoader, 2);
		SimpleListBoxItem.getFontRepository().setMax(5000);
		
		// closeボタン生成
		m_btClose = new GUIButton();
		auto tl = new TextureLoader();
		tl.loadDefFile(cast(char[]) "img/dict/close_bt.lst");
		auto v = new GUINormalButtonListener();
		v.setType(9);
		v.setTextureLader(tl,0);
		m_btClose.setMouse(m_mouse);
		m_btClose.setEvent(v);
		m_btClose.setXY(CLOSE_BT_X, CLOSE_BT_Y);
		
		// 背景画像読み込み
		m_bg.load(cast(char[]) "img/dict/snd_w.png");
		
		// モデル読み込み
		m_indexData.load( cast(char[]) LC_INDEX_DATA_NAME );
		m_dataPath = m_indexData.getIndex(0).filename;
		
		// インデックスデータより先頭データを取得しメインデータに設定する
		m_data.getFontRepository().setMax(1000);
		m_data.getFontRepository().setLoader( m_fontLoader, 1);
		
		// モデルをビューに設定
		m_indexView.setIndexData( m_indexData );
		m_indexView.setScrollbar(scrollBar);
		m_indexView.setPos(LIST_BOX_POS.X, LIST_BOX_POS.Y);
		
		// 解説データのセットアップ
		setupDictData(m_dataPath);
//printf("getIndexes.length:%s", m_indexData.getIndexes.length);		
		printf("2\n");
		m_mainView.setData( m_data );
//printf("getIndexes.length:%s", m_indexData.getIndexes.length);		
		m_mainView.setTitleText( toWCS(m_indexData.getIndex(0).title) );
		printf("3\n");
		m_mainView.setPos(MAIN_VIEW_POS.X, MAIN_VIEW_POS.Y);
		printf("3\n");
		m_mainView.setTextOffset(0, 35);
		printf("4\n");
		
		// ビューの設定
		
		// ベース画像の設定
		Texture t1 = new Texture();
		Texture t2 = new Texture();
		t1.load(cast(char[]) "img/dict/index_base.bmp");
		t2.load(cast(char[]) "img/dict/main_base.bmp");
		printf("5\n");
		
		m_indexView.setBaseTexture(t1);
		m_mainView.setBaseTexture(t2);
		m_indexView.setMouse(m_mouse);
		m_mainView.setMouse(m_mouse);
		
		// マウスを少しガードする（メインのメニューバーと同じところにあるため
		m_mouse.setGuardTime(60);
		
		Log.print("DictControlle#onInit finish!");
	}
	
	/// explainデータのセットアップ
	void setupDictData(char[] filename) {
		// TextDrawContext
		TextDrawContext tdc = new TextDrawContext();
		tdc.width = MAIN_VIEW_WIDTH;
		tdc.setBaseFontSize(11);
		tdc.hInterval = 3;
		tdc.rgbColor = TEXT_COLOR;
		tdc.setText(  toWCS( cast(char[]) FileSys.read(filename) ) );
		m_data.setTextDrawContext( tdc );
		m_data.updateText();

		Log.print("main view update %s", filename);
	}
	
	/// ボタンの生成
	void createButtons() {
		m_btHisNext = new GUIButton();
		m_btHisBack = new GUIButton();
		TextureLoader tl = new TextureLoader();
//		tl.loadDefRW( FileSys.read("") );
	}

	MouseInput m_mouse;
	bool init;
	bool m_close;
	char[][]	m_fileStack;	//!< 表示していく情報をスタックする
	
	FontLoader m_fontLoader;
	

	Texture		m_bg;			//!< 背景用
	IndexView 	m_indexView;	//!< インデックスビュー
	MainView	m_mainView;		//!< メインビュー
	DictData	m_data;			//!< ecplaneデータ
	IndexData	m_indexData;	//!< インデックスデータ
	char[]		m_dataPath;		//!< 現在のデータパス
	
	GUIButton	m_btClose;		//!< 閉じるボタン
	GUIButton	m_btHisNext;	//!< HistoryNext
	GUIButton	m_btHisBack;	//!< HistoryNext

}