﻿module kyojintati4d.myapp;

private import std.gc;

private import y4d_draw.screen;
private import y4d_aux.filesys;
private import y4d_draw.texture;
private import y4d_sound.sound;
private import ytl.y4d_result;

private import kyojintati4d.gameinfo;

private import yamalib.auxil.singleapp;
//private import yamalib.auxil.fileex;
private import yamalib.auxil.scenariochecker;
private import yamalib.auxil.appassist;
private import yamalib.auxil.properties;
private import yamalib.counterfsp;
private import yamalib.log.log;

/++ test import ++/
private import yamalib.auxil.list2scenario;
private import yamalib.auxil.list2kirikiri;

static const char[] PROP_KEY_READ_BUFFER_SIZE = "file_read_buffer";
static const char[] PROP_KEY_OUT_BUFFER_SIZE = "file_out_buffer";
static const char[] PROP_KEY_SOUND_OUT_BUFFER_SIZE = "sound_file_out_buffer";

/// アプリケーションのエントリーポイント
int main(char[][] argv) {
	
	try {
//		fileex.setExistThenWrite(true);
		
		// 二重起動を抑止する
		if (!SingleApp.isValid()) {
			return 1;
		}

		// ファイルアーカイバのセットアップ
		{
			Properties prop = Properties.getInstance(cast(char[]) "setting.txt");
//			long readBufferSize = prop.getPropertyNum(PROP_KEY_READ_BUFFER_SIZE, 1024*1024*1);
			long outBufferSize = prop.getPropertyNum(cast(char[]) PROP_KEY_OUT_BUFFER_SIZE, 1024*1024*2);
			long soundOutBufferSize = prop.getPropertyNum(cast(char[]) PROP_KEY_SOUND_OUT_BUFFER_SIZE, 1024*1024*12);
			
			FileArchiverZip.setPassStatic(cast(char[]) KyojinConst.PK2C);
			FileArchiverZip arcZip = new FileArchiverZip(outBufferSize);
			FileArchiverZip arcZipForSound = new FileArchiverZip(soundOutBufferSize);
			
//			FileEx fileex = new FileEx(readBufferSize, outBufferSize);
//			FileSys.addPath( TmpFileManager.getTmpPath() );
//			FileSys.addArchiver( fileex );
			FileSys.addArchiver(arcZip);
			Sound.setFileArchiver(arcZipForSound);
		}
		
		// メモリー状況
		GameInfo.printMemoryState();
		
		// デバッグ用スタックトレース
	//	Reflection.init(argv[length-1]);
	
		y4d_result res;
		// カウンタの設定
		// FSPによって、カウンタ速度をすべて制御する
		ICounter.setStepRate( KyojinConst.C_FSP_DEFAULT / KyojinConst.C_FSP_NOW );

		// BGM展開！
//		fileex.expandDat("snd.dat", "bgm\\");
		
	//	IndexData indexData = new IndexData();
	//	indexData.load( "./data/dict/index.csv" );
	//	FileSys.write( "LOG.txt", indexData.toString() );
	//	Log.print( "INDEXDATA_TEST: %s", indexData.toString() );
		
		
	//	AppAssist.test001();
	//	return 0;
		
	/*	void[] data = FileSys.read("data/font.lst");
		TmpFileManager.write("font.lst", data, "data");
		data = FileSys.read("data\\font/Dfminc.TTC");
		TmpFileManager.write("Dfminc.TTC", data, "data\\fonts\\");
		
		TmpFileManager.updateListFile();
	*/	
	
	char[] charaListFileName = cast(char[]) "data/config/charalist.csv";
	char[] kyojinCharaListFileName = cast(char[]) "data/config/kyojin_charalist.csv";
	
	// -- 吉里吉里コンバートテスト
	//	(new List2KiriKiriScript("s04", charaListFileName)).convert("data/list4_0.csv", "work/s04.html");
	//	(new List2KiriKiriScript("s02", charaListFileName)).convert("data/list2_0.csv", "work/s02.0.html");
	// -- 吉里吉里コンバートテスト
	

	//	(new List2Script("s02", charaListFileName)).convert("data/list2.csv", "work/s02.0.html");
	//	(new List2Script("s02_1", charaListFileName)).convert("data/list2_1.csv", "work/s02.1.html");
	//	(new List2Script("s02_2", charaListFileName)).convert("data/list2_2.csv", "work/s02.2.html");
	//	(new List2Script("s03", charaListFileName)).convert("data/list3_0.csv", "work/s03.html");
	
	//	(new List2Script("s04", charaListFileName)).convert("data/list4_0.csv", "work/s04.html");
	//	(new List2Script("s05", charaListFileName)).convert("data/list5_0.csv", "work/s05.html");
	//	(new List2Script("s06", charaListFileName)).convert("data/list6_0.csv", "work/s06.html");
	//	(new List2Script("s07", charaListFileName)).convert("data/list7_0.csv", "work/s07.html");
	
	//	(new List2Script(cast(char[]) "s10", kyojinCharaListFileName)).convert(cast(char[]) "data/list11_0.csv", cast(char[]) "../work/sKyojin1.html");
	//	(new List2Script(cast(char[]) "s11", kyojinCharaListFileName)).convert(cast(char[]) "data/list12_0.csv", cast(char[]) "../work/sKyojin2.html");
	//	(new List2Script(cast(char[]) "s12", kyojinCharaListFileName)).convert(cast(char[]) "data/list13_0.csv", cast(char[]) "../work/sKyojin3.html");

	//	return 0;
	
		Log.print("MAIN START!");
		
		GameInfo info = new GameInfo();
		// 画像も含めて初期化処理
		info.init();
			
	// パフォーマンステスト！
	//	AppAssist.openGLParformance(info.screen);
	//	return 0;
		
		// ここでまったくの黒画面にしておくと見栄えがよいかもしれない
		info.screen.setClearColor(0,0,0);
		info.screen.clear();
		info.screen.update();
		info.screen.blendSrcAlpha();
		// コントローラタスクを管理開始
		info.gameTaskController.addTask(info.gameSceneController,0);
		// シーントランジッタの設定
		info.gameSceneTransiter.setGameController(info.gameTaskController, info.gameSceneController);
	
		// 最初の起動タスク
		info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Logo);
	
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Title);
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Option);
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Bookmark);
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Selector);
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Telop);
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Scenario);

	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_EyeCatche);
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Loader);

	// Extraタスク
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Music);
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Demo);
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Dev);

	// エンディングタスク
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Ending1);
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Ending2);
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Ending3);
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_EndingOption);
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_EndingKyojin);

	// 開発中タスク
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Movie);
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_4Koma);
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_TelopKyojin);
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Pinup);

	// テスト用タスク	
	//	info.gameSceneTransiter.jumpScene(KyojinConst.Task.Task_Test);
	
		try {
			info.run();
		} finally {
			// ファイナライザにまかせると順不同で何が起こるかわからない
			// スレッドに依存した処理をしていて、スレッドが崩壊しているためnullアクセスになるかも
			Log.print("RELEASE ALL SOUND");
			Sound.stopAll();
			Sound.releaseAllFinal();		
	
			// テクスチャは明示的に解放する
			Texture.releaseAllFinal();
			
			// パフォーマンス調査
			info.checkCacheEffective();
			
			Log.print("MAIN END");
	
			Log.disporse();
	
			info = null;
		}
		
//		// テンポラリデータを破棄する
//		try {
//			TmpFileManager.clear();
//		} catch {
//			printf("Exception main() - TmpFileManager.clear()");
//		}
		
	} catch (Exception e) {
		printf("Exception main() : [%s]", e.toString());
	}
	
	return 0;
}
