module kyojintati4d.component.komacontroller;

private import y4d_draw.screen;
private import y4d_draw.texture;
private import y4d_draw.fontloader;

private import kyojintati4d.component.komadata;
private import kyojintati4d.component.komaview;

private import yamalib.log.log;


/// 四コマのコントローラ
class KomaController {
	
	/// 四コマをロードします 引数には四コマリソースのフォルダパスを設定してください
	bool load(char[] sbjPath) {
		try {
			
			reset();

			m_data = new KomaData(sbjPath);
			if ( !m_data.load() ) {
				return false;
			}
			
			Log.print("load 4koma xml : %s", m_data.toString());
			m_view = new KomaView(sbjPath);
			m_view.initScenarnioDraw(this.m_fontloader, this.m_fontNo);
			m_view.setData( m_data );
			m_view.loadKoma();
			
			return true;

		} catch (Exception e) {
			Log.printFatal("Exception %s#load : [%s][%s]", 
				super.toString(), e.toString(), e.msg);
			throw e;
		}
	}
	
	/// ビューで使うフォントローダを設定する
	void setFontLoader(FontLoader fl_, int no_) {
		this.m_fontloader = fl_;
		this.m_fontNo = no_;
	}
	
	/// 四コマの動作
	int onMove(Screen screen) {
		try {

			if ( !m_init ) {
				onInit();
				m_init = true;
				m_view.play();
			}
			
			m_view.onMove(screen);
			return 0;
			
		} catch (Exception e) {
			Log.printFatal("Exception %s#onMove : [%s][%s]", 
				super.toString(), e.toString(), e.msg);
			throw e;
		}
	}

	/// 四コマの描画処理
	int onDraw(Screen screen) {
		try {

			m_view.onDraw(screen);

			return 0;
		} catch (Exception e) {
			Log.printFatal("Exception %s#onMove : [%s][%s]", 
				super.toString(), e.toString(), e.msg);
			throw e;
		}
	}
	
	/// 状態の初期化
	void reset() {
	}
	
	/// コンストラクタ
	this() {
	}
	
private:

	/// 初期化処理
	void onInit() {
		
	}
			
private:

	KomaData m_data;
	KomaView m_view;
	bool m_init;
	
	FontLoader m_fontloader;
	int m_fontNo;

}