module kyojintati4d.component.ending.endingmoment;

private import kyojintati4d.component.ending.floatagetexture;
private import y4d_draw.screen;
private import y4d_draw.texture;
private import ytl.y4d_result;

/** 拡縮・回転モーメントクラス */
public class RateRadMoment : Moment {
	/** 移動処理 */
	y4d_result act(DrawInfo drawInfo) {
		if (!m_reverse) {
			drawInfo.x = drawInfo.x + m_addX;
			drawInfo.y = drawInfo.y + m_addY;
			drawInfo.rad = drawInfo.rad + m_addRad;
			drawInfo.rate = drawInfo.rate + m_addRate;
		} else {
			drawInfo.x = drawInfo.x - m_addX;
			drawInfo.y = drawInfo.y - m_addY;
			drawInfo.rad = drawInfo.rad - m_addRad;
			drawInfo.rate = drawInfo.rate - m_addRate;
		}
		
		return y4d_result.no_error;
	}
	
	void reverse(bool value) {
		m_reverse = value;
	}
	
	bool isReverse() {
		return m_reverse;
	}
	
	/** 初期状態に戻す */
	void reset() {
		// とくになんもせんでよし
	}
	
	// x 移動
	float addX() {
		return m_addX;
	}
	float addX(float value) {
		return m_addX = value;
	}

	// y 移動
	float addY() {
		return m_addY;
	}
	float addY(float value) {
		return m_addY = value;
	}

	// 回転角
	float addRad() {
		return m_addRad;
	}
	float addRad(float value) {
		return m_addRad = value;
	}

	// 拡大率
	float addRate() {
		return m_addRate;
	}
	float addRate(float value) {
		return m_addRate = value;
	}

private:
	float addAlpha = 1.0f;
	float m_addX = 0.0f;
	float m_addY = 0.0f;
	float m_addRad = 0.0f;
	float m_addRate = 0.0f;
	bool m_reverse = false;
	

}