﻿using WeifenLuo.WinFormsUI.Docking;
using System;
using System.IO;

namespace Kuineator.Components.Window
{
    class EditWindow:DockContent
    {
        private string swp;
        private bool loaded = true;
        private System.Windows.Forms.ContextMenuStrip contextMenuStrip1;
        private System.Windows.Forms.ToolStripMenuItem ConMenuItem01;
        private System.Windows.Forms.ToolStripMenuItem ConMenuItem02;
        private System.Windows.Forms.ToolStripMenuItem ConMenuItem03;
        private System.Windows.Forms.ToolStripSeparator ConSeparator01;
        private System.Windows.Forms.ToolStripMenuItem ConMenuItem04;
        private System.Windows.Forms.ToolStripMenuItem ConMenuItem05;
        private System.Windows.Forms.ToolStripSeparator ConSeparator02;
        private System.Windows.Forms.ToolStripMenuItem ConMenuItem06;
        private System.Windows.Forms.ToolStripMenuItem ConMenuItem07;
        public string path = "";
        public EditWindow(){
            InitializeComponent();
            EditInitialize();
        }

        public EditWindow(string path)
        {
            InitializeComponent();
            EditInitialize();
            FileInfo f = new FileInfo(path);
            this.Text = f.Name;
            this.codeEditorControl1.Open(path);
            this.path = path;
        }

        public EditWindow(string tabname, int mode)
        {
            InitializeComponent();
            EditInitialize();
            this.Text = tabname;
        }

        public EditWindow(string tabname, string str)
        {
            InitializeComponent();
            EditInitialize();
            this.Text = tabname;
            swp = str;
            loaded = false;
            this.Load +=new EventHandler(codeEditorControl1_Load);
        }

        private void codeEditorControl1_Load(object sender, EventArgs e){
            this.syntaxDocument1.InsertText(swp, 0, 0);
            this.loaded = true;
        }

        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            Fireball.Windows.Forms.LineMarginRender lineMarginRender2 = new Fireball.Windows.Forms.LineMarginRender();
            this.tableLayoutPanel1 = new System.Windows.Forms.TableLayoutPanel();
            this.codeEditorControl1 = new Fireball.Windows.Forms.CodeEditorControl();
            this.syntaxDocument1 = new Fireball.Syntax.SyntaxDocument(this.components);
            this.contextMenuStrip1 = new System.Windows.Forms.ContextMenuStrip(this.components);
            this.ConMenuItem01 = new System.Windows.Forms.ToolStripMenuItem();
            this.ConMenuItem02 = new System.Windows.Forms.ToolStripMenuItem();
            this.ConMenuItem03 = new System.Windows.Forms.ToolStripMenuItem();
            this.ConSeparator01 = new System.Windows.Forms.ToolStripSeparator();
            this.ConMenuItem04 = new System.Windows.Forms.ToolStripMenuItem();
            this.ConMenuItem05 = new System.Windows.Forms.ToolStripMenuItem();
            this.ConSeparator02 = new System.Windows.Forms.ToolStripSeparator();
            this.ConMenuItem06 = new System.Windows.Forms.ToolStripMenuItem();
            this.ConMenuItem07 = new System.Windows.Forms.ToolStripMenuItem();
            this.tableLayoutPanel1.SuspendLayout();
            this.contextMenuStrip1.SuspendLayout();
            this.SuspendLayout();
            // 
            // tableLayoutPanel1
            // 
            this.tableLayoutPanel1.ColumnCount = 1;
            this.tableLayoutPanel1.ColumnStyles.Add(new System.Windows.Forms.ColumnStyle(System.Windows.Forms.SizeType.Percent, 50F));
            this.tableLayoutPanel1.Controls.Add(this.codeEditorControl1, 0, 1);
            this.tableLayoutPanel1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.tableLayoutPanel1.Location = new System.Drawing.Point(0, 0);
            this.tableLayoutPanel1.Name = "tableLayoutPanel1";
            this.tableLayoutPanel1.RowCount = 2;
            this.tableLayoutPanel1.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Percent, 4.198473F));
            this.tableLayoutPanel1.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Percent, 95.80153F));
            this.tableLayoutPanel1.Size = new System.Drawing.Size(284, 262);
            this.tableLayoutPanel1.TabIndex = 0;
            // 
            // codeEditorControl1
            // 
            this.codeEditorControl1.ActiveView = Fireball.Windows.Forms.CodeEditor.ActiveView.BottomRight;
            this.codeEditorControl1.AllowDrop = true;
            this.codeEditorControl1.AutoListPosition = null;
            this.codeEditorControl1.AutoListSelectedText = "a123";
            this.codeEditorControl1.AutoListVisible = false;
            this.codeEditorControl1.CopyAsRTF = false;
            this.codeEditorControl1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.codeEditorControl1.Document = this.syntaxDocument1;
            this.codeEditorControl1.Indent = Fireball.Windows.Forms.CodeEditor.IndentStyle.None;
            this.codeEditorControl1.InfoTipCount = 1;
            this.codeEditorControl1.InfoTipPosition = null;
            this.codeEditorControl1.InfoTipSelectedIndex = 1;
            this.codeEditorControl1.InfoTipVisible = false;
            lineMarginRender2.Bounds = new System.Drawing.Rectangle(19, 0, 19, 16);
            this.codeEditorControl1.LineMarginRender = lineMarginRender2;
            this.codeEditorControl1.Location = new System.Drawing.Point(3, 13);
            this.codeEditorControl1.LockCursorUpdate = false;
            this.codeEditorControl1.Name = "codeEditorControl1";
            this.codeEditorControl1.Saved = false;
            this.codeEditorControl1.ScopeIndicatorColor = System.Drawing.Color.White;
            this.codeEditorControl1.ShowScopeIndicator = false;
            this.codeEditorControl1.Size = new System.Drawing.Size(278, 246);
            this.codeEditorControl1.SmoothScroll = true;
            this.codeEditorControl1.SplitviewH = -4;
            this.codeEditorControl1.SplitviewV = -4;
            this.codeEditorControl1.TabGuideColor = System.Drawing.Color.FromArgb(((int)(((byte)(233)))), ((int)(((byte)(233)))), ((int)(((byte)(233)))));
            this.codeEditorControl1.TabIndex = 0;
            this.codeEditorControl1.Text = "codeEditorControl1";
            this.codeEditorControl1.WhitespaceColor = System.Drawing.SystemColors.ControlDark;
            // 
            // syntaxDocument1
            // 
            this.syntaxDocument1.Lines = new string[] {
        ""};
            this.syntaxDocument1.MaxUndoBufferSize = 1000;
            this.syntaxDocument1.Modified = false;
            this.syntaxDocument1.UndoStep = 0;
            // 
            // contextMenuStrip1
            // 
            this.contextMenuStrip1.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.ConMenuItem01,
            this.ConMenuItem02,
            this.ConMenuItem03,
            this.ConSeparator01,
            this.ConMenuItem04,
            this.ConMenuItem05,
            this.ConSeparator02,
            this.ConMenuItem06,
            this.ConMenuItem07});
            this.contextMenuStrip1.Name = "contextMenuStrip1";
            this.contextMenuStrip1.Size = new System.Drawing.Size(153, 192);
            // 
            // ConMenuItem01
            // 
            this.ConMenuItem01.Name = "ConMenuItem01";
            this.ConMenuItem01.Size = new System.Drawing.Size(152, 22);
            this.ConMenuItem01.Text = "閉じる";
            this.ConMenuItem01.Click += new System.EventHandler(this.ConMenuItem01_Click);
            // 
            // ConMenuItem02
            // 
            this.ConMenuItem02.Name = "ConMenuItem02";
            this.ConMenuItem02.Size = new System.Drawing.Size(152, 22);
            this.ConMenuItem02.Text = "他を閉じる";
            this.ConMenuItem02.Click += new System.EventHandler(this.ConMenuItem02_Click);
            // 
            // ConMenuItem03
            // 
            this.ConMenuItem03.Name = "ConMenuItem03";
            this.ConMenuItem03.Size = new System.Drawing.Size(152, 22);
            this.ConMenuItem03.Text = "すべて閉じる";
            this.ConMenuItem03.Click += new System.EventHandler(this.ConMenuItem03_Click);
            // 
            // ConSeparator01
            // 
            this.ConSeparator01.Name = "ConSeparator01";
            this.ConSeparator01.Size = new System.Drawing.Size(149, 6);
            // 
            // ConMenuItem04
            // 
            this.ConMenuItem04.Name = "ConMenuItem04";
            this.ConMenuItem04.Size = new System.Drawing.Size(152, 22);
            this.ConMenuItem04.Text = "再読み込み";
            this.ConMenuItem04.Click += new System.EventHandler(this.ConMenuItem04_Click);
            // 
            // ConMenuItem05
            // 
            this.ConMenuItem05.Name = "ConMenuItem05";
            this.ConMenuItem05.Size = new System.Drawing.Size(152, 22);
            this.ConMenuItem05.Text = "複製";
            this.ConMenuItem05.Click += new System.EventHandler(this.ConMenuItem05_Click);
            // 
            // ConSeparator02
            // 
            this.ConSeparator02.Name = "ConSeparator02";
            this.ConSeparator02.Size = new System.Drawing.Size(149, 6);
            // 
            // ConMenuItem06
            // 
            this.ConMenuItem06.Name = "ConMenuItem06";
            this.ConMenuItem06.Size = new System.Drawing.Size(152, 22);
            this.ConMenuItem06.Text = "保存";
            this.ConMenuItem06.Click += new System.EventHandler(this.ConMenuItem06_Click);
            // 
            // ConMenuItem07
            // 
            this.ConMenuItem07.Name = "ConMenuItem07";
            this.ConMenuItem07.Size = new System.Drawing.Size(152, 22);
            this.ConMenuItem07.Text = "上書き保存";
            this.ConMenuItem07.Click += new System.EventHandler(this.ConMenuItem07_Click);
            // 
            // EditWindow
            // 
            this.ClientSize = new System.Drawing.Size(284, 262);
            this.Controls.Add(this.tableLayoutPanel1);
            this.Font = new System.Drawing.Font("Courier New", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(128)));
            this.Name = "EditWindow";
            this.TabPageContextMenuStrip = this.contextMenuStrip1;
            this.tableLayoutPanel1.ResumeLayout(false);
            this.contextMenuStrip1.ResumeLayout(false);
            this.ResumeLayout(false);

        }

        private void EditInitialize()
        {
            this.lexer = new PwrLexer(this.syntaxDocument1, this.codeEditorControl1);
            //
            //tablist1
            //
            this.tablist1 = new Fireball.Windows.Forms.CodeEditor.AutoListForm(this.codeEditorControl1);
            this.tablist1.AutoSize = true;
            this.tablist1.AutoSizeMode = System.Windows.Forms.AutoSizeMode.GrowAndShrink;
            this.tablist1.ClientSize = new System.Drawing.Size(167, 164);
            this.tablist1.FormBorderStyle = System.Windows.Forms.FormBorderStyle.None;
            this.tablist1.Location = new System.Drawing.Point(0, 0);
            this.tablist1.Name = "tablist1";
            this.tablist1.ShowInTaskbar = false;
            this.tablist1.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
            this.tablist1.Visible = false;
            this.codeEditorControl1.TextChanged += new System.EventHandler(this.codeEditorControl1_TextChanged);
        }

        public Fireball.Windows.Forms.CodeEditorControl getEditor()
        {
            return this.codeEditorControl1;
        }

        private void codeEditorControl1_TextChanged(object sender, EventArgs e)
        {
            this.lexer.TextChanged();
            if (this.Text[this.Text.Length - 1] != '*' && loaded) this.Text += "*";
        }

        public void EditWindow_Deactivate(object sender, EventArgs e)
        {
            this.codeEditorControl1.AutoListVisible = false;
        }

        public void WindowSave()
        {
            if (this.Text[this.Text.Length - 1] == '*')
            {
                if (this.path == "")
                {
                    if (System.Windows.Forms.MessageBox.Show("新規ファイルを保存しますか？",
                        "質問",
                        System.Windows.Forms.MessageBoxButtons.YesNo,
                        System.Windows.Forms.MessageBoxIcon.Exclamation,
                        System.Windows.Forms.MessageBoxDefaultButton.Button2) == System.Windows.Forms.DialogResult.Yes)
                    {
                        FileStream f = Settings.FileControl.getSaveFile();
                        if (f != null)
                        {
                            StreamWriter fw = new StreamWriter(f, System.Text.Encoding.GetEncoding(Settings.FileControl.CharacterCode));
                            fw.Write(this.syntaxDocument1.Text);
                            fw.Close();
                            f.Close();
                        }
                    }
                }
                else
                {
                    FileStream f = new FileStream(this.path, FileMode.Create);
                    StreamWriter fw = new StreamWriter(f, System.Text.Encoding.GetEncoding(Settings.FileControl.CharacterCode));
                    fw.Write(this.syntaxDocument1.Text);
                    fw.Close();
                    f.Close();
                }
            }
        }

        public void WindowSaveAs()
        {

            FileStream f = Settings.FileControl.getSaveFile();
            if (f != null)
            {
                this.path = f.Name;
                StreamWriter fw = new StreamWriter(f, System.Text.Encoding.GetEncoding(Settings.FileControl.CharacterCode));
                fw.Write(this.syntaxDocument1.Text);
                fw.Close();
                f.Close();
            }
        }

        private System.Windows.Forms.TableLayoutPanel tableLayoutPanel1;
        private Fireball.Windows.Forms.CodeEditorControl codeEditorControl1;
        public Fireball.Syntax.SyntaxDocument syntaxDocument1;
        private Fireball.Windows.Forms.CodeEditor.AutoListForm tablist1;
        private System.ComponentModel.IContainer components;
        private PwrLexer lexer;

        private void ConMenuItem01_Click(object sender, EventArgs e)
        {
            this.WindowSave();
            this.Dispose();
        }

        private void ConMenuItem02_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.OtherRemoveWindow(this);
        }

        private void ConMenuItem03_Click(object sender, EventArgs e)
        {

        }

        private void ConMenuItem04_Click(object sender, EventArgs e)
        {

        }

        private void ConMenuItem05_Click(object sender, EventArgs e)
        {

        }

        private void ConMenuItem06_Click(object sender, EventArgs e)
        {

        }

        private void ConMenuItem07_Click(object sender, EventArgs e)
        {

        }

    }
}
