﻿using System;

namespace Kuineator.Settings
{
    class PrintControl
    {
        public static void printDisplay(Tools.PrintingManager manager)
        {
            System.Windows.Forms.PrintDialog f = new System.Windows.Forms.PrintDialog();
            f.Document = manager.doc_set;
            f.PrinterSettings = manager.print_set;
            if(f.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                f.Document.Print();
        }

        public static void printPreview(Tools.PrintingManager manager)
        {
            System.Windows.Forms.PrintPreviewDialog f = new System.Windows.Forms.PrintPreviewDialog();
            f.Document = manager.doc_set;
            f.ShowDialog();
        }

        public static void printSetup(Tools.PrintingManager manager)
        {
            System.Windows.Forms.PageSetupDialog f = new System.Windows.Forms.PageSetupDialog();
            f.Document = manager.doc_set;
            f.PageSettings = manager.page_set;
            f.PrinterSettings = manager.print_set;
            f.ShowDialog();
        }

    }

}
