﻿using System;
using System.Collections.Generic;
using System.Text;
using WeifenLuo.WinFormsUI.Docking;
using System.IO;

namespace Kuineator.Tools
{
    class EditManager
    {
        private DockPanel pn;
        private List<Components.Window.EditWindow> tabs;
        public EditManager(DockPanel p)
        {
            pn = p;
            tabs = new List<Components.Window.EditWindow>();
        }
        public void AddWindow(string path)
        {
            Components.Window.EditWindow w = new Components.Window.EditWindow(path);
            w.Show(pn, DockState.Document);
            pn.ActiveContentChanged += new EventHandler(w.EditWindow_Deactivate);
            tabs.Add(w);
        }
        public void AddWindow(string tabname, bool def)
        {
            Components.Window.EditWindow w = new Components.Window.EditWindow(tabname,1);
            w.Show(pn, DockState.Document);
            pn.ActiveContentChanged += new EventHandler(w.EditWindow_Deactivate);
            tabs.Add(w);
        }
        public void AddWindow(string path, System.IO.StreamReader read)
        {
            string str = read.ReadToEnd();
            Components.Window.EditWindow w = new Components.Window.EditWindow(path.Remove(0, path.LastIndexOf("\\")+1), str);
            w.path = path;
            w.Show(pn, DockState.Document);
            pn.ActiveContentChanged += new EventHandler(w.EditWindow_Deactivate);
            tabs.Add(w);
            read.Close();
        }
        public void RemoveWindow()
        {
            if (pn.ActiveContent != null)
            {
                ((Components.Window.EditWindow)pn.ActiveContent).WindowSave();
                ((Components.Window.EditWindow)pn.ActiveContent).Dispose();
                tabs.Remove((Components.Window.EditWindow)pn.ActiveContent);
            }
        }
        public void RemoveWindow(Components.Window.EditWindow w)
        {
            w.WindowSave();
            w.Dispose();
            tabs.Remove(w);
        }
        public void OtherRemoveWindow()
        {
            if (pn.ActiveContent != null)
            {
                Components.Window.EditWindow w = (Components.Window.EditWindow)pn.ActiveContent;
                foreach (Components.Window.EditWindow ws in tabs)
                {
                    if (ws != w)
                    {
                        ws.WindowSave();
                        ws.Dispose();
                    }
                }
                tabs.RemoveRange(0, tabs.Count);
                tabs.Add(w);
            }
        }
        public void OtherRemoveWindow(Components.Window.EditWindow w)
        {
            foreach (Components.Window.EditWindow ws in tabs)
            {
                if (ws != w)
                {
                    ws.WindowSave();
                    ws.Dispose();
                }
            }
            tabs.RemoveRange(0, tabs.Count);
            tabs.Add(w);
        }
        public void AllRemoveWindow()
        {
            foreach (Components.Window.EditWindow w in tabs)
            {
                w.WindowSave();
                w.Dispose();
            }
            tabs.RemoveRange(0, tabs.Count);
        }
        public Fireball.Syntax.SyntaxDocument getDocument()
        {
            if (pn.ActiveContent == null) return null;
            if((pn.ActiveContent as Components.Window.EditWindow) == null) return null;
            return (pn.ActiveContent as Components.Window.EditWindow).syntaxDocument1;
        }
    }
}
