﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Kuineator.Components.Dialog
{
    public partial class ProjectCustomDialog : Form
    {
        public ProjectCustomDialog(Tools.Project project)
        {
            InitializeComponent();
            defproject = project;
        }

        private void ProjectCustomDialog_Load(object sender, EventArgs e)
        {
            this.textBox1.Text = defproject.OutputPath;
            this.textBox5.Text = defproject.IconPath;
            this.textBox4.Text = defproject.CustomPath;
            this.textBox2.Text = defproject.PreBuildCommand;
            this.textBox3.Text = defproject.PostBuildCommand;
            this.textBox6.Text = defproject.CompileTarget;
            this.textBox7.Text = defproject.CommandLines;
            foreach (string line in defproject.ClassPaths)
            {
                this.listBox1.Items.Add(line);
            }
            foreach (string line in defproject.HiddenPaths)
            {
                this.listBox2.Items.Add(line);
            }
            this.radioButton1.Checked = !(defproject.IconUse);
            this.radioButton2.Checked = defproject.IconUse;
            this.checkBox1.Checked = defproject.CommandUse;
            this.radioButtonInstalledSDK.Checked = !(defproject.CustomUse);
            this.radioButtonCustomSDK.Checked = defproject.CustomUse;
        }

        private Tools.Project defproject;

        private void button1_Click(object sender, EventArgs e)
        {
            string swap = Settings.FileControl.getSaveFilePath();
            if (swap != "")
                this.textBox1.Text = new Uri(defproject.currentpath).MakeRelativeUri(new Uri(swap)).ToString();
        }

        private void buttonBrowse2_Click(object sender, EventArgs e)
        {
            string swap = Settings.FileControl.getSaveFilePath();
            if (swap != "")
                this.textBox5.Text = new Uri(defproject.currentpath).MakeRelativeUri(new Uri(swap)).ToString();
        }

        private void button9_Click(object sender, EventArgs e)
        {
            string swap = Settings.FileControl.getSaveFilePath();
            if (swap != "")
                this.textBox6.Text = new Uri(defproject.currentpath).MakeRelativeUri(new Uri(swap)).ToString();
        }

        private void button5_Click(object sender, EventArgs e)
        {
            string swap = Settings.FileControl.getSaveFilePath();
            if (swap != "")
                this.textBox4.Text = new Uri(defproject.currentpath).MakeRelativeUri(new Uri(swap)).ToString();
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            buttonSource_Click(null, null);
            this.Dispose();
        }
        
        private void buttonCancel_Click(object sender, EventArgs e)
        {
            this.Dispose();
        }

        private void buttonSource_Click(object sender, EventArgs e)
        {
            if (listBox1.Items.Count != 0)
            {
                string[] str = new string[this.listBox1.Items.Count];
                for (int i = 0; i < str.Length; i++)
                {
                    str[i] = this.listBox1.Items[i] as string;
                }
                defproject.ClassPaths = str;
            }
            if (listBox2.Items.Count != 0)
            {
                string[] str = new string[this.listBox2.Items.Count];
                for (int i = 0; i < str.Length; i++)
                {
                    str[i] = this.listBox2.Items[i] as string;
                }
                defproject.HiddenPaths = str;
            }
            defproject.CommandLines = this.textBox7.Text;
            defproject.CommandUse = this.checkBox1.Checked;
            defproject.CompileTarget = this.textBox6.Text;
            defproject.CustomPath = this.textBox4.Text;
            defproject.CustomUse = this.radioButtonCustomSDK.Checked;
            defproject.IconPath = this.textBox5.Text;
            defproject.IconUse = this.radioButton2.Checked;
            defproject.OutputPath = this.textBox1.Text;
            defproject.PostBuildCommand = this.textBox3.Text;
            defproject.PreBuildCommand = this.textBox2.Text;
        }

    }
}
