<%@page pageEncoding="UTF-8" isELIgnored="false"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="f" uri="http://www.slim3.org/functions"%>

<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<title>Crud2</title>
	<link rel="stylesheet" type="text/css" href="/css/global.css" />
</head>
<body>
	<a href="${f:url('create')}">Create</a><br />
	<br />
	<form action="${f:url('search')}" method="post">
		Title<br />
		<input type="text" ${f:text("searchTitle")} /><br />
		Content<br />
		<input type="text" ${f:text("searchContent")} /><br />
		Date<br />
		<input type="text" ${f:text("searchDateFrom")} />～<input type="text" ${f:text("searchDateTo")} />（例：2010-04-01）<br />
		Number<br />
		<input type="text" ${f:text("searchNumberFrom")} />～<input type="text" ${f:text("searchNumberTo")} /><br />
		Flag<br />
		<select name="searchFlag">
			<option ${f:select("searchFlag", "")}>指定なし</option>
			<option ${f:select("searchFlag", "false")}>false</option>
			<option ${f:select("searchFlag", "true")}>true</option>
		</select><br />
		<input type="submit" value="Search" />
	</form>
	<table>
		<thead>
			<tr>
				<th>Title</th>
				<th>Content</th>
				<th>Date</th>
				<th>Number</th>
				<th>Flag</th>
			</tr>
		</thead>
		<tbody>
			<c:forEach var="e" items="${crud2List}">
				<tr>
					<td>${f:h(e.title)}</td>
					<td>${f:br(f:nbsp(f:h(e.content)))}</td>
					<td>${f:h(e.dateAsString)}</td>
					<td align="right">${f:h(e.number)}</td>
					<td>${f:h(e.flag)}</td>
					<c:set var="editUrl" value="edit/${f:key(e.key)}/${e.version}"/>
					<c:set var="deleteUrl" value="delete/${f:key(e.key)}/${e.version}"/>
					<td><a href="${f:url(editUrl)}">Edit</a></td>
					<td><a href="${f:url(deleteUrl)}" onclick="return confirm('delete OK?')">Delete</a></td>
				</tr>
			</c:forEach>
		</tbody>
	</table>
</body>
</html>