package com.kurukurupapa.tryandroidui002;

import android.app.Activity;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.RadioGroup.OnCheckedChangeListener;

/**
 * アクティビティの通常表示/全画面表示を動的に切り替える実験プログラム<br>
 * ユーザ設定に応じて表示内容を切り替える<br>
 * 参考<br>
 * Activityのタイトルバーを消す。(フルスクリーンにする) | JiroBlog<br>
 * http://www.jirosoft.com/wordpress/android-memo/memo001/<br>
 */
public class TryAndroidUI002Activity extends Activity implements
		OnCheckedChangeListener {
	private static final String KEY_VIEW_TYPE = "view_type";

	private RadioGroup radioGroup;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		Log.d(getClass().getName(), getClass().getSimpleName() + "#onCreate()");

		// 設定を取得する
		SharedPreferences sp = getPreferences(MODE_PRIVATE);
		int viewType = sp.getInt(KEY_VIEW_TYPE, 0);

		// テーマを設定する
		// 親クラスのonCreate()呼び出し前に設定すること
		switch (viewType) {
		case R.id.themeTitleRadioButton:
			// テーマを使ってタイトルバーあり
			setTheme(R.style.CustomTheme_Theme001);
			break;
		case R.id.themeNoTitleRadioButton:
			// テーマを使ってタイトルバーなし
			setTheme(R.style.CustomTheme_Theme001_NoTitle);
			break;
		case R.id.customTitleRadioButton:
			// タイトルバーありテーマ＆カスタムタイトルバー
			setTheme(R.style.CustomTheme_Theme001);
			break;
		// default:
		// // 通常表示
		// viewType = R.id.nothingRadioButton;
		// break;
		}

		// テーマ設定後に親クラスのonCreate()を呼ぶ
		// テーマ設定前に呼ぶと一部テーマが設定されなかったりする
		sleep(1000);
		super.onCreate(savedInstanceState);

		// タイトルバーの形式を指示する
		// setContentView()呼び出し前に実施すること
		switch (viewType) {
		case R.id.noTitleRadioButton:
			// タイトルバーなし
			getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
			requestWindowFeature(Window.FEATURE_NO_TITLE);
			break;
		case R.id.customTitleRadioButton:
			// カスタムタイトルバー
			requestWindowFeature(Window.FEATURE_CUSTOM_TITLE);
			break;
		}

		// レイアウト設定
		setContentView(R.layout.main);

		// カスタムタイトルバーのレイアウトを設定する
		switch (viewType) {
		case R.id.customTitleRadioButton:
			getWindow().setFeatureInt(Window.FEATURE_CUSTOM_TITLE,
					R.layout.custom_title);
			break;
		}

		// ラジオボタン設定
		radioGroup = (RadioGroup) findViewById(R.id.radioGroup);
		radioGroup.check(viewType);
		radioGroup.setOnCheckedChangeListener(this);

		// コンテンツ設定
		TextView textView = (TextView) findViewById(R.id.textView1);
		textView.setText(getResources().getString(R.string.hello));
	}

	@Override
	public void onCheckedChanged(RadioGroup group, int checkedId) {
		SharedPreferences sp = getPreferences(MODE_PRIVATE);
		SharedPreferences.Editor editor = sp.edit();
		editor.putInt(KEY_VIEW_TYPE, checkedId);
		editor.commit();
	}

	private void sleep(long time) {
		try {
			Thread.sleep(time);
		} catch (InterruptedException e) {
			Log.d(getClass().getName(), getClass().getSimpleName()
					+ "#onCreate()," + e.getMessage());
		}
	}
}