package com.kurukurupapa.tryandroidui002;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;

/**
 * アクティビティのタイトルバー部分を動的に切り替える実験プログラム<br>
 * Java側でタイトルバーなしを設定する<br>
 * 参考<br>
 * Activityのタイトルバーを消す。(フルスクリーンにする) | JiroBlog<br>
 * http://www.jirosoft.com/wordpress/android-memo/memo001/<br>
 */
public class NoTitleActivity extends Activity {

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		Log.d(getClass().getName(), getClass().getSimpleName() + "#onCreate()");

		// 親クラスのonCreate()を呼ぶ前にスリープを入れて、表示状態を確認する。
		sleep(1000);
		super.onCreate(savedInstanceState);

		// setContentView()呼び出し前に、タイトルバーなし設定を行う
		getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
		requestWindowFeature(Window.FEATURE_NO_TITLE);

		// レイアウト設定
		setContentView(R.layout.activity);

		// コンテンツ設定
		TextView textView = (TextView) findViewById(R.id.textView1);
		textView.setText(getResources().getString(R.string.hello));
	}

	private void sleep(long time) {
		try {
			Thread.sleep(time);
		} catch (InterruptedException e) {
			Log.d(getClass().getName(), getClass().getSimpleName()
					+ "#onCreate()," + e.getMessage());
		}
	}
}