package com.kurukurupapa.tryandroidui.draglist2_bk;

import com.kurukurupapa.tryandroidui.R;
import com.kurukurupapa.tryandroidui.draglist_bk.DragListAdapter;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

/**
 * ドラッグアンドドロップで並び替え可能なリストビュー用のデータアダプター（リスト項目は２つのテキスト）
 */
public class DragList2Adapter extends DragListAdapter {
	private Activity mActivity;
	private String[][] mItems;

	public DragList2Adapter(String[][] items, Activity activity) {
		mItems = items;
		mActivity = activity;
	}

	@Override
	public int getCount() {
		return mItems.length;
	}

	@Override
	public Object getItem(int position) {
		return mItems[position];
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	protected View getNormalView(int position, View convertView,
			ViewGroup parent) {
		if (convertView == null) {
			convertView = mActivity.getLayoutInflater().inflate(
					R.layout.drag_list_item, null);
		}
		TextView text1 = (TextView) convertView.findViewById(R.id.text1);
		TextView text2 = (TextView) convertView.findViewById(R.id.text2);
		String[] data = mItems[position];
		text1.setText(data[0]);
		text2.setText(data[1]);
		return convertView;
	}

	@Override
	public void swapItems(int position1, int position2) {
		String[] tmp = mItems[position1];
		mItems[position1] = mItems[position2];
		mItems[position2] = tmp;
	}

}
