package com.kurukurupapa.tryandroid.fw.db;

import com.kurukurupapa.tryandroid.fw.util.LogUtil;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class DbTransaction {
	public DbTransaction() {
	}

	public <T> T runForReading(SQLiteOpenHelper helper, DbProcess<T> process) {
		return run(helper, process, false);
	}

	public <T> T runForWriting(SQLiteOpenHelper helper, DbProcess<T> process) {
		return run(helper, process, true);
	}

	private <T> T run(SQLiteOpenHelper helper, DbProcess<T> process,
			boolean writingFlag) {
		T result;
		SQLiteDatabase db = null;

		if (!writingFlag) {
			db = helper.getReadableDatabase();
		} else {
			db = helper.getWritableDatabase();
		}
		LogUtil.d("DB接続");

		try {
			// トランザクション開始
			db.beginTransaction();

			// DB操作
			result = process.process(db);

			// コミット
			db.setTransactionSuccessful();

		} catch (Exception e) {
			LogUtil.e("トランザクション処理に失敗しました。", e);
			throw new RuntimeException(e);

		} finally {
			// トランザクション終了
			db.endTransaction();
			// DB切断
			db.close();
			LogUtil.d("DB切断");
		}

		return result;
	}

}
