package com.kurukurupapa.tryandroid.fw.battery;

import android.os.BatteryManager;

public class BatteryUtil {
	// ステータス表示用テキスト
	public static String textOfStatusUnknown = "不明";
	public static String textOfStatusCharging = "充電中";
	public static String textOfStatusDischarging = "放出中";
	public static String textOfStatusNotCharging = "放電中";
	public static String textOfStatusFull = "満充電";

	// 状態表示用テキスト
	public static String textOfHealthUnknown = "不明";
	public static String textOfHealthGood = "良好";
	public static String textOfHealthOverheat = "過熱";
	public static String textOfHealthDead = "故障";
	public static String textOfHealthOverVoltage = "過電圧";
	public static String textOfHealthUnspecifiedFailure = "不特定の問題あり";

	// 接続状態表示用テキスト
	public static String textOfPluggedNone = "なし";
	public static String textOfPluggedAc = "AC";
	public static String textOfPluggedUsb = "USB";

	public static String getStatusString(int status) {
		String str = textOfStatusUnknown;
		switch (status) {
		case BatteryManager.BATTERY_STATUS_UNKNOWN:
			// str = "unknown";
			str = textOfStatusUnknown;
			break;
		case BatteryManager.BATTERY_STATUS_CHARGING:
			// str = "charging";
			str = textOfStatusCharging;
			break;
		case BatteryManager.BATTERY_STATUS_DISCHARGING:
			// str = "discharging";
			str = textOfStatusDischarging;
			break;
		case BatteryManager.BATTERY_STATUS_NOT_CHARGING:
			// str = "not charging";
			str = textOfStatusNotCharging;
			break;
		case BatteryManager.BATTERY_STATUS_FULL:
			// str = "full";
			str = textOfStatusFull;
			break;
		}
		return str;
	}

	public static boolean isChargingOrFull(int status) {
		boolean result = false;
		switch (status) {
		case BatteryManager.BATTERY_STATUS_CHARGING:
		case BatteryManager.BATTERY_STATUS_FULL:
			result = true;
			break;
		}
		return result;
	}

	public static boolean isNotChargingOrDischarging(int status) {
		boolean result = false;
		switch (status) {
		case BatteryManager.BATTERY_STATUS_DISCHARGING:
		case BatteryManager.BATTERY_STATUS_NOT_CHARGING:
			result = true;
			break;
		}
		return result;
	}

	public static String getHealthString(int health) {
		String str = textOfHealthUnknown;
		switch (health) {
		case BatteryManager.BATTERY_HEALTH_UNKNOWN:
			// str = "Unknown";
			str = textOfHealthUnknown;
			break;
		case BatteryManager.BATTERY_HEALTH_GOOD:
			// str = "Good";
			str = textOfHealthGood;
			break;
		case BatteryManager.BATTERY_HEALTH_OVERHEAT:
			// str = "Overheat";
			str = textOfHealthOverheat;
			break;
		case BatteryManager.BATTERY_HEALTH_DEAD:
			// str = "Dead";
			str = textOfHealthDead;
			break;
		case BatteryManager.BATTERY_HEALTH_OVER_VOLTAGE:
			// str = "Voltage";
			str = textOfHealthOverVoltage;
			break;
		case BatteryManager.BATTERY_HEALTH_UNSPECIFIED_FAILURE:
			// str = "Unspecified failure";
			str = textOfHealthUnspecifiedFailure;
			break;
		}
		return str;
	}

	public static String getPluggedString(int plugged) {
		// String str = "Not plugged";
		String str = textOfPluggedNone;
		switch (plugged) {
		case BatteryManager.BATTERY_PLUGGED_AC:
			str = textOfPluggedAc;
			break;
		case BatteryManager.BATTERY_PLUGGED_USB:
			str = textOfPluggedUsb;
			break;
		}
		return str;
	}

	public static float getRate(int level, int scale) {
		return (float) level / scale;
	}

	public static int getPercentage(int level, int scale) {
		return Math.round(getRate(level, scale) * 100);
	}

	public static int getPercentage(float rate) {
		return Math.round(rate * 100);
	}

	public static String getPercentageString(int level, int scale) {
		return String.valueOf(getPercentage(level, scale)) + "%";
	}

	public static String getPercentageString(float rate) {
		return String.valueOf(Math.round(rate * 100)) + "%";
	}

	public static String getVoltageString(int voltage) {
		return String.valueOf(voltage) + "mV";
	}

	public static String getShortTemperatureString(int temperature) {
		return String.format("%d", Math.round((double) temperature / 10.0))
				+ "℃";
	}

	public static String getTemperatureString(int temperature) {
		return String.format("%.1f", (double) temperature / 10.0) + "℃";
	}

}
