package com.kurukurupapa.tryandroiddb.top;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.kurukurupapa.tryandroiddb.top.model.Item;
import com.kurukurupapa.tryandroiddb.top.model.ItemList;

import android.content.Context;
import android.widget.ListAdapter;
import android.widget.SimpleAdapter;

public class ItemListToListAdapter {
	public static ListAdapter getListAdapter(Context context, ItemList itemList) {
		List<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
		for (Item item : itemList) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("text1", item.title);
			mapList.add(map);
		}

		ListAdapter adapter = new SimpleAdapter(context, mapList,
				android.R.layout.simple_list_item_1, new String[] { "text1" },
				new int[] { android.R.id.text1 });
		return adapter;
	}
}
