package com.kurukurupapa.tryandroiddb.db003.model;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

import com.kurukurupapa.tryandroid.fw.apt.TaaEntity;
import com.kurukurupapa.tryandroid.fw.apt.TaaExclude;
import com.kurukurupapa.tryandroid.fw.util.LogUtil;

/**
 * サンプルテーブルクラス
 */
@TaaEntity
public class Record {
	@TaaExclude
	public static DateFormat dateFormat = new SimpleDateFormat(
			"yyyy/MM/dd hh:mm:ss");

	public int id;
	public String text;
	public long timestamp;

	public String getDateString() {
		String result = "Unknown";
		try {
			result = dateFormat.format(timestamp);
		} catch (Exception e) {
			LogUtil.e("timestamp=" + timestamp + ", ", e);
		}
		return result;
	}

	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(String.valueOf(id));
		sb.append(", " + text);
		sb.append(", " + getDateString());
		return sb.toString();
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public long getTimestamp() {
		return timestamp;
	}

	public void setTimestamp(long timestamp) {
		this.timestamp = timestamp;
	}

}
