package com.tryandroid.media;

import java.io.File;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.widget.ImageView;
import android.widget.TextView;

public class CameraPlayViewHelper implements OnTouchListener {

	private boolean isPlay;
	private AnimationDrawable animationDrawable;

	public CameraPlayViewHelper(Context context, ImageView imageView,
			TextView msgTextView) {

		// 読み込み元ディレクトリ表示
		File baseDir = CameraUtil.getBaseDir(context);
		msgTextView.setText(baseDir.getAbsolutePath());
		File[] files = baseDir.listFiles();

		// アニメーション設定
		animationDrawable = new AnimationDrawable();
		for (File file : files) {
			BitmapDrawable bitmapDrawable = new BitmapDrawable(
					file.getAbsolutePath());
			animationDrawable.addFrame(bitmapDrawable, 1000);
		}
		// 繰り返し再生する
		animationDrawable.setOneShot(false);
		imageView.setBackgroundDrawable(animationDrawable);

		// ImageViewのタッチイベントを紐付け
		imageView.setOnTouchListener(this);
	}

	@Override
	public boolean onTouch(View view, MotionEvent motionEvent) {
		if (motionEvent.getAction() == MotionEvent.ACTION_UP) {
			isPlay = !isPlay;

			if (isPlay) {
				// 再生処理
				animationDrawable.start();
			} else {
				// 停止処理
				animationDrawable.stop();
			}

			return false;
		}

		return true;
	}
}
