package com.tryandroid.file;

import java.io.File;
import java.io.IOException;

import com.kurukurupapa.tryandroid.fw.util.ActivityUtil;
import com.kurukurupapa.tryandroid.fw.util.LogUtil;
import com.tryandroid.R;

import android.app.Activity;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.AdapterView.OnItemSelectedListener;

public class FileActivity extends Activity implements OnClickListener,
		OnItemSelectedListener {

	private Button saveButton;
	private Spinner mediaSpinner;
	private EditText nameEditText;
	private Spinner modeSpinner;
	private EditText contentEditText;
	private TextView commentTextView;

	/*
	 * (非 Javadoc)
	 *
	 * @see android.app.Activity#onCreate(android.os.Bundle)
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		LogUtil.called();

		setContentView(R.layout.file_activity);

		saveButton = (Button) findViewById(R.id.file_save_button);
		mediaSpinner = (Spinner) findViewById(R.id.file_media_spinner);
		nameEditText = (EditText) findViewById(R.id.file_name_edit_text);
		modeSpinner = (Spinner) findViewById(R.id.file_mode_spinner);
		contentEditText = (EditText) findViewById(R.id.file_content_edit_text);
		commentTextView = (TextView) findViewById(R.id.file_comment_text_view);

		saveButton.setOnClickListener(this);
		mediaSpinner.setOnItemSelectedListener(this);

		nameEditText.setText("test.txt");
		contentEditText.setText("test\ntest");
	}

	@Override
	public void onClick(View view) {
		if (view == saveButton) {
			onSaveButtonClick();
		}
	}

	private void onSaveButtonClick() {
		String media = mediaSpinner.getSelectedItem().toString();
		String name = nameEditText.getText().toString();
		String modeStr = modeSpinner.getSelectedItem().toString();
		String content = contentEditText.getText().toString();

		int mode = MODE_PRIVATE;
		if ("MODE_PRIVATE".equals(modeStr)) {
			mode = MODE_PRIVATE;
		} else if ("MODE_APPEND".equals(modeStr)) {
			mode = MODE_APPEND;
		} else if ("MODE_WORLD_READABLE".equals(modeStr)) {
			mode = MODE_WORLD_READABLE;
		} else if ("MODE_WORLD_WRITEABLE".equals(modeStr)) {
			mode = MODE_WORLD_WRITEABLE;
		}

		File file = null;
		try {
			if ("本体".equals(media)) {
				ActivityUtil.saveFile(this, name, mode, content);
				file = ActivityUtil.getFile(this, name);
			} else {
				ActivityUtil.saveFileOnExternalStorage(this, name, content);
				file = ActivityUtil.getFileOnExternalStorage(this, name);
			}
		} catch (IOException e) {
			LogUtil.e("ファイル保存に失敗しました。", e);
			ActivityUtil.showDialog(this, "エラー", "ファイル保存に失敗しました。");
			return;
		}

		StringBuilder sb = new StringBuilder();
		sb.append("ファイルパス：" + file.getAbsolutePath() + "\n");
		sb.append("ファイルサイズ：" + file.length() + "\n");
		sb.append("----------\n");
		sb.append("DataDirectory：" + Environment.getDataDirectory() + "\n");
		sb.append("ExternalStorageDirectory："
				+ Environment.getExternalStorageDirectory() + "\n");
		sb.append("RootDirectory：" + Environment.getRootDirectory() + "\n");
		commentTextView.setText(sb.toString());
	}

	@Override
	public void onItemSelected(AdapterView<?> parent, View view, int position,
			long id) {
		if (parent == mediaSpinner) {
			String media = mediaSpinner.getSelectedItem().toString();
			modeSpinner.setEnabled("本体".equals(media));
		}
	}

	@Override
	public void onNothingSelected(AdapterView<?> arg0) {
		// TODO 自動生成されたメソッド・スタブ

	}
}
