/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.commons.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.seasar.aptina.commons.util.AssertionUtils;

public class IOUtils {
    private IOUtils() {
    }

    public static void closeSilently(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String readString(File file) throws IOException {
        return new String(IOUtils.readBytes(file));
    }

    public static String readString(File file, Charset charset) throws IOException {
        return new String(IOUtils.readBytes(file), charset);
    }

    public static String readString(File file, String charsetName) throws IOException {
        return IOUtils.readString(file, Charset.forName(charsetName));
    }

    public static String readString(InputStream is) throws IOException {
        return new String(IOUtils.readBytes(is));
    }

    public static String readString(InputStream is, Charset charset) throws IOException {
        return new String(IOUtils.readBytes(is), charset);
    }

    public static String readString(InputStream is, String charsetName) throws IOException {
        return IOUtils.readString(is, Charset.forName(charsetName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        FileInputStream is = new FileInputStream(file);
        try {
            FileChannel channel = is.getChannel();
            int size = (int)channel.size();
            ByteBuffer buffer = ByteBuffer.allocate(size);
            int readSize = channel.read(buffer);
            AssertionUtils.assertEquals(size, readSize);
            byte[] byArray = buffer.array();
            return byArray;
        }
        finally {
            IOUtils.closeSilently(is);
        }
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        int size = is.available();
        byte[] bytes = new byte[size];
        for (int readSize = 0; readSize < size; readSize += is.read(bytes, readSize, size - readSize)) {
        }
        return bytes;
    }
}

