/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.commons.util;

import java.util.Collection;

public class AssertionUtils {
    private AssertionUtils() {
    }

    public static void assertNotNull(String name, Object param) throws AssertionError {
        if (param == null) {
            throw new AssertionError((Object)(name + "must not be null"));
        }
    }

    public static void assertNotEmpty(String name, CharSequence string) throws AssertionError {
        if (string == null) {
            throw new AssertionError((Object)(name + "must not be null"));
        }
        if (string.length() == 0) {
            throw new AssertionError((Object)(name + " must not be empty"));
        }
    }

    public static void assertNotEmpty(String name, Object[] array) throws AssertionError {
        if (array == null) {
            throw new AssertionError((Object)(name + " must not be null"));
        }
        if (array.length == 0) {
            throw new AssertionError((Object)(name + " must not be empty"));
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new AssertionError((Object)(name + "[" + i + "] must not be null"));
            }
        }
    }

    public static void assertNotEmpty(String name, Collection<?> collection) throws AssertionError {
        if (collection == null) {
            throw new AssertionError((Object)(name + " must not be null"));
        }
        if (collection.isEmpty()) {
            throw new AssertionError((Object)(name + " must not be empty"));
        }
        int i = 0;
        for (Object element : collection) {
            if (element == null) {
                throw new AssertionError((Object)(name + "[" + i + "] must not be null"));
            }
            ++i;
        }
    }

    public static void assertEquals(int expected, int actual) throws AssertionError {
        if (expected != actual) {
            throw new AssertionError((Object)("expected <" + expected + ">, but was <" + actual + ">"));
        }
    }

    public static void assertEquals(long expected, long actual) throws AssertionError {
        if (expected != actual) {
            throw new AssertionError((Object)("expected <" + expected + ">, but was <" + actual + ">"));
        }
    }
}

