/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.AbstractWrapper;
import org.seasar.doma.wrapper.IntegerWrapperVisitor;
import org.seasar.doma.wrapper.NumberWrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class IntegerWrapper
extends AbstractWrapper<Integer>
implements NumberWrapper<Integer> {
    public IntegerWrapper() {
    }

    public IntegerWrapper(Integer value) {
        super(value);
    }

    @Override
    public void set(Number v) {
        this.set(v.intValue());
    }

    @Override
    public Integer getDefault() {
        return 0;
    }

    @Override
    public void increment() {
        Integer value = (Integer)this.doGet();
        if (value != null) {
            this.doSet(value + 1);
        }
    }

    @Override
    public void decrement() {
        Integer value = (Integer)this.doGet();
        if (value != null) {
            this.doSet(value - 1);
        }
    }

    @Override
    public <R, P, TH extends Throwable> R accept(WrapperVisitor<R, P, TH> visitor, P p) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof IntegerWrapperVisitor) {
            IntegerWrapperVisitor v = (IntegerWrapperVisitor)visitor;
            return v.visitIntegerWrapper(this, p);
        }
        return visitor.visitUnknownWrapper(this, p);
    }
}

