/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.AbstractWrapper;
import org.seasar.doma.wrapper.FloatWrapperVisitor;
import org.seasar.doma.wrapper.NumberWrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class FloatWrapper
extends AbstractWrapper<Float>
implements NumberWrapper<Float> {
    public FloatWrapper() {
    }

    public FloatWrapper(Float value) {
        super(value);
    }

    @Override
    public void set(Number v) {
        super.set(Float.valueOf(v.floatValue()));
    }

    @Override
    public Float getDefault() {
        return Float.valueOf(0.0f);
    }

    @Override
    public void increment() {
        Float value = (Float)this.doGet();
        if (value != null) {
            this.doSet(Float.valueOf(value.floatValue() + 1.0f));
        }
    }

    @Override
    public void decrement() {
        Float value = (Float)this.doGet();
        if (value != null) {
            this.doSet(Float.valueOf(value.floatValue() - 1.0f));
        }
    }

    @Override
    public <R, P, TH extends Throwable> R accept(WrapperVisitor<R, P, TH> visitor, P p) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof FloatWrapperVisitor) {
            FloatWrapperVisitor v = (FloatWrapperVisitor)visitor;
            return v.visitFloatWrapper(this, p);
        }
        return visitor.visitUnknownWrapper(this, p);
    }
}

