/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.AbstractWrapper;
import org.seasar.doma.wrapper.DoubleWrapperVisitor;
import org.seasar.doma.wrapper.NumberWrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class DoubleWrapper
extends AbstractWrapper<Double>
implements NumberWrapper<Double> {
    public DoubleWrapper() {
    }

    public DoubleWrapper(Double value) {
        super(value);
    }

    @Override
    public void set(Number v) {
        super.set(v.doubleValue());
    }

    @Override
    public Double getDefault() {
        return 0.0;
    }

    @Override
    public void increment() {
        Double value = (Double)this.doGet();
        if (value != null) {
            this.doSet(value + 1.0);
        }
    }

    @Override
    public void decrement() {
        Double value = (Double)this.doGet();
        if (value != null) {
            this.doSet(value - 1.0);
        }
    }

    @Override
    public <R, P, TH extends Throwable> R accept(WrapperVisitor<R, P, TH> visitor, P p) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof DoubleWrapperVisitor) {
            DoubleWrapperVisitor v = (DoubleWrapperVisitor)visitor;
            return v.visitDoubleWrapper(this, p);
        }
        return visitor.visitUnknownWrapper(this, p);
    }
}

