/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import org.seasar.doma.wrapper.Accessor;
import org.seasar.doma.wrapper.Wrapper;

public abstract class AbstractWrapper<V>
implements Wrapper<V> {
    protected V value;
    protected Accessor<V> accessor;

    protected AbstractWrapper() {
    }

    protected AbstractWrapper(V value) {
        this.doSet(value);
    }

    @Override
    public final void set(V value) {
        this.doSet(value);
    }

    protected void doSet(V value) {
        if (this.accessor != null) {
            this.accessor.set(value);
        } else {
            this.value = value;
        }
    }

    @Override
    public final V get() {
        return this.doGet();
    }

    protected V doGet() {
        if (this.accessor != null) {
            return this.accessor.get();
        }
        return this.value;
    }

    @Override
    public final V getCopy() {
        return this.doGetCopy();
    }

    protected V doGetCopy() {
        return this.doGet();
    }

    @Override
    public V getDefault() {
        return null;
    }

    @Override
    public final boolean hasEqualValue(Object otherValue) {
        return this.doHasEqualValue(otherValue);
    }

    protected boolean doHasEqualValue(Object otherValue) {
        V value = this.doGet();
        if (value == null) {
            return otherValue == null;
        }
        return value.equals(otherValue);
    }

    @Override
    public void setAccessor(Accessor<V> accessor) {
        this.doSetAccessor(accessor);
    }

    protected void doSetAccessor(Accessor<V> accessor) {
        this.accessor = accessor;
    }
}

